---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 95
  claims_with_evidence: 95
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: Encoding モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：95 / 95、根拠なし：0
- 優先レビュー（高）
  1. **エンコード実行系テスト（UT-ENC-030〜032）**：実際の動作確認が必要
  2. **エラーハンドリング系テスト（UT-ENC-006, 053, 061）**：例外発生条件の確認が必要
  3. **HDRメタデータ設定系テスト（UT-ENC-033〜034, 083）**：メタデータ形式の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/staxrip-master/Source/Encoding/VideoEncoder.vb` - 基底クラス定義（行1-857）
- E-02: `/Users/tomoka.baba/Work/staxrip-master/Source/Encoding/x264Enc.vb` - x264エンコーダー実装（行1-1494）
- E-03: `/Users/tomoka.baba/Work/staxrip-master/Source/Encoding/x265Enc.vb` - x265エンコーダー実装
- E-04: `/Users/tomoka.baba/Work/staxrip-master/Source/Encoding/NVEnc.vb` - NVIDIAハードウェアエンコーダー実装
- E-05: `/Users/tomoka.baba/Work/staxrip-master/Source/Encoding/QSVEnc.vb` - Intel QSVエンコーダー実装
- E-06: `/Users/tomoka.baba/Work/staxrip-master/Source/Encoding/VCEEnc.vb` - AMD VCEエンコーダー実装
- E-07: `/Users/tomoka.baba/Work/staxrip-master/Source/Encoding/ffmpegEnc.vb` - ffmpegエンコーダー実装
- E-08: `/Users/tomoka.baba/Work/staxrip-master/Source/Encoding/AOMEnc.vb` - AOM AV1エンコーダー実装
- E-09: `/Users/tomoka.baba/Work/staxrip-master/Source/Encoding/Rav1e.vb` - Rav1e AV1エンコーダー実装
- E-10: `/Users/tomoka.baba/Work/staxrip-master/Source/Encoding/SvtAv1Enc.vb` - SVT-AV1エンコーダー実装
- E-11: `/Users/tomoka.baba/Work/staxrip-master/Source/Encoding/VvencffappEnc.vb` - VVC/H.266エンコーダー実装
- E-12: `/Users/tomoka.baba/Work/staxrip-master/Source/Encoding/SvtAv1EssentialEnc.vb` - SVT-AV1 Essential実装
- E-13: `/Users/tomoka.baba/Work/staxrip-master/Source/Encoding/SvtAv1HdrEnc.vb` - SVT-AV1 HDR実装
- E-14: `/Users/tomoka.baba/Work/staxrip-master/Source/Encoding/SvtAv1PsyexEnc.vb` - SVT-AV1 Psyex実装

## 3) Claims と根拠の対応（レビューの主戦場）

### VideoEncoder 基底クラス（UT-ENC-001〜015）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VideoEncoder.Encode()は抽象メソッドである | E-01 行12「MustOverride Sub Encode()」 | ○ |
| C-02 | OutputPathはNullMuxer時にp.TargetFileを返す | E-01 行95-99 OutputPathプロパティ実装 | ○ |
| C-03 | OutputExtFullは「.」+OutputExtを返す | E-01 行87-91 OutputExtFullプロパティ | ○ |
| C-04 | AfterEncodingはファイル不在時にErrorAbortExceptionをスローする | E-01 行127-136 AfterEncoding実装 | ○ |
| C-05 | GetH265MaxBitrateはレベルとtierに基づきビットレートを返す | E-01 行185-218 Select Case文 | ○ |
| C-06 | UpdateTargetFileは既存ファイルとの衝突を回避する | E-01 行220-287 Do Whileループ | ○ |
| C-07 | AutoSetImageSizeは圧縮率に基づき画像サイズを調整する | E-01 行289-322 AutoSetImageSize実装 | ○ |
| C-08 | GetDefaultsは全標準エンコーダーのリストを返す | E-01 行412-456 GetDefaults実装 | ○ |
| C-09 | CompareToVideoEncoderは名前でソートを行う | E-01 行458-460 IComparable実装 | ○ |

### BasicVideoEncoder（UT-ENC-016〜021）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | ImportCommandLineは空文字列で早期リターンする | E-01 行514-516 「If commandLine = """" Then Exit Sub」 | ○ |
| C-11 | ImportCommandLineはBoolParamを正しくパースする | E-01 行541-559 BoolParamパース処理 | ○ |
| C-12 | ImportCommandLineはNumParamを正しくパースする | E-01 行560-567 NumParamパース処理 | ○ |
| C-13 | ImportCommandLineはOptionParamを正しくパースする | E-01 行568-604 OptionParamパース処理 | ○ |
| C-14 | GetCommandLineはパラメータからコマンドライン文字列を生成する | E-01 行510-512 GetCommandLine実装 | ○ |

### x264Enc（UT-ENC-022〜043）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | x264Enc.Codecは"h264"を返す | E-02 行43-47 Codecプロパティ | ○ |
| C-16 | OutputExtはMuxer値に基づき拡張子を決定する | E-02 行49-57 OutputExtプロパティ | ○ |
| C-17 | Bitrateプロパティはアクセサ/ミューテータを持つ | E-02 行59-66 Bitrateプロパティ | ○ |
| C-18 | QualityModeはQuantizerまたはQualityモード時にTrueを返す | E-02 行380-386 QualityModeプロパティ | ○ |
| C-19 | Encodeはモードに応じてマルチパス実行を行う | E-02 行88-98 Encodeメソッド | ○ |
| C-20 | SetMetaDataはソースファイルからHDRメタデータを取得設定する | E-02 行121-230 SetMetaData実装 | ○ |
| C-21 | CanChunkEncodeはChunks > 1時にTrueを返す | E-02 行232-234 CanChunkEncode実装 | ○ |
| C-22 | GetChunkEncodeActionsはチャンク数分のActionを返す | E-02 行240-278 GetChunkEncodeActions実装 | ○ |
| C-23 | x264Params.ApplyValuesはPreset/Tuneに基づきパラメータを設定する | E-02 行803-1015 ApplyValues実装 | ○ |
| C-24 | GetPartitionsArgはパーティション設定から引数を生成する | E-02 行1425-1452 GetPartitionsArg実装 | ○ |
| C-25 | IsCustomはカスタムパラメータ内のスイッチ存在を判定する | E-02 行1454-1478 IsCustom実装 | ○ |

### x265Enc（UT-ENC-044〜049）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | x265Enc.Codecは"hevc"を返す | E-03 行100-104 Codecプロパティ | ○ |
| C-27 | IsDolbyVisionSetはプロファイルとRPU設定を判定する | E-03 行64-69 IsDolbyVisionSetプロパティ | ○ |
| C-28 | BeforeEncodingはDolbyVision RPUを処理する | E-03 行148-173 BeforeEncoding実装 | ○ |
| C-29 | CanChunkEncodeはDolbyVision設定時にFalseを返す | E-03 行322-324 CanChunkEncode実装 | ○ |

### NVEnc（UT-ENC-050〜056）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | NVEnc.CodecはParams.Codec.ValueTextを返す | E-04 行149-153 Codecプロパティ | ○ |
| C-31 | OutputExtはAV1時にMuxer.OutputExtを返す | E-04 行155-163 OutputExtプロパティ | ○ |
| C-32 | EncodeはHEVC時にハードウェアサポートを確認する | E-04 行174-182 Encode実装 | ○ |
| C-33 | QualityModeはMode=0または1時にTrueを返す | E-04 行376-382 QualityModeプロパティ | ○ |

### QSVEnc（UT-ENC-057〜061）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | QSVEnc.CodecはParams.Codec.ValueTextを返す | E-05 行159-163 Codecプロパティ | ○ |
| C-35 | OutputExtはMPEG-2でm2v、VP9でivfを返す | E-05 行165-177 OutputExtプロパティ | ○ |
| C-36 | QualityModeは特定モード時にTrueを返す | E-05 行381-387 QualityModeプロパティ | ○ |

### VCEEnc（UT-ENC-062〜064）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | VCEEnc.CodecはParams.Codec.ValueTextを返す | E-06 行154-158 Codecプロパティ | ○ |
| C-38 | OutputExtはAV1時にMuxer.OutputExtを返す | E-06 行160-168 OutputExtプロパティ | ○ |
| C-39 | BeforeEncodingはDolbyVision RPUを処理する | E-06 行183-216 BeforeEncoding実装 | ○ |

### ffmpegEnc（UT-ENC-065〜070）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | OutputExtはコーデックに基づき拡張子を決定する | E-07 行118-139 OutputExtプロパティ | ○ |
| C-41 | IsCompCheckEnabledは常にFalseを返す | E-07 行141-145 IsCompCheckEnabledプロパティ | ○ |
| C-42 | EncodeはTwoPassモードで2回エンコードを実行する | E-07 行147-157 Encode実装 | ○ |
| C-43 | QualityModeはEncodingMode.Quality時にTrueを返す | E-07 行185-191 QualityModeプロパティ | ○ |

### AOMEnc（UT-ENC-071〜076）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | AOMEnc.Codecは"av1"を返す | E-08 行69-73 Codecプロパティ | ○ |
| C-45 | OutputExtはIvf/Obuフラグに基づき拡張子を決定する | E-08 行75-81 OutputExtプロパティ | ○ |
| C-46 | Encodeは2パス設定時に2回エンコードを実行する | E-08 行83-89 Encode実装 | ○ |
| C-47 | QualityModeはRateMode=3時にTrueを返す | E-08 行200-206 QualityModeプロパティ | ○ |

### Rav1e（UT-ENC-077〜080）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | Rav1e.Codecは"av1"を返す | E-09 行49-53 Codecプロパティ | ○ |
| C-49 | Rav1e.OutputExtは"ivf"を返す | E-09 行55-59 OutputExtプロパティ | ○ |
| C-50 | Encodeは2パス設定時に2回エンコードを実行する | E-09 行61-68 Encode実装 | ○ |
| C-51 | QualityModeはMode="Quality"時にTrueを返す | E-09 行128-134 QualityModeプロパティ | ○ |

### SvtAv1Enc（UT-ENC-081〜084）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | SvtAv1Enc.Codecは"av1"を返す | E-10 行93-97 Codecプロパティ | ○ |
| C-53 | SvtAv1Enc.OutputExtは"ivf"を返す | E-10 行99-103 OutputExtプロパティ | ○ |
| C-54 | SetMetaDataはSVT-AV1形式でメタデータを設定する | E-10 行145-200+ SetMetaData実装 | ○ |

### VvencffappEnc（UT-ENC-085〜088）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | VvencffappEnc.Codecは"vvc"を返す | E-11 行60-64 Codecプロパティ | ○ |
| C-56 | VvencffappEnc.OutputExtは"vvc"を返す | E-11 行66-70 OutputExtプロパティ | ○ |
| C-57 | EncodeはTwoPassモードで2回エンコードを実行する | E-11 行72-78 Encode実装 | ○ |
| C-58 | RunCompCheckは圧縮率チェックを実行する | E-11 行154-200 RunCompCheck実装 | ○ |

### BatchEncoder / NullEncoder（UT-ENC-089〜095）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | BatchEncoder.CodecはOutputFileTypeValueを返す | E-01 行651-655 Codecプロパティ | ○ |
| C-60 | BatchEncoder.EncodeはCommandLinesを実行する | E-01 行689-709 Encode実装 | ○ |
| C-61 | NullEncoder.Codecは OutputExtと同値を返す | E-01 行817-821 Codecプロパティ | ○ |
| C-62 | NullEncoder.OutputPathはソースファイルを返す | E-01 行799-815 OutputPathプロパティ | ○ |
| C-63 | NullEncoder.EncodeはMKVファイルをDemuxする | E-01 行837-846 Encode実装 | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠なしの項目はありません
- 追加確認推奨項目:
  - 実際のエンコード処理の結合テスト結果
  - ハードウェアエンコーダー（NVEnc/QSVEnc/VCEEnc）の環境依存動作
  - HDR/DolbyVisionメタデータの形式仕様詳細

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - VideoEncoder基底クラスのプロパティ系テスト（単純なアクセサ/ミューテータ）
- **1: 中リスク** - コマンドライン生成/パース系テスト（複雑な文字列処理）
- **2: 高リスク** - 以下の項目は追加検証を推奨:
  - エンコード実行系（外部プロセス呼び出し）
  - ハードウェアサポートチェック（環境依存）
  - HDR/DolbyVisionメタデータ処理（データ形式依存）

## 6) レビュアーチェックリスト（最小）
- [ ] VideoEncoder基底クラスの抽象メソッド/プロパティが正しく識別されているか
- [ ] 各エンコーダークラスのCodec/OutputExtプロパティの戻り値が正確か
- [ ] マルチパスエンコードの実行回数とパス順序が正しいか（特にx264の3パス: 1>3>2）
- [ ] QualityModeの判定条件が各エンコーダーで正しく定義されているか
- [ ] HDRメタデータ設定のコマンドライン引数が仕様に準拠しているか
- [ ] チャンクエンコード有効/無効の判定条件が正しいか
- [ ] DolbyVision設定時の特別処理が網羅されているか
- [ ] ハードウェアエンコーダーのサポートチェック処理が正しく記述されているか
