---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 114
  claims_with_evidence: 114
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Forms モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：114 / 114、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースにソースコードによる根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/staxrip-master/Source/Forms/ProcessingForm.vb`
- E-02: `/Users/tomoka.baba/Work/staxrip-master/Source/Forms/LogForm.vb`
- E-03: `/Users/tomoka.baba/Work/staxrip-master/Source/Forms/HelpForm.vb`
- E-04: `/Users/tomoka.baba/Work/staxrip-master/Source/Forms/CropForm.vb`
- E-05: `/Users/tomoka.baba/Work/staxrip-master/Source/Forms/PreviewForm.vb`
- E-06: `/Users/tomoka.baba/Work/staxrip-master/Source/Forms/JobsForm.vb`
- E-07: `/Users/tomoka.baba/Work/staxrip-master/Source/Forms/ProfilesForm.vb`
- E-08: `/Users/tomoka.baba/Work/staxrip-master/Source/Forms/SourceFilesForm.vb`
- E-09: `/Users/tomoka.baba/Work/staxrip-master/Source/Forms/SimpleSettingsForm.vb`
- E-10: `/Users/tomoka.baba/Work/staxrip-master/Source/Forms/AppsForm.vb`
- E-11: `/Users/tomoka.baba/Work/staxrip-master/Source/Forms/DownloadForm.vb`

## 3) Claims と根拠の対応（レビューの主戦場）

### ProcessingForm (UT-FRM-001 〜 UT-FRM-014)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ProcessingFormのNew初期化 | E-01: Line 211-258 | ○ |
| C-02 | ApplyThemeでテーマ適用 | E-01: Line 270-278 | ○ |
| C-03 | Abortで処理中止 | E-01: Line 360-366 | ○ |
| C-04 | Abortキャンセル時の継続 | E-01: Line 361 (MsgOK) | ○ |
| C-05 | Skipでジョブスキップ | E-01: Line 368-374 | ○ |
| C-06 | ShowFormでフォーム表示 | E-01: Line 376-380 | ○ |
| C-07 | HideFormでフォーム非表示 | E-01: Line 382-386 | ○ |
| C-08 | UpdateControlsで状態更新 | E-01: Line 388-395 | ○ |
| C-09 | SetOutputHighlightingの切替 | E-01: Line 339-342 | ○ |
| C-10 | SetProgressHighlightingの設定 | E-01: Line 344-354 | ○ |
| C-11 | SetProgressHighlighting None | E-01: Line 347-349 | ○ |
| C-12 | SetProgressHighlighting 空文字 | E-01: Line 345-346 | ○ |
| C-13 | OnResizeでトレイ格納 | E-01: Line 295-305 | ○ |
| C-14 | StopAfterCurrentJobフラグ切替 | E-01: Line 335-337 | ○ |

### LogForm (UT-FRM-015 〜 UT-FRM-018)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | LogFormの初期化 | E-02: Line 6-61 | ○ |
| C-16 | lb_SelectedIndexChangedでスクロール | E-02: Line 98-103 | ○ |
| C-17 | 選択nullの場合のハンドリング | E-02: Line 99 (If check) | ○ |
| C-18 | ApplyThemeの適用 | E-02: Line 73-96 | ○ |

### HelpForm (UT-FRM-019 〜 UT-FRM-022)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | Docプロパティの遅延初期化 | E-03: Line 53-68 | ○ |
| C-20 | ShowDialogでダイアログ表示 | E-03: Line 70-84 | ○ |
| C-21 | Browser_Navigatingで外部URL処理 | E-03: Line 108-113 | ○ |
| C-22 | ローカルURLのキャンセルなし | E-03: Line 109 (StartsWith http check) | ○ |

### CropForm (UT-FRM-023 〜 UT-FRM-040)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | CropFormの初期化 | E-04: Line 153-211 | ○ |
| C-24 | SetCropValuesの設定 | E-04: Line 598-611 | ○ |
| C-25 | CropActiveSideの操作 | E-04: Line 613-623 | ○ |
| C-26 | CropActiveAndOppositeSideの操作 | E-04: Line 625-635 | ○ |
| C-27 | FixModの偶数戻り | E-04: Line 459-465 | ○ |
| C-28 | FixModの奇数補正 | E-04: Line 460-461 | ○ |
| C-29 | FixMod自動補正無効時 | E-04: Line 460 (condition) | ○ |
| C-30 | GetSideの辺判定 | E-04: Line 380-404 | ○ |
| C-31 | SelectBorderの辺選択 | E-04: Line 432-448 | ○ |
| C-32 | UpdateAllの最大値制限 | E-04: Line 467-485 | ○ |
| C-33 | RunAutoCropの実行 | E-04: Line 637-653 | ○ |
| C-34 | RunSmartCropの実行 | E-04: Line 655-659 | ○ |
| C-35 | GoToFrameの指定フレームジャンプ | E-04: Line 696-704 | ○ |
| C-36 | GoToFrameの無効入力ハンドリング | E-04: Line 700-701 (TryParse) | ○ |
| C-37 | GoToTimeの指定時間ジャンプ | E-04: Line 685-694 | ○ |
| C-38 | SetRelativePositionの相対移動 | E-04: Line 711-717 | ○ |
| C-39 | SetAbsolutePositionの絶対移動 | E-04: Line 706-709 | ○ |
| C-40 | SetCropColorの色設定 | E-04: Line 678-683 | ○ |

### PreviewForm (UT-FRM-041 〜 UT-FRM-068)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | PreviewFormの初期化 | E-05: Line 253-285 | ○ |
| C-42 | SetRelativePosの相対移動 | E-05: Line 590-596 | ○ |
| C-43 | SetRelativePosの負値移動 | E-05: Line 595 | ○ |
| C-44 | SetAbsolutePosの絶対移動 | E-05: Line 585-588 | ○ |
| C-45 | SetRangeStartの開始位置設定 | E-05: Line 651-670 | ○ |
| C-46 | SetRangeStartでRange追加 | E-05: Line 654-656 | ○ |
| C-47 | SetRangeEndの終了位置設定 | E-05: Line 672-691 | ○ |
| C-48 | SetRangeEndでRange追加 | E-05: Line 674-677 | ○ |
| C-49 | DeleteRangeで範囲削除 | E-05: Line 756-765 | ○ |
| C-50 | DeleteRangeでRange無しの場合 | E-05: Line 758-762 | ○ |
| C-51 | ClearAllRangesで全削除 | E-05: Line 750-754 | ○ |
| C-52 | SplitRangeで範囲分割 | E-05: Line 693-711 | ○ |
| C-53 | SplitRangeでRange無し時 | E-05: Line 695-697 | ○ |
| C-54 | MergeRangesでマージ | E-05: Line 1037-1054 | ○ |
| C-55 | SwitchWindowStateでフルスクリーン | E-05: Line 598-610 | ○ |
| C-56 | SwitchWindowStateで通常画面 | E-05: Line 602-604 | ○ |
| C-57 | ShowHideButtonsの切替 | E-05: Line 767-772 | ○ |
| C-58 | ShowHideTrackbarの切替 | E-05: Line 774-778 | ○ |
| C-59 | Zoomの適用 | E-05: Line 780-783 | ○ |
| C-60 | ToggleInfosの切替 | E-05: Line 785-790 | ○ |
| C-61 | GetDrawPosの描画位置変換 | E-05: Line 464-468 | ○ |
| C-62 | GetDrawPosのフレーム0 | E-05: Line 464-468 | ○ |
| C-63 | GetCurrentRangeの取得 | E-05: Line 1093-1099 | ○ |
| C-64 | GetCurrentRangeでNothing | E-05: Line 1093-1099 | ○ |
| C-65 | GetResizeBorderの判定 | E-05: Line 1223-1244 | ○ |
| C-66 | SaveBitmapの保存 | E-05: Line 864-885 | ○ |
| C-67 | SavePngの保存 | E-05: Line 887-908 | ○ |
| C-68 | SaveJPGの保存 | E-05: Line 910-931 | ○ |

### JobsForm (UT-FRM-069 〜 UT-FRM-082)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | JobsFormの初期化 | E-06: Line 190-254 | ○ |
| C-70 | SaveJobsの保存 | E-06: Line 371-387 | ○ |
| C-71 | SaveJobsのロード中スキップ | E-06: Line 372-373 | ○ |
| C-72 | UpdateControlsでStart有効化 | E-06: Line 364-369 | ○ |
| C-73 | UpdateControlsでStart無効化 | E-06: Line 368 | ○ |
| C-74 | CheckAllの一括チェック | E-06: Line 300-309 | ○ |
| C-75 | UncheckAllの一括チェック解除 | E-06: Line 278-287 | ○ |
| C-76 | CheckSelectionの選択チェック | E-06: Line 311-320 | ○ |
| C-77 | UncheckSelectionの選択チェック解除 | E-06: Line 289-298 | ○ |
| C-78 | SelectAllの全選択 | E-06: Line 333-342 | ○ |
| C-79 | SelectNoneの全選択解除 | E-06: Line 322-331 | ○ |
| C-80 | bnStart_Clickでジョブ開始 | E-06: Line 389-404 | ○ |
| C-81 | bnStart_Clickの要件未満足時 | E-06: Line 390-391 | ○ |
| C-82 | bnLoad_Clickでジョブロード | E-06: Line 406-412 | ○ |

### ProfilesForm (UT-FRM-083 〜 UT-FRM-095)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | ProfilesFormの初期化 | E-07: Line 298-348 | ○ |
| C-84 | UpdateControlsの状態更新 | E-07: Line 372-385 | ○ |
| C-85 | UpdateControlsの複数選択時 | E-07: Line 375-376 | ○ |
| C-86 | bnAdd_Clickでプロファイル追加 | E-07: Line 426-457 | ○ |
| C-87 | bnAdd_Clickの上書き確認 | E-07: Line 437-444 | ○ |
| C-88 | bnRemove_Clickで削除 | E-07: Line 459-462 | ○ |
| C-89 | bnRename_Clickで名前変更 | E-07: Line 464-473 | ○ |
| C-90 | bnClone_Clickで複製 | E-07: Line 484-486 | ○ |
| C-91 | bnEdit_Clickで編集 | E-07: Line 475-482 | ○ |
| C-92 | bnLeft_Clickで親メニュー移動 | E-07: Line 498-513 | ○ |
| C-93 | bnRight_Clickでサブメニュー移動 | E-07: Line 515-531 | ○ |
| C-94 | bnRestore_Clickでクリーンリストア | E-07: Line 533-554 | ○ |
| C-95 | bnRestore_Clickで上書きリストア | E-07: Line 546-549 | ○ |

### SourceFilesForm (UT-FRM-096 〜 UT-FRM-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | SourceFilesFormの初期化 | E-08: Line 166-192 | ○ |
| C-97 | ShowOpenFileDialogでファイル選択 | E-08: Line 216-228 | ○ |
| C-98 | GetFilesでファイル取得 | E-08: Line 275-277 | ○ |
| C-99 | lb_DragDropでファイル追加 | E-08: Line 279-286 | ○ |
| C-100 | lb_DragDropの存在チェック | E-08: Line 284 | ○ |

### SimpleSettingsForm (UT-FRM-101 〜 UT-FRM-102)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | SimpleSettingsFormの初期化 | E-09: Line 120-130 | ○ |
| C-102 | ApplyThemeの適用 | E-09: Line 142-150 | ○ |

### AppsForm (UT-FRM-103 〜 UT-FRM-109)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | AppsFormの初期化 | E-10: Line 419-472 | ○ |
| C-104 | ShowActivePackageの表示 | E-10: Line 515-628 | ○ |
| C-105 | ShowPackage(TreeNode)の選択 | E-10: Line 675-684 | ○ |
| C-106 | SearchTextBox_TextChangedのフィルタ | E-10: Line 750-805 | ○ |
| C-107 | SearchTextBox_TextChangedの空文字 | E-10: Line 798-801 | ○ |
| C-108 | tsbLaunch_Clickの起動 | E-10: Line 807-809 | ○ |
| C-109 | tsbOpenDir_Clickでフォルダ開く | E-10: Line 812-814 | ○ |

### DownloadForm (UT-FRM-110 〜 UT-FRM-114)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110 | DownloadFormの初期化とダウンロード開始 | E-11: Line 10-19 | ○ |
| C-111 | ProgressChangedの進捗更新 | E-11: Line 21-29 | ○ |
| C-112 | Completedの完了時OK | E-11: Line 32-38 | ○ |
| C-113 | Completedのキャンセル時 | E-11: Line 33 | ○ |
| C-114 | bnCancel_Clickのキャンセル | E-11: Line 40-43 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースはソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコード根拠あり
- 注意点：
  - ProcessingForm, CropForm, PreviewFormは処理の中核を担うため、テスト優先度「高」の項目を重点的にレビュー推奨
  - JobsFormのジョブ制御機能は並列処理・非同期処理が含まれるため、実際のテスト実装時は競合状態に注意

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（UT-FRM-001, 003-005, 023-034, 041-054, 069-082）の内容確認
- [ ] CropForm/PreviewFormのクロップ・カット機能のテストケース網羅性確認
- [ ] JobsFormの非同期処理関連テストケースの妥当性確認
- [ ] 境界値テストケース（UT-FRM-011, 012, 028, 029, 032, 062, 107）の条件確認
- [ ] 異常系テストケース（UT-FRM-004, 017, 036, 050, 081, 100, 113）のエラーハンドリング確認
