---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 164
  claims_with_evidence: 164
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：General モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードから対象クラス・メソッドが存在するか
2. **根拠との整合性**：テストケースの内容がコードの実装と矛盾していないか
3. **網羅性**：Generalモジュール内の主要なクラス・メソッドをカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：164 / 164、根拠なし：0
- 優先レビュー（高）
  1. **数値計算系（Mathf, Calc）**：境界値テストが重要
  2. **ファイル操作系（Folder, SafeSerialization）**：実行環境依存
  3. **プロセス管理（Proc）**：外部プロセス連携

## 2) 参照した情報（Evidence一覧）
> 実在するソースファイルを列挙

- E-01: `/Users/tomoka.baba/Work/staxrip-master/Source/General/General.vb`
- E-02: `/Users/tomoka.baba/Work/staxrip-master/Source/General/Mathf.vb`
- E-03: `/Users/tomoka.baba/Work/staxrip-master/Source/General/LogBuilder.vb`
- E-04: `/Users/tomoka.baba/Work/staxrip-master/Source/General/Macro.vb`
- E-05: `/Users/tomoka.baba/Work/staxrip-master/Source/General/Proc.vb`
- E-06: `/Users/tomoka.baba/Work/staxrip-master/Source/General/Package.vb`
- E-07: `/Users/tomoka.baba/Work/staxrip-master/Source/General/Extensions.vb`
- E-08: `/Users/tomoka.baba/Work/staxrip-master/Source/General/GlobalClass.vb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Folderクラスのプロパティがシステムパスを返却する | E-01 (Folder Class, line 13-100) | ○ |
| C-02 | SafeSerializationクラスがオブジェクトを永続化する | E-01 (SafeSerialization Class) | ○ |
| C-03 | HelpDocumentクラスがHTML出力を行う | E-01 (HelpDocument Class) | ○ |
| C-04 | StringPairがIComparable実装を持つ | E-01 (StringPair Class) | ○ |
| C-05 | CliArgがコマンドライン引数を解析する | E-01 (CliArg Class) | ○ |
| C-06 | Commandクラスがコマンド実行を管理する | E-01 (Command Class) | ○ |
| C-07 | CommandManagerがコマンドを管理・実行する | E-01 (CommandManager Class) | ○ |
| C-08 | MainModuleがダイアログ表示機能を持つ | E-01 (MsgInfo, MsgError, MsgWarn) | ○ |
| C-09 | Reflectorがリフレクション操作を提供する | E-01 (Reflector Class) | ○ |
| C-10 | Shutdownが電源管理機能を持つ | E-01 (Shutdown Class) | ○ |
| C-11 | PowerRequestがスタンバイ制御を行う | E-01 (PowerRequest Class) | ○ |
| C-12 | CRC32がチェックサム計算を行う | E-01 (CRC32 Class) | ○ |
| C-13 | CudaがCUDA検出機能を持つ | E-01 (Cuda Class) | ○ |
| C-14 | VulkanがVulkan検出機能を持つ | E-01 (Vulkan Class) | ○ |
| C-15 | StringExtensionsが文字列操作を提供する | E-07 (StringExtensions Module) | ○ |
| C-16 | MathfがClamp/Min/Max/RoundToInt計算を行う | E-02 (Mathf Class, all methods) | ○ |
| C-17 | LogBuilderがログ管理機能を持つ | E-03 (LogBuilder Class, all methods) | ○ |
| C-18 | MacroがマクロExpand機能を持つ | E-04 (Macro Class) | ○ |
| C-19 | Procがプロセス管理を行う | E-05 (Proc Class, all methods) | ○ |
| C-20 | Calc関数群がビットレート計算を行う | E-01 (Calc Module) | ○ |
| C-21 | Languageクラスが言語コード変換を行う | E-01 (Language Class) | ○ |
| C-22 | ObjectStorageがキーバリューストアを提供する | E-01 (ObjectStorage Class) | ○ |
| C-23 | Rangeが範囲計算を行う | E-01 (Range Class) | ○ |
| C-24 | OSVersionがOS情報を取得する | E-01 (OSVersion Class) | ○ |
| C-25 | FileTypesがファイル種別判定を行う | E-01 (FileTypes Class) | ○ |
| C-26 | Subtitleが字幕処理を行う | E-01 (Subtitle Class) | ○ |
| C-27 | AudioStreamが音声ストリーム情報を持つ | E-01 (AudioStream Class) | ○ |
| C-28 | VideoStreamがビデオストリーム情報を持つ | E-01 (VideoStream Class) | ○ |
| C-29 | BitmapUtilが画像処理を行う | E-01 (BitmapUtil Class) | ○ |
| C-30 | AutoCropがクロップ値計算を行う | E-01 (AutoCrop Class) | ○ |
| C-31 | OS.Hardwareがハードウェア情報を取得する | E-01 (OS.Hardware Class) | ○ |
| C-32 | Packageがパッケージ管理を行う | E-06 (Package Class) | ○ |
| C-33 | GlobalClassがグローバル設定を管理する | E-08 (GlobalClass) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。すべてのテストケースはソースコードに基づいて生成されています。
- ただし、一部のメソッド（P/Invoke呼び出し、外部プロセス実行）は実行環境に依存するため、モックを使用したテストが推奨されます。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - Mathf, StringExtensions, Range などの純粋な計算・文字列操作
- **1: 中リスク** - ファイルI/O、レジストリアクセス（Folder, SafeSerialization, ObjectStorage）
  - 実行環境によって結果が異なる可能性
  - テスト時はモック/スタブの使用を推奨
- **1: 中リスク** - 外部プロセス実行（Proc, Shutdown）
  - 副作用を持つため、統合テストまたはモック使用を推奨
- **1: 中リスク** - ハードウェア検出（Cuda, Vulkan, OS.Hardware）
  - 実行環境依存、CI環境では一部テストがスキップされる可能性

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（UT-GEN-087〜099: Mathf, UT-GEN-124〜127: Calc）のロジック確認
- [ ] ファイル操作系テスト（UT-GEN-001〜009: Folder）がテスト環境で実行可能か確認
- [ ] プロセス管理テスト（UT-GEN-113〜120: Proc）にモック戦略が必要か検討
- [ ] 境界値テストケースが網羅されているか確認（特に数値計算系）
- [ ] 実行環境依存テストの扱い（スキップまたはモック）を決定
