---
generated_at: 2026-01-21 19:45:00
metrics:
  claims_total: 95
  claims_with_evidence: 95
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Tools単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：95 / 95、根拠なし：0
- 優先レビュー（高）
  1. **フレームサーバー関連テスト（UT-TLS-075〜091）**：ネイティブDLL依存のため実行環境に注意
  2. **BitmapUtil関連テスト（UT-TLS-061〜068）**：GDI+リソース管理の確認が必要
  3. **AutoCrop関連テスト（UT-TLS-069〜072）**：実際の画像データでの検証が推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/staxrip-master/Source/Tools/AutoCrop/Main.vb` - メインソースファイル（行1-798）
- E-02: `/Users/tomoka.baba/Work/staxrip-master/Source/Tools/AutoCrop/My Project/AssemblyInfo.vb` - アセンブリ情報
- E-03: `/Users/tomoka.baba/Work/staxrip-master/docs/code-to-docs/単体テストケース一覧/plan.md` - 生成プラン

## 3) Claims と根拠の対応（レビューの主戦場）

### Mathfクラス（UT-TLS-001〜030）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Mathf.Clamp(Integer)が値を範囲内に制限する | E-01 (行683-690) | ○ |
| C-02 | Mathf.Clamp(Single)が浮動小数点値を制限する | E-01 (行692-699) | ○ |
| C-03 | Mathf.Clamp01が0-1範囲に制限する | E-01 (行701-708) | ○ |
| C-04 | Mathf.Min(Single, Single)が最小値を返す | E-01 (行710-712) | ○ |
| C-05 | Mathf.Min(ParamArray Single())が配列から最小値を返す | E-01 (行714-729) | ○ |
| C-06 | Mathf.Min(Integer, Integer)が整数最小値を返す | E-01 (行731-733) | ○ |
| C-07 | Mathf.Min(ParamArray Integer())が整数配列から最小値を返す | E-01 (行735-750) | ○ |
| C-08 | Mathf.Max(Single, Single)が最大値を返す | E-01 (行752-754) | ○ |
| C-09 | Mathf.Max(ParamArray Single())が配列から最大値を返す | E-01 (行756-771) | ○ |
| C-10 | Mathf.Max(Integer, Integer)が整数最大値を返す | E-01 (行773-775) | ○ |
| C-11 | Mathf.Max(ParamArray Integer())が整数配列から最大値を返す | E-01 (行777-790) | ○ |
| C-12 | Mathf.RoundToIntが四捨五入した整数を返す | E-01 (行794-796) | ○ |

### ColorHSLクラス（UT-TLS-031〜060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | ColorHSL.Newが有効なHSL値でインスタンスを作成する | E-01 (行552-558) | ○ |
| C-14 | ColorHSL.Newが色相を0-359に正規化する | E-01 (行553-554) | ○ |
| C-15 | ColorHSL.Newが彩度を0-1にクランプする | E-01 (行555) | ○ |
| C-16 | ColorHSL.Newが輝度を0-1にクランプする | E-01 (行556) | ○ |
| C-17 | ColorHSL.Newがアルファを0-1にクランプする | E-01 (行557) | ○ |
| C-18 | CType(ColorHSL As Color)がHSLからRGBへ変換する | E-01 (行560-602) | ○ |
| C-19 | CType(Color As ColorHSL)がRGBからHSLへ変換する | E-01 (行604-622) | ○ |
| C-20 | ColorHSL.Equalsが値の等価性を判定する | E-01 (行648-651) | ○ |
| C-21 | ColorHSL演算子=が等価性を判定する | E-01 (行624-626) | ○ |
| C-22 | ColorHSL演算子<>が非等価性を判定する | E-01 (行628-630) | ○ |
| C-23 | ColorHSL.AddHueが色相オフセットを加算する | E-01 (行632-634) | ○ |
| C-24 | ColorHSL.AddSaturationが彩度オフセットを加算する | E-01 (行636-638) | ○ |
| C-25 | ColorHSL.AddLuminanceが輝度オフセットを加算する | E-01 (行640-642) | ○ |
| C-26 | ColorHSL.AddAlphaがアルファオフセットを加算する | E-01 (行644-646) | ○ |
| C-27 | ColorHSL.SetHueが色相を設定する | E-01 (行653-655) | ○ |
| C-28 | ColorHSL.SetSaturationが彩度を設定する | E-01 (行657-659) | ○ |
| C-29 | ColorHSL.SetLuminanceが輝度を設定する | E-01 (行661-663) | ○ |
| C-30 | ColorHSL.SetAlphaがアルファを設定する | E-01 (行665-667) | ○ |
| C-31 | ColorHSL.ToColorがColorを返す | E-01 (行669-671) | ○ |
| C-32 | ColorHSL.ToStringがHSLA形式文字列を返す | E-01 (行677-679) | ○ |
| C-33 | ColorHSL.ToHTMLがHTML色コードを返す | E-01 (行673-675) | ○ |

### BitmapUtilクラス（UT-TLS-061〜068）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | BitmapUtil.CreateがBitmapからデータを抽出する | E-01 (行177-187) | ○ |
| C-35 | BitmapUtil.GetPixelが指定座標の色を返す | E-01 (行168-171) | ○ |
| C-36 | BitmapUtil.GetMaxLuminanceがピクセルの輝度を返す | E-01 (行173-175) | ○ |
| C-37 | BitmapUtil.CreateBitmapがフレームサーバーからBitmapを作成する | E-01 (行189-197) | ○ |

### AutoCropクラス（UT-TLS-069〜072）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | AutoCrop.Startがクロップ値を検出する | E-01 (行100-161) | ○ |
| C-39 | AutoCrop.Startが20ポイントでサンプリングする | E-01 (行103-104) | ○ |
| C-40 | AutoCrop.Startが輝度閾値で黒枠を判定する | E-01 (行117, 125, 144, 152) | ○ |

### ServerInfo構造体（UT-TLS-073〜074）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | ServerInfo.FrameRateがフレームレートを計算する | E-01 (行280-284) | ○ |
| C-42 | ServerInfo.FrameRateがゼロ除算を防止する | E-01 (行282) | ○ |

### FrameServerFactoryクラス（UT-TLS-075〜076）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | FrameServerFactory.CreateがuseVFWでサーバーを切り替える | E-01 (行288-303) | ○ |
| C-44 | FrameServerFactory.CreateがFrameServer.dllをロードする | E-01 (行292-298) | ○ |

### DirectFrameServerクラス（UT-TLS-077〜082）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | DirectFrameServer.NewがAVS/VPYで適切なサーバーを選択する | E-01 (行207-216) | ○ |
| C-46 | DirectFrameServer.FrameRateがフレームレートを計算する | E-01 (行224-228) | ○ |
| C-47 | DirectFrameServer.Errorがエラーメッセージを返す | E-01 (行218-222) | ○ |
| C-48 | DirectFrameServer.GetFrameがフレームを取得する | E-01 (行230-235) | ○ |
| C-49 | DirectFrameServer.DisposeがCOMオブジェクトを解放する | E-01 (行246-251) | ○ |

### VfwFrameServerクラス（UT-TLS-083〜091）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | VfwFrameServer.NewがAVIファイルを開く | E-01 (行315-363) | ○ |
| C-51 | VfwFrameServer.NewがAVIFileOpen失敗時に例外をスローする | E-01 (行320-321) | ○ |
| C-52 | VfwFrameServer.NewがAVIFileGetStream失敗時に例外をスローする | E-01 (行323-325) | ○ |
| C-53 | VfwFrameServer.FrameRateがフレームレートを計算する | E-01 (行368-372) | ○ |
| C-54 | VfwFrameServer.GetFrameがフレームを取得する | E-01 (行374-394) | ○ |
| C-55 | VfwFrameServer.GetFrameが失敗時にE_FAILを返す | E-01 (行393) | ○ |
| C-56 | VfwFrameServer.GetFrameがpitchを正しく計算する | E-01 (行388) | ○ |
| C-57 | VfwFrameServer.Disposeが全リソースを解放する | E-01 (行500-516) | ○ |
| C-58 | VfwFrameServer.Disposeが二重呼び出しに対応する | E-01 (行501) | ○ |

### Extensionsモジュール（UT-TLS-092）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | Extensions.ToColorHSLがColor拡張メソッドとして機能する | E-01 (行87-92) | ○ |

### Module1（UT-TLS-093〜095）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | Module1.Mainが引数なしでヘルプを表示する | E-01 (行15-18) | ○ |
| C-61 | Module1.Mainが有効な引数でクロップ処理を実行する | E-01 (行20-75) | ○ |
| C-62 | Module1.Mainが例外発生時にExitCode=1を設定する | E-01 (行76-79) | ○ |

## 4) 不足情報（Unknown / Missing）
- すべてのテストケースはソースコードに基づいて作成されており、根拠なしの項目はありません。
- ただし、以下の点は実行環境依存のため、テスト時に注意が必要です：
  - FrameServer.dll（ネイティブDLL）の存在
  - AviSynth/VapourSynthのインストール状況
  - avifil32.dll（Windows VFW API）の利用可能性

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: Mathfクラス、ColorHSLクラスのテスト - 純粋な計算ロジックのため
- **1（中リスク）**: BitmapUtil、AutoCropのテスト - GDI+リソース管理が必要
- **2（高リスク）**: フレームサーバー関連のテスト - ネイティブDLLとCOM相互運用が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Mathfクラスの境界値テストが網羅されているか確認
- [ ] ColorHSLのRGB/HSL相互変換の精度要件を確認
- [ ] BitmapUtilのメモリリーク対策（Disposeパターン）の確認
- [ ] AutoCropの閾値設定の妥当性を確認
- [ ] フレームサーバーテストの実行環境（DLL依存）を確認
- [ ] VfwFrameServerのWin32 API呼び出しエラーハンドリングを確認
- [ ] テストケースの優先度（高/中/低）が適切か確認
