---
generated_at: 2026-01-21 19:30:00
metrics:
  claims_total: 132
  claims_with_evidence: 132
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：UI モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：132 / 132、根拠なし：0
- 優先レビュー（高）
  1. **ColorHSL変換ロジック**：HSL-RGB変換の数学的正確性の検証推奨
  2. **ThemeManager初期化**：Lazy初期化パターンの確認推奨
  3. **TaskDialog表示処理**：モーダルダイアログの動作確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/staxrip-master/Source/UI/ColorHSL.vb`
- E-02: `/Users/tomoka.baba/Work/staxrip-master/Source/UI/HSLColor.vb`
- E-03: `/Users/tomoka.baba/Work/staxrip-master/Source/UI/Theme.vb`
- E-04: `/Users/tomoka.baba/Work/staxrip-master/Source/UI/ThemeManager.vb`
- E-05: `/Users/tomoka.baba/Work/staxrip-master/Source/UI/FontManager.vb`
- E-06: `/Users/tomoka.baba/Work/staxrip-master/Source/UI/ImageUtils.vb`
- E-07: `/Users/tomoka.baba/Work/staxrip-master/Source/UI/TaskDialog.vb`
- E-08: `/Users/tomoka.baba/Work/staxrip-master/Source/UI/Menu.vb`
- E-09: `/Users/tomoka.baba/Work/staxrip-master/Source/UI/Misc.vb`
- E-10: `/Users/tomoka.baba/Work/staxrip-master/Source/UI/SelectionBox.vb`
- E-11: `/Users/tomoka.baba/Work/staxrip-master/Source/UI/TipProvider.vb`
- E-12: `/Users/tomoka.baba/Work/staxrip-master/Source/UI/StockIcon.vb`
- E-13: `/Users/tomoka.baba/Work/staxrip-master/Source/UI/Dynamic.vb`
- E-14: `/Users/tomoka.baba/Work/staxrip-master/Source/UI/Controls/SimpleUI.vb`
- E-15: `/Users/tomoka.baba/Work/staxrip-master/Source/UI/ToolStripRendererEx.vb`
- E-16: `/Users/tomoka.baba/Work/staxrip-master/Source/UI/Criteria/Criteria.vb`

## 3) Claims と根拠の対応（レビューの主戦場）

### ColorHSL (UT-UI-001 〜 UT-UI-016)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ColorHSL.Newで色相・彩度・輝度・アルファ値からインスタンス生成 | E-01 (L35-41) | ○ |
| C-02 | 色相が360以上の場合にMod演算で正規化 | E-01 (L36-37) | ○ |
| C-03 | 色相が負の場合に+360で正規化 | E-01 (L37) | ○ |
| C-04 | 彩度がMathf.Clamp01でクランプ | E-01 (L38) | ○ |
| C-05 | 輝度がMathf.Clamp01でクランプ | E-01 (L39) | ○ |
| C-06 | CType演算子でColorHSLからColorへ変換 | E-01 (L43-86) | ○ |
| C-07 | CType演算子でColorからColorHSLへ変換 | E-01 (L88-106) | ○ |
| C-08 | AddHueで色相にオフセット加算 | E-01 (L116-118) | ○ |
| C-09 | AddSaturationで彩度にオフセット加算 | E-01 (L120-122) | ○ |
| C-10 | AddLuminanceで輝度にオフセット加算 | E-01 (L124-126) | ○ |
| C-11 | SetHueで色相を設定 | E-01 (L137-139) | ○ |
| C-12 | SetSaturationで彩度を設定 | E-01 (L141-143) | ○ |
| C-13 | SetLuminanceで輝度を設定 | E-01 (L145-147) | ○ |
| C-14 | Equalsで同一値の比較がTrue | E-01 (L132-135) | ○ |
| C-15 | Equalsで異なる値の比較がFalse | E-01 (L132-135) | ○ |
| C-16 | ToHTMLでHTML形式文字列を返却 | E-01 (L157-159) | ○ |

### HSLColor (UT-UI-017 〜 UT-UI-025)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | New(Color)でRGBからHSL変換 | E-02 (L2-4) | ○ |
| C-18 | New(h,s,l)で値からインスタンス生成 | E-02 (L6-10) | ○ |
| C-19 | CheckRangeで0未満を0に修正 | E-02 (L45-53) | ○ |
| C-20 | CheckRangeで1超過を1に修正 | E-02 (L45-53) | ○ |
| C-21 | ToColorでHSLからColor変換 | E-02 (L65-84) | ○ |
| C-22 | ToColorAddLuminosityで輝度加算変換 | E-02 (L55-58) | ○ |
| C-23 | ToColorSetLuminosityで輝度設定変換 | E-02 (L60-63) | ○ |
| C-24 | Convert静的メソッドでColor変換 | E-02 (L124-132) | ○ |
| C-25 | SetRGBでRGB値からHSL設定 | E-02 (L134-140) | ○ |

### Theme (UT-UI-026 〜 UT-UI-032)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | New(name)でテーマ名指定インスタンス生成 | E-03 (L118-123) | ○ |
| C-27 | 空テーマ名でArgumentNullException | E-03 (L119-121) | ○ |
| C-28 | nullテーマ名でArgumentNullException | E-03 (L119-121) | ○ |
| C-29 | パラメータなしNew()でException | E-03 (L114-116) | ○ |
| C-30 | GeneralプロパティのLazy初期化 | E-03 (L32-40) | ○ |
| C-31 | AppsFormプロパティのLazy初期化 | E-03 (L42-50) | ○ |
| C-32 | ControlsThemeColors.Cloneでディープコピー | E-03 (L452-459) | ○ |

### ThemeManager (UT-UI-033 〜 UT-UI-040)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | CurrentThemeで現在のテーマ取得 | E-04 (L55-68) | ○ |
| C-34 | SetCurrentThemeでテーマ設定 | E-04 (L126-137) | ○ |
| C-35 | 無効テーマ名でデフォルト設定 | E-04 (L127-129) | ○ |
| C-36 | 空テーマ名でデフォルト設定 | E-04 (L127) | ○ |
| C-37 | Themesでテーマリスト取得 | E-04 (L82-87) | ○ |
| C-38 | LoadDefaultsでデフォルトテーマロード | E-04 (L112-124) | ○ |
| C-39 | WindowsAccentColorでレジストリ取得 | E-04 (L89-105) | ○ |
| C-40 | CurrentThemeChangedイベント発火 | E-04 (L139-144) | ○ |

### FontManager (UT-UI-041 〜 UT-UI-048)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | Initでフォントコレクション初期化 | E-05 (L10-14) | ○ |
| C-42 | GetFontFamiliesでカテゴリ別取得 | E-05 (L45-58) | ○ |
| C-43 | GetFontFamilyで名前検索 | E-05 (L60-64) | ○ |
| C-44 | GetFontでFont生成 | E-05 (L66-76) | ○ |
| C-45 | GetCodeFontでコード用フォント | E-05 (L84-94) | ○ |
| C-46 | GetDefaultFontでデフォルトフォント | E-05 (L96-106) | ○ |
| C-47 | GetThumbnailFontでサムネイル用フォント | E-05 (L108-118) | ○ |
| C-48 | Resetでキャッシュクリア | E-05 (L16-18) | ○ |

### ImageHelp (UT-UI-049 〜 UT-UI-051)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | GetSymbolImageでシンボル画像生成 | E-06 (L18-59) | ○ |
| C-50 | フォントファイル不存在時にNothing | E-06 (L23-25) | ○ |
| C-51 | GetSymbolImageAsyncで非同期取得 | E-06 (L14-16) | ○ |

### TaskDialog (UT-UI-052 〜 UT-UI-059)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | デフォルト値でTaskDialog生成 | E-07 (L32-35) | ○ |
| C-53 | AddCommandでコマンド追加 | E-07 (L273-287) | ○ |
| C-54 | AddButtonでボタン追加 | E-07 (L295-305) | ○ |
| C-55 | GetDialogResultFromButtonで変換 | E-07 (L493-508) | ○ |
| C-56 | Cancel/CloseがDialogResult.Cancel | E-07 (L496-497) | ○ |
| C-57 | Initでダイアログ初期化 | E-07 (L43-271) | ○ |
| C-58 | Showでダイアログ表示 | E-07 (L552-564) | ○ |
| C-59 | GetTextでテキスト結合 | E-07 (L479-491) | ○ |

### Menu関連 (UT-UI-060 〜 UT-UI-074)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | CustomMenuItem.Addでパス階層追加 | E-08 (L79-116) | ○ |
| C-61 | キーボードショートカット設定 | E-08 (L79-116) | ○ |
| C-62 | GetAllItemsで全子項目取得 | E-08 (L132-143) | ○ |
| C-63 | GetCloneでクローン | E-08 (L145-147) | ○ |
| C-64 | SetParentsで親参照設定 | E-08 (L121-127) | ○ |
| C-65 | Removeで項目削除 | E-08 (L128-130) | ○ |
| C-66 | CustomMenu.BuildMenuでメニュー構築 | E-08 (L292-350) | ○ |
| C-67 | OnKeyDownでコマンド実行 | E-08 (L255-263) | ○ |
| C-68 | GetKeysでショートカット一覧 | E-08 (L197-216) | ○ |
| C-69 | EnableMenuItemByActionNameで有効化 | E-08 (L232-236) | ○ |
| C-70 | MenuItemEx.Addで静的追加 | E-08 (L467-512) | ○ |
| C-71 | SetImageでシンボル画像設定 | E-08 (L520-539) | ○ |
| C-72 | GetPreferredSizeでサイズ計算 | E-08 (L514-518) | ○ |
| C-73 | ContextMenuStripEx.Addで項目追加 | E-08 (L786-859) | ○ |
| C-74 | ApplyThemeでテーマ適用 | E-08 (L753-765) | ○ |

### FormBase/DialogBase (UT-UI-075 〜 UT-UI-079)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | OnDragEnterでファイルドロップ許可 | E-09 (L66-76) | ○ |
| C-76 | OnDragDropでイベント発火 | E-09 (L78-88) | ○ |
| C-77 | SetMinimumSizeでフォント比設定 | E-09 (L102-104) | ○ |
| C-78 | SetMaximumSizeでフォント比設定 | E-09 (L98-100) | ○ |
| C-79 | DialogBase初期化設定 | E-09 (L197-206) | ○ |

### ListBag/WindowPositions (UT-UI-080 〜 UT-UI-087)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | SelectItemで値選択 | E-09 (L236-244) | ○ |
| C-81 | GetValueで選択値取得 | E-09 (L246-248) | ○ |
| C-82 | GetBagsForEnumTypeでEnum変換 | E-09 (L250-258) | ○ |
| C-83 | WindowPositions.Saveで位置保存 | E-09 (L274-277) | ○ |
| C-84 | RestorePositionで位置復元 | E-09 (L305-316) | ○ |
| C-85 | GetKeyで一意キー生成 | E-09 (L318-320) | ○ |
| C-86 | InputBox.Show静的入力ボックス | E-09 (L401-415) | ○ |
| C-87 | InputBox.Showインスタンス入力ボックス | E-09 (L417-439) | ○ |

### SelectionBox (UT-UI-088 〜 UT-UI-091)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | AddItemで選択項目追加 | E-10 (L36-42) | ○ |
| C-89 | SelectedValueで値選択 | E-10 (L10-20) | ○ |
| C-90 | SelectedTextでテキスト選択 | E-10 (L22-34) | ○ |
| C-91 | Showでダイアログ表示 | E-10 (L48-65) | ○ |

### TipProvider (UT-UI-092 〜 UT-UI-097)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92 | SetTipTextでツールチップ設定 | E-11 (L50-53) | ○ |
| C-93 | SetTipで複数コントロール設定 | E-11 (L60-80) | ○ |
| C-94 | HasContextMenuでTextBox判定 | E-11 (L125-139) | ○ |
| C-95 | ContextMenuStrip設定時にTrue | E-11 (L136-138) | ○ |
| C-96 | FormatNameで名前フォーマット | E-11 (L141-159) | ○ |
| C-97 | GetTipsで全ツールチップ取得 | E-11 (L161-191) | ○ |

### StockIcon (UT-UI-098 〜 UT-UI-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | GetSmallImageで小アイコン取得 | E-12 (L124-136) | ○ |
| C-99 | GetImageでアイコン取得 | E-12 (L138-150) | ○ |
| C-100 | GetIconでハンドル取得 | E-12 (L152-157) | ○ |

### Criteria (UT-UI-101 〜 UT-UI-113)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | CreateでString型からStringCriteria | E-16 (L32-42) | ○ |
| C-102 | CreateでInteger型からIntCriteria | E-16 (L32-42) | ○ |
| C-103 | CreateでBoolean型からBooleanCriteria | E-16 (L32-42) | ○ |
| C-104 | 未サポート型でException | E-16 (L41) | ○ |
| C-105 | IntCriteria.EvalでIs条件 | E-16 (L79-89) | ○ |
| C-106 | IntCriteria.EvalでIsNot条件 | E-16 (L79-89) | ○ |
| C-107 | IntCriteria.EvalでIsHigherThan条件 | E-16 (L79-89) | ○ |
| C-108 | IntCriteria.EvalでIsLowerThan条件 | E-16 (L79-89) | ○ |
| C-109 | StringCriteria.EvalでIs条件 | E-16 (L115-126) | ○ |
| C-110 | StringCriteria.EvalでContains条件 | E-16 (L115-126) | ○ |
| C-111 | StringCriteria.EvalでDoesntContain条件 | E-16 (L115-126) | ○ |
| C-112 | BooleanCriteria.EvalでIs条件 | E-16 (L153-161) | ○ |
| C-113 | BooleanCriteria.EvalでIsNot条件 | E-16 (L153-161) | ○ |

### SimpleUI (UT-UI-114 〜 UT-UI-122)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-114 | CreateFlowPageでFlowPage生成 | E-14 (L434-450) | ○ |
| C-115 | ShowPageでページ表示 | E-14 (L211-225) | ○ |
| C-116 | AddBoolでチェックボックス追加 | E-14 (L265-274) | ○ |
| C-117 | AddNumericで数値入力追加 | E-14 (L282-290) | ○ |
| C-118 | SaveでSaveValuesイベント発火 | E-14 (L123-125) | ○ |
| C-119 | FlowPage.ApplyThemeでテーマ適用 | E-14 (L521-532) | ○ |
| C-120 | SimpleUICheckBox.SaveでField保存 | E-14 (L593-601) | ○ |
| C-121 | SimpleUINumEdit.SaveでProperty保存 | E-14 (L688-698) | ○ |
| C-122 | SimpleUIMenuButton.Saveで保存 | E-14 (L910-920) | ○ |

### ToolStripRendererEx (UT-UI-123 〜 UT-UI-125)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-123 | ApplyThemeでテーマカラー適用 | E-15 (L45-74) | ○ |
| C-124 | OnRenderMenuItemBackgroundで背景描画 | E-15 (L128-161) | ○ |
| C-125 | OnRenderItemCheckでチェック描画 | E-15 (L186-251) | ○ |

### Dynamic (UT-UI-126 〜 UT-UI-132)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | GridProperty.Valueで値型設定 | E-13 (L97-108) | ○ |
| C-127 | GridProperty.Valueで参照型コピー | E-13 (L102-106) | ○ |
| C-128 | GridTypeDescriptor.GetValueで値取得 | E-13 (L228-236) | ○ |
| C-129 | GridTypeDescriptor.GetBoolでBoolean取得 | E-13 (L242-244) | ○ |
| C-130 | YesNoConverter.ConvertFromでYes変換 | E-13 (L324-333) | ○ |
| C-131 | YesNoConverter.ConvertToでTrue変換 | E-13 (L344-354) | ○ |
| C-132 | DispNameAttribute.GetValueForEnumで表示名取得 | E-13 (L378-392) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

すべてのテストケースはソースコードを根拠として生成されています。

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 全テストケースがソースコードに基づいて生成されている
- ColorHSL/HSLColorの色変換ロジックは数学的精度のテストが重要（境界値テスト追加検討）
- ThemeManager.WindowsAccentColorはOS依存のため、環境によってはテスト不可

## 6) レビュアーチェックリスト（最小）
- [ ] ColorHSL/HSLColorの色変換テストで実際のRGB値を検証
- [ ] ThemeManager.SetCurrentThemeのスレッドセーフ性を確認
- [ ] TaskDialogのモーダル動作テストの実行環境を確認
- [ ] フォントファイル存在チェックのテスト環境を確認
- [ ] Windows固有機能（StockIcon, WindowsAccentColor）のテスト除外条件を確認
