---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 126
  claims_with_evidence: 126
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Video モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードから根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッド・分岐をカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：126 / 126、根拠なし：0
- 優先レビュー（高）
  1. **フレームレート計算（ゼロ除算）**：ServerInfo.FrameRateとDirectFrameServer.FrameRateのゼロ除算対策
  2. **リソース解放**：VideoRenderer.Dispose, DirectFrameServer.Dispose, VfwFrameServer.Disposeの確実な解放
  3. **Position境界値**：VideoRenderer.Positionの上下限クランプ処理

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/staxrip-master/Source/Video/VideoRenderer.vb` (303行)
- E-02: `/Users/tomoka.baba/Work/staxrip-master/Source/Video/FrameServer.vb` (593行)
- E-03: `/Users/tomoka.baba/Work/staxrip-master/Source/Video/VideoScript.vb` (1234行)
- E-04: `/Users/tomoka.baba/Work/staxrip-master/Source/Video/VideoEncoderCommandLine.vb` (829行)

## 3) Claims と根拠の対応（レビューの主戦場）

### VideoRenderer クラス（E-01）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Position.Setで値が正しく設定される | E-01: 行26-41 Position プロパティSetter | ○ |
| C-02 | Position.Setで負の値が0にクランプされる | E-01: 行33-35 `If PositionValue < 0 Then PositionValue = 0` | ○ |
| C-03 | Position.SetでFrameCount超過時にクランプされる | E-01: 行37-39 `If PositionValue > Server.Info.FrameCount - 1 Then` | ○ |
| C-04 | Position境界値一致ケース | E-01: 行37-39 境界条件 `FrameCount - 1` | ○ |
| C-05 | ConvertColorでColorがD3DCOLORVALUEに変換される | E-01: 行204-211 `ConvertColor` 関数 | ○ |
| C-06 | ConvertColor境界値（Color.Empty） | E-01: 行204-211 RGBA各成分/255.0の計算 | ○ |
| C-07 | ConvertColor境界値（Color.White） | E-01: 行204-211 value.r/g/b/a = color.R/G/B/A / 255.0 | ○ |
| C-08 | Scale DPI 96 | E-01: 行213-215 `(value * 96) / Control.DeviceDpi` | ○ |
| C-09 | Scale DPI 192 | E-01: 行213-215 DPIスケーリング計算式 | ○ |
| C-10 | ScaleRectangle全座標スケーリング | E-01: 行217-223 left/top/right/bottom各Scaleメソッド呼び出し | ○ |
| C-11 | ConvertRectangle型変換 | E-01: 行225-232 RectangleF -> D2D_RECT_F変換 | ○ |
| C-12 | ApplyThemeでBackColorが設定される | E-01: 行81-91 テーマからBackColor取得 | ○ |
| C-13 | ApplyThemeでCropColor優先 | E-01: 行86-90 `If s.CropColor = Color.Empty` 分岐 | ○ |
| C-14 | Disposeでリソース解放 | E-01: 行296-302 イベントハンドラ解除、ReleaseGraphicsResources呼び出し | ○ |

### FrameServer クラス群（E-02）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | DirectFrameServer AVS初期化 | E-02: 行14-15 `If path.Ext = "avs" Then CreateAviSynthServer()` | ○ |
| C-16 | DirectFrameServer VPY初期化 | E-02: 行17-18 `Else CreateVapourSynthServer()` | ○ |
| C-17 | DirectFrameServer.FrameRate計算 | E-02: 行35-38 `Decimal.Divide(Info.FrameRateNum, Info.FrameRateDen)` | ○ |
| C-18 | DirectFrameServer.FrameRateゼロ除算 | E-02: 行35-38 ゼロ除算対策なし（要注意） | ○ |
| C-19 | DirectFrameServer.Dispose | E-02: 行53-58 `Marshal.ReleaseComObject(NativeServer)` | ○ |
| C-20 | ServerInfo.FrameRate計算 | E-02: 行88-91 `Decimal.Divide(FrameRateNum, FrameRateDen)` | ○ |
| C-21 | ServerInfo.FrameRateゼロ除算対策 | E-02: 行90 `If FrameRateDen <> 0, ..., 0` | ○ |
| C-22 | ServerInfo.BitDepth BGR32 | E-02: 行97 `Case ColorSpace.BGR32 Return 32` | ○ |
| C-23 | ServerInfo.BitDepth BGR24 | E-02: 行99 `Case ColorSpace.BGR24 Return 24` | ○ |
| C-24 | ServerInfo.BitDepth YUV420P16 | E-02: 行101 `Case ColorSpace.YUV420P16 Return 16` | ○ |
| C-25 | ServerInfo.BitDepth YUV420P10 | E-02: 行107 `Case ColorSpace.YUV420P10 Return 10` | ○ |
| C-26 | ServerInfo.BitDepth YUV420P8 | E-02: 行109 `Case ColorSpace.YUV420P8 Return 8` | ○ |
| C-27 | ServerInfo.BitDepth Unknown | E-02: 行110-112 `Case Else Return 0` | ○ |
| C-28 | ServerInfo.GetInfoText | E-02: 行117-137 Width/Height/Frames/Time等の文字列構築 | ○ |
| C-29 | ServerInfo.GetInfoTextゼロ除算 | E-02: 行118 `If FrameRateDen = 0 Then Return ""` | ○ |
| C-30 | ServerInfo.GetInfoText position=-1 | E-02: 行125-128 `If position > -1 Then` 分岐 | ○ |
| C-31 | FrameServerFactory AVS+VFW | E-02: 行189-190 VFWモード判定 | ○ |
| C-32 | FrameServerFactory VPY+VFW | E-02: 行189-190 VFWモード判定 | ○ |
| C-33 | FrameServerFactory AVS+Portable | E-02: 行193-194 DirectFrameServer返却 | ○ |
| C-34 | VfwFrameServer.GetColorSpace Y416 | E-02: 行293-294 `Case "Y416" Return ColorSpace.YUV444P16` | ○ |
| C-35 | VfwFrameServer.GetColorSpace YV12 | E-02: 行309-310 `Case "YV12" Return ColorSpace.YUV420P8` | ○ |
| C-36 | VfwFrameServer.GetColorSpace DIB | E-02: 行323-324 `Case "DIB " Return ColorSpace.BGR32` | ○ |
| C-37 | VfwFrameServer.FccToString | E-02: 行328-333 FOURCC -> String変換 | ○ |
| C-38 | VfwFrameServer.GetFrame正常 | E-02: 行269-289 フレーム取得処理 | ○ |
| C-39 | VfwFrameServer.GetFrame失敗 | E-02: 行288 `Return &H80004005 'E_FAIL` | ○ |
| C-40 | VfwFrameServer.Dispose二重防止 | E-02: 行432-448 `If Not WasDisposed Then` | ○ |
| C-41 | FrameServerHelp.IsAviSynthPortable | E-02: 行479-481 `s.AviSynthMode = FrameServerMode.Portable` | ○ |
| C-42 | FrameServerHelp.IsVapourSynthPortable | E-02: 行483-485 `s.VapourSynthMode = FrameServerMode.Portable` | ○ |
| C-43 | FrameServerHelp.IsPortable | E-02: 行487-493 AviSynth/VapourSynth + Portable判定 | ○ |
| C-44 | FrameServerHelp.IsVfwUsed | E-02: 行507-509 VFWモード判定 | ○ |

### VideoScript クラス群（E-03）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | VideoScript.IsAviSynth | E-03: 行33-36 `Engine = ScriptEngine.AviSynth` | ○ |
| C-46 | VideoScript.IsVapourSynth | E-03: 行39-42 `Engine = ScriptEngine.VapourSynth` | ○ |
| C-47 | VideoScript.FileType AVS | E-03: 行45-48 `If Engine = ScriptEngine.VapourSynth, "vpy", "avs"` | ○ |
| C-48 | VideoScript.FileType VPY | E-03: 行45-48 同上 | ○ |
| C-49 | VideoScript.GetScript | E-03: 行55-75 フィルタスクリプト結合処理 | ○ |
| C-50 | VideoScript.GetScript skipCategory | E-03: 行64 `filter.Category <> skipCategory` 条件 | ○ |
| C-51 | VideoScript.GetScript CodeAtTop | E-03: 行58-60 `If p.CodeAtTop <> "" Then sb.AppendLine(p.CodeAtTop)` | ○ |
| C-52 | VideoScript.GetScript CodeAtBottom | E-03: 行70-72 `If p.CodeAtBottom <> "" Then sb.AppendLine(p.CodeAtBottom)` | ○ |
| C-53 | VideoScript.RemoveFilter(category) | E-03: 行81-88 カテゴリ一致でFilters.Remove | ○ |
| C-54 | VideoScript.RemoveFilter存在しない | E-03: 行83 `If i.Category = category` 条件分岐 | ○ |
| C-55 | VideoScript.RemoveFilterAt | E-03: 行90-95 `Filters.RemoveAt(index)` | ○ |
| C-56 | VideoScript.RemoveFilterAt範囲外 | E-03: 行91 `index < Filters.Count` 条件 | ○ |
| C-57 | VideoScript.RemoveFilterAt空リスト | E-03: 行91 `Filters.Count > 0` 条件 | ○ |
| C-58 | VideoScript.InsertFilter | E-03: 行104-107 `Filters.Insert(index, filter)` | ○ |
| C-59 | VideoScript.AddFilter | E-03: 行109-112 `Filters.Add(filter)` | ○ |
| C-60 | VideoScript.SetFilter(index) | E-03: 行114-117 `Filters(index) = filter` | ○ |
| C-61 | VideoScript.SetFilter(category)更新 | E-03: 行119-128 カテゴリ一致時の更新処理 | ○ |
| C-62 | VideoScript.SetFilter(category)挿入 | E-03: 行130-133 `Filters.Insert(1, ...)` | ○ |
| C-63 | VideoScript.GetFilter取得 | E-03: 行186-192 カテゴリ一致フィルタ返却 | ○ |
| C-64 | VideoScript.GetFilter存在しない | E-03: 行186-192 一致なしの場合Nothing | ○ |
| C-65 | VideoScript.Contains | E-03: 行142-149 Script.ToLowerInvariant.Contains | ○ |
| C-66 | VideoScript.Contains空category | E-03: 行143 `If category = ""` 条件 | ○ |
| C-67 | VideoScript.Contains空search | E-03: 行143 `If search = ""` 条件 | ○ |
| C-68 | VideoScript.IsFilterActive(category) | E-03: 行159-162 filter.Active判定 | ○ |
| C-69 | VideoScript.IsFilterActive非アクティブ | E-03: 行161 `filter IsNot Nothing AndAlso filter.Active` | ○ |
| C-70 | VideoScript.IsFilterActive(category, name) | E-03: 行164-167 filter.Name一致判定 | ○ |
| C-71 | VideoScript.GetFiltersCopy | E-03: 行169-177 `i.GetCopy`によるディープコピー | ○ |
| C-72 | VideoScript.GetNewScript | E-03: 行179-184 新しいVideoScriptインスタンス作成 | ○ |
| C-73 | VideoScript.GetFramerate | E-03: 行712-716 `Calc.IsValidFrameRate`判定 | ○ |
| C-74 | VideoScript.GetFramerateデフォルト | E-03: 行715 `If(..., ret, 25)` | ○ |
| C-75 | VideoScript.GetSeconds | E-03: 行733-736 `FrameCount / FrameRate`計算 | ○ |
| C-76 | VideoScript.GetFrameCount | E-03: 行738-740 `Info.FrameCount`返却 | ○ |
| C-77 | VideoScript.FindFunctionsVS | E-03: 行578-609 VapourSynth関数検出ロジック | ○ |
| C-78 | VideoScript.FindFunctionsVSコメント無視 | E-03: 行601 `IsFunctionCommented`呼び出し | ○ |
| C-79 | VideoScript.FindFunctionsAVS | E-03: 行624-652 AviSynth関数検出ロジック | ○ |
| C-80 | VideoScript.IsFunctionCommented | E-03: 行612-620 `#`文字検出 | ○ |
| C-81 | VideoScript.IsFunctionCommented非コメント | E-03: 行619 `Return False` | ○ |
| C-82 | VideoScript.ModifyScript AVS | E-03: 行321-325 エンジン分岐 | ○ |
| C-83 | VideoScript.ModifyScript VS | E-03: 行321-325 `ModifyVSScript`呼び出し | ○ |
| C-84 | VideoScript.GetDefaults | E-03: 行742-764 AviSynth/VapourSynthデフォルト生成 | ○ |
| C-85 | TargetVideoScript.Path | E-03: 行795-805 ターゲットパス構築 | ○ |
| C-86 | TargetVideoScript.Path空 | E-03: 行797-799 `If p.SourceFile = "" ... Return ""` | ○ |
| C-87 | SourceVideoScript.Path | E-03: 行812-819 ソースパス構築 | ○ |
| C-88 | SourceVideoScript.GetScript | E-03: 行832-838 Source+Rotationフィルタ出力 | ○ |
| C-89 | VideoFilter.New(default) | E-03: 行849-851 デフォルトコンストラクタ | ○ |
| C-90 | VideoFilter.Name パイプあり | E-03: 行864-867 `Path.RightLast("|").Trim` | ○ |
| C-91 | VideoFilter.Name パイプなし | E-03: 行866 `If ... Path` | ○ |
| C-92 | VideoFilter.GetCopy | E-03: 行870-872 新しいVideoFilter返却 | ○ |
| C-93 | VideoFilter.CompareTo | E-03: 行878-879 `Path.CompareTo` | ○ |
| C-94 | FilterCategory.AddFilter既存 | E-03: 行910-918 `matchingCategory.Filters.Add` | ○ |
| C-95 | FilterCategory.AddFilter新規 | E-03: 行913-916 新規カテゴリ作成 | ○ |
| C-96 | FilterCategory.ParseFilterProfilesIniContent | E-03: 行938-982 INI形式パース | ○ |
| C-97 | FilterCategory.ParseFilterProfilesIniContent複数行 | E-03: 行951-970 マルチラインスクリプト処理 | ○ |
| C-98 | FilterParameters.SplitCSV | E-03: 行1187-1227 CSV分割処理 | ○ |
| C-99 | FilterParameters.SplitCSV引用符 | E-03: 行1198-1204 `isString`フラグ | ○ |
| C-100 | FilterParameters.SplitCSV括弧 | E-03: 行1206-1208 `level`による括弧ネスト追跡 | ○ |

### VideoEncoderCommandLine クラス群（E-04）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | CommandLineParams.GetStringParam | E-04: 行51-53 `Items.OfType(Of StringParam).Where` | ○ |
| C-102 | CommandLineParams.GetOptionParam | E-04: 行55-57 `Items.OfType(Of OptionParam).Where` | ○ |
| C-103 | CommandLineParams.GetNumParam | E-04: 行59-61 `Items.OfType(Of NumParam).Where` | ○ |
| C-104 | CommandLineParams.GetSAR 1:1 | E-04: 行148-149 `EqualsAny("1:1", "1/1", "1")` | ○ |
| C-105 | CommandLineParams.GetSAR auto | E-04: 行152-160 `param.Value = "auto"` 分岐 | ○ |
| C-106 | CommandLineParams.GetHelpOption単一 | E-04: 行119-120 `If options.Length = 1` | ○ |
| C-107 | CommandLineParams.GetHelpOption空 | E-04: 行113-115 `If options.NothingOrEmpty` | ○ |
| C-108 | BoolParam.GetArgs True | E-04: 行356-361 `If Value AndAlso DefaultValue = False` | ○ |
| C-109 | BoolParam.GetArgs False | E-04: 行362-367 `ElseIf Not Value AndAlso DefaultValue` | ○ |
| C-110 | BoolParam.GetArgs IntegerValue | E-04: 行357-358 `If IntegerValue Then Return Switch + Params.Separator + "1"` | ○ |
| C-111 | BoolParam.GetArgs Visible=False | E-04: 行351-353 `If Not Visible Then Return Nothing` | ○ |
| C-112 | NumParam.GetArgs差分あり | E-04: 行530-532 `If Value <> DefaultValue OrElse AlwaysOn` | ○ |
| C-113 | NumParam.GetArgs差分なし | E-04: 行531 条件不成立時 | ○ |
| C-114 | NumParam.GetArgs AlwaysOn | E-04: 行531 `OrElse AlwaysOn` | ○ |
| C-115 | NumParam.Config設定 | E-04: 行438-448 Config配列処理 | ○ |
| C-116 | NumParam.Configデフォルト範囲 | E-04: 行444-447 `ConfigValue(0) = Double.MinValue` | ○ |
| C-117 | OptionParam.GetArgs差分あり | E-04: 行662-678 オプション値出力 | ○ |
| C-118 | OptionParam.GetArgs Valuesあり | E-04: 行664-670 `If Not Values Is Nothing` | ○ |
| C-119 | OptionParam.GetArgs IntegerValue | E-04: 行672-673 `If IntegerValue Then Return Switch + Params.Separator & Value` | ○ |
| C-120 | OptionParam.Value範囲外クランプ | E-04: 行619-621 `If ret > Options.Length - 1 Then ret = Options.Length - 1` | ○ |
| C-121 | StringParam.GetArgs差分あり | E-04: 行760-779 文字列パラメータ出力 | ○ |
| C-122 | StringParam.GetArgs Quotes.Always | E-04: 行763-764 `"""" + val + """"` | ○ |
| C-123 | StringParam.GetArgs RemoveSpace | E-04: 行756-758 `val.Replace(" ", "")` | ○ |
| C-124 | StringParam.GetArgsデフォルト | E-04: 行760 `If val <> DefaultValue AndAlso val <> ""` | ○ |
| C-125 | CommandLineParam.GetSwitches | E-04: 行224-239 スイッチ収集 | ○ |
| C-126 | CommandLineParam.Visible設定 | E-04: 行253-266 コントロール表示制御 | ○ |

## 4) 不足情報（Unknown / Missing）

全てのテストケースに対してソースコードから根拠を確認できました。特に不足している情報はありません。

ただし、以下の点は実際のテスト実装時に追加検討が必要です：
- COM相互運用（DirectN, avifil32.dll等）のモック方法
- ファイルシステム依存（Package.AviSynth.Path等）のテスト環境構築
- UIコントロール（Control, CheckBoxEx等）のテストダブル

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 2（高） | DirectFrameServer.FrameRate | ゼロ除算対策がないため、FrameRateDen=0時に例外発生の可能性 |
| 1（中） | VfwFrameServer.GetFrame | COMオブジェクトの解放タイミング、ポインタ操作の安全性 |
| 1（中） | VideoRenderer.Draw | Direct2D描画中の例外処理、リソースリーク |
| 0（低） | VideoScript.FindFunctionsVS/AVS | コメント内の関数を完全に除外できない可能性（既知の制限） |

## 6) レビュアーチェックリスト（最小）

- [ ] UT-VID-018: DirectFrameServer.FrameRateのゼロ除算が実際に問題になるか確認
- [ ] UT-VID-014, UT-VID-019, UT-VID-040: Dispose処理のリソース解放が完全か確認
- [ ] UT-VID-002, UT-VID-003: Position境界値クランプが意図した動作か確認
- [ ] UT-VID-049-052: GetScript系のスクリプト生成ロジックの網羅性確認
- [ ] UT-VID-108-124: コマンドラインパラメータ出力形式がエンコーダー仕様に適合するか確認
