---
generated_at: 2026-01-21 15:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 47
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：受入テストケース一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：47 / 50、根拠なし：3
- 優先レビュー（高）
  1. **UAT-043 アップデート確認**：実際のアップデートサーバー仕様未確認
  2. **UAT-044 テーマ設定**：テーマ変更機能の詳細実装未確認
  3. **UAT-049 イベントコマンド**：イベントコマンドの完全な仕様未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/MainForm.vb` - メインフォームのUI定義とイベントハンドラー
- E-02: `Source/General/Project.vb` - プロジェクト設定とプロパティ定義
- E-03: `Source/General/GlobalCommands.vb` - グローバルコマンドと各種操作機能
- E-04: `Source/Forms/PreviewForm.vb` - プレビュー画面とカット編集機能
- E-05: `Source/Forms/CropForm.vb` - クロップ設定画面
- E-06: `Source/General/Audio.vb` - オーディオ処理ロジック
- E-07: `Source/General/Muxer.vb` - Muxer設定（MKV、MP4等）
- E-08: `Source/Video/VideoEncoderCommandLine.vb` - ビデオエンコーダーコマンドライン処理
- E-09: `Source/Forms/JobsForm.vb` - ジョブ管理フォーム
- E-10: `Source/Forms/LogForm.vb` - ログ表示フォーム
- E-11: `Source/Forms/ProfilesForm.vb` - プロファイル/テンプレート管理
- E-12: `Source/Forms/StreamDemuxForm.vb` - Demux機能
- E-13: `Source/General/Thumbnailer.vb` - サムネイル生成
- E-14: `Source/Forms/VideoComparisonForm.vb` - ビデオ比較機能
- E-15: `Source/Forms/UpdateForm.vb` - アップデート確認
- E-16: `Source/UI/ThemeManager.vb` - テーマ管理
- E-17: `Source/Forms/MacrosForm.vb` - マクロ機能
- E-18: `Source/Forms/EventCommandsEditor.vb` - イベントコマンド設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UAT-001: ドラッグ&ドロップでソースファイル読み込み | E-01 (MainForm.vb: OpenVideoSourceFile) | ○ |
| C-02 | UAT-002: メニューからソースファイル選択 | E-01, E-03 (LoadSourceFile) | ○ |
| C-03 | UAT-003: 複数ソースファイル連結 | E-01, E-03 (LoadSourceFiles) | ○ |
| C-04 | UAT-004: ターゲットファイル設定 | E-01, E-02 (TargetFile Property) | ○ |
| C-05 | UAT-005: ターゲットサイズからビットレート計算 | E-01, E-02 (TargetSize, VideoBitrate) | ○ |
| C-06 | UAT-006: ビデオビットレート直接指定 | E-01, E-02 (VideoBitrate) | ○ |
| C-07 | UAT-007: ソース動画プレビュー | E-04 (PreviewForm, Renderer) | ○ |
| C-08 | UAT-008: プレビューナビゲーションボタン | E-04 (bnLeft1/2/3, bnRight1/2/3) | ○ |
| C-09 | UAT-009: カット範囲設定 | E-04 (SetRangeStart, SetRangeEnd) | ○ |
| C-10 | UAT-010: カット範囲削除 | E-04 (DeleteRange) | ○ |
| C-11 | UAT-011: 手動クロップ設定 | E-05 (CropActiveSide, MouseCrop) | ○ |
| C-12 | UAT-012: 自動クロップ機能 | E-05 (RunAutoCrop) | ○ |
| C-13 | UAT-013: スマートクロップ機能 | E-05 (RunSmartCrop) | ○ |
| C-14 | UAT-014: ターゲット解像度設定 | E-01, E-02 (TargetWidth, TargetHeight) | ○ |
| C-15 | UAT-015: x265エンコーダー設定 | E-08 (CommandLineParams) | ○ |
| C-16 | UAT-016: NVEncハードウェアエンコード | E-03 (NVEnc.Test), E-08 | ○ |
| C-17 | UAT-017: QSVEncハードウェアエンコード | E-03 (QSVEnc.Test), E-08 | ○ |
| C-18 | UAT-018: オーディオトラック追加 | E-06 (Audio.Process), E-02 (AudioFiles, AudioTracks) | ○ |
| C-19 | UAT-019: オーディオAACエンコード | E-06 (GUIAudioProfile) | ○ |
| C-20 | UAT-020: オーディオパススルー | E-06 (MuxAudioProfile) | ○ |
| C-21 | UAT-021: 字幕ファイル追加 | E-07 (Subtitles Property) | ○ |
| C-22 | UAT-022: 字幕ハードコード | E-02 (AddHardcodedSubtitleFilter) | ○ |
| C-23 | UAT-023: MKVコンテナ出力 | E-07 (MkvMuxer Class) | ○ |
| C-24 | UAT-024: MP4コンテナ出力 | E-07 (MP4Muxer Class) | ○ |
| C-25 | UAT-025: ビデオフィルター追加 | E-02 (Script, VideoFilter) | ○ |
| C-26 | UAT-026: フィルター有効/無効切替 | E-02 (VideoFilter.Active) | ○ |
| C-27 | UAT-027: ジョブキュー追加 | E-09 (JobsForm) | ○ |
| C-28 | UAT-028: 複数ジョブ連続実行 | E-03 (StartJobs, g.ProcessJobs) | ○ |
| C-29 | UAT-029: ジョブ削除 | E-09 (JobsForm) | ○ |
| C-30 | UAT-030: エンコード実行・完了 | E-03, E-01 | ○ |
| C-31 | UAT-031: エンコード中止 | E-03 (AbortException) | ○ |
| C-32 | UAT-032: テンプレート保存 | E-11 (ProfilesForm), E-02 (TemplateName) | ○ |
| C-33 | UAT-033: テンプレート読み込み | E-11, E-01 (LoadTemplateWithSelectionDialog) | ○ |
| C-34 | UAT-034: プロジェクト保存 | E-01, E-02 (Project Class, ISafeSerialization) | ○ |
| C-35 | UAT-035: プロジェクト読み込み | E-01 (OpenProject) | ○ |
| C-36 | UAT-036: ログ確認 | E-10 (LogForm), E-03 (ShowLogFile) | ○ |
| C-37 | UAT-037: メディア情報表示 | E-03 (ShowMediaInfo) | ○ |
| C-38 | UAT-038: Demux機能 | E-12 (StreamDemuxForm), E-03 (ShowDemuxTool) | ○ |
| C-39 | UAT-039: サムネイル生成 | E-13, E-03 (ShowThumbnailerDialogAsync) | ○ |
| C-40 | UAT-040: アシスタント機能 | E-01 (gbAssistant, laTip, bnNext) | ○ |
| C-41 | UAT-041: アプリケーション設定 | E-01 (ShowOptionsDialog) | ○ |
| C-42 | UAT-042: ツール管理 | E-03 (Package.Items), AppsForm | ○ |
| C-43 | UAT-043: アップデート確認 | E-15, E-03 (CheckForUpdate) | △ |
| C-44 | UAT-044: テーマ設定 | E-16 (ThemeManager) | △ |
| C-45 | UAT-045: 圧縮率チェック | E-02 (AutoCompCheck, CompCheckAction) | ○ |
| C-46 | UAT-046: ビデオ比較 | E-14 (VideoComparisonForm) | ○ |
| C-47 | UAT-047: コマンドライン直接編集 | E-08 (GetCommandLine, Edit) | ○ |
| C-48 | UAT-048: マクロ機能 | E-17 (MacrosForm), E-03 (ShowMacrosDialog) | ○ |
| C-49 | UAT-049: イベントコマンド | E-18 (EventCommandsEditor) | △ |
| C-50 | UAT-050: HDR処理 | E-02 (SourceVideoHdrFormat, HdrDolbyVisionMetadataFile) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UAT-043 アップデート確認**: StaxRipUpdate.CheckForUpdateAsyncの実際のサーバー通信仕様が未確認
  - 候補：ネットワークテスト / サーバー仕様書 / 実機テスト
- **UAT-044 テーマ設定**: ThemeManager.vbの詳細なテーマ切替ロジック確認が必要
  - 候補：ThemeManager.vb詳細解析 / UIテスト
- **UAT-049 イベントコマンド**: イベントコマンドの全種類と実行タイミングの完全な仕様が未確認
  - 候補：EventCommandsEditor.vb詳細解析 / ユーザーマニュアル

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: C-01〜C-42, C-45〜C-48, C-50 - コードから直接確認可能な機能
- **1 (中リスク)**: C-43, C-44 - 外部依存または詳細実装の確認が必要
- **2 (高リスク)**: C-49 - イベントコマンドの完全性検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] UAT-001〜UAT-010: ソースファイル操作とプレビュー機能のテスト手順が実際のUIと一致しているか
- [ ] UAT-011〜UAT-014: クロップ・リサイズ機能のテスト手順がユーザー操作と整合しているか
- [ ] UAT-015〜UAT-020: エンコーダー・オーディオ設定のテストケースが主要なユースケースをカバーしているか
- [ ] UAT-021〜UAT-026: 字幕・フィルター・Muxer設定のテストケースが正確か
- [ ] UAT-027〜UAT-035: ジョブ管理・プロジェクト管理のフローが正しいか
- [ ] UAT-036〜UAT-042: ユーティリティ機能のテストケースが適切か
- [ ] UAT-043〜UAT-050: 特殊機能（アップデート、テーマ、HDR等）のテストケースが要確認
- [ ] 全体: 優先度（高/中/低）の設定が適切か
- [ ] 全体: テスト手順の記述が実行可能な粒度で書かれているか
