---
generated_at: 2026-01-21 16:15:00
metrics:
  claims_total: 5
  claims_with_evidence: 5
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：5 / 5、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります。特に優先的なレビュー項目はありません。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Thumbnailer.vb` - サムネイル画像生成クラス
- E-02: `Source/General/LogBuilder.vb` - ログ出力クラス
- E-03: `Source/Video/VideoScript.vb` - ビデオスクリプト生成クラス
- E-04: `Source/Forms/LogForm.vb` - ログ表示・保存フォーム

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | サムネイル画像：ビデオファイルのサムネイル画像を生成（JPG/PNG/BMP/GIF/TIF形式） | E-01: Thumbnailer.vb Line 131-138でImageFormat設定、Line 270でimage.Save() | ○ |
| C-02 | 処理ログ：エンコード処理のログをテキストファイルとして出力 | E-02: LogBuilder.vb Line 171-181のSaveメソッド、WriteFileUTF8でUTF-8出力 | ○ |
| C-03 | AviSynthスクリプト：.avs形式でビデオフィルタスクリプトを生成 | E-03: VideoScript.vb Line 45-48でFileTypeプロパティ（.avs）、Line 291-294でファイル書き込み | ○ |
| C-04 | VapourSynthスクリプト：.vpy形式でPythonベースのビデオフィルタスクリプトを生成 | E-03: VideoScript.vb Line 45-48でFileTypeプロパティ（.vpy）、Line 291-294でWriteFileUTF8 | ○ |
| C-05 | 難読化ログ：個人情報を隠した形式でログを出力 | E-04: LogForm.vb Line 43-53のSave Obfuscated As機能、g.ObfuscateLogFile呼び出し | ○ |

## 4) 不足情報（Unknown / Missing）
- 本プロジェクトは従来のビジネスアプリケーションとは異なり、印刷可能な帳票（PDF、Excel等）を出力する機能は実装されていません。
- 上記で抽出した「帳票」は、ビデオエンコーディングソフトウェアにおける出力ファイル（画像、ログ、スクリプト）を帳票として分類しています。
- 候補：なし（追加の帳票機能は確認されませんでした）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードによって裏付けられています
- 注意点：このプロジェクトはビデオエンコーディングツールであり、一般的なビジネスアプリケーションの「帳票」（請求書、レポート等）とは性質が異なります

## 6) レビュアーチェックリスト（最小）
- [x] サムネイル画像出力がThumbnailr.vbで実装されていることを確認
- [x] ログ出力がLogBuilder.vbで実装されていることを確認
- [x] スクリプト出力がVideoScript.vbで実装されていることを確認
- [x] 難読化ログがLogForm.vbで実装されていることを確認
- [ ] プロジェクト固有の出力要件に追加の帳票が必要か確認
