# 帳票設計書 2-処理ログ

## 概要

本ドキュメントは、StaxRipにおける処理ログ出力機能の設計書である。エンコード処理の各ステップをテキストファイルとして記録し、処理履歴の確認やトラブルシューティングに使用される。

### 本帳票の処理概要

処理ログ機能は、エンコードジョブの実行中に発生する各種イベント・処理結果・エラー情報などをテキスト形式で記録し、ログファイルとして出力する機能である。

**業務上の目的・背景**：エンコード処理は長時間にわたることが多く、処理完了後に各ステップの成功・失敗を確認する必要がある。また、エラー発生時の原因調査やサポート依頼時のデバッグ情報提供のため、詳細な処理記録が必要となる。

**帳票の利用シーン**：エンコード処理完了後の結果確認時、エラー発生時のトラブルシューティング時、バグレポート作成時、処理時間の分析時。

**主要な出力内容**：
1. システム環境情報（StaxRipバージョン、OS、CPU、RAM、GPU、解像度、DPI）
2. エンコード設定情報（テンプレート、ビデオエンコーダー、コンテナ、オーディオトラック）
3. 各処理ステップのヘッダーと内容
4. 処理の開始・終了時刻と所要時間

**帳票の出力タイミング**：エンコード処理中に随時追記され、処理完了時およびLogBuilder.Saveメソッド呼び出し時にファイル保存される。

**帳票の利用者**：動画編集者、エンコード担当者、テクニカルサポート担当者、開発者。

## 帳票種別

ログ出力（テキストログ）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 11 | LogForm | ログ表示フォーム | メニュー View > Log または自動保存 |
| - | MainForm | メインフォーム | 処理完了時に自動保存 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキストファイル (.log) |
| 用紙サイズ | - |
| 向き | - |
| ファイル名 | {ターゲットファイル名}_staxrip.log |
| 出力方法 | ファイル保存（UTF-8） |
| 文字コード | UTF-8 |

### ファイルパス決定ロジック

| 条件 | 出力パス |
|-----|---------|
| SourceFileが空 | {Temp}/staxrip.log |
| TempDirが空 | {SourceFile.Dir}/{SourceFile.FileName}_staxrip.log |
| 上記以外 | {TempDir}/{TargetFile.Base}_staxrip.log |

## 帳票レイアウト

### レイアウト概要

処理ログは、セクション区切りヘッダーと内容で構成される構造化テキスト形式である。

```
┌─────────────────────────────────────┐
│  ---------- Section Name ---------- │
│                                     │
│  Content lines...                   │
│                                     │
│  Start:    HH:MM:SS                 │
│  End:      HH:MM:SS                 │
│  Duration: HH:MM:SS                 │
│                                     │
│  ---------- Section Name ---------- │
│  ...                                │
└─────────────────────────────────────┘
```

### ヘッダー部（セクションヘッダー）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | ヘッダー線 | セクション区切り | 固定フォーマット | ------ {タイトル} ------ |

**ヘッダーフォーマット仕様**：
- 全体幅: 65文字
- 形式: `"--" + "-".Repeat(len) + " " + title + " " + "-".Repeat(len) + "--"`
- len = (65 - title.Length) / 2

### 明細部（セクション内容）

#### System Environment セクション

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | StaxRip | アプリケーションバージョン | g.DefaultCommands.GetApplicationDetails | StaxRip: {version} |
| 2 | Settings | 設定バージョン | s.Version | Settings: v{Major}.{Minor}.{Build} |
| 3 | Windows | OSバージョン | OSVersion.VersionString | Windows: {version} |
| 4 | Language | 言語設定 | CultureInfo.CurrentCulture | Language: {name} |
| 5 | CPU | CPU名 | レジストリ | CPU: {name} |
| 6 | RAM | 総物理メモリ | ComputerInfo.TotalPhysicalMemory | RAM: {size}GB |
| 7 | GPU | ビデオコントローラ | OS.VideoControllers | GPU: {name1}, {name2}... |
| 8 | Resolution | 画面解像度 | Screen.PrimaryScreen.Bounds | Resolution: {W} x {H} |
| 9 | DPI | DPI設定 | g.DPI | DPI: {value} |
| 10 | Code Page | コードページ | TextEncoding.CodePageOfSystem | Code Page: {value} |

#### Configuration セクション

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Template | テンプレート名 | p.TemplateName | Template: {name} |
| 2 | Video Encoder | エンコーダータイプ | p.VideoEncoder.GetType().Name | Video Encoder: {type} |
| 3 | Video Encoder Profile | エンコーダープロファイル名 | p.VideoEncoder.Name | Video Encoder Profile: {name} |
| 4 | Container/Muxer Profile | Muxerプロファイル名 | p.VideoEncoder.Muxer.Name | Container/Muxer Profile: {name} |
| 5 | Audio Tracks | オーディオトラック一覧 | p.AudioTracks | 番号. 名前 (コーデック) [言語]: パス |
| 6 | AviSynth/VapourSynth Mode | フレームサーバーモード | s.AviSynthMode/s.VapourSynthMode | AviSynth/VapourSynth Mode: {mode}/{mode} |
| 7 | Process Priority | 処理優先度 | s.ProcessPriority | Process Priority: {priority} |
| 8 | Delete Temp Files | 一時ファイル削除設定 | p.DeleteTempFilesMode | Delete Temp Files: {mode} |
| 9 | Delete Temp Files Selection | 削除対象選択モード | p.DeleteTempFilesSelectionMode | Delete Temp Files Selection: {mode} |

### フッター部（統計情報）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Start | 処理開始時刻 | StartTime | Start: HH:MM:SS |
| 2 | End | 処理終了時刻 | DateTime.Now | End: HH:MM:SS |
| 3 | Duration | 処理所要時間 | DateTime.Now - StartTime | Duration: HH:MM:SS |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ログ内容存在 | Log.Length > 0 | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 時系列（書き込み順） | 昇順 |

### 改ページ条件

改ページなし（連続テキスト）

## データベース参照仕様

### 参照テーブル一覧

本機能はデータベースを使用しない。

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| - | - | - |

### 外部データソース

| ソース | 用途 | 取得方法 |
|--------|------|---------|
| レジストリ | CPU名取得 | Registry.LocalMachine.GetString |
| ComputerInfo | RAM情報取得 | Microsoft.VisualBasic.Devices.ComputerInfo |
| Project | プロジェクト設定 | p（グローバル変数） |
| ApplicationSettings | アプリケーション設定 | s（グローバル変数） |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| ヘッダー左右パディング | (65 - title.Length) / 2 | 整数除算 | - |
| 処理時間 | DateTime.Now - StartTime | - | TimeSpan |
| RAM (GB) | TotalPhysicalMemory / 1024^3 | 小数点以下切り捨て | - |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[処理開始] --> B[WriteEnvironment呼び出し]
    B --> C[WriteConfiguration呼び出し]
    C --> D[各処理ステップ実行]
    D --> E{エラー発生?}
    E -->|Yes| F[エラー情報追記]
    E -->|No| G[処理内容追記]
    F --> H[WriteStats呼び出し]
    G --> H
    H --> I{次のステップ?}
    I -->|Yes| D
    I -->|No| J[Save呼び出し]
    J --> K[UTF-8でファイル出力]
    K --> L[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ログ空 | Log.Length = 0 | - | Save処理をスキップ |
| 書き込み失敗 | ファイルアクセスエラー | 例外メッセージ | 例外をスロー |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数KB〜数百KB |
| 目標出力時間 | 瞬時 |
| 同時出力数上限 | 1（SyncLockで排他制御） |

## セキュリティ考慮事項

- ファイルパスやシステム情報が含まれるため、個人情報が露出する可能性あり
- バグレポート送信時は難読化ログ（別帳票）の使用を推奨
- ログファイルへの書き込みにはファイルシステム権限が必要

## 備考

- EnvironmentStringはキャッシュされ、アプリケーション起動後最初の呼び出し時のみ生成される
- SyncLockによりスレッドセーフに書き込みが行われる
- FormatColumnメソッドによりコロン位置が揃えられて出力される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ログビルダークラスの基本構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LogBuilder.vb | `Source/General/LogBuilder.vb` | Line 8-11でフィールド定義（StartTime, Log, Last）を確認 |
| 1-2 | Project.vb | `Source/General/Project.vb` | LogプロパティでLogBuilderインスタンス管理を確認 |

**読解のコツ**: LogBuilderはSerializable属性を持ち、StringBuilderをラップしてスレッドセーフなログ追記を実現している。

#### Step 2: エントリーポイントを理解する

ログ出力の呼び出し元を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LogBuilder.vb | `Source/General/LogBuilder.vb` | WriteHeader/Write/WriteLineメソッドが各処理から呼び出される |
| 2-2 | Proc.vb | `Source/General/Proc.vb` | 外部プロセス実行時のログ出力を確認 |

**主要処理フロー**:
1. **Line 13-21**: Appendメソッド - SyncLockでスレッドセーフに追記
2. **Line 39-57**: Writeメソッド - タイトル付きセクションの書き込み
3. **Line 77-87**: WriteHeaderメソッド - セクションヘッダーのみ書き込み
4. **Line 171-181**: Saveメソッド - UTF-8でファイル出力

#### Step 3: 環境情報出力処理を理解する

システム環境情報の収集・出力処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LogBuilder.vb | `Source/General/LogBuilder.vb` | WriteEnvironment（Line 96-116）でシステム情報収集を確認 |

**主要処理フロー**:
- **Line 97**: 重複出力防止チェック
- **Line 99**: "System Environment"ヘッダー出力
- **Line 103-113**: EnvironmentString生成（キャッシュ利用）
- **Line 115**: FormatColumnでコロン位置揃え出力

#### Step 4: 設定情報出力処理を理解する

エンコード設定情報の出力処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | LogBuilder.vb | `Source/General/LogBuilder.vb` | WriteConfiguration（Line 118-144）で設定情報出力を確認 |

**主要処理フロー**:
- **Line 119**: "Configuration"ヘッダー出力
- **Line 121-127**: オーディオトラック情報の構築
- **Line 129-141**: 各設定項目の文字列構築
- **Line 143**: FormatColumnでコロン位置揃え出力

#### Step 5: 統計情報出力処理を理解する

処理時間統計の出力処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | LogBuilder.vb | `Source/General/LogBuilder.vb` | WriteStats（Line 146-157）で時刻・所要時間出力を確認 |

**主要処理フロー**:
- **Line 150-151**: 処理時間計算
- **Line 153-156**: Start/End/Durationフォーマット出力

#### Step 6: ファイル保存処理を理解する

ログファイルの保存処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 6-1 | LogBuilder.vb | `Source/General/LogBuilder.vb` | Save（Line 171-181）とGetPath（Line 183-195）を確認 |

**主要処理フロー**:
- **Line 176-179**: SyncLock内でファイル書き込み
- **Line 183-195**: 出力パス決定ロジック

### プログラム呼び出し階層図

```
エンコード処理開始
    │
    ├─ p.Log.WriteEnvironment()
    │      └─ WriteHeader("System Environment")
    │      └─ WriteLine(EnvironmentString)
    │
    ├─ p.Log.WriteConfiguration()
    │      └─ WriteHeader("Configuration")
    │      └─ WriteLine(configurationString)
    │
    ├─ [各処理ステップ]
    │      ├─ p.Log.Write(title, content)
    │      │      └─ FormatHeader(title)
    │      │      └─ Append(content)
    │      │
    │      └─ p.Log.WriteStats()
    │             └─ Append(Start/End/Duration)
    │
    └─ p.Log.Save()
           └─ Log.ToString.WriteFileUTF8(GetPath())
```

### データフロー図

```
[入力]                    [処理]                         [出力]

システム情報 ────────▶ WriteEnvironment() ────────▶ ログバッファ
  (OS, CPU, RAM等)                                        │
                                                          ▼
プロジェクト設定 ────▶ WriteConfiguration() ──────▶ ログバッファ
  (Template, Encoder等)                                   │
                                                          ▼
各処理結果 ──────────▶ Write() / WriteLine() ──────▶ ログバッファ
                                                          │
                                                          ▼
処理時刻 ────────────▶ WriteStats() ───────────────▶ ログバッファ
  (StartTime, Now)                                        │
                                                          ▼
                         Save()
                           │
                           ▼
                      GetPath() ──────────────────▶ ログファイル
                                                   (.log UTF-8)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LogBuilder.vb | `Source/General/LogBuilder.vb` | ソース | ログ構築・保存メインロジック |
| Project.vb | `Source/General/Project.vb` | ソース | LogBuilderインスタンス管理 |
| Proc.vb | `Source/General/Proc.vb` | ソース | 外部プロセス実行時のログ出力 |
| LogForm.vb | `Source/Forms/LogForm.vb` | ソース | ログ表示UI |
| LogForm.Designer.vb | `Source/Forms/LogForm.Designer.vb` | ソース | デザイナー生成コード |
| General.vb | `Source/General/General.vb` | ソース | 拡張メソッド（WriteFileUTF8等） |
