---
generated_at: 2026-01-21 18:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-サムネイル画像

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠が確認された

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Thumbnailer.vb` - サムネイル生成メインロジック（428行）
- E-02: `Source/General/GlobalCommands.vb` - メニュー呼び出し
- E-03: `Source/Video/VideoScript.vb` - VapourSynthスクリプト生成
- E-04: `Source/Forms/MainForm_ShowOptions.vb` - サムネイラー設定UI
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 出力形式はJPG/PNG/BMP/GIF/TIFの5種類 | E-01: Line 131-139でImageFormat.Jpeg/Png/Bmp/Gif/Tiff設定 | ○ |
| C-02 | サムネイル幅は0〜1920ピクセル（デフォルト600） | E-01: Line 74 `Mathf.Clamp(settings.GetInt("ThumbWidth", 600), 0, 1920)` | ○ |
| C-03 | 列数は1〜50（デフォルト4） | E-01: Line 82 `Mathf.Clamp(settings.GetInt("Columns", 4), 1, 50)` | ○ |
| C-04 | 行数は1〜80（デフォルト6） | E-01: Line 83 `Mathf.Clamp(settings.GetInt("Rows", 6), 1, 80)` | ○ |
| C-05 | 時間間隔は1〜1800秒（デフォルト60） | E-01: Line 81 `Mathf.Clamp(settings.GetInt("Interval", 60), 1, 1800)` | ○ |
| C-06 | 画質は1〜100（デフォルト70） | E-01: Line 129 `Mathf.Clamp(settings.GetInt("ImageQuality", 70), 1, 100)` | ○ |
| C-07 | VapourSynth必須確認 | E-01: Line 26 `If Not Package.VapourSynth.VerifyOK(True) Then Return` | ○ |
| C-08 | 3並列ソース処理制御 | E-01: Line 28 `Using semaSlim = New SemaphoreSlim(3)` | ○ |
| C-09 | 4並列フレーム取得 | E-01: Line 211 `New ParallelOptions() With {.MaxDegreeOfParallelism = 4}` | ○ |
| C-10 | HDRトーンマップ処理（libplacebo） | E-01: Line 303-305 `core.placebo.Tonemap` | ○ |
| C-11 | ヘッダーにファイル情報表示 | E-01: Line 340-348 GetHeaderInfosAsyncでFilename/FileSize/Duration等取得 | ○ |
| C-12 | ビデオストリーム情報表示 | E-01: Line 350-376 ビデオストリームループ処理 | ○ |
| C-13 | オーディオストリーム情報表示 | E-01: Line 378-394 オーディオストリームループ処理 | ○ |
| C-14 | 字幕ストリーム情報表示 | E-01: Line 396-411 テキストストリームループ処理 | ○ |
| C-15 | タイムスタンプ描画 | E-01: Line 232-250 GraphicsPath使用のタイムスタンプ描画 | ○ |
| C-16 | サムネイル高さはDARを考慮し4の倍数 | E-01: Line 75-77 `thumbHeight = CInt(thumbWidth / dar)` / `thumbHeight -= thumbHeight Mod 4` | ○ |
| C-17 | ffms2ソースフィルタ使用 | E-01: Line 293 `core.ffms2.Source` | ○ |
| C-18 | 出力パスはマクロ展開 | E-01: Line 146-149 `Macro.Expand(...)` | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主要機能はソースコードから確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] Line 74-83の設定値範囲が実際のUI設定と整合しているか確認
- [ ] HDRトーンマップ処理の前提条件（libplacebo有効）が適切に説明されているか確認
- [ ] 並列処理のスレッド数（3並列・4並列）がパフォーマンス要件と整合しているか確認
