---
generated_at: 2026-01-21 18:48:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-処理ログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠が確認された

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/LogBuilder.vb` - ログ構築・保存メインロジック（196行）
- E-02: `Source/General/Project.vb` - Logプロパティ定義
- E-03: `Source/Forms/LogForm.vb` - ログ表示UI
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 出力形式はUTF-8テキストファイル（.log） | E-01: Line 178 `WriteFileUTF8(GetPath(proj))` | ○ |
| C-02 | SyncLockによるスレッドセーフ書き込み | E-01: Line 14, 24, 40, 71, 160, 166, 176で`SyncLock Log/WriteLock` | ○ |
| C-03 | ヘッダーフォーマットは65文字幅 | E-01: Line 90 `Dim len = (65 - value.Length) \ 2` | ○ |
| C-04 | ヘッダー形式は"--{dash} title {dash}--" | E-01: Line 91 `"--" + "-".Multiply(len) + " " + value + " " + "-".Multiply(len) + "--"` | ○ |
| C-05 | システム環境情報にStaxRipバージョン含む | E-01: Line 104 `"StaxRip:" + g.DefaultCommands.GetApplicationDetails(False, True)` | ○ |
| C-06 | システム環境情報にOS/CPU/RAM/GPU/解像度/DPI含む | E-01: Line 106-113でWindows/Language/CPU/RAM/GPU/Resolution/DPI/CodePage取得 | ○ |
| C-07 | 設定情報にテンプレート名含む | E-01: Line 130 `$"Template: {p.TemplateName}"` | ○ |
| C-08 | 設定情報にビデオエンコーダー情報含む | E-01: Line 131-132 `p.VideoEncoder.GetType().Name` / `p.VideoEncoder.Name` | ○ |
| C-09 | 設定情報にオーディオトラック一覧含む | E-01: Line 122-127でオーディオトラックループ処理 | ○ |
| C-10 | 統計情報にStart/End/Duration出力 | E-01: Line 153-156 `"Start:", "End:", "Duration:"` 出力 | ○ |
| C-11 | 所要時間計算はDateTime.Now - StartTime | E-01: Line 151 `Dim dt = DateTime.Now.Subtract(start)` | ○ |
| C-12 | 出力パスはSourceFile/TempDir/TargetFileから決定 | E-01: Line 183-195 GetPath()で条件分岐 | ○ |
| C-13 | SourceFile空の場合はTemp/staxrip.log | E-01: Line 189 `Return Path.Combine(Folder.Temp, "staxrip.log")` | ○ |
| C-14 | EnvironmentStringはキャッシュされる | E-01: Line 94 `Shared EnvironmentString As String` / Line 103 `If EnvironmentString = "" Then` | ○ |
| C-15 | ログ長0の場合はSave処理スキップ | E-01: Line 177 `If Log.Length > 0 Then` | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主要機能はソースコードから確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] Line 103-113のEnvironmentString生成でシステム情報が正しく取得されるか確認
- [ ] Line 183-195の出力パス決定ロジックが意図通りか確認
- [ ] SyncLock対象（Log, WriteLock）の使い分けが適切か確認
