---
generated_at: 2026-01-21 18:52:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-AviSynthスクリプト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠が確認された

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Video/VideoScript.vb` - スクリプト生成メインロジック（1234行）
- E-02: `Source/Forms/CodeEditor.vb` - コードエディタUI
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 出力形式は.avs（AviSynthスクリプト） | E-01: Line 45-48 `FileType = If(Engine = ScriptEngine.VapourSynth, "vpy", "avs")` | ○ |
| C-02 | 文字コードはシステム依存（EncodingOfProcess） | E-01: Line 294 `ModifyScript(code, Engine).WriteFile(Path, TextEncoding.EncodingOfProcess)` | ○ |
| C-03 | CodeAtTopがスクリプト先頭に追加される | E-01: Line 58-60 `If p.CodeAtTop <> "" Then sb.AppendLine(p.CodeAtTop)` | ○ |
| C-04 | CodeAtBottomがスクリプト末尾に追加される | E-01: Line 70-72 `If p.CodeAtBottom <> "" Then sb.AppendLine(p.CodeAtBottom)` | ○ |
| C-05 | Activeフィルタのみが出力対象 | E-01: Line 63 `If filter.Active Then` | ○ |
| C-06 | LoadPluginでDLLプラグインをロード | E-01: Line 483 `Dim load = "LoadPlugin(""" + fp + """)" + BR` | ○ |
| C-07 | ImportでAVSIスクリプトをインポート | E-01: Line 524 `Dim avsiImport = "Import(""" + fp + """)" + BR` | ○ |
| C-08 | ポータブルモード時はAddAutoloadDirが追加される | E-01: Line 694-695 `If FrameServerHelp.IsPortable Then ret.AppendLine($"AddAutoloadDir(...)")` | ○ |
| C-09 | オートロードフォルダ内のプラグインはロード省略 | E-01: Line 488 `Not IsAvsPluginInAutoLoadFolder(plugin.Filename)` | ○ |
| C-10 | FindFunctionsAVSでスクリプトから関数名抽出 | E-01: Line 473 `Dim functions = FindFunctionsAVS(scriptLower)` / Line 624-652 | ○ |
| C-11 | 依存プラグイン（Dependencies）も自動ロード | E-01: Line 493-522 `If Not plugin.Dependencies.NothingOrEmpty Then` | ○ |
| C-12 | デフォルトフィルタは埋め込みリソースから読み込み | E-01: Line 922-928 `GetManifestResourceStream("StaxRip.AviSynthFilterProfileDefaults.txt")` | ○ |
| C-13 | ソースフィルタはFilters(0)に必須 | E-01: Line 772-775 `If Filters.Count = 0 OrElse Filters(0).Category <> "Source" Then MsgError(...)` | ○ |
| C-14 | Synchronizeメソッドでスクリプト同期 | E-01: Line 194-319 Synchronize Sub定義 | ○ |
| C-15 | フレームサーバー起動でInfo/Error取得 | E-01: Line 305-313 `Using server = FrameServerFactory.Create(Path)` | ○ |
| C-16 | Engine=AviSynthの判定 | E-01: Line 33-36 `ReadOnly Property IsAviSynth ... Return Engine = ScriptEngine.AviSynth` | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主要機能はソースコードから確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] Line 468-571のプラグインロードコード生成が正しく動作するか確認
- [ ] Line 624-652のFindFunctionsAVS関数がコメント内の関数名を誤検出しないか確認
- [ ] ポータブルモード判定（FrameServerHelp.IsPortable）が正しく動作するか確認
