---
generated_at: 2026-01-21 18:56:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-VapourSynthスクリプト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠が確認された

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Video/VideoScript.vb` - スクリプト生成メインロジック（1234行）
- E-02: `Source/Forms/CodeEditor.vb` - コードエディタUI
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 出力形式は.vpy（VapourSynthスクリプト） | E-01: Line 45-48 `FileType = If(Engine = ScriptEngine.VapourSynth, "vpy", "avs")` | ○ |
| C-02 | 文字コードはUTF-8 | E-01: Line 292 `ModifyScript(code, Engine).WriteFileUTF8(Path)` | ○ |
| C-03 | import vapoursynth as vs が追加される | E-01: Line 354 `clip.AppendLine("import vapoursynth as vs")` | ○ |
| C-04 | core = vs.core が追加される | E-01: Line 355 `clip.AppendLine("core = vs.core")` | ○ |
| C-05 | ポータブルプラグインロードが追加される | E-01: Line 356 `clip.AppendLine(GetVsPortableAutoLoadPluginCode())` | ○ |
| C-06 | sys.path.appendでスクリプトパス追加 | E-01: Line 357 `sys.path.append(r"" + ... + "")` | ○ |
| C-07 | .pyスクリプトはSourceFileLoaderでロード | E-01: Line 404 `module = importlib.machinery.SourceFileLoader(...)` | ○ |
| C-08 | DLLはcore.std.LoadPluginでロード | E-01: Line 420-422 `core.std.LoadPlugin(r"...", altsearchpath=True)` | ○ |
| C-09 | AVS互換プラグインはcore.avs.LoadPluginでロード | E-01: Line 420-421 `core.avs.LoadPlugin(r"...")` | ○ |
| C-10 | set_output()が存在しない場合は自動追加 | E-01: Line 367-369 `If Not clip.ToString().Contains(".set_output(") Then clip.Append("clip.set_output()")` | ○ |
| C-11 | FindFunctionsVSでスクリプトから関数名抽出 | E-01: Line 375 `Dim functions = FindFunctionsVS(script)` / Line 578-610 | ○ |
| C-12 | 要件未充足プラグインはコメントアウト | E-01: Line 424-425 `If Not plugin.RequirementsFulfilled Then code += "# !! ... commented out ..."` | ○ |
| C-13 | Engine=VapourSynthの判定 | E-01: Line 39-42 `ReadOnly Property IsVapourSynth ... Return Engine = ScriptEngine.VapourSynth` | ○ |
| C-14 | デフォルトフィルタは埋め込みリソースから読み込み | E-01: Line 930-936 `GetManifestResourceStream("StaxRip.VapourSynthFilterProfileDefaults.txt")` | ○ |
| C-15 | VapourSynth/vspipeパッケージの検証 | E-01: Line 297-301 `If Not Package.AviSynth.VerifyOK OrElse Not Package.VapourSynth.VerifyOK OrElse Not Package.vspipe.VerifyOK` | ○ |
| C-16 | RGB変換時はmatrix自動判定 | E-01: Line 246-256 `if '_Matrix' in props ... else: if %source_height% > 576: matrix = m_709` | ○ |
| C-17 | libp2p.Pack()でRGBパッキング | E-01: Line 280 `clip = clip.libp2p.Pack()` | ○ |
| C-18 | オートロードフォルダ内のプラグインはロード省略 | E-01: Line 419 `Not IsVsPluginInAutoLoadFolder(plugin.Filename)` | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主要機能はソースコードから確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] Line 346-372のModifyVSScriptでインポート文が正しく追加されるか確認
- [ ] Line 578-610のFindFunctionsVS関数がコメント内の関数名を誤検出しないか確認
- [ ] Line 217-284のRGB変換コードがすべてのHDR形式に対応しているか確認
- [ ] SourceFileLoaderによるPythonモジュールロードがセキュリティ上安全か確認
