---
generated_at: 2026-01-21 19:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-難読化ログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠が確認された

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/LogForm.vb` - UI・メニュー処理（104行）
- E-02: `Source/General/GlobalClass.vb` - ObfuscateLogFile関数（Line 1122-1139）
- E-03: `Source/General/Project.vb` - SourceFileプロパティ
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メニュー「Save Obfuscated As...」から呼び出し | E-01: Line 43 `cms.Add("Save Obfuscated As...", Sub()...` | ○ |
| C-02 | ショートカットキーはCtrl+Alt+S | E-01: Line 53 `Keys.Control Or Keys.Alt Or Keys.S` | ○ |
| C-03 | デフォルトファイル名は"Source"+拡張子 | E-01: Line 46 `dialog.FileName = "Source" & p.Log.GetPath.ExtFull` | ○ |
| C-04 | g.ObfuscateLogFile関数で難読化処理 | E-01: Line 50 `g.ObfuscateLogFile(rtb.Text.FixBreak, p)` | ○ |
| C-05 | 出力形式はUTF-8 | E-01: Line 50 `.WriteFileUTF8(dialog.FileName)` | ○ |
| C-06 | 空テキストの場合は空文字返却 | E-02: Line 1123 `If String.IsNullOrWhiteSpace(text) Then Return ""` | ○ |
| C-07 | SourceFile空の場合は元テキスト返却 | E-02: Line 1125 `If String.IsNullOrWhiteSpace(p.SourceFile) Then Return text` | ○ |
| C-08 | フォルダ名のデフォルト置換は"x" | E-02: Line 1122 `Optional folderReplacement As String = "x"` | ○ |
| C-09 | ファイル名のデフォルト置換は"Source" | E-02: Line 1122 `Optional fileReplacement As String = "Source"` | ○ |
| C-10 | DirAndBase()でパス部分を取得 | E-02: Line 1129 `toReplace = sourcePath.DirAndBase()` | ○ |
| C-11 | 正規表現でフォルダ名部分を置換 | E-02: Line 1130 `Regex.Replace(toReplace, $"[^{Path.VolumeSeparatorChar}\{Path.DirectorySeparatorChar}]+(?=\{Path.DirectorySeparatorChar})", folderReplacement)` | ○ |
| C-12 | 正規表現でファイル名部分を置換 | E-02: Line 1131 `Regex.Replace(replaceBy, $"(?<=\{Path.DirectorySeparatorChar})[^\{Path.DirectorySeparatorChar}]+$", fileReplacement)` | ○ |
| C-13 | Base()でファイル名のみも追加置換 | E-02: Line 1134-1136 `toReplace = sourcePath.Base()` / `ret.Replace(toReplace, replaceBy)` | ○ |
| C-14 | ボリューム区切りとパス区切りは維持 | E-02: Line 1130-1131 正規表現パターンでボリューム区切り・パス区切りを除外 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主要機能はソースコードから確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] Line 1130-1131の正規表現がすべてのパス形式（ネットワークパス等）に対応しているか確認
- [ ] DirAndBase()とBase()の拡張メソッドが期待通りに動作するか確認
- [ ] ログ内のSourceFile以外のパス（依存ファイル等）も難読化されるか確認
