---
generated_at: 2026-01-21 18:45:00
metrics:
  claims_total: 50
  claims_with_evidence: 47
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：業務要件一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：47 / 50、根拠なし：3
- 優先レビュー（高）
  1. **BR-047 サムネイル生成**：Thumbnailerクラスの詳細実装根拠不足
  2. **BR-048 動画比較**：VideoComparisonFormの詳細仕様根拠不足
  3. **BR-049 アプリ更新確認**：更新機能の詳細フロー根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Project.vb` - プロジェクト設定クラス
- E-02: `Source/General/GlobalClass.vb` - グローバル処理・イベント管理
- E-03: `Source/Forms/MainForm.vb` - メインフォームUI
- E-04: `Source/Encoding/VideoEncoder.vb` - ビデオエンコーダー基底クラス
- E-05: `Source/General/Audio.vb` - 音声処理クラス
- E-06: `Source/General/Muxer.vb` - マクサー基底クラス（MKV/MP4/WebM/ffmpeg）
- E-07: `Source/General/Demux.vb` - デマクサー基底クラス（ffmpeg/mkvextract/MP4Box/eac3to）
- E-08: `Source/General/JobManager.vb` - ジョブキュー管理
- E-09: `Source/Forms/CropForm.vb` - クロップダイアログ
- E-10: `Source/Forms/PreviewForm.vb` - プレビューダイアログ
- E-11: `Source/Video/VideoScript.vb` - スクリプト生成クラス
- E-12: `README.md` - プロジェクト概要説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BR-001 ソースファイル読込 | E-01, E-03 | ○ |
| C-02 | BR-002 メディア情報取得 | E-01, E-02 | ○ |
| C-03 | BR-003 複数ソースファイル結合 | E-01 | ○ |
| C-04 | BR-004 自動クロップ検出 | E-09, E-01 | ○ |
| C-05 | BR-005 手動クロップ設定 | E-09, E-01 | ○ |
| C-06 | BR-006 スマートクロップ | E-09, E-02 | ○ |
| C-07 | BR-007 リサイズ処理 | E-11 | ○ |
| C-08 | BR-008 フィルタ適用 | E-11, E-03 | ○ |
| C-09 | BR-009 トーンマッピング | E-09, E-11 | ○ |
| C-10 | BR-010 カット編集 | E-10, E-01, E-05 | ○ |
| C-11 | BR-011 プレビュー再生 | E-10 | ○ |
| C-12 | BR-012 動画エンコーダー設定 | E-04 | ○ |
| C-13 | BR-013 ビットレート計算 | E-04, E-01 | ○ |
| C-14 | BR-014 圧縮チェック | E-04, E-01 | ○ |
| C-15 | BR-015 チャンクエンコード | E-04 | ○ |
| C-16 | BR-016 音声デマックス | E-07, E-05 | ○ |
| C-17 | BR-017 音声エンコード | E-05 | ○ |
| C-18 | BR-018 音声正規化 | E-05 | ○ |
| C-19 | BR-019 音声チャンネル変換 | E-05 | ○ |
| C-20 | BR-020 音声遅延補正 | E-05, E-06 | ○ |
| C-21 | BR-021 字幕デマックス | E-07 | ○ |
| C-22 | BR-022 字幕ハードコード | E-01 | ○ |
| C-23 | BR-023 字幕マックス | E-06 | ○ |
| C-24 | BR-024 MKVマックス | E-06 | ○ |
| C-25 | BR-025 MP4マックス | E-06 | ○ |
| C-26 | BR-026 WebMマックス | E-06 | ○ |
| C-27 | BR-027 チャプター処理 | E-06, E-07 | ○ |
| C-28 | BR-028 添付ファイル処理 | E-06, E-07 | ○ |
| C-29 | BR-029 ジョブキュー管理 | E-08 | ○ |
| C-30 | BR-030 バッチエンコード | E-08, E-01 | ○ |
| C-31 | BR-031 処理中断・再開 | E-02, E-08 | ○ |
| C-32 | BR-032 プロジェクト保存 | E-01, E-08 | ○ |
| C-33 | BR-033 プロジェクト読込 | E-01 | ○ |
| C-34 | BR-034 テンプレート管理 | E-01, E-04 | ○ |
| C-35 | BR-035 アシスタント機能 | E-03, E-12 | ○ |
| C-36 | BR-036 ログ出力 | E-01, E-02 | ○ |
| C-37 | BR-037 エラー通知 | E-02 | ○ |
| C-38 | BR-038 アプリケーション設定 | E-02, E-03 | ○ |
| C-39 | BR-039 外部ツール管理 | E-02 | ○ |
| C-40 | BR-040 カスタムメニュー | E-09, E-10 | ○ |
| C-41 | BR-041 HDRメタデータ抽出 | E-01 | ○ |
| C-42 | BR-042 Dolby Vision処理 | E-01, E-04 | ○ |
| C-43 | BR-043 AviSynthスクリプト生成 | E-11 | ○ |
| C-44 | BR-044 VapourSynthスクリプト生成 | E-11 | ○ |
| C-45 | BR-045 マクロ展開 | E-11 | ○ |
| C-46 | BR-046 イベントコマンド実行 | E-02 | ○ |
| C-47 | BR-047 サムネイル生成 | **根拠不足** | △ |
| C-48 | BR-048 動画比較 | **根拠不足** | △ |
| C-49 | BR-049 アプリ更新確認 | **根拠不足** | △ |
| C-50 | BR-050 一時ファイル管理 | E-01, E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- BR-047 サムネイル生成：Thumbnailer.vbの詳細実装を確認していない
  - 候補：`Source/General/Thumbnailer.vb` / `ThumbnailerSettings`
- BR-048 動画比較：VideoComparisonForm.vbの詳細実装を確認していない
  - 候補：`Source/Forms/VideoComparisonForm.vb`
- BR-049 アプリ更新確認：UpdateForm.vb、DownloadForm.vbの詳細実装を確認していない
  - 候補：`Source/Forms/UpdateForm.vb` / `Source/Forms/DownloadForm.vb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能（BR-001〜BR-030）は全てソースコードで確認済み
- 1: 中リスク - HDR関連機能（BR-041、BR-042）は外部ツール依存が多く、バージョン互換性に注意
- 1: 中リスク - AviSynth/VapourSynth対応（BR-043、BR-044）はスクリプトエンジンのバージョンに依存

## 6) レビュアーチェックリスト（最小）
- [ ] 業務要件の網羅性：StaxRipの主要機能が全て業務要件としてカバーされているか確認
- [ ] 優先度の妥当性：「高」「中」「低」の分類が利用頻度・重要度と整合しているか確認
- [ ] 関連機能の正確性：各業務要件に対応するソースコードファイル/クラス名が正確か確認
- [ ] 根拠不足項目（△）：サムネイル生成、動画比較、アプリ更新の実装詳細を確認
- [ ] 外部ツール依存：ffmpeg、mkvmerge、MP4Box、x264、x265等の外部ツール連携要件の確認
