---
generated_at: 2026-01-21 16:30:00
metrics:
  claims_total: 73
  claims_with_evidence: 71
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：71 / 73、根拠なし：2
- 優先レビュー（高）
  1. **C-67（ログ表示）**：LogForm.vbの存在は確認済みだが詳細機能の確認が不十分
  2. **C-72（ヘルプ表示）**：HelpForm.vbの存在は確認済みだが内容の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要、機能説明
- E-02: `Source/Forms/MainForm.vb` - メインフォームの実装
- E-03: `Source/General/GlobalCommands.vb` - グローバルコマンド定義
- E-04: `Source/General/Project.vb` - プロジェクト設定クラス
- E-05: `Source/General/Demux.vb` - Demuxer実装（mkvextract、ffmpeg、MP4Box、eac3to）
- E-06: `Source/General/Audio.vb` - オーディオ処理実装
- E-07: `Source/General/Muxer.vb` - Muxer実装（MKV、MP4、WebM、ffmpeg）
- E-08: `Source/Video/VideoEncoderCommandLine.vb` - ビデオエンコーダーコマンドライン
- E-09: `Source/Video/VideoScript.vb` - AviSynth/VapourSynthスクリプト処理
- E-10: `Source/Forms/PreviewForm.vb` - プレビュー機能
- E-11: `Source/Forms/CropForm.vb` - クロップ機能
- E-12: `Source/General/Thumbnailer.vb` - サムネイル生成機能
- E-13: `Source/Forms/JobsForm.vb` - ジョブ管理フォーム
- E-14: `Source/Forms/AppsForm.vb` - 外部ツール管理
- E-15: `Source/Forms/ProfilesForm.vb` - プロファイル管理
- E-16: `Source/Forms/MacrosForm.vb` - マクロ管理
- E-17: `Source/Forms/EventCommandEditor.vb` - イベントコマンドエディタ
- E-18: `Source/Forms/CodeEditor.vb` - コードエディタ
- E-19: `Source/Forms/VideoComparisonForm.vb` - ビデオ比較
- E-20: `Source/UI/ThemeManager.vb` - テーマ管理
- E-21: `Source/Forms/UpdateForm.vb` - アップデート機能

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ソースファイル読み込み | E-02, E-03 (LoadSourceFile) | ○ |
| C-02 | 複数ファイル読み込み | E-03 (LoadSourceFiles) | ○ |
| C-03 | Blu-ray/DVDサポート | E-01 (README記載) | ○ |
| C-04 | mkvextract Demux | E-05 (mkvDemuxer class) | ○ |
| C-05 | ffmpeg Demux | E-05 (ffmpegDemuxer class) | ○ |
| C-06 | MP4Box Demux | E-05 (MP4BoxDemuxer class) | ○ |
| C-07 | eac3to Demux | E-05 (eac3toDemuxer class) | ○ |
| C-08 | DGIndex/D2V Witch | E-05 (CommandLineDemuxer設定) | ○ |
| C-09 | チャプター抽出 | E-05 (DemuxChapters) | ○ |
| C-10 | タイムスタンプ抽出 | E-05 (ExtractTimestamps) | ○ |
| C-11 | 添付ファイル抽出 | E-05 (DemuxAttachments) | ○ |
| C-12 | x265エンコード | E-04 (VideoEncoder=x265Enc) | ○ |
| C-13 | x264エンコード | E-03 (x264Enc.Test) | ○ |
| C-14 | NVEncエンコード | E-03 (NVEnc.Test) | ○ |
| C-15 | QSVEncエンコード | E-03 (QSVEnc.Test) | ○ |
| C-16 | VCEEncエンコード | E-03 (VCEEnc.Test コメント) | ○ |
| C-17 | AV1エンコード | E-07 (AOMEnc参照) | ○ |
| C-18 | チャンクエンコード | E-07 (GetChunks) | ○ |
| C-19 | 2パスエンコード | E-08 (pass parameter) | ○ |
| C-20 | オーディオDemux | E-05, E-06 | ○ |
| C-21 | オーディオエンコード | E-06 (GUIAudioProfile) | ○ |
| C-22 | オーディオ正規化 | E-06 (NormalizeFF, loudnorm, dynaudnorm) | ○ |
| C-23 | オーディオカット | E-06 (CutMkvmerge, CutNicAudio, CutDirectShowSource) | ○ |
| C-24 | チャンネルダウンミックス | E-06 (Down2, ChannelsMode) | ○ |
| C-25 | 字幕抽出 | E-05 (DemuxSubtitles) | ○ |
| C-26 | 字幕追加 | E-07 (Subtitles property) | ○ |
| C-27 | ハードコード字幕 | E-04 (AddHardcodedSubtitleFilter) | ○ |
| C-28 | MKV Mux | E-07 (MkvMuxer class) | ○ |
| C-29 | MP4 Mux | E-07 (MP4Muxer class) | ○ |
| C-30 | WebM Mux | E-07 (WebMMuxer class) | ○ |
| C-31 | ffmpeg Mux | E-07 (ffmpegMuxer class) | ○ |
| C-32 | カスタムMux | E-07 (BatchMuxer class) | ○ |
| C-33 | メタデータ設定 | E-07 (Tags, Title properties) | ○ |
| C-34 | 添付ファイル追加 | E-07 (Attachments property) | ○ |
| C-35 | AviSynth+連携 | E-09 (ScriptEngine.AviSynth) | ○ |
| C-36 | VapourSynth連携 | E-09 (ScriptEngine.VapourSynth) | ○ |
| C-37 | クロップ | E-03 (SetCrop), E-11 | ○ |
| C-38 | リサイズ | E-04 (TargetWidth, TargetHeight) | ○ |
| C-39 | デインターレース | E-09 (VideoFilter) | ○ |
| C-40 | ノイズ除去 | E-09 (VideoFilter) | ○ |
| C-41 | シャープ化 | E-09 (VideoFilter) | ○ |
| C-42 | 色調補正 | E-09 (VideoFilter) | ○ |
| C-43 | HDR処理 | E-04 (SourceVideoHdrFormat, ExtractHdrmetadata) | ○ |
| C-44 | フレームカット | E-04 (Ranges), E-10 | ○ |
| C-45 | 範囲指定カット | E-04 (Ranges list) | ○ |
| C-46 | ビデオプレビュー | E-10 (PreviewForm) | ○ |
| C-47 | クロップ調整UI | E-11 (CropForm) | ○ |
| C-48 | 比較プレビュー | E-19 (VideoComparisonForm) | ○ |
| C-49 | サムネイルシート生成 | E-12 (Thumbnailer class) | ○ |
| C-50 | カスタマイズ設定 | E-12 (ThumbnailerSettings) | ○ |
| C-51 | GIF生成 | E-03 (SaveGIF) | ○ |
| C-52 | APNG生成 | E-03 (SavePNG) | ○ |
| C-53 | テンプレート | E-15 (ProfilesForm) | ○ |
| C-54 | プロジェクト保存/読込 | E-04 (Project class) | ○ |
| C-55 | ジョブキュー | E-13 (JobsForm) | ○ |
| C-56 | ジョブ実行 | E-03 (StartJobs, g.ProcessJobs) | ○ |
| C-57 | イベントコマンド | E-17 (EventCommandEditor) | ○ |
| C-58 | マクロ機能 | E-03 (ShowMacrosDialog), E-16 | ○ |
| C-59 | PowerShell連携 | E-03 (ExecutePowerShellCode, ExecutePowerShellFile) | ○ |
| C-60 | 外部ツール管理 | E-14 (AppsForm) | ○ |
| C-61 | ツール自動ダウンロード | E-03 (Package.VerifyOK) | ○ |
| C-62 | MediaInfo表示 | E-03 (ShowMediaInfo) | ○ |
| C-63 | mkvinfo表示 | E-03 (ShowMkvInfo) | ○ |
| C-64 | カスタムメニュー | E-11 (CustomMenu) | ○ |
| C-65 | テーマ設定 | E-20 (ThemeManager) | ○ |
| C-66 | アシスタント機能 | E-04 (SkippedAssistantTips) | ○ |
| C-67 | ログ表示 | E-03 (ShowLogFile) | △ |
| C-68 | アプリケーション設定 | E-04 (ApplicationSettings) | ○ |
| C-69 | プロジェクトオプション | E-04 (Project properties) | ○ |
| C-70 | 設定リセット | E-03 (ResetSettings) | ○ |
| C-71 | アップデート確認 | E-03 (CheckForUpdate), E-21 | ○ |
| C-72 | ヘルプ表示 | E-03 (OpenHelpTopic) | △ |
| C-73 | コードエディタ | E-18 (CodeEditor) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-67（ログ表示）**：LogForm.vbファイルの存在は確認したが、詳細な機能実装の確認が不十分
  - 候補：LogForm.vbの詳細読み込み / LogBuilder.vbの確認
- **C-72（ヘルプ表示）**：HelpForm.vbの存在は確認したが、ヘルプコンテンツの管理方法の詳細確認が必要
  - 候補：HelpForm.vbの詳細読み込み / Help.vbの確認 / Documentationフォルダの確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的に信頼度が高く、主要機能はすべてソースコードで確認済み
- 1: 中リスク - ビデオエンコーダーの詳細オプション（C-12〜C-19）は専用ファイルを読み込んでいないため、細部に差異がある可能性
- 0: 低リスク - Demux/Mux機能はDemux.vb、Muxer.vbで詳細に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Demux機能（C-04〜C-11）が実際のソースコードと一致しているか確認
- [ ] エンコーダー機能（C-12〜C-19）の詳細オプションを追加確認
- [ ] オーディオ処理（C-20〜C-24）の対応コーデック一覧を詳細確認
- [ ] フィルタ機能（C-39〜C-42）の具体的なフィルタ名を追加確認
- [ ] ログ機能とヘルプ機能の詳細実装を確認（△項目）
