# 機能設計書 1-ソースファイル読み込み

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるソースファイル読み込み機能の設計仕様を記述する。ビデオ/オーディオファイルをプロジェクトに読み込み、エンコード処理の基盤となるソース情報を設定する機能である。

### 本機能の処理概要

**業務上の目的・背景**：動画エンコード作業において、最初に行うべき作業はソースファイルの読み込みである。本機能は、ユーザーが指定したビデオファイルを解析し、解像度、フレームレート、コーデック情報などのメタデータを取得してプロジェクトに設定する。これにより、後続のエンコード設定やフィルタ適用の基礎情報が確立される。

**機能の利用シーン**：
- 新規プロジェクト作成時にソースファイルを指定する場合
- 既存プロジェクトのソースファイルを変更する場合
- ドラッグ&ドロップでファイルを読み込む場合
- コマンドライン引数でファイルパスを渡す場合

**主要な処理内容**：
1. ファイルパスの検証と存在確認
2. MediaInfoによるファイルメタデータの解析
3. ビデオストリーム情報（解像度、フレームレート、コーデック等）の取得
4. オーディオストリーム情報の取得
5. プロジェクトオブジェクトへの情報設定
6. 一時ディレクトリの設定
7. フレームサーバー（AviSynth+/VapourSynth）スクリプトの生成準備

**関連システム・外部連携**：
- MediaInfo.NET：メディアファイルのメタデータ解析
- AviSynth+/VapourSynth：フレームサーバー連携
- ffmpeg/ffprobe：補助的なファイル解析

**権限による制御**：特になし。ファイルシステムへの読み取りアクセス権が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | tbSourceFileからソースファイルを読み込み、プロジェクトに設定 |

## 機能種別

データ読み込み / ファイル解析 / プロジェクト初期化

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| filePath | String | Yes | ソースファイルのフルパス | ファイル存在確認、対応形式チェック |

### 入力データソース

- 画面入力：MainFormのtbSourceFileテキストボックス
- ドラッグ&ドロップ：MainFormへのファイルドロップ
- コマンドライン引数：アプリケーション起動時のパラメータ
- プログラム呼び出し：GlobalCommands.LoadSourceFile()メソッド

### 対応ファイル形式

MKV、MP4、M2TS、AVI、VOB、WebM、FLV、TS、MPG、MPEG、M4V、MOV等

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| SourceFile | String | ソースファイルパス |
| SourceWidth | Integer | ソース映像の幅（ピクセル） |
| SourceHeight | Integer | ソース映像の高さ（ピクセル） |
| SourceFrameRate | Decimal | フレームレート |
| SourceFrames | Integer | 総フレーム数 |
| SourceSeconds | Integer | 再生時間（秒） |
| SourceVideoFormat | String | ビデオコーデック名 |
| SourceVideoBitDepth | Integer | ビット深度 |
| SourceChromaSubsampling | String | クロマサブサンプリング形式 |
| SourcePAR | Point | ピクセルアスペクト比 |

### 出力先

- Projectオブジェクト：プロジェクト設定の保持
- MainForm画面表示：ソース情報ラベルへの反映
- ログファイル：処理ログの記録

## 処理フロー

### 処理シーケンス

```
1. ファイルパス受信
   └─ tbSourceFile.TextChangedイベントまたはOpenVideoSourceFile()呼び出し
2. ファイル検証
   └─ 存在確認、対応形式チェック
3. MediaInfo解析
   └─ MediaInfo.GetVideoStreams()でビデオ情報取得
   └─ MediaInfo.GetAudioStreams()でオーディオ情報取得
4. プロジェクト設定
   └─ p.SourceFile、p.SourceWidth等への値設定
5. 一時ディレクトリ設定
   └─ g.SetTempDir()による作業フォルダ設定
6. UI更新
   └─ MainFormの各表示要素の更新
7. イベント発火
   └─ ApplicationEvent.AfterSourceLoadedイベント
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ファイルパス取得]
    B --> C{ファイル存在?}
    C -->|No| D[エラー表示]
    D --> E[終了]
    C -->|Yes| F{対応形式?}
    F -->|No| D
    F -->|Yes| G[MediaInfo解析]
    G --> H[ビデオ情報取得]
    H --> I[オーディオ情報取得]
    I --> J[Project設定]
    J --> K[TempDir設定]
    K --> L[UI更新]
    L --> M[イベント発火]
    M --> E
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | ファイル存在必須 | 指定パスにファイルが存在すること | 常時 |
| BR-002 | 対応形式制限 | FileTypes.Videoに含まれる拡張子のみ受付 | 常時 |
| BR-003 | 読み取り権限 | ファイルに読み取りアクセス可能であること | 常時 |

### 計算ロジック

- フレーム数計算: SourceFrames = SourceSeconds * SourceFrameRate
- ターゲット初期値: TargetWidth/Height = SourceWidth/Height

## データベース操作仕様

本機能はデータベースを使用しない。ファイルシステムとメモリ上のProjectオブジェクトを操作する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-001 | FileNotFound | 指定ファイルが存在しない | エラーメッセージ表示、処理中断 |
| E-002 | UnsupportedFormat | 非対応ファイル形式 | 警告メッセージ表示 |
| E-003 | MediaInfoError | MediaInfo解析失敗 | 代替解析またはエラー表示 |
| E-004 | AccessDenied | ファイルアクセス権限なし | 権限確認を促すメッセージ |

### リトライ仕様

リトライ処理は行わない。エラー発生時はユーザーに通知し、再操作を促す。

## トランザクション仕様

本機能はトランザクション管理を行わない。ファイル読み込みは単一操作として完了する。

## パフォーマンス要件

- ファイル解析：5秒以内（標準的なファイルサイズの場合）
- UI更新：即時反映

## セキュリティ考慮事項

- ファイルパスのサニタイズ（不正文字チェック）
- 一時ディレクトリへの書き込み権限確認
- ユーザー権限での実行

## 備考

- ISO形式のBlu-rayイメージはWindows 8以降でマウント対応
- VFR（可変フレームレート）ファイルは追加処理が必要

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

プロジェクトのソースファイル情報を保持するデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Project.vb | `Source/General/Project.vb` | SourceFile、SourceWidth、SourceHeight等のプロパティ定義（119-136行目） |

**読解のコツ**: VB.NETのPublicフィールドとPropertyの違いに注意。プロパティにはセッター内でバリデーションが入る場合がある。

#### Step 2: エントリーポイントを理解する

ファイル読み込みの起点となる処理を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | tbSourceFile定義とTextChangedイベントハンドラ |
| 2-2 | GlobalCommands.vb | `Source/General/GlobalCommands.vb` | LoadSourceFile()メソッド（545-547行目） |

**主要処理フロー**:
1. **545行目**: LoadSourceFileコマンド定義
2. **546行目**: g.MainForm.OpenVideoSourceFile(path)呼び出し

#### Step 3: ファイル読み込み処理を理解する

MainFormでの実際のファイル読み込み処理を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MainForm.vb | `Source/Forms/MainForm.vb` | OpenVideoSourceFile()メソッドの実装 |

**主要処理フロー**:
- ファイルパス検証
- プロジェクトオブジェクトへの設定
- UIの更新処理

#### Step 4: MediaInfo連携を理解する

ファイルメタデータ解析の詳細を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Misc.vb | `Source/General/Misc.vb` | MediaInfoクラスの実装 |

### プログラム呼び出し階層図

```
GlobalCommands.LoadSourceFile(path)
    │
    └─ MainForm.OpenVideoSourceFile(path)
           │
           ├─ g.VerifySource() [ファイル検証]
           │
           ├─ MediaInfo.GetVideoStreams() [ビデオ情報取得]
           │
           ├─ MediaInfo.GetAudioStreams() [オーディオ情報取得]
           │
           ├─ Project設定
           │      └─ p.SourceFile = path
           │      └─ p.SourceWidth = width
           │      └─ p.SourceHeight = height
           │
           └─ g.SetTempDir() [一時ディレクトリ設定]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ファイルパス ───────▶ MainForm.OpenVideoSourceFile() ───▶ Project.SourceFile
                              │
                              ▼
                     MediaInfo.GetVideoStreams()
                              │
                              ▼
                     ビデオ情報解析 ─────────────────────▶ Project.SourceWidth
                              │                          Project.SourceHeight
                              │                          Project.SourceFrameRate
                              ▼
                     MediaInfo.GetAudioStreams()
                              │
                              ▼
                     オーディオ情報解析 ──────────────────▶ AudioStreams
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | メインフォーム、UI処理 |
| Project.vb | `Source/General/Project.vb` | ソース | プロジェクトデータモデル |
| GlobalCommands.vb | `Source/General/GlobalCommands.vb` | ソース | グローバルコマンド定義 |
| Misc.vb | `Source/General/Misc.vb` | ソース | MediaInfo等のユーティリティ |
| FileTypes.vb | `Source/General/` | ソース | 対応ファイル形式定義 |
