# 機能設計書 11-添付ファイル抽出

## 概要

本ドキュメントは、StaxRipの添付ファイル抽出機能の設計書である。MKVファイルに埋め込まれた添付ファイル（主にフォントファイル）を抽出し、字幕の正確な表示やアーカイブ目的で利用可能にする機能を定義する。

### 本機能の処理概要

MKVコンテナに格納された添付ファイル（アタッチメント）を抽出する機能である。MKVファイルには字幕で使用されるフォント、カバーアート、その他の補助ファイルを添付として格納できる。この機能では、これらの添付ファイルを個別または一括で抽出できる。

**業務上の目的・背景**：
MKVファイルには、ASS/SSA字幕で使用される特殊フォントが添付されていることが多い。これらのフォントがシステムにインストールされていない場合、字幕が正しく表示されない。添付ファイル抽出機能により、ユーザーは必要なフォントを取得してインストールしたり、字幕の見た目を維持したまま別のフォーマットへ変換したりできる。また、カバーアートや関連ドキュメントの抽出・保存にも使用される。

**機能の利用シーン**：
- MKVファイルから字幕用フォントを抽出してシステムにインストールする場合
- 動画ファイルのリマックス時に添付ファイルを保持・再利用する場合
- ファイルに埋め込まれたカバーアートを取り出す場合
- アーカイブ目的で全ての添付ファイルをバックアップする場合

**主要な処理内容**：
1. ソースMKVファイルの解析と添付ファイル情報の取得
2. 添付ファイル一覧のGUI表示（ListView）
3. ユーザーによる抽出対象の選択（チェックボックス）
4. mkvextractコマンドによる添付ファイルの抽出
5. 抽出先ディレクトリへの出力

**関連システム・外部連携**：
- MKVToolNix（mkvextract）: 添付ファイルの実際の抽出処理を担当
- MediaInfo: ファイル情報の解析に使用される場合がある

**権限による制御**：
本機能に特別な権限制御はない。ファイルシステムへのアクセス権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 16 | StreamDemuxForm | 主画面 | lvAttachmentsで添付ファイル一覧を表示・選択 |
| 1 | MainForm | 参照画面 | メニューからStreamDemuxFormを起動 |

## 機能種別

データ抽出処理 / ファイル出力

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| SourcePath | String | Yes | 入力MKVファイルのパス | ファイル存在確認、拡張子チェック(.mkv, .webm) |
| AttachmentList | List(Of Attachment) | Yes | 抽出対象の添付ファイルリスト | 空でないこと |
| OutputDir | String | Yes | 出力先ディレクトリ | ディレクトリ存在確認/作成 |

### 入力データソース

- ソースMKVファイル: ユーザーがMainFormで指定したソースファイル
- 添付ファイル情報: MediaInfo/mkvmergeで解析されたストリーム情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 抽出ファイル | File | 添付ファイルの実体（フォント、画像等） |
| ファイル名 | String | 元のファイル名を保持 |
| MIME Type | String | ファイルの種類情報 |

### 出力先

- 一時ディレクトリ（p.TempDir）または指定ディレクトリ
- 抽出されたファイルはMuxerで再添付可能

## 処理フロー

### 処理シーケンス

```
1. StreamDemuxFormの初期化
   └─ ソースファイルからストリーム情報を読み込み
2. 添付ファイル情報の解析
   └─ MediaInfo.GetAttachmentSummary()で添付ファイル一覧を取得
3. ListViewへの表示
   └─ lvAttachmentsに添付ファイル名、サイズ、MIMEタイプを表示
4. ユーザー選択
   └─ チェックボックスで抽出対象を選択
5. Demux実行
   └─ mkvDemuxer.Demux()を呼び出し
6. mkvextractコマンド生成
   └─ attachments モードでコマンドライン生成
7. プロセス実行
   └─ Procクラスでmkvextractを実行
8. 結果確認
   └─ 抽出ファイルの存在確認
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ソースファイル読み込み]
    B --> C[添付ファイル情報解析]
    C --> D{添付ファイルあり?}
    D -->|No| E[処理終了]
    D -->|Yes| F[ListView表示]
    F --> G[ユーザー選択待ち]
    G --> H{抽出実行?}
    H -->|No| E
    H -->|Yes| I[mkvextractコマンド生成]
    I --> J[プロセス実行]
    J --> K{成功?}
    K -->|Yes| L[抽出完了]
    K -->|No| M[エラー表示]
    L --> E
    M --> E
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-11-01 | 対応フォーマット | MKV/WebMファイルのみ添付ファイル抽出に対応 | 常時 |
| BR-11-02 | ファイル名保持 | 添付ファイルの元ファイル名を維持して抽出 | 常時 |
| BR-11-03 | 重複処理 | 同名ファイルが存在する場合は上書き | デフォルト動作 |

### 計算ロジック

特になし

## データベース操作仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR-11-01 | ファイルエラー | ソースファイルが存在しない | エラーメッセージ表示 |
| ERR-11-02 | ツールエラー | mkvextractが見つからない | ツールのインストールを促す |
| ERR-11-03 | 書き込みエラー | 出力先に書き込み権限がない | 出力先の変更を促す |
| ERR-11-04 | フォーマットエラー | 非対応ファイル形式 | 対応形式の案内 |

### リトライ仕様

リトライ機能なし。エラー発生時は処理を中断し、ユーザーに通知する。

## トランザクション仕様

ファイル操作のみのため、トランザクション管理なし。

## パフォーマンス要件

- 添付ファイル数が多い場合（100以上）でもListView表示は1秒以内
- 抽出処理はmkvextractのパフォーマンスに依存

## セキュリティ考慮事項

- 抽出されるファイルはウイルススキャンの対象外となるため、信頼できるソースからのファイルのみを処理すること
- フォントファイルはシステムへの影響があるため、インストール前に内容を確認すること

## 備考

- MKVToolNixがインストールされていることが前提条件
- WebMファイルも内部的にはMKVと同じ形式のため対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、添付ファイル情報を格納するデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Demux.vb | `Source/General/Demux.vb` | Attachmentクラスの構造、プロパティ定義 |
| 1-2 | MediaInfo.vb | `Source/General/MediaInfo.vb` | MediaInfo解析結果の格納形式 |

**読解のコツ**: VB.NETのProperty構文とClass定義に注目。

#### Step 2: エントリーポイントを理解する

処理の起点となるUIフォームを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StreamDemuxForm.vb | `Source/Forms/StreamDemuxForm.vb` | フォーム初期化とListView構築ロジック |

**主要処理フロー**:
1. **44-80行目**: フォーム初期化、lvAttachmentsの設定
2. **220-250行目**: cbDemuxAttachments_CheckedChangedイベント
3. **300-350行目**: Demux実行処理

#### Step 3: Demuxer処理を理解する

実際の抽出処理を行うDemuxerクラスを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Demux.vb | `Source/General/Demux.vb` | mkvDemuxer.Demuxメソッドの実装 |

**主要処理フロー**:
- **mkvDemuxer.Demux()**: MKVからの抽出を統括
- **GetAttachmentArgs()**: mkvextract用のコマンドライン引数生成

### プログラム呼び出し階層図

```
StreamDemuxForm
    │
    ├─ MediaInfo.GetAttachments()
    │      └─ MediaInfo DLL呼び出し
    │
    └─ mkvDemuxer.Demux()
           ├─ GetAttachmentArgs()
           │      └─ コマンドライン生成
           │
           └─ Proc.Start()
                  └─ mkvextract.exe実行
```

### データフロー図

```
[入力]                  [処理]                        [出力]

MKVファイル ───▶ MediaInfo解析 ───▶ 添付ファイル情報
                      │
                      ▼
              StreamDemuxForm
              (ユーザー選択)
                      │
                      ▼
              mkvDemuxer.Demux()
                      │
                      ▼
              mkvextract実行 ───▶ 抽出ファイル(.ttf, .otf等)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StreamDemuxForm.vb | `Source/Forms/StreamDemuxForm.vb` | ソース | メインUI、ユーザーインタラクション |
| Demux.vb | `Source/General/Demux.vb` | ソース | Demux処理の実装、mkvextract呼び出し |
| MediaInfo.vb | `Source/General/MediaInfo.vb` | ソース | ファイル情報解析 |
| Proc.vb | `Source/General/Proc.vb` | ソース | 外部プロセス実行管理 |
| Package.vb | `Source/General/Package.vb` | ソース | 外部ツール（mkvextract）のパス管理 |
