# 機能設計書 12-x265エンコード

## 概要

本ドキュメントは、StaxRipのx265エンコード機能の設計書である。x265エンコーダーを使用してHEVC（H.265）形式でビデオをエンコードする機能を定義する。StaxRipのデフォルトビデオエンコーダーとして位置付けられている。

### 本機能の処理概要

x265エンコーダーを使用して、入力ビデオストリームをHEVC（High Efficiency Video Coding）形式にエンコードする機能である。CRF（Constant Rate Factor）モード、2パス/3パスエンコード、品質ベースのエンコードなど、多彩なエンコードモードをサポートする。

**業務上の目的・背景**：
HEVCは、H.264/AVCと比較して同等の品質でファイルサイズを約50%削減できる次世代コーデックである。4K/8Kコンテンツや、HDR10/Dolby Visionなどの高ダイナミックレンジ映像のエンコードに最適。ストリーミング配信やアーカイブ用途で広く使用される。x265はオープンソースのHEVCエンコーダーとして最も普及しており、高い品質と豊富なオプションを提供する。

**機能の利用シーン**：
- 4K/8K動画の高効率圧縮
- Blu-rayからのリッピング・トランスコード
- HDR10/HDR10+/Dolby Vision対応コンテンツのエンコード
- 動画配信用ファイルの作成
- 長期保存用アーカイブの作成

**主要な処理内容**：
1. 入力ソース（AviSynth/VapourSynthスクリプト）の準備
2. エンコードパラメータの設定（プリセット、チューニング、CRF/ビットレート等）
3. HDRメタデータの自動インポート（オプション）
4. x265エンコーダープロセスの実行
5. 2パス/3パスエンコードの実行（選択時）
6. チャンクエンコードによる並列処理（オプション）
7. 出力ファイル（.hevc）の生成

**関連システム・外部連携**：
- x265エンコーダー: 実際のエンコード処理を担当
- AviSynth+/VapourSynth: フレームサーバーとして入力を提供
- MediaInfo: ソースメタデータの解析
- ffmpeg: パイプ入力のサポート

**権限による制御**：
本機能に特別な権限制御はない。ファイルシステムへのアクセス権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | lgbEncoderからエンコーダ設定、エンコード実行 |
| 18 | CommandLineForm | API連携 | コマンドラインパラメータのGUI設定 |
| 3 | ProcessingForm | 結果表示画面 | エンコード進捗表示、ログ表示 |

## 機能種別

データ変換処理 / 計算処理 / ファイル出力

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Mode | x265RateMode | Yes | エンコードモード（CRF/2Pass/3Pass等） | 有効な列挙値 |
| Quant | Integer | No | CRF/QP値（0-51） | 範囲チェック |
| Bitrate | Integer | No | ターゲットビットレート（kbps） | 正の整数 |
| Preset | String | Yes | エンコードプリセット | 有効なプリセット名 |
| Tune | String | No | チューニングオプション | 有効なチューン名 |
| Profile | String | No | HEVCプロファイル | 有効なプロファイル名 |
| OutputDepth | Integer | No | 出力ビット深度（8/10/12） | 有効な深度値 |
| DolbyVisionProfile | String | No | Dolby Visionプロファイル | 有効なDVプロファイル |
| DolbyVisionRpu | String | No | RPUファイルパス | ファイル存在確認 |

### 入力データソース

- AviSynth/VapourSynthスクリプト: フレームサーバー経由のビデオデータ
- ソースファイル: MediaInfoでメタデータ取得
- HDRメタデータファイル: HDR10+/Dolby Vision用

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| エンコードファイル | File | HEVCエンコードされたビデオストリーム（.hevc） |
| ログ | Text | エンコードログ（進捗、統計情報） |
| 統計ファイル | File | 2パス/3パス用の統計ファイル（.log, .cutree） |

### 出力先

- 一時ディレクトリ（p.TempDir）にエンコードファイルを出力
- 最終的にMuxerでコンテナに多重化

## 処理フロー

### 処理シーケンス

```
1. エンコード設定の読み込み
   └─ ParamsStoreからx265Paramsを復元
2. ソーススクリプトの同期
   └─ p.Script.Synchronize()でフレームサーバー準備
3. HDRメタデータの処理（オプション）
   └─ SetMetaData()でVUIメタデータをインポート
4. Dolby Visionの前処理（オプション）
   └─ BeforeEncoding()でRPUファイルの調整
5. コマンドライン生成
   └─ GetArgs()でx265用コマンドライン生成
6. エンコード実行
   └─ Procクラスでx265プロセスを実行
7. マルチパス処理（選択時）
   └─ 2パス目/3パス目の実行
8. 結果の確認
   └─ 出力ファイルの存在確認
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[パラメータ読み込み]
    B --> C[スクリプト同期]
    C --> D{HDRメタデータ?}
    D -->|Yes| E[SetMetaData]
    D -->|No| F{Dolby Vision?}
    E --> F
    F -->|Yes| G[BeforeEncoding]
    F -->|No| H[コマンドライン生成]
    G --> H
    H --> I[1パス目実行]
    I --> J{2パス/3パス?}
    J -->|Yes| K[2パス目実行]
    J -->|No| L[完了]
    K --> M{3パス?}
    M -->|Yes| N[3パス目実行]
    M -->|No| L
    N --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-12-01 | 3パス順序 | 3パスエンコードは1→3→2の順で実行 | Mode = ThreePass |
| BR-12-02 | チャンク制限 | Dolby Vision使用時はチャンクエンコード不可 | IsDolbyVisionSet = True |
| BR-12-03 | 出力深度 | HDR10使用時は自動的に10bit出力 | HDRメタデータ存在時 |
| BR-12-04 | プリセット適用 | プリセット変更時はデフォルト値を再適用 | プリセット変更時 |

### 計算ロジック

- **CRF計算**: 品質ベースエンコードで内部的にビットレートを動的に決定
- **VBVバッファサイズ**: レベル・ティアに基づいて最大ビットレートを計算
- **チャンク分割**: 総フレーム数をチャンク数で均等分割

## データベース操作仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR-12-01 | ツールエラー | x265が見つからない | ツールのインストールを促す |
| ERR-12-02 | 入力エラー | スクリプトが無効 | スクリプトの確認を促す |
| ERR-12-03 | パラメータエラー | 無効なパラメータ組み合わせ | エラーメッセージ表示 |
| ERR-12-04 | ファイルエラー | 出力先書き込み不可 | 出力先の変更を促す |
| ERR-12-05 | プロセスエラー | x265がクラッシュ | ログ確認を促す |

### リトライ仕様

リトライ機能なし。エラー発生時は処理を中断し、ユーザーに通知する。

## トランザクション仕様

ファイル操作のみのため、トランザクション管理なし。エンコード失敗時は不完全な出力ファイルが残る可能性がある。

## パフォーマンス要件

- エンコード速度はプリセットとハードウェアに依存
- CPUマルチスレッド対応（--threads オプション）
- チャンクエンコードで並列処理可能

## セキュリティ考慮事項

- コマンドライン引数はエスケープ処理を実施
- 一時ファイルは作業完了後に保持（Muxerで使用）

## 備考

- x265のバージョンによってサポートするオプションが異なる
- 10bit/12bitエンコードには対応するx265ビルドが必要

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、エンコードパラメータを格納するデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | x265Enc.vb | `Source/Encoding/x265Enc.vb` | x265Encクラスの構造、プロパティ定義 |
| 1-2 | VideoEncoderCommandLine.vb | `Source/Encoding/VideoEncoderCommandLine.vb` | コマンドラインパラメータの基底クラス |

**読解のコツ**: VB.NETのProperty構文とInheritsによる継承関係に注目。x265ParamsクラスはCommandLineParamsを継承している。

#### Step 2: エントリーポイントを理解する

処理の起点となるEncode()メソッドを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | x265Enc.vb | `Source/Encoding/x265Enc.vb` | Encode()メソッドの実装 |

**主要処理フロー**:
1. **112-122行目**: Encode()メソッド - エンコード実行のエントリーポイント
2. **115-121行目**: 2パス/3パスモードの分岐処理
3. **124-146行目**: Encode(passName, commandLine, priority) - 実際のプロセス実行

#### Step 3: コマンドライン生成を理解する

x265に渡すコマンドライン引数の生成ロジック。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | x265Enc.vb | `Source/Encoding/x265Enc.vb` | GetArgs()メソッド |
| 3-2 | x265Params (内部クラス) | `Source/Encoding/x265Enc.vb` | パラメータ定義とGetArgs()実装 |

**主要処理フロー**:
- **430-438行目**: GetArgs() - Params.GetArgs()へ委譲
- **175-311行目**: SetMetaData() - HDRメタデータの自動インポート

#### Step 4: HDR/Dolby Vision処理を理解する

高度なHDR機能の処理フロー。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | x265Enc.vb | `Source/Encoding/x265Enc.vb` | BeforeEncoding()メソッド |

**主要処理フロー**:
- **148-173行目**: BeforeEncoding() - Dolby Vision RPUファイルの前処理
- **64-98行目**: HDR関連プロパティ（IsDolbyVisionSet等）

### プログラム呼び出し階層図

```
MainForm (エンコード実行ボタン)
    │
    └─ x265Enc.Encode()
           │
           ├─ p.Script.Synchronize()
           │      └─ AviSynth/VapourSynthスクリプト同期
           │
           ├─ SetMetaData() [オプション]
           │      └─ MediaInfo.GetVideo()
           │
           ├─ BeforeEncoding() [Dolby Vision時]
           │      └─ HdrDolbyVisionMetadataFile処理
           │
           └─ Encode(passName, commandLine, priority)
                  │
                  ├─ GetArgs()
                  │      └─ Params.GetArgs()
                  │
                  └─ Proc.Start()
                         └─ x265.exe実行
```

### データフロー図

```
[入力]                    [処理]                      [出力]

ソースファイル ───▶ MediaInfo解析 ───▶ メタデータ
     │
     ▼
AviSynth/VS
スクリプト ───────▶ フレームサーバー ───▶ YUV4MPEGパイプ
                          │
                          ▼
                    x265Enc.Encode()
                          │
                          ├─▶ コマンドライン生成
                          │
                          └─▶ x265.exe ───▶ .hevcファイル
                                 │
                                 └─▶ 統計ファイル（2pass時）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| x265Enc.vb | `Source/Encoding/x265Enc.vb` | ソース | x265エンコーダークラス、パラメータ定義 |
| BasicVideoEncoder.vb | `Source/Encoding/VideoEncoder.vb` | ソース | ビデオエンコーダー基底クラス |
| VideoEncoderCommandLine.vb | `Source/Encoding/VideoEncoderCommandLine.vb` | ソース | コマンドラインパラメータ基底クラス |
| Proc.vb | `Source/General/Proc.vb` | ソース | 外部プロセス実行管理 |
| MediaInfo.vb | `Source/General/MediaInfo.vb` | ソース | メディア情報解析 |
| Package.vb | `Source/General/Package.vb` | ソース | 外部ツール（x265）のパス管理 |
| CommandLineForm.vb | `Source/Forms/CommandLineForm.vb` | ソース | パラメータ設定UI |
| x265Control.vb | `Source/UI/x265Control.vb` | ソース | x265専用コントロール |
