# 機能設計書 13-x264エンコード

## 概要

本ドキュメントは、StaxRipのx264エンコード機能の設計書である。x264エンコーダーを使用してH.264/AVC形式でビデオをエンコードする機能を定義する。

### 本機能の処理概要

x264エンコーダーを使用して、入力ビデオストリームをH.264/AVC（Advanced Video Coding）形式にエンコードする機能である。業界標準のH.264コーデックを使用し、高い互換性と優れた圧縮効率を実現する。

**業務上の目的・背景**：
H.264/AVCは最も広く普及したビデオコーデックであり、ほぼすべてのデバイスとプレーヤーで再生可能。ストリーミング配信、Blu-ray、放送、モバイル機器など、あらゆる用途で使用される。x264はオープンソースのH.264エンコーダーとして最高品質を誇り、映画スタジオやストリーミングサービスでも使用されている。

**機能の利用シーン**：
- 広い互換性が必要な動画配信
- DVD/Blu-ray作成
- モバイル機器向けの動画変換
- レガシーデバイス対応が必要な場合
- ストリーミング用コンテンツの作成

**主要な処理内容**：
1. 入力ソース（AviSynth/VapourSynthスクリプト）の準備
2. エンコードパラメータの設定（プリセット、チューニング、CRF/ビットレート等）
3. x264エンコーダープロセスの実行
4. 2パス/3パスエンコードの実行（選択時）
5. 出力ファイル（.264 / .h264）の生成

**関連システム・外部連携**：
- x264エンコーダー: 実際のエンコード処理を担当
- AviSynth+/VapourSynth: フレームサーバーとして入力を提供
- ffmpeg: パイプ入力のサポート

**権限による制御**：
本機能に特別な権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | lgbEncoderからエンコーダ選択、コマンドライン設定 |
| 18 | CommandLineForm | API連携 | コマンドラインパラメータのGUI設定 |
| 3 | ProcessingForm | 結果表示画面 | エンコード進捗表示 |

## 機能種別

データ変換処理 / 計算処理 / ファイル出力

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Mode | x264RateMode | Yes | エンコードモード | 有効な列挙値 |
| Quant | Integer | No | CRF/QP値（0-51） | 範囲チェック |
| Bitrate | Integer | No | ターゲットビットレート（kbps） | 正の整数 |
| Preset | String | Yes | エンコードプリセット | 有効なプリセット名 |
| Tune | String | No | チューニングオプション | 有効なチューン名 |
| Profile | String | No | H.264プロファイル | baseline/main/high |
| Level | String | No | H.264レベル | 有効なレベル値 |

### 入力データソース

- AviSynth/VapourSynthスクリプト経由のビデオデータ
- パイプ入力（ffmpeg、avs2pipemod等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| エンコードファイル | File | H.264エンコードされたビデオストリーム（.264） |
| ログ | Text | エンコードログ |
| 統計ファイル | File | 2パス用の統計ファイル |

### 出力先

- 一時ディレクトリ（p.TempDir）
- Muxerでコンテナに多重化

## 処理フロー

### 処理シーケンス

```
1. エンコード設定の読み込み
   └─ ParamsStoreからx264Paramsを復元
2. ソーススクリプトの同期
   └─ p.Script.Synchronize()
3. コマンドライン生成
   └─ GetArgs()でx264用コマンドライン生成
4. エンコード実行
   └─ Procクラスでx264プロセスを実行
5. マルチパス処理（選択時）
   └─ 2パス目以降の実行
6. 結果確認
   └─ 出力ファイルの存在確認
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[パラメータ読み込み]
    B --> C[スクリプト同期]
    C --> D[コマンドライン生成]
    D --> E[1パス目実行]
    E --> F{2パスモード?}
    F -->|Yes| G[2パス目実行]
    F -->|No| H[完了]
    G --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-13-01 | プロファイル制限 | baseline使用時はBフレーム無効 | Profile = baseline |
| BR-13-02 | 互換性優先 | レベル4.1以下で広い互換性 | デフォルト推奨 |
| BR-13-03 | 10bit制限 | 10bitは専用ビルドが必要 | OutputDepth = 10 |

### 計算ロジック

- CRF計算: 品質ベースで動的ビットレート決定
- VBVバッファ: レベルに基づいて計算

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR-13-01 | ツールエラー | x264が見つからない | ツールのインストールを促す |
| ERR-13-02 | 入力エラー | スクリプトが無効 | スクリプト確認を促す |
| ERR-13-03 | パラメータエラー | 無効なパラメータ | エラーメッセージ表示 |

### リトライ仕様

リトライ機能なし。

## トランザクション仕様

ファイル操作のみのため、トランザクション管理なし。

## パフォーマンス要件

- CPUマルチスレッド対応
- プリセットによる速度/品質トレードオフ

## セキュリティ考慮事項

- コマンドライン引数のエスケープ処理

## 備考

- 8bit/10bitエンコードをサポート
- チャンクエンコード対応

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | x264Enc.vb | `Source/Encoding/x264Enc.vb` | x264Encクラスの構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | x264Enc.vb | `Source/Encoding/x264Enc.vb` | Encode()メソッド |

**主要処理フロー**:
- **Encode()**: エンコード実行のエントリーポイント
- **GetArgs()**: コマンドライン引数生成

### プログラム呼び出し階層図

```
MainForm
    │
    └─ x264Enc.Encode()
           │
           ├─ p.Script.Synchronize()
           │
           ├─ GetArgs()
           │      └─ Params.GetArgs()
           │
           └─ Proc.Start()
                  └─ x264.exe実行
```

### データフロー図

```
[入力]                    [処理]                      [出力]

AviSynth/VS
スクリプト ───────▶ フレームサーバー ───▶ YUV4MPEGパイプ
                          │
                          ▼
                    x264Enc.Encode()
                          │
                          └─▶ x264.exe ───▶ .264ファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| x264Enc.vb | `Source/Encoding/x264Enc.vb` | ソース | x264エンコーダークラス |
| Proc.vb | `Source/General/Proc.vb` | ソース | プロセス実行管理 |
| Package.vb | `Source/General/Package.vb` | ソース | ツールパス管理 |
