# 機能設計書 14-NVEncエンコード

## 概要

本ドキュメントは、StaxRipのNVEncエンコード機能の設計書である。NVIDIAグラフィックスカードのハードウェアエンコーダー（NVENC）を使用して、高速にビデオをエンコードする機能を定義する。

### 本機能の処理概要

NVIDIAのNVENC（NVIDIA Video Encoder）ハードウェアエンコーダーを活用し、GPU上で高速にビデオエンコードを実行する機能である。NVEncCツールを使用して、H.264、HEVC、AV1形式でのエンコードをサポートする。

**業務上の目的・背景**：
ハードウェアエンコードはソフトウェアエンコードと比較して大幅に高速であり、リアルタイムエンコードや大量のファイル処理に適している。NVIDIA製グラフィックスカードを所有するユーザーは、GPUの余剰リソースを活用してCPU負荷を軽減しながらエンコードを実行できる。

**機能の利用シーン**：
- 高速エンコードが必要な場合
- CPU負荷を軽減したい場合
- リアルタイムエンコード・ストリーミング
- 大量のファイルバッチ処理
- 4K/8K HDRコンテンツのエンコード

**主要な処理内容**：
1. NVIDIAハードウェアのチェック（--check-hw）
2. 入力ソースの準備（ネイティブデコードまたはパイプ入力）
3. エンコードパラメータの設定
4. HDR/Dolby Visionメタデータの処理
5. NVEncCプロセスの実行
6. 出力ファイルの生成

**関連システム・外部連携**：
- NVEncC: rigaya氏開発のNVENC CLIツール
- NVIDIA Driver: 対応するドライバーが必要
- CUDA: GPUアクセラレーション

**権限による制御**：
NVIDIAドライバーのインストールとGPUへのアクセス権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | GPUハードウェアエンコード設定 |
| 18 | CommandLineForm | API連携 | パラメータのGUI設定 |
| 3 | ProcessingForm | 結果表示画面 | エンコード進捗表示 |

## 機能種別

データ変換処理 / ハードウェアアクセラレーション / ファイル出力

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Codec | String | Yes | コーデック（h264/hevc/av1） | 有効なコーデック |
| Mode | Integer | Yes | レートコントロールモード | 有効な値 |
| Bitrate | Integer | No | ターゲットビットレート | 正の整数 |
| QualityPreset | String | No | 品質プリセット | 有効なプリセット |
| DolbyVisionProfile | String | No | Dolby Visionプロファイル | 有効なDVプロファイル |
| DolbyVisionRpu | String | No | RPUファイルパス | ファイル存在確認 |

### 入力データソース

- ソースファイル（ネイティブデコード）
- AviSynth/VapourSynthスクリプト（パイプ入力）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| エンコードファイル | File | エンコードされたビデオストリーム |
| ログ | Text | エンコードログ |

### 出力先

- 一時ディレクトリ（p.TempDir）
- 出力拡張子はコーデックに依存（h264/hevc/ivf）

## 処理フロー

### 処理シーケンス

```
1. ハードウェアチェック
   └─ NVEncC --check-hw でGPU確認
2. コーデックサポート確認
   └─ HEVCの場合、サポート状況をチェック
3. スクリプト同期
   └─ p.Script.Synchronize()
4. HDRメタデータ処理
   └─ SetMetaData()でVUIメタデータインポート
5. Dolby Vision前処理
   └─ BeforeEncoding()でRPU調整
6. コマンドライン生成
   └─ Params.GetCommandLine()
7. エンコード実行
   └─ cmd.exe経由でNVEncCを実行
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ハードウェアチェック]
    B --> C{GPU対応?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[スクリプト同期]
    E --> F{HDRメタデータ?}
    F -->|Yes| G[SetMetaData]
    F -->|No| H{Dolby Vision?}
    G --> H
    H -->|Yes| I[BeforeEncoding]
    H -->|No| J[コマンドライン生成]
    I --> J
    J --> K[NVEncC実行]
    K --> L[完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-14-01 | HEVC対応チェック | HEVC使用前にGPU対応をチェック | OutputExt = hevc |
| BR-14-02 | Dolby Vision制約 | DVプロファイルに応じたモード設定 | DolbyVisionProfile設定時 |
| BR-14-03 | AV1出力 | AV1はMuxer出力拡張子を使用 | Codec = av1 |

### 計算ロジック

- HDRメタデータのluminance値を10000倍してNVEncC形式に変換

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR-14-01 | ハードウェアエラー | NVIDIAグラフィックスカードなし | エラーメッセージ表示 |
| ERR-14-02 | コーデックエラー | HEVCがサポートされていない | 対応コーデックを案内 |
| ERR-14-03 | ツールエラー | NVEncCが見つからない | ツールインストールを促す |

### リトライ仕様

リトライ機能なし。

## トランザクション仕様

ファイル操作のみ。

## パフォーマンス要件

- ハードウェアエンコードによりソフトウェアの数倍〜数十倍高速
- GPU使用率に依存

## セキュリティ考慮事項

- ドライバー互換性の確認

## 備考

- 対応するNVIDIA GPUとドライバーが必要
- 品質はソフトウェアエンコードに劣る場合がある

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NVEnc.vb | `Source/Encoding/NVEnc.vb` | NVEncクラスの構造、EncoderParams |

**読解のコツ**: Paramsプロパティで遅延初期化されるEncoderParamsクラスに注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | NVEnc.vb | `Source/Encoding/NVEnc.vb` | Encode()メソッド（174-193行目） |

**主要処理フロー**:
- **174-181行目**: HEVCサポートチェック
- **183-192行目**: Procクラスでcmd.exe経由でNVEncC実行

#### Step 3: HDR処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | NVEnc.vb | `Source/Encoding/NVEnc.vb` | SetMetaData()メソッド（230-366行目） |

**主要処理フロー**:
- **230-280行目**: VUIメタデータ（colorprim, transfer, colormatrix）の設定
- **289-334行目**: MasteringDisplay情報の処理
- **336-356行目**: Dolby Visionプロファイルの設定

### プログラム呼び出し階層図

```
MainForm
    │
    └─ NVEnc.Encode()
           │
           ├─ ProcessHelp.GetConsoleOutput() [HEVCチェック]
           │
           ├─ p.Script.Synchronize()
           │
           ├─ Params.GetCommandLine()
           │
           └─ Proc.Start()
                  └─ cmd.exe /S /C "NVEncC ..."
```

### データフロー図

```
[入力]                    [処理]                      [出力]

ソースファイル ───▶ NVEncC内蔵デコーダー
      or               │
AviSynth/VS ─────────▶ パイプ入力
                       │
                       ▼
                 NVEncC (GPU)
                       │
                       ▼
                  .hevc/.h264/.ivf
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| NVEnc.vb | `Source/Encoding/NVEnc.vb` | ソース | NVEncエンコーダークラス |
| Proc.vb | `Source/General/Proc.vb` | ソース | プロセス実行管理 |
| Package.vb | `Source/General/Package.vb` | ソース | NVEncCパス管理 |
| MediaInfo.vb | `Source/General/MediaInfo.vb` | ソース | メタデータ取得 |
