# 機能設計書 15-QSVEncエンコード

## 概要

本ドキュメントは、StaxRipのQSVEncエンコード機能の設計書である。IntelプロセッサのQuick Sync Video（QSV）ハードウェアエンコーダーを使用して、高速にビデオをエンコードする機能を定義する。

### 本機能の処理概要

IntelのQuick Sync Video（QSV）ハードウェアエンコーダーを活用し、Intel CPU/GPU上で高速にビデオエンコードを実行する機能である。QSVEncCツールを使用して、H.264、HEVC、MPEG-2、VP9、AV1形式でのエンコードをサポートする。

**業務上の目的・背景**：
Intel製CPUを搭載したPCでは、追加のグラフィックスカードなしでハードウェアエンコードが可能。内蔵GPUを活用することで、ソフトウェアエンコードより高速に処理でき、CPUリソースを他の作業に使用できる。

**機能の利用シーン**：
- Intel CPU搭載PCでの高速エンコード
- 専用GPUなしでのハードウェアエンコード
- バッチ処理による大量ファイルの変換
- HDR/Dolby Visionコンテンツのエンコード

**主要な処理内容**：
1. QSVハードウェアのチェック（--check-hw）
2. 入力ソースの準備
3. エンコードパラメータの設定
4. HDR/Dolby Visionメタデータの処理
5. QSVEncCプロセスの実行
6. 出力ファイルの生成

**関連システム・外部連携**：
- QSVEncC: rigaya氏開発のQSV CLIツール
- Intel Media SDK / oneVPL: Intelメディアライブラリ

**権限による制御**：
対応するIntel CPUとドライバーが必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | Intel QSVエンコード設定 |
| 18 | CommandLineForm | API連携 | パラメータのGUI設定 |

## 機能種別

データ変換処理 / ハードウェアアクセラレーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Codec | String | Yes | コーデック（h264/hevc/mpeg2/vp9/av1） | 有効なコーデック |
| Mode | String | Yes | レートコントロールモード | 有効な値 |
| Bitrate | Integer | No | ターゲットビットレート | 正の整数 |
| DolbyVisionProfile | String | No | Dolby Visionプロファイル | 有効なプロファイル |
| DolbyVisionRpu | String | No | RPUファイルパス | ファイル存在確認 |

### 入力データソース

- ソースファイル（ネイティブデコード）
- AviSynth/VapourSynthスクリプト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| エンコードファイル | File | エンコードされたビデオストリーム |

### 出力先

- 一時ディレクトリ（p.TempDir）
- 拡張子はコーデックに依存（h264/hevc/m2v/ivf）

## 処理フロー

### 処理シーケンス

```
1. ハードウェアチェック
   └─ QSVEncC --check-features でサポート確認
2. スクリプト同期
   └─ p.Script.Synchronize()
3. HDRメタデータ処理
   └─ SetMetaData()
4. Dolby Vision前処理
   └─ BeforeEncoding()
5. コマンドライン生成
   └─ Params.GetCommandLine()
6. エンコード実行
   └─ cmd.exe経由でQSVEncC実行
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{HEVCモード?}
    B -->|Yes| C[HEVCサポートチェック]
    B -->|No| D[スクリプト同期]
    C --> E{サポート?}
    E -->|No| F[エラー終了]
    E -->|Yes| D
    D --> G[コマンドライン生成]
    G --> H[QSVEncC実行]
    H --> I[完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-15-01 | HEVCチェック | HEVC使用前にハードウェアサポート確認 | OutputExt = hevc |
| BR-15-02 | 出力拡張子 | MPEG-2はm2v、VP9はivf | コーデックに応じて |
| BR-15-03 | QualityMode | cqp/icq/la-icq/vcmで品質モード | Mode設定時 |

### 計算ロジック

- HDRメタデータのluminance値を10000倍

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR-15-01 | ハードウェアエラー | Intel QSV非対応 | エラーメッセージ表示 |
| ERR-15-02 | コーデックエラー | HEVCがサポートされていない | 対応コーデック案内 |

### リトライ仕様

リトライ機能なし。

## トランザクション仕様

ファイル操作のみ。

## パフォーマンス要件

- ハードウェアエンコードにより高速処理

## セキュリティ考慮事項

- ドライバー互換性の確認

## 備考

- Intel 第6世代以降のCPUを推奨
- oneVPL対応により新しいプラットフォームもサポート

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | QSVEnc.vb | `Source/Encoding/QSVEnc.vb` | QSVEncクラスの構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | QSVEnc.vb | `Source/Encoding/QSVEnc.vb` | Encode()メソッド（179-199行目） |

**主要処理フロー**:
- **180-186行目**: HEVCサポートチェック
- **188-198行目**: Procクラスでcmd.exe経由でQSVEncC実行

### プログラム呼び出し階層図

```
MainForm
    │
    └─ QSVEnc.Encode()
           │
           ├─ ProcessHelp.GetConsoleOutput() [HEVCチェック]
           │
           ├─ p.Script.Synchronize()
           │
           └─ Proc.Start()
                  └─ cmd.exe /S /C "QSVEncC ..."
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| QSVEnc.vb | `Source/Encoding/QSVEnc.vb` | ソース | QSVEncエンコーダークラス |
| Proc.vb | `Source/General/Proc.vb` | ソース | プロセス実行管理 |
| Package.vb | `Source/General/Package.vb` | ソース | QSVEncCパス管理 |
