# 機能設計書 16-VCEEncエンコード

## 概要

本ドキュメントは、StaxRipのVCEEncエンコード機能の設計書である。AMDグラフィックスカードのVideo Coding Engine（VCE）ハードウェアエンコーダーを使用して、高速にビデオをエンコードする機能を定義する。

### 本機能の処理概要

AMDのVCE（Video Coding Engine）ハードウェアエンコーダーを活用し、AMD GPU上で高速にビデオエンコードを実行する機能である。VCEEncCツールを使用して、H.264、HEVC、AV1形式でのエンコードをサポートする。

**業務上の目的・背景**：
AMD製グラフィックスカードを所有するユーザーは、GPUのハードウェアエンコード機能を活用して高速なエンコードを実現できる。NVIDIA NVENCやIntel QSVと同様に、CPU負荷を軽減しながら高速処理が可能。

**機能の利用シーン**：
- AMD GPU搭載PCでの高速エンコード
- CPU負荷を軽減したい場合
- HDR/Dolby Visionコンテンツのエンコード
- バッチ処理による大量ファイル変換

**主要な処理内容**：
1. AMDハードウェアのチェック（--check-hw）
2. 入力ソースの準備
3. エンコードパラメータの設定
4. HDR/Dolby Visionメタデータの処理
5. VCEEncCプロセスの実行
6. 出力ファイルの生成

**関連システム・外部連携**：
- VCEEncC: rigaya氏開発のVCE CLIツール
- AMD AMF SDK: AMDメディアフレームワーク

**権限による制御**：
対応するAMD GPUとドライバーが必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | AMD VCEエンコード設定 |
| 18 | CommandLineForm | API連携 | パラメータのGUI設定 |

## 機能種別

データ変換処理 / ハードウェアアクセラレーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Codec | String | Yes | コーデック（h264/hevc/av1） | 有効なコーデック |
| Mode | Integer | Yes | レートコントロールモード | 有効な値 |
| Bitrate | Integer | No | ターゲットビットレート | 正の整数 |
| DolbyVisionProfile | String | No | Dolby Visionプロファイル | 有効なプロファイル |

### 入力データソース

- ソースファイル（ネイティブデコード）
- AviSynth/VapourSynthスクリプト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| エンコードファイル | File | エンコードされたビデオストリーム |

### 出力先

- 一時ディレクトリ（p.TempDir）
- 拡張子はコーデックに依存

## 処理フロー

### 処理シーケンス

```
1. スクリプト同期
   └─ p.Script.Synchronize()
2. HDRメタデータ処理
   └─ SetMetaData()
3. Dolby Vision前処理
   └─ BeforeEncoding()
4. コマンドライン生成
   └─ Params.GetCommandLine()
5. エンコード実行
   └─ cmd.exe経由でVCEEncC実行
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[スクリプト同期]
    B --> C{HDRメタデータ?}
    C -->|Yes| D[SetMetaData]
    C -->|No| E{Dolby Vision?}
    D --> E
    E -->|Yes| F[BeforeEncoding]
    E -->|No| G[コマンドライン生成]
    F --> G
    G --> H[VCEEncC実行]
    H --> I[完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-16-01 | AV1出力 | AV1はMuxer出力拡張子を使用 | Codec = av1 |
| BR-16-02 | QualityMode | Mode.Value = 0で品質モード | Mode設定時 |

### 計算ロジック

- HDRメタデータのluminance値を10000倍

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR-16-01 | ハードウェアエラー | AMD VCE非対応 | エラーメッセージ表示 |
| ERR-16-02 | ツールエラー | VCEEncCが見つからない | ツールインストールを促す |

### リトライ仕様

リトライ機能なし。

## トランザクション仕様

ファイル操作のみ。

## パフォーマンス要件

- ハードウェアエンコードにより高速処理

## セキュリティ考慮事項

- ドライバー互換性の確認

## 備考

- 対応するAMD GPUとドライバーが必要
- Radeon RX 400シリーズ以降を推奨

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | VCEEnc.vb | `Source/Encoding/VCEEnc.vb` | VCEEncクラスの構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | VCEEnc.vb | `Source/Encoding/VCEEnc.vb` | Encode()メソッド（170-181行目） |

**主要処理フロー**:
- **171行目**: p.Script.Synchronize()
- **173-180行目**: Procクラスでcmd.exe経由でVCEEncC実行

### プログラム呼び出し階層図

```
MainForm
    │
    └─ VCEEnc.Encode()
           │
           ├─ p.Script.Synchronize()
           │
           └─ Proc.Start()
                  └─ cmd.exe /S /C "VCEEncC ..."
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| VCEEnc.vb | `Source/Encoding/VCEEnc.vb` | ソース | VCEEncエンコーダークラス |
| Proc.vb | `Source/General/Proc.vb` | ソース | プロセス実行管理 |
| Package.vb | `Source/General/Package.vb` | ソース | VCEEncCパス管理 |
