# 機能設計書 17-AV1エンコード

## 概要

本ドキュメントは、StaxRipのAV1エンコード機能の設計書である。次世代ビデオコーデックであるAV1形式でビデオをエンコードする機能を定義する。AOMEnc、SVT-AV1、Rav1eの3つのエンコーダーをサポートする。

### 本機能の処理概要

AV1（AOMedia Video 1）コーデックを使用して、入力ビデオストリームをAV1形式にエンコードする機能である。AOMEnc（リファレンスエンコーダー）、SVT-AV1（Intel/Netflix共同開発の高速エンコーダー）、Rav1e（Rustベースのエンコーダー）の3種類のエンコーダーをサポートし、用途に応じた選択が可能。

**業務上の目的・背景**：
AV1はロイヤリティフリーの次世代ビデオコーデックであり、HEVCと同等以上の圧縮効率を持つ。YouTube、Netflix、その他のストリーミングサービスで採用が進んでおり、将来的にはH.264/HEVCの後継として期待されている。

**機能の利用シーン**：
- 次世代コーデックでの高効率エンコード
- ロイヤリティフリーコーデックが必要な場合
- ストリーミング配信用コンテンツの作成
- WebM形式での出力が必要な場合

**主要な処理内容**：
1. エンコーダーの選択（AOMEnc/SVT-AV1/Rav1e）
2. 入力ソースの準備
3. エンコードパラメータの設定
4. 1パス/2パスエンコードの実行
5. チャンクエンコードによる並列処理（AOMEnc/SVT-AV1）
6. 出力ファイル（.ivf/.obu/.webm）の生成

**関連システム・外部連携**：
- AOMEnc: Alliance for Open Mediaリファレンスエンコーダー
- SVT-AV1: Intel/Netflix開発の高速エンコーダー
- Rav1e: Rustで実装されたエンコーダー

**権限による制御**：
本機能に特別な権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | AV1コーデックエンコード設定 |
| 18 | CommandLineForm | API連携 | パラメータのGUI設定 |

## 機能種別

データ変換処理 / 計算処理 / ファイル出力

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Encoder | String | Yes | エンコーダー（AOMEnc/SVT-AV1/Rav1e） | 有効なエンコーダー |
| RateMode | String | Yes | レートモード（VBR/CBR/CQ/Q） | 有効なモード |
| CqLevel | Integer | No | CQ/Qレベル（0-63） | 範囲チェック |
| TargetBitrate | Integer | No | ターゲットビットレート | 正の整数 |
| Passes | Integer | No | パス数（1/2） | 1または2 |
| Chunks | Integer | No | チャンク数（並列処理） | 正の整数 |

### 入力データソース

- AviSynth/VapourSynthスクリプト
- QSVEnc/ffmpegデコーダー

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| エンコードファイル | File | AV1エンコードされたビデオ |
| 統計ファイル | File | 2パス用統計ファイル（.fpf） |

### 出力先

- 一時ディレクトリ（p.TempDir）
- 出力形式はIVF/OBU/WebMから選択

## 処理フロー

### 処理シーケンス

```
1. エンコーダー選択確認
   └─ AOMEnc/SVT-AV1/Rav1eの判定
2. スクリプト同期
   └─ p.Script.Synchronize()
3. パス1実行
   └─ Encode("Video encoding pass 1", ...)
4. パス2実行（2パスモード時）
   └─ Encode("Video encoding pass 2", ...)
5. チャンク結合（チャンクエンコード時）
   └─ mkvmerge等で結合
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[エンコーダー選択]
    B --> C[スクリプト同期]
    C --> D{チャンクエンコード?}
    D -->|Yes| E[チャンク分割処理]
    D -->|No| F{2パスモード?}
    E --> G[並列エンコード]
    F -->|Yes| H[1パス目実行]
    F -->|No| I[1パス実行]
    H --> J[2パス目実行]
    G --> K[チャンク結合]
    I --> L[完了]
    J --> L
    K --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-17-01 | 出力形式選択 | IVF/OBU/WebMから選択可能 | AOMEnc使用時 |
| BR-17-02 | チャンクエンコード | Chunks > 1で並列処理 | AOMEnc/SVT-AV1 |
| BR-17-03 | 2パス順序 | 1パス→2パスの順序で実行 | Passes = 2 |
| BR-17-04 | VUIメタデータ | SVT-AV1でカラー情報をインポート | SVT-AV1使用時 |

### 計算ロジック

- チャンク分割: 総フレーム数をチャンク数で均等分割
- 各チャンクの開始/終了フレームを計算

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR-17-01 | ツールエラー | エンコーダーが見つからない | ツールインストールを促す |
| ERR-17-02 | 入力エラー | スクリプトが無効 | スクリプト確認を促す |

### リトライ仕様

リトライ機能なし。

## トランザクション仕様

ファイル操作のみ。

## パフォーマンス要件

- SVT-AV1が最も高速、AOMEncが最も高品質
- チャンクエンコードで並列処理可能

## セキュリティ考慮事項

- コマンドライン引数のエスケープ処理

## 備考

- AV1はエンコードに時間がかかる傾向がある
- SVT-AV1は速度と品質のバランスが良い

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AOMEnc.vb | `Source/Encoding/AOMEnc.vb` | AOMEncクラス、AV1Params |
| 1-2 | SvtAv1Enc.vb | `Source/Encoding/SvtAv1Enc.vb` | SvtAv1Encクラス |
| 1-3 | Rav1e.vb | `Source/Encoding/Rav1e.vb` | Rav1eクラス |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AOMEnc.vb | `Source/Encoding/AOMEnc.vb` | Encode()メソッド（83-90行目） |

**主要処理フロー**:
- **83-90行目**: Encode()メソッド - 1パス/2パス実行
- **110-149行目**: GetChunkEncodeActions() - チャンクエンコード処理

#### Step 3: コマンドライン生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AOMEnc.vb | `Source/Encoding/AOMEnc.vb` | AV1Params.GetArgs()メソッド |

**主要処理フロー**:
- **617-811行目**: GetArgs() - パイプ入力とコマンドライン生成

### プログラム呼び出し階層図

```
MainForm
    │
    ├─ AOMEnc.Encode()
    │      │
    │      ├─ p.Script.Synchronize()
    │      │
    │      └─ Encode(passName, commandLine, priority)
    │             └─ Proc.Start()
    │                    └─ cmd.exe経由でaomenc実行
    │
    ├─ SvtAv1Enc.Encode()
    │      └─ 同様の構造
    │
    └─ Rav1e.Encode()
           └─ 同様の構造
```

### データフロー図

```
[入力]                    [処理]                      [出力]

AviSynth/VS ───▶ avs2pipemod/vspipe ───▶ Y4Mパイプ
                          │
                          ▼
                    AOMEnc/SVT-AV1/Rav1e
                          │
                          ├─▶ .ivfファイル
                          ├─▶ .obuファイル
                          └─▶ .webmファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AOMEnc.vb | `Source/Encoding/AOMEnc.vb` | ソース | AOMEncエンコーダークラス |
| SvtAv1Enc.vb | `Source/Encoding/SvtAv1Enc.vb` | ソース | SVT-AV1エンコーダークラス |
| Rav1e.vb | `Source/Encoding/Rav1e.vb` | ソース | Rav1eエンコーダークラス |
| Proc.vb | `Source/General/Proc.vb` | ソース | プロセス実行管理 |
| Package.vb | `Source/General/Package.vb` | ソース | エンコーダーパス管理 |
