# 機能設計書 19-2パスエンコード

## 概要

本ドキュメントは、StaxRipの2パスエンコード機能の設計書である。2パス可変ビットレート（VBR）エンコードを実行し、指定したビットレートで最高品質のエンコードを実現する機能を定義する。

### 本機能の処理概要

2パスエンコードは、1パス目でビデオ全体を解析して統計情報を収集し、2パス目でその統計に基づいて最適なビットレート配分を行うエンコード手法である。シーンの複雑さに応じてビットレートを動的に配分することで、一定品質を維持しながらターゲットファイルサイズを達成する。

**業務上の目的・背景**：
1パスエンコードでは、エンコーダーは先のシーンを予測できないため、ビットレート配分が最適化されない。2パスエンコードでは、1パス目で収集した情報を活用することで、複雑なシーンにより多くのビットを、単純なシーンには少ないビットを割り当てる最適化が可能。

**機能の利用シーン**：
- 特定のファイルサイズに収める必要がある場合
- Blu-ray/DVD作成でビットレート制限がある場合
- 配信用に正確なファイルサイズが必要な場合
- 最高品質のエンコードが必要な場合

**主要な処理内容**：
1. 1パス目: ビデオ全体を解析し、統計ファイル生成
2. 統計ファイルの保存（.log, .cutree等）
3. 2パス目: 統計に基づいた最適ビットレート配分でエンコード
4. 出力ファイルの生成

**関連システム・外部連携**：
- x265: 2パス/3パスエンコード対応
- x264: 2パス/3パスエンコード対応
- AOMEnc: 2パスエンコード対応

**権限による制御**：
本機能に特別な権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | エンコーダー設定でモード選択 |
| 18 | CommandLineForm | API連携 | Modeパラメータの設定 |

## 機能種別

データ変換処理 / 計算処理 / 高品質エンコード

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Mode | RateMode | Yes | エンコードモード（TwoPass/ThreePass） | 有効な列挙値 |
| Bitrate | Integer | Yes | ターゲットビットレート（kbps） | 正の整数 |
| Pass | Integer | No | 現在のパス番号 | 1, 2, または3 |

### 入力データソース

- AviSynth/VapourSynthスクリプト
- 1パス目で生成された統計ファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 統計ファイル | File | 1パス目で生成される解析データ（.log, .cutree） |
| エンコードファイル | File | 2パス目で生成される最終出力 |

### 出力先

- 一時ディレクトリ（p.TempDir）

## 処理フロー

### 処理シーケンス

```
1. モード確認
   └─ Mode = TwoPass または ThreePass
2. 1パス目実行
   └─ --pass 1 オプションで解析実行
   └─ 統計ファイル生成（.log, .cutree）
3. 2パス目実行（または3パス時はパス3）
   └─ --pass 2 オプションで最終エンコード
   └─ 統計ファイルを読み込んで最適化
4. [3パス時のみ] 追加パス
   └─ x265では 1→3→2 の順序で実行
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{2パス/3パスモード?}
    B -->|Yes| C[1パス目実行]
    B -->|No| D[1パスエンコード]
    C --> E[統計ファイル生成]
    E --> F{3パスモード?}
    F -->|Yes| G[3パス目実行]
    F -->|No| H[2パス目実行]
    G --> I[2パス目実行]
    H --> J[完了]
    I --> J
    D --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-19-01 | 3パス順序 | x265の3パスは1→3→2の順序で実行 | Mode = ThreePass (x265) |
| BR-19-02 | 統計ファイル必須 | 2パス目実行には1パス目の統計が必要 | Pass = 2 |
| BR-19-03 | ビットレート指定 | 2パスではビットレート指定が必須 | Mode = TwoPass |

### 計算ロジック

- 1パス目: シーンの複雑さ、モーション情報を解析
- 2パス目: 統計に基づいてフレームごとのビット配分を最適化

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR-19-01 | ファイルエラー | 統計ファイルが存在しない | 1パス目から再実行 |
| ERR-19-02 | 設定エラー | ビットレートが指定されていない | ビットレート設定を促す |

### リトライ仕様

リトライ機能なし。統計ファイルが破損した場合は1パス目から再実行が必要。

## トランザクション仕様

ファイル操作のみ。1パス目が失敗した場合、統計ファイルは生成されない。

## パフォーマンス要件

- エンコード時間は1パスの約2倍（2パス時）
- 1パス目は統計のみ生成のため比較的高速

## セキュリティ考慮事項

- 統計ファイルは一時ファイルとして管理

## 備考

- CRFモードとの併用は通常不要（CRFは品質ベース）
- 3パスモードはさらに高品質だが時間がかかる

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | x265Enc.vb | `Source/Encoding/x265Enc.vb` | x265RateMode列挙型 |
| 1-2 | x264Enc.vb | `Source/Encoding/x264Enc.vb` | x264RateMode列挙型 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | x265Enc.vb | `Source/Encoding/x265Enc.vb` | Encode()メソッド（112-122行目） |

**主要処理フロー**:
- **112-114行目**: 1パス目実行
- **115-116行目**: 2パスモード時の2パス目実行
- **117-121行目**: 3パスモード時の処理（1→3→2順序）

#### Step 3: コマンドライン生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | x265Params | `Source/Encoding/x265Enc.vb` | GetArgs()でのpass引数生成 |

**主要処理フロー**:
- 統計ファイルパスの生成
- --pass オプションの設定

### プログラム呼び出し階層図

```
MainForm (エンコード開始)
    │
    └─ x265Enc.Encode()
           │
           ├─ Encode("Video encoding", GetArgs(1, ...), ...)
           │      └─ 1パス目実行、統計ファイル生成
           │
           ├─ [2パス時] Encode("Video encoding second pass", GetArgs(2, ...), ...)
           │      └─ 2パス目実行、最終出力
           │
           └─ [3パス時]
                  ├─ Encode("Video encoding Nth pass", GetArgs(3, ...), ...)
                  │      └─ 3パス目実行
                  │
                  └─ Encode("Video encoding last pass", GetArgs(2, ...), ...)
                         └─ 2パス目実行、最終出力
```

### データフロー図

```
[1パス目]                [2パス目]                  [出力]

ソーススクリプト ───▶ x265 --pass 1
                           │
                           ▼
                     統計ファイル(.log)
                     統計ファイル(.cutree)
                           │
                           ▼
                     x265 --pass 2 ───▶ .hevcファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| x265Enc.vb | `Source/Encoding/x265Enc.vb` | ソース | x265の2パス/3パス実装 |
| x264Enc.vb | `Source/Encoding/x264Enc.vb` | ソース | x264の2パス実装 |
| AOMEnc.vb | `Source/Encoding/AOMEnc.vb` | ソース | AOMEncの2パス実装 |
| Proc.vb | `Source/General/Proc.vb` | ソース | プロセス実行管理 |
