# 機能設計書 2-複数ファイル読み込み

## 概要

本ドキュメントは、StaxRipアプリケーションにおける複数ファイル読み込み機能の設計仕様を記述する。複数のソースファイルを一括で読み込み、バッチ処理やファイル結合に対応する機能である。

### 本機能の処理概要

**業務上の目的・背景**：動画エンコード作業において、複数のソースファイルを連続処理したい場合がある。例えば、分割されたビデオファイルの結合や、複数ファイルのバッチエンコードである。本機能は、SourceFilesFormダイアログを介して複数ファイルを選択し、プロジェクトに設定する。これにより、効率的なバッチ処理ワークフローが実現される。

**機能の利用シーン**：
- 分割されたビデオファイルを結合してエンコードする場合
- フォルダ内の複数ファイルを一括でバッチキューに追加する場合
- DVD VOBファイル群を連結処理する場合
- 連番ファイルを順序通りに読み込む場合

**主要な処理内容**：
1. SourceFilesFormダイアログの表示
2. ファイル選択（ファイルダイアログまたはフォルダ選択）
3. ファイルリストの並び替え（上下移動、ドラッグ&ドロップ）
4. ファイルの追加・削除
5. 選択ファイルのバリデーション
6. プロジェクトSourceFilesリストへの設定

**関連システム・外部連携**：
- ファイルシステム：ファイル/フォルダの参照
- StringLogicalComparer：自然順ソート

**権限による制御**：特になし。ファイルシステムへの読み取りアクセス権が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | SourceFilesFormを呼び出して複数ファイルを一括読み込み |
| - | SourceFilesForm | 専用ダイアログ | ファイルリストの管理UI |

## 機能種別

データ読み込み / バッチ処理準備 / ファイル管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| filePaths | String() | Yes | ソースファイルのパス配列 | 各ファイル存在確認、対応形式チェック |

### 入力データソース

- ファイル選択ダイアログ：OpenFileDialogでMultiselect=True
- フォルダ選択ダイアログ：FolderBrowserDialogでフォルダ内ファイル取得
- ドラッグ&ドロップ：SourceFilesFormのListBoxへのファイルドロップ
- プログラム呼び出し：GlobalCommands.LoadSourceFiles()メソッド

### 対応ファイル形式

FileTypes.Videoに定義された形式（MKV、MP4、M2TS、AVI、VOB、WebM等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| SourceFiles | List(Of String) | ソースファイルパスのリスト |
| SourceFile | String | 最初のソースファイルパス（プライマリ） |
| FirstOriginalSourceFile | String | 元の最初のソースファイル |
| LastOriginalSourceFile | String | 元の最後のソースファイル |

### 出力先

- Projectオブジェクト：SourceFilesリストの保持
- MainForm画面表示：ソース情報表示の更新

## 処理フロー

### 処理シーケンス

```
1. SourceFilesForm表示
   └─ MainFormからダイアログ起動
2. ファイル追加
   └─ Add/ファイル選択またはフォルダ選択
   └─ ドラッグ&ドロップ対応
3. リスト操作
   └─ Up/Downで並び替え
   └─ Removeで削除
4. バリデーション
   └─ g.VerifySource()で検証
5. 確定処理
   └─ OKボタンでプロジェクトに反映
6. プロジェクト設定
   └─ p.SourceFiles、p.SourceFileへの設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[SourceFilesForm表示]
    B --> C{追加方法選択}
    C -->|ファイル| D[ファイル選択ダイアログ]
    C -->|フォルダ| E[フォルダ選択ダイアログ]
    C -->|ドラッグ| F[ファイルドロップ受付]
    D --> G[リストに追加]
    E --> H{サブフォルダ含む?}
    H -->|Yes| I[再帰的にファイル取得]
    H -->|No| J[直下のファイル取得]
    I --> G
    J --> G
    F --> G
    G --> K{OK押下?}
    K -->|No| L{Cancel?}
    L -->|Yes| M[終了]
    L -->|No| C
    K -->|Yes| N[VerifySource検証]
    N --> O{検証OK?}
    O -->|No| K
    O -->|Yes| P[プロジェクト設定]
    P --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | ファイル形式統一 | リスト内の全ファイルは対応形式であること | 常時 |
| BR-002 | 自然順ソート | ファイル追加時にStringLogicalComparerでソート | ファイル/フォルダ追加時 |
| BR-003 | 重複除外 | 同一ファイルの重複追加は防止 | ドラッグ&ドロップ時 |

### 計算ロジック

特になし。ファイルリストの管理のみ。

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-001 | FileNotFound | リスト内ファイルが存在しない | エラーメッセージ表示、OK無効化 |
| E-002 | UnsupportedFormat | 非対応ファイル形式が含まれる | 該当ファイルを除外 |
| E-003 | EmptyList | ファイルが1つも選択されていない | 警告表示 |

### リトライ仕様

リトライ処理は行わない。ユーザーがリストを修正して再度OKを押す。

## トランザクション仕様

本機能はトランザクション管理を行わない。

## パフォーマンス要件

- ダイアログ表示：即時
- フォルダスキャン：ファイル数に依存（大量ファイル時は数秒）

## セキュリティ考慮事項

- ファイルパスのサニタイズ
- アクセス権限チェック

## 備考

- IsMergeプロパティがTrueの場合、フォルダ追加オプションが無効化される
- 連番ファイルの自然順ソートにはStringLogicalComparerを使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ソースファイルリストを保持するデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Project.vb | `Source/General/Project.vb` | SourceFilesプロパティ（120行目） |

**読解のコツ**: SourceFilesはList(Of String)型で、複数ファイルパスを格納する。

#### Step 2: ダイアログUIを理解する

SourceFilesFormのUI構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SourceFilesForm.vb | `Source/Forms/SourceFilesForm.vb` | フォーム定義とコントロール（1-162行目） |

**主要処理フロー**:
1. **4行目**: SourceFilesFormクラス定義
2. **21-161行目**: InitializeComponentでUI初期化
3. **lb**: ファイルリストを表示するListBoxEx

#### Step 3: ファイル追加処理を理解する

ファイル/フォルダ追加の実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SourceFilesForm.vb | `Source/Forms/SourceFilesForm.vb` | bnAdd_Clickハンドラ（230-261行目） |
| 3-2 | SourceFilesForm.vb | `Source/Forms/SourceFilesForm.vb` | ShowOpenFileDialog（216-228行目） |

**主要処理フロー**:
- **230行目**: bnAdd_Clickイベントハンドラ
- **236行目**: TaskDialogで追加方法選択（ファイル/フォルダ）
- **255行目**: Directory.GetFilesでフォルダ内ファイル取得

#### Step 4: バリデーションを理解する

ファイルリストの検証処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SourceFilesForm.vb | `Source/Forms/SourceFilesForm.vb` | OnFormClosing（263-273行目） |

**主要処理フロー**:
- **269行目**: g.VerifySource(GetFiles)で検証

### プログラム呼び出し階層図

```
MainForm（メニュー/ボタン）
    │
    └─ SourceFilesForm.ShowDialog()
           │
           ├─ bnAdd_Click()
           │      ├─ ShowOpenFileDialog() [ファイル追加]
           │      └─ FolderBrowserDialog [フォルダ追加]
           │
           ├─ lb.Items操作 [リスト管理]
           │      ├─ Up/Down [並び替え]
           │      └─ Remove [削除]
           │
           └─ OnFormClosing()
                  └─ g.VerifySource() [検証]
```

### データフロー図

```
[入力]                      [処理]                        [出力]

ファイル選択 ──────────▶ ShowOpenFileDialog()
                              │
                              ▼
フォルダ選択 ──────────▶ Directory.GetFiles()
                              │
                              ▼
ドラッグ&ドロップ ────▶ lb_DragDrop()
                              │
                              ▼
                     lb.Items（リスト管理）
                              │
                              ▼
                     g.VerifySource() ────────────▶ Project.SourceFiles
                                                    Project.SourceFile
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SourceFilesForm.vb | `Source/Forms/SourceFilesForm.vb` | ソース | 複数ファイル選択ダイアログ |
| Project.vb | `Source/General/Project.vb` | ソース | SourceFilesリスト保持 |
| GlobalCommands.vb | `Source/General/GlobalCommands.vb` | ソース | LoadSourceFilesコマンド |
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | ダイアログ呼び出し元 |
