# 機能設計書 20-オーディオDemux

## 概要

本ドキュメントは、StaxRipのオーディオDemux機能の設計書である。ソースファイルからオーディオストリームを分離（Demux）し、後続のオーディオエンコードやMux処理で使用できるようにする機能を定義する。

### 本機能の処理概要

動画ファイルに含まれるオーディオストリームを分離（Demux）する機能である。MKV、MP4、M2TS等の各種コンテナからオーディオトラックを抽出し、AAC、AC3、DTS、FLAC等の形式で出力する。複数のオーディオトラックを持つファイルから特定のトラックのみを選択的に抽出することも可能。

**業務上の目的・背景**：
動画ファイルの再エンコード時、オーディオストリームはそのまま保持（パススルー）するか、別のコーデックに変換する必要がある。オーディオDemux機能により、ソースファイルからオーディオを分離し、必要に応じてエンコードや言語選択を行った後、最終出力に含めることができる。

**機能の利用シーン**：
- ビデオ再エンコード時のオーディオ抽出
- 多言語音声から特定言語の選択
- オーディオコーデックの変換前処理
- カット編集時のオーディオ同期

**主要な処理内容**：
1. ソースファイルの解析（MediaInfo/mkvinfo）
2. オーディオストリーム情報の取得
3. 抽出対象ストリームの選択
4. Demuxer（mkvextract/ffmpeg/MP4Box/eac3to）による分離
5. 抽出ファイルの出力

**関連システム・外部連携**：
- mkvextract: MKV/WebMファイルからのDemux
- ffmpeg: 汎用Demux
- MP4Box: MP4ファイルからのDemux
- eac3to: M2TS/BDからのDemux

**権限による制御**：
本機能に特別な権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 16 | StreamDemuxForm | 主画面 | lvAudioでオーディオストリーム選択 |
| 6 | AudioForm | 主画面 | オーディオストリーム分離設定 |
| 17 | eac3toForm | 主画面 | eac3toを使用したDemux |

## 機能種別

データ抽出処理 / ファイル出力

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| SourcePath | String | Yes | ソースファイルのパス | ファイル存在確認 |
| StreamIndex | Integer | Yes | 抽出対象ストリームのインデックス | 有効なインデックス |
| OutputExt | String | No | 出力ファイルの拡張子 | 有効な拡張子 |

### 入力データソース

- ソースファイル（MKV、MP4、M2TS、AVI等）
- オーディオストリーム情報（MediaInfo解析結果）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 抽出オーディオ | File | 分離されたオーディオファイル（aac, ac3, dts, flac等） |

### 出力先

- 一時ディレクトリ（p.TempDir）
- ファイル名にはストリームID、言語、遅延情報が含まれる

## 処理フロー

### 処理シーケンス

```
1. ソースファイル解析
   └─ MediaInfo.GetAudioStreams()でオーディオ情報取得
2. コンテナ形式の判定
   └─ 拡張子に基づいてDemuxerを選択
3. Demux実行
   └─ mkvDemuxer/ffmpegDemuxer/MP4BoxDemuxer呼び出し
4. 出力ファイル生成
   └─ 抽出したオーディオファイルをp.TempDirに保存
5. カット処理（オプション）
   └─ ビデオのカット範囲に合わせてオーディオもカット
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ソースファイル解析]
    B --> C{コンテナ形式}
    C -->|MKV/WebM| D[mkvDemuxer.Demux]
    C -->|MP4| E[MP4BoxDemuxer.DemuxAudio]
    C -->|その他| F[ffmpegDemuxer.DemuxAudio]
    D --> G[出力ファイル生成]
    E --> G
    F --> G
    G --> H{カット必要?}
    H -->|Yes| I[Audio.Cut]
    H -->|No| J[完了]
    I --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-20-01 | Demuxer選択 | コンテナ形式に応じて最適なDemuxerを選択 | 常時 |
| BR-20-02 | ストリーム命名 | 出力ファイル名にID、言語、遅延を含める | 常時 |
| BR-20-03 | カット同期 | ビデオカット時はオーディオも同様にカット | p.Ranges.Count > 0 |
| BR-20-04 | 遅延情報保持 | ストリームの遅延情報を保持 | 常時 |

### 計算ロジック

- 出力ファイル名: `{Base} ID{Index}_[{Language}] ({EnglishName}) {Delay}ms`

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR-20-01 | ファイルエラー | ソースファイルが存在しない | エラーメッセージ表示 |
| ERR-20-02 | ツールエラー | Demuxerが見つからない | ツールインストールを促す |
| ERR-20-03 | ストリームエラー | 指定ストリームが存在しない | ストリーム選択を促す |

### リトライ仕様

リトライ機能なし。

## トランザクション仕様

ファイル操作のみ。

## パフォーマンス要件

- Demux処理はI/Oバウンドのため、ストレージ速度に依存
- 大容量ファイルでも比較的高速

## セキュリティ考慮事項

- 一時ファイルは作業完了後も保持（後続処理で使用）

## 備考

- DirectShowSourceを使用している場合は専用の変換処理が必要
- M2TSファイルの場合はeac3toの使用を推奨

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Demux.vb | `Source/General/Demux.vb` | AudioStreamクラス、Demuxerクラス |
| 1-2 | Audio.vb | `Source/General/Audio.vb` | AudioProfileクラス |

**読解のコツ**: AudioStreamクラスにはIndex、Language、Delay等の重要なプロパティがある。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Audio.vb | `Source/General/Audio.vb` | Audio.Process()メソッド（8-69行目） |

**主要処理フロー**:
- **8-69行目**: Audio.Process() - オーディオ処理のメインエントリー
- **35-61行目**: コンテナ形式に応じたDemux処理の分岐

#### Step 3: 各Demuxer処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Demux.vb | `Source/General/Demux.vb` | mkvDemuxer.Demux()メソッド |
| 3-2 | Demux.vb | `Source/General/Demux.vb` | ffmpegDemuxer.DemuxAudio()メソッド |
| 3-3 | Demux.vb | `Source/General/Demux.vb` | MP4BoxDemuxer.DemuxAudio()メソッド |

**主要処理フロー**:
- MKV/WebM: mkvextract tracks コマンド実行
- MP4: MP4Box -raw コマンド実行
- その他: ffmpeg -vn -c:a copy コマンド実行

#### Step 4: カット処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Audio.vb | `Source/General/Audio.vb` | Audio.Cut()メソッド（247-272行目） |

**主要処理フロー**:
- **247-272行目**: カットモードに応じた処理（mkvmerge/NicAudio/DirectShow）

### プログラム呼び出し階層図

```
Audio.Process(ap)
    │
    ├─ MediaInfo.GetSummary() [ログ出力]
    │
    ├─ [MKV/WebM] mkvDemuxer.Demux()
    │      └─ mkvextract.exe実行
    │
    ├─ [MP4] MP4BoxDemuxer.DemuxAudio()
    │      └─ MP4Box.exe実行
    │
    ├─ [その他] ffmpegDemuxer.DemuxAudio()
    │      └─ ffmpeg.exe実行
    │
    └─ Audio.Cut() [カット処理]
           ├─ CutMkvmerge()
           ├─ CutNicAudio()
           └─ CutDirectShowSource()
```

### データフロー図

```
[入力]                    [処理]                      [出力]

ソースファイル ───▶ MediaInfo解析 ───▶ オーディオストリーム情報
(MKV/MP4/M2TS)          │
                        ▼
                  Demuxer選択
                        │
                        ▼
           ┌────────────────────┐
           │ mkvextract (MKV)   │
           │ MP4Box (MP4)       │───▶ オーディオファイル
           │ ffmpeg (その他)     │     (.aac/.ac3/.dts等)
           └────────────────────┘
                        │
                        ▼
                  [カット処理] ───▶ カット済みオーディオ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Audio.vb | `Source/General/Audio.vb` | ソース | オーディオ処理のメインクラス |
| Demux.vb | `Source/General/Demux.vb` | ソース | 各種Demuxer実装 |
| StreamDemuxForm.vb | `Source/Forms/StreamDemuxForm.vb` | ソース | Demux選択UI |
| AudioForm.vb | `Source/Forms/AudioForm.vb` | ソース | オーディオ設定UI |
| eac3toForm.vb | `Source/Forms/eac3toForm.vb` | ソース | eac3to設定UI |
| MediaInfo.vb | `Source/General/MediaInfo.vb` | ソース | メディア情報解析 |
| Package.vb | `Source/General/Package.vb` | ソース | 外部ツールパス管理 |
