# 機能設計書 21-オーディオエンコード

## 概要

本ドキュメントは、StaxRipのオーディオエンコード機能について、その処理内容、入出力仕様、および実装詳細を記載した設計書である。

### 本機能の処理概要

オーディオエンコード機能は、ソースファイルから抽出または指定されたオーディオストリームを、ユーザーが選択したコーデック・ビットレート・品質設定に基づいてエンコードする機能である。

**業務上の目的・背景**：動画制作・変換ワークフローにおいて、音声トラックを目的のコーデック（AAC、AC3、Opus等）に変換する必要がある。ソースファイルの音声形式が出力コンテナでサポートされていない場合や、ファイルサイズ削減のためにビットレートを調整する場合に本機能が必要となる。

**機能の利用シーン**：
- Blu-rayソースのDTS-HD MA音声をAAC/AC3に変換してファイルサイズを削減する場合
- 複数言語の音声トラックをそれぞれ異なるビットレートでエンコードする場合
- VBR（可変ビットレート）による高品質エンコードを行う場合
- ハードウェアデコーダー非対応の音声形式を汎用形式に変換する場合

**主要な処理内容**：
1. 入力オーディオファイルの形式判定とデコーダー選択
2. 選択されたエンコーダー（qaac、fdkaac、opusenc、ffmpeg等）に応じたコマンドライン構築
3. 正規化処理（loudnorm/dynaudnorm）の適用（オプション）
4. エンコード処理の実行とログ出力
5. 出力ファイルの生成とビットレート調整

**関連システム・外部連携**：
- 外部エンコーダー: qaac（Apple AAC）、fdkaac（Fraunhofer FDK AAC）、opusenc（Opus）、eac3to、DeeZy
- FFmpeg: デフォルトエンコーダーとして使用
- Apple Application Support: qaac使用時に必要

**権限による制御**：本機能に権限による制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | AudioForm | 主画面 | 各種コーデックへのエンコード設定UI |
| 1 | MainForm | 参照画面 | オーディオプロファイル選択 |

## 機能種別

計算処理 / データ変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Codec | AudioCodec | Yes | 出力コーデック（AAC, AC3, EAC3, FLAC, MP3, Opus, Vorbis, W64, WAV） | Enum値チェック |
| Encoder | GuiAudioEncoder | No | 使用エンコーダー（Automatic, qaac, fdkaac, opusenc, eac3to, ffmpeg, deezy） | Enum値チェック |
| Bitrate | Double | Yes | 出力ビットレート（Kbps） | 0より大きい値 |
| Quality | Single | No | VBR品質値 | コーデックにより範囲が異なる |
| RateMode | AudioRateMode | No | レートモード（CBR, ABR, VBR） | Enum値チェック |
| ChannelsMode | ChannelsMode | No | チャンネル数（Original, 1, 2, 6, 7, 8） | Enum値チェック |
| SamplingRate | Integer | No | サンプリングレート（Hz） | 0または正の整数 |
| Normalize | Boolean | No | 正規化の有効/無効 | - |
| ffmpegNormalizeMode | ffmpegNormalizeMode | No | 正規化モード（volumedetect, loudnorm, dynaudnorm） | Enum値チェック |
| CustomSwitches | String | No | カスタムコマンドラインスイッチ | - |

### 入力データソース

- 画面入力（AudioForm）
- プロジェクト設定（AudioProfile）
- ソースファイルのオーディオストリーム情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| OutputFile | String | エンコードされたオーディオファイルパス |
| ActualBitrate | Double | 実際の出力ビットレート |
| EncodingLog | String | エンコード処理ログ |

### 出力先

- ファイルシステム: 一時ディレクトリ（p.TempDir）にエンコード済みオーディオファイル出力
- ログ: 処理ログへの記録

## 処理フロー

### 処理シーケンス

```
1. エンコーダー決定
   └─ GetEncoder()でコーデックに応じた最適エンコーダーを選択

2. コマンドライン構築
   └─ GetCommandLine()で各エンコーダー固有のコマンドライン生成

3. 正規化処理（オプション）
   └─ NormalizeFF()でffmpegによる音量正規化を実行

4. エンコード実行
   └─ Proc経由で外部エンコーダーを起動

5. 出力検証
   └─ 出力ファイル存在確認とビットレート調整
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{ファイル存在?}
    B -->|No| Z[終了]
    B -->|Yes| C[エンコーダー決定]
    C --> D{正規化有効?}
    D -->|Yes| E[NormalizeFF実行]
    D -->|No| F[コマンドライン構築]
    E --> F
    F --> G{パイプモード?}
    G -->|Yes| H[ffmpeg + エンコーダー パイプ]
    G -->|No| I[エンコーダー直接実行]
    H --> J[Proc.Start]
    I --> J
    J --> K{出力ファイル存在?}
    K -->|Yes| L[ビットレート調整]
    K -->|No| M[エラー処理]
    L --> N[ログ出力]
    M --> N
    N --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-21-01 | エンコーダー自動選択 | Automaticの場合、AAC=qaac、Opus=opusencを選択 | Encoder=Automatic |
| BR-21-02 | VBRビットレート推定 | VBRモード時は品質値からビットレートを推定 | RateMode=VBR |
| BR-21-03 | 入力形式変換 | エンコーダーが入力形式をサポートしない場合、WAV/FLACに変換 | IsInputSupported=False |
| BR-21-04 | ディレイ処理 | 一部エンコーダーはディレイ値をコマンドラインで処理 | HandlesDelay=True |

### 計算ロジック

**VBRビットレート推定（AAC/qaac）**:
```
Bitrate = GetYFromTwoPointForm(0, 50/8*Channels, 127, 1000/8*Channels, Quality)
```

**VBRビットレート推定（MP3）**:
```
Bitrate = GetYFromTwoPointForm(9, 65, 0, 245, Quality)
```

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-21-01 | ファイル未検出 | 出力ファイルが生成されない | ErrorAbortExceptionをスロー |
| E-21-02 | エンコーダー未検出 | 外部ツールが存在しない | Package.VerifyOK()で事前検証 |
| E-21-03 | 入力形式未対応 | 入力形式がエンコーダー非対応 | Convert()でWAV/FLAC変換 |

### リトライ仕様

リトライ処理なし。エラー発生時はジョブを中断。

## トランザクション仕様

トランザクション制御なし（ファイル処理のため）。

## パフォーマンス要件

- 処理時間: 入力ファイル再生時間と同程度またはそれ以下
- メモリ使用: パイプモード使用時はストリーミング処理により低メモリ

## セキュリティ考慮事項

- 外部プロセス実行: 信頼されたパッケージ（Package）経由でのみ実行
- ファイルパス: エスケープ処理によるインジェクション防止

## 備考

対応エンコーダー一覧:
- qaac: Apple AAC（TVBR/CVBR/ABR/CBR）
- fdkaac: Fraunhofer FDK AAC
- opusenc: Opus
- eac3to: AAC/AC3/DTS/FLAC
- ffmpeg: 汎用（MP3/AC3/EAC3/Vorbis/Opus/AAC/FLAC/WAV）
- DeeZy: Dolby Digital/Dolby Digital Plus/Atmos

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、オーディオプロファイルのデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AudioProfile.vb | `Source/General/AudioProfile.vb` | AudioProfile基底クラスの構造、GUIAudioProfileの設計 |
| 1-2 | AudioProfile.vb | `Source/General/AudioProfile.vb` | Parameters内部クラス（1778-1934行目）のエンコード設定パラメータ |

**読解のコツ**: AudioCodec、GuiAudioEncoder、ChannelsModeなどのEnum定義（1937-2096行目）を先に確認すると、コード全体の理解が容易になる。

#### Step 2: エントリーポイントを理解する

処理の起点となるEncode()メソッドを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AudioProfile.vb | `Source/General/AudioProfile.vb` | GUIAudioProfile.Encode()メソッド（900-961行目）がエンコードのエントリーポイント |

**主要処理フロー**:
1. **903行目**: GetOutputFile()で出力パスを決定
2. **904行目**: GetCommandLine(True)でコマンドライン構築
3. **906-942行目**: Procオブジェクトでエンコーダー起動
4. **944-956行目**: 出力ファイル確認とビットレート調整

#### Step 3: コマンドライン生成を理解する

各エンコーダー固有のコマンドライン生成ロジックを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AudioProfile.vb | `Source/General/AudioProfile.vb` | GetCommandLine()（1083-1098行目）でエンコーダー分岐 |
| 3-2 | AudioProfile.vb | `Source/General/AudioProfile.vb` | GetQaacCommandLine()（1355-1428行目）qaac用コマンドライン |
| 3-3 | AudioProfile.vb | `Source/General/AudioProfile.vb` | GetffmpegCommandLine()（1467-1668行目）ffmpeg用コマンドライン |
| 3-4 | AudioProfile.vb | `Source/General/AudioProfile.vb` | GetOpusencCommandLine()（1280-1352行目）opusenc用コマンドライン |

**読解のコツ**: 各Get*CommandLine()メソッドは、includePaths引数でファイルパスを含めるかを制御している。UIプレビュー時はFalse、実行時はTrueとなる。

#### Step 4: 正規化処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | AudioProfile.vb | `Source/General/AudioProfile.vb` | NormalizeFF()（963-1011行目）音量正規化処理 |
| 4-2 | Audio.vb | `Source/General/Audio.vb` | GetLoudNormArgs()（448-458行目）loudnormパラメータ生成 |
| 4-3 | Audio.vb | `Source/General/Audio.vb` | GetDynAudNormArgs()（460-474行目）dynaudnormパラメータ生成 |

### プログラム呼び出し階層図

```
GUIAudioProfile.Encode()
    │
    ├─ GetOutputFile()
    │      └─ GetTrackID()
    │
    ├─ GetCommandLine(True)
    │      ├─ GetEncoder()
    │      │      └─ コーデックに基づくエンコーダー選択
    │      │
    │      ├─ GetQaacCommandLine()
    │      │      └─ GetPipeCommandLine() [パイプモード時]
    │      │
    │      ├─ GetffmpegCommandLine()
    │      │      ├─ Audio.GetLoudNormArgs()
    │      │      └─ Audio.GetDynAudNormArgs()
    │      │
    │      ├─ GetOpusencCommandLine()
    │      ├─ GetfdkaacCommandLine()
    │      ├─ GetEac3toCommandLine()
    │      └─ GetDeezyCommandLine()
    │
    └─ Proc.Start()
           └─ 外部エンコーダープロセス実行
```

### データフロー図

```
[入力]                    [処理]                              [出力]

オーディオファイル  ───▶  デコード（ffmpeg/eac3to等） ───▶  PCMデータ
      │                                                         │
      │                                                         ▼
AudioProfile設定   ───▶  コマンドライン構築          ───▶  エンコーダー起動
      │                                                         │
      │                                                         ▼
      │                  正規化処理（オプション）      ───▶  正規化済みPCM
      │                                                         │
      │                                                         ▼
      └──────────────────────────────────────────────────▶  エンコード済み
                                                              オーディオファイル
                                                              (.m4a/.ac3/.opus等)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AudioProfile.vb | `Source/General/AudioProfile.vb` | ソース | オーディオプロファイル・エンコードロジック |
| Audio.vb | `Source/General/Audio.vb` | ソース | オーディオ処理ユーティリティ |
| AudioForm.vb | `Source/Forms/AudioForm.vb` | ソース | オーディオ設定UI |
| Proc.vb | `Source/General/Proc.vb` | ソース | 外部プロセス実行 |
| Package.vb | `Source/General/Package.vb` | ソース | 外部ツールパッケージ管理 |
