# 機能設計書 24-チャンネルダウンミックス

## 概要

本ドキュメントは、StaxRipのチャンネルダウンミックス機能について、その処理内容、入出力仕様、および実装詳細を記載した設計書である。

### 本機能の処理概要

チャンネルダウンミックス機能は、マルチチャンネル（5.1ch、7.1ch等）のオーディオをステレオ（2ch）やモノラル（1ch）にダウンミックスする機能である。センター最適化ステレオオプションにより、ダイアログ（セリフ）を強調したダウンミックスも可能。

**業務上の目的・背景**：サラウンド音声のソースを、ステレオ再生環境向けに変換する場合や、ファイルサイズ削減のためにチャンネル数を減らす場合に本機能が必要となる。特に映画コンテンツではセンターチャンネルにダイアログが収録されているため、適切なダウンミックスが視聴体験に影響する。

**機能の利用シーン**：
- 5.1ch/7.1chサラウンド音声をステレオに変換する場合
- モバイルデバイス向けにチャンネル数を削減する場合
- ダイアログ（セリフ）を聞き取りやすくする場合
- 夜間視聴向けにダイナミックレンジを抑えた2chミックスを作成する場合

**主要な処理内容**：
1. 入力オーディオのチャンネル構成を判定
2. 指定チャンネル数へのダウンミックス（ffmpegフィルタ使用）
3. センター最適化オプション適用（オプション）
4. 出力ファイルの生成

**関連システム・外部連携**：
- FFmpeg: ダウンミックス処理エンジン（-ac、pan、amergeフィルタ）
- eac3to: 代替ダウンミックス処理

**権限による制御**：本機能に権限による制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | AudioForm | 主画面 | チャンネル数選択、センター最適化設定 |

## 機能種別

計算処理 / 信号処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ChannelsMode | ChannelsMode | Yes | 出力チャンネル数 | Enum値チェック |
| ChannelsOrig | Integer | No | 入力チャンネル数 | 正の整数 |
| CenterOptimizedStereo | Boolean | No | センター最適化有効/無効 | - |
| eac3toExtractDtsCore | Boolean | No | DTS Core抽出モード | - |

### ChannelsMode Enum

| 値 | 説明 |
|-----|------|
| Original | 入力と同じチャンネル数を維持 |
| _1 | モノラル（1ch） |
| _2 | ステレオ（2ch） |
| _6 | 5.1ch（6ch） |
| _7 | 6.1ch（7ch） |
| _8 | 7.1ch（8ch） |

### 入力データソース

- 画面入力（AudioForm）
- GUIAudioProfile.Parameters

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| OutputChannels | Integer | 出力チャンネル数 |
| DownmixedAudio | String | ダウンミックス済みオーディオファイル |

### 出力先

- エンコード済みオーディオファイル内

## 処理フロー

### 処理シーケンス

```
1. チャンネルモード判定
   └─ ChannelsModeから出力チャンネル数を決定

2. ダウンミックス必要性判定
   └─ 入力ch > 出力chの場合のみ処理

3. ダウンミックスフィルタ適用
   └─ ffmpeg -ac または panフィルタ使用

4. センター最適化適用（オプション）
   └─ センターチャンネル強調フィルタ追加

5. エンコード処理と統合
   └─ 通常のオーディオエンコードフローに組み込み
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{ChannelsMode?}
    B -->|Original| Z[ダウンミックスなし]
    B -->|他| C{入力ch > 出力ch?}
    C -->|No| Z
    C -->|Yes| D{CenterOptimizedStereo?}
    D -->|Yes| E[panフィルタ適用]
    D -->|No| F[-acオプション適用]
    E --> G[エンコード]
    F --> G
    G --> Z[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-24-01 | Original維持 | ChannelsMode=Originalの場合はダウンミックスしない | ChannelsMode=Original |
| BR-24-02 | アップミックス禁止 | 入力ch < 出力chの場合はダウンミックスしない | 入力ch < 出力ch |
| BR-24-03 | センター最適化 | CenterOptimizedStereo有効時はpanフィルタで中央強調 | CenterOptimizedStereo=True |
| BR-24-04 | DTS Core優先 | eac3toでDTS Core抽出時はオリジナルch維持 | eac3toExtractDtsCore=True |

### 計算ロジック

**センター最適化ステレオのpanフィルタ**:
```
-af pan=stereo|FL=0.5*FC+0.707*FL+0.707*BL+0.5*LFE|FR=0.5*FC+0.707*FR+0.707*BR+0.5*LFE
```

**標準ダウンミックス（ffmpeg -ac）**:
```
-ac 2  (ステレオへ)
-ac 1  (モノラルへ)
```

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-24-01 | チャンネル数不明 | 入力オーディオのチャンネル数が取得できない | MediaInfo使用で再取得 |

### リトライ仕様

リトライ処理なし。

## トランザクション仕様

トランザクション制御なし。

## パフォーマンス要件

- 処理時間: ダウンミックスはエンコード処理と統合されるため追加オーバーヘッドは軽微

## セキュリティ考慮事項

外部プロセス（ffmpeg）の実行はPackage経由で制御。

## 備考

ダウンミックス係数について:
- センターチャンネル（FC）: ダイアログが主に収録される
- LFE（低周波効果）: サブウーファー用。ダウンミックス時は減衰または除外
- サラウンドチャンネル（BL/BR）: 環境音、効果音

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AudioProfile.vb | `Source/General/AudioProfile.vb` | ChannelsMode Enum（2020-2027行目） |
| 1-2 | AudioProfile.vb | `Source/General/AudioProfile.vb` | Parameters.Channels プロパティ（1813行目） |
| 1-3 | AudioProfile.vb | `Source/General/AudioProfile.vb` | Parameters.CenterOptimizedStereo（1886行目） |

**読解のコツ**: ChannelsModeの_1, _2などはIntegerにキャストするとチャンネル数になる。Originalは特別扱い。

#### Step 2: ダウンミックス処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AudioProfile.vb | `Source/General/AudioProfile.vb` | GetffmpegCommandLine()内の-ac処理 |
| 2-2 | AudioProfile.vb | `Source/General/AudioProfile.vb` | CenterOptimizedStereo適用部分 |

**主要処理フロー**:
1. ChannelsModeチェック
2. 入力チャンネル数との比較
3. ffmpegコマンドラインに-acまたはpanフィルタ追加

#### Step 3: UIとの連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AudioForm.vb | `Source/Forms/AudioForm.vb` | mbChannels（チャンネル数選択メニュー） |
| 3-2 | AudioForm.vb | `Source/Forms/AudioForm.vb` | cbCenterOptimizedStereo（センター最適化チェックボックス） |

### プログラム呼び出し階層図

```
GUIAudioProfile.GetCommandLine()
    │
    ├─ GetffmpegCommandLine()
    │      │
    │      ├─ ChannelsMode判定
    │      │      └─ Original: 何もしない
    │      │      └─ 他: チャンネル数取得
    │      │
    │      ├─ CenterOptimizedStereo判定
    │      │      └─ True: panフィルタ追加
    │      │      └─ False: -acオプション追加
    │      │
    │      └─ コマンドライン返却
    │
    └─ GetPipeCommandLine()
           └─ 同様のチャンネル処理
```

### データフロー図

```
[入力]                    [処理]                         [出力]

マルチチャンネル   ───▶   チャンネル数判定    ───▶   ダウンミックス要否
オーディオ                                            判定
(5.1ch/7.1ch)                                           │
      │                                                  ▼
      │                  CenterOptimized?    ───▶   panフィルタ
      │                  (センター最適化)              または
      │                                               -acオプション
      │                                                  │
      │                                                  ▼
      └──────────────────────────────────────────▶   ffmpegエンコード
                                                          │
                                                          ▼
                                                     ステレオ/モノラル
                                                     オーディオ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AudioProfile.vb | `Source/General/AudioProfile.vb` | ソース | ChannelsMode、ダウンミックス処理 |
| AudioForm.vb | `Source/Forms/AudioForm.vb` | ソース | チャンネル数選択UI |
