# 機能設計書 26-字幕追加

## 概要

本ドキュメントは、StaxRipの字幕追加機能について、その処理内容、入出力仕様、および実装詳細を記載した設計書である。

### 本機能の処理概要

字幕追加機能は、エンコード済みビデオと字幕ファイルをMuxerで合成し、出力コンテナ（MKV、MP4等）に字幕トラックを追加する機能である。言語設定、既定トラック、強制字幕などのメタデータも設定可能。

**業務上の目的・背景**：動画変換において、外部字幕ファイル（SRT、ASS等）や抽出した字幕を出力ファイルに埋め込む。複数言語の字幕を追加して、視聴者が切り替えられるようにするケースが多い。

**機能の利用シーン**：
- 外部SRT字幕ファイルをMKVに埋め込む場合
- 複数言語の字幕を追加する場合
- 強制字幕（Forced）を設定する場合
- 字幕トラックの既定設定を行う場合

**主要な処理内容**：
1. Subtitleオブジェクトリストの管理
2. 字幕トラックのメタデータ設定（言語、タイトル、フラグ）
3. Muxerによるコンテナへの字幕合成
4. mkvmerge/mp4boxのコマンドライン生成

**関連システム・外部連携**：
- mkvmerge: MKVへの字幕Mux
- mp4box: MP4への字幕Mux（限定的サポート）

**権限による制御**：本機能に権限による制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | MuxerForm | 主画面 | 字幕トラック設定、メタデータ編集 |

## 機能種別

データ変換 / ファイル合成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Subtitles | List(Of Subtitle) | Yes | 追加する字幕リスト | 各SubtitleのPath存在 |
| Subtitle.Language | Language | Yes | 字幕言語 | 有効な言語コード |
| Subtitle.Title | String | No | 字幕トラック名 | - |
| Subtitle.Default | Boolean | No | 既定トラックフラグ | - |
| Subtitle.Forced | Boolean | No | 強制字幕フラグ | - |
| Subtitle.Enabled | Boolean | No | Mux有効/無効 | - |

### 入力データソース

- MuxerForm UI
- Subtitle.Create()で生成されたオブジェクト
- Muxer.Init()で自動検出された字幕

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| MuxedContainer | String | 字幕を含むコンテナファイル |

### 出力先

- 出力ファイル（p.TargetFile）

## 処理フロー

### 処理シーケンス

```
1. 字幕リスト確認
   └─ Muxer.Subtitles の Enabled=True のみ処理

2. メタデータ展開
   └─ ExpandMacros()でタイトル内のマクロ展開

3. コマンドライン生成
   └─ Muxer種別に応じたコマンドライン構築

4. Mux実行
   └─ mkvmerge/mp4boxで字幕を含めてMux
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{Subtitles存在?}
    B -->|No| Z[字幕なしでMux]
    B -->|Yes| C[Enabled字幕をフィルタ]
    C --> D{Enabled字幕あり?}
    D -->|No| Z
    D -->|Yes| E[ExpandMacros実行]
    E --> F{Muxer種別?}
    F -->|MkvMuxer| G[mkvmergeコマンド生成]
    F -->|MP4Muxer| H[mp4boxコマンド生成]
    G --> I[字幕オプション追加]
    H --> I
    I --> J[Mux実行]
    J --> Z[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-26-01 | Enabled判定 | Enabled=Falseの字幕はMuxしない | 常時 |
| BR-26-02 | 既定排他 | 複数字幕のDefaultは最初の1つのみ有効 | 複数Default時 |
| BR-26-03 | MP4制限 | MP4はSRT/VobSubのみ対応 | MP4Muxer時 |
| BR-26-04 | マクロ展開 | Titleに%language_native%等のマクロ使用可能 | Title設定時 |

### 対応字幕形式（Muxer別）

| Muxer | 対応形式 |
|-------|---------|
| MkvMuxer | SRT, ASS, SSA, VobSub, PGS, DVB等（全形式） |
| MP4Muxer | SRT, VobSub（idx/sub） |
| WebMMuxer | 制限あり（WebVTT等） |

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-26-01 | ファイル未検出 | 字幕ファイルが存在しない | 警告してスキップ |
| E-26-02 | 形式未対応 | MP4にPGS字幕を追加しようとした | 警告してスキップ |

### リトライ仕様

リトライ処理なし。

## トランザクション仕様

トランザクション制御なし。

## パフォーマンス要件

- 字幕Muxは高速（コピー処理）

## セキュリティ考慮事項

外部プロセス（mkvmerge、mp4box）の実行はPackage経由で制御。

## 備考

字幕タイトルのマクロ:
- `%language_native%`: 言語のネイティブ名（日本語→日本語）
- `%language_english%`: 言語の英語名（Japanese）
- その他のStaxRipマクロも使用可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Muxer.vb | `Source/General/Muxer.vb` | Muxer.Subtitles プロパティ（84-97行目） |
| 1-2 | Misc.vb | `Source/General/Misc.vb` | Subtitle クラス（1482-1518行目）- プロパティ |

**読解のコツ**: Subtitleオブジェクトは字幕のメタデータ（Language、Title、Default、Forced等）を保持。

#### Step 2: マクロ展開を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Muxer.vb | `Source/General/Muxer.vb` | ExpandMacros()（131-147行目） |

**主要処理**:
- `%language_native%` → Language.CultureInfo.NativeName
- `%language_english%` → Language.EnglishName
- その他マクロ → Macro.Expand()

#### Step 3: MkvMuxerの字幕処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Muxer.vb | `Source/General/Muxer.vb` | MkvMuxer.GetArgs()内の字幕処理（789-819行目） |

**主要処理**:
1. 字幕ループ
2. --language オプション
3. --default-track-flag オプション
4. --forced-display-flag オプション
5. --track-name オプション

#### Step 4: MP4Muxerの字幕処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Muxer.vb | `Source/General/Muxer.vb` | MP4Muxer.GetArgs()内の字幕処理（380-392行目） |

**主要処理**:
- idx字幕: `#index` でストリーム指定
- srt字幕: `:lang=` で言語指定

### プログラム呼び出し階層図

```
Muxer.Mux()
    │
    ├─ ExpandMacros()
    │      └─ 各Subtitle.Titleのマクロ展開
    │
    ├─ GetArgs() / GetCommandLine()
    │      │
    │      ├─ MkvMuxer.GetArgs()
    │      │      ├─ For Each subtitle In Subtitles
    │      │      │      ├─ --language {id}:{lang}
    │      │      │      ├─ --default-track-flag {id}:{0|1}
    │      │      │      ├─ --forced-display-flag {id}:{0|1}
    │      │      │      ├─ --track-name "{id}:{title}"
    │      │      │      └─ {subtitlePath}
    │      │      └─ 完全なコマンドライン
    │      │
    │      └─ MP4Muxer.GetArgs()
    │             ├─ For Each st In Subtitles
    │             │      └─ -add "{path}#index:lang=...:name=..."
    │             └─ 完全なコマンドライン
    │
    └─ Proc.Start()
           └─ mkvmerge / mp4box 実行
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Subtitle[]         ───▶   Enabled判定          ───▶   有効字幕リスト
(Muxer.Subtitles)                                        │
      │                                                   ▼
      │                  ExpandMacros()         ───▶   マクロ展開済み
      │                  %language_native%等           Titleプロパティ
      │                                                   │
      │                                                   ▼
      │                  GetArgs()              ───▶   コマンドライン
      │                  MkvMuxer/MP4Muxer             生成
      │                                                   │
      │                                                   ▼
ビデオファイル     ───▶   Mux実行               ───▶   字幕付き
オーディオファイル        mkvmerge/mp4box             コンテナ
                                                      (MKV/MP4)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Muxer.vb | `Source/General/Muxer.vb` | ソース | Muxer基底クラス、MkvMuxer、MP4Muxer |
| Misc.vb | `Source/General/Misc.vb` | ソース | Subtitle クラス |
| MuxerForm.vb | `Source/Forms/MuxerForm.vb` | ソース | 字幕設定UI |
| Macro.vb | `Source/General/Macro.vb` | ソース | マクロ展開 |
