# 機能設計書 27-ハードコード字幕

## 概要

本ドキュメントは、StaxRipのハードコード字幕機能について、その処理内容、入出力仕様、および実装詳細を記載した設計書である。

### 本機能の処理概要

ハードコード字幕機能は、字幕をビデオフレームに直接焼き付ける（ハードサブ/バーンイン）機能である。AviSynth/VapourSynthのTextSub/VobSubフィルタを使用して、字幕をビデオストリームの一部として描画する。

**業務上の目的・背景**：一部の再生環境では字幕トラックをサポートしていないため、字幕をビデオに焼き付ける必要がある。また、強制字幕（外国語シーンのみの翻訳など）を常に表示させたい場合にも使用される。

**機能の利用シーン**：
- 字幕トラック非対応の再生環境向けエンコード
- 強制字幕を確実に表示させたい場合
- 字幕のフォント・スタイルを固定したい場合
- SNSや動画共有サイト向けの出力

**主要な処理内容**：
1. 字幕ファイルの形式判定（SRT/ASS/VobSub等）
2. AviSynth/VapourSynthスクリプトへのTextSub/VobSubフィルタ追加
3. ビデオエンコード時にフィルタ適用
4. 字幕がビデオに焼き付けられた出力生成

**関連システム・外部連携**：
- AviSynth: TextSub/VobSubフィルタ
- VapourSynth: VSFilterフィルタ
- VSFilter/xy-VSFilter: 字幕レンダリングエンジン

**権限による制御**：本機能に権限による制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | フィルタ設定（Subtitle欄） |
| 15 | PreviewForm | 参照画面 | 字幕焼き付けのプレビュー |

## 機能種別

映像処理 / フィルタ適用

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| SubtitleFile | String | Yes | 字幕ファイルパス | ファイル存在、対応形式 |
| SubtitleType | String | No | 字幕形式（srt/ass/vobsub等） | 拡張子から自動判定可 |

### 対応字幕形式

| 形式 | AviSynthフィルタ | VapourSynthフィルタ |
|-----|-----------------|-------------------|
| SRT | TextSub | core.sub.TextFile |
| ASS/SSA | TextSub | core.sub.TextFile |
| VobSub (idx+sub) | VobSub | core.sub.Subtitle |
| PGS (sup) | sup2srt変換後TextSub | - |

### 入力データソース

- 字幕ファイル（SRT、ASS、IDX等）
- スクリプトエディタでの手動追加

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ModifiedScript | String | 字幕フィルタが追加されたスクリプト |
| HardcodedVideo | String | 字幕焼き付け済みビデオファイル |

### 出力先

- AviSynth/VapourSynthスクリプトファイル
- エンコード済みビデオファイル

## 処理フロー

### 処理シーケンス

```
1. 字幕ファイル準備
   └─ パス取得、形式判定

2. スクリプトへのフィルタ追加
   └─ TextSub/VobSubフィルタ行をスクリプトに挿入

3. スクリプト保存
   └─ 変更されたスクリプトを保存

4. ビデオエンコード
   └─ フィルタ適用済みスクリプトでエンコード

5. 出力確認
   └─ 字幕が焼き付けられたビデオを確認
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{字幕ファイル存在?}
    B -->|No| Z[エラー終了]
    B -->|Yes| C[形式判定]
    C --> D{形式?}
    D -->|SRT/ASS| E[TextSubフィルタ追加]
    D -->|VobSub| F[VobSubフィルタ追加]
    D -->|PGS| G[sup2srt変換]
    E --> H[スクリプト保存]
    F --> H
    G --> E
    H --> I[エンコード実行]
    I --> J[字幕焼き付け済みビデオ]
    J --> Z[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-27-01 | 形式自動判定 | 拡張子から字幕形式を自動判定 | 常時 |
| BR-27-02 | パス変換 | AviSynthではバックスラッシュをエスケープ | AviSynth使用時 |
| BR-27-03 | PGS変換 | PGS(sup)はOCR変換後にTextSub適用 | ConvertSup2Sub=True時 |
| BR-27-04 | フィルタ位置 | 字幕フィルタはリサイズ後に適用 | 常時 |

### AviSynthフィルタ構文

**TextSub（SRT/ASS用）**:
```
TextSub("C:\\path\\to\\subtitle.srt")
TextSub("C:\\path\\to\\subtitle.ass")
```

**VobSub（IDX+SUB用）**:
```
VobSub("C:\\path\\to\\subtitle.idx")
```

### VapourSynthフィルタ構文

**TextFile（SRT/ASS用）**:
```python
clip = core.sub.TextFile(clip, file=r"C:\path\to\subtitle.srt")
clip = core.sub.TextFile(clip, file=r"C:\path\to\subtitle.ass")
```

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-27-01 | ファイル未検出 | 字幕ファイルが存在しない | エラーメッセージ表示 |
| E-27-02 | 形式未対応 | 未対応の字幕形式 | 対応形式への変換を促す |
| E-27-03 | フィルタエラー | TextSub/VobSubフィルタのエラー | スクリプトエラーとして表示 |

### リトライ仕様

リトライ処理なし。

## トランザクション仕様

トランザクション制御なし。

## パフォーマンス要件

- 字幕フィルタはフレームごとに適用されるため、エンコード時間が増加
- 特にASSスタイル付き字幕は描画負荷が高い

## セキュリティ考慮事項

字幕ファイルのパスはエスケープ処理を実施。

## 備考

ハードコード字幕 vs ソフトサブ:
- **ハードコード**: 常に表示、オン/オフ不可、ファイルサイズ増加なし
- **ソフトサブ**: オン/オフ可能、複数言語対応、再生環境依存

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: フィルタ定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | VideoFilter.vb | `Source/General/VideoFilter.vb` | フィルタクラスの基本構造 |
| 1-2 | FilterParameter.vb | `Source/General/FilterParameter.vb` | フィルタパラメータ定義 |

**読解のコツ**: VideoFilterクラスはスクリプト出力用のScriptプロパティを持つ。

#### Step 2: 字幕フィルタ適用を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Project.vb | `Source/General/Project.vb` | p.ConvertSup2Sub プロパティ |
| 2-2 | GlobalClass.vb | `Source/General/GlobalClass.vb` | 字幕関連のユーティリティメソッド |

#### Step 3: スクリプト生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Script.vb | `Source/General/Script.vb` | スクリプト生成とフィルタ追加 |

### プログラム呼び出し階層図

```
MainForm（フィルタ設定）
    │
    ├─ フィルタ追加
    │      └─ VideoFilter作成
    │             ├─ FilterCategory.Subtitle
    │             └─ TextSub/VobSubパラメータ設定
    │
    └─ Script生成
           │
           ├─ AviSynth
           │      ├─ TextSub("{path}")
           │      └─ VobSub("{path}")
           │
           └─ VapourSynth
                  └─ core.sub.TextFile(clip, file=r"{path}")

エンコード時
    │
    └─ エンコーダー
           └─ スクリプト読込
                  └─ 字幕フィルタ適用
                         └─ 焼き付け済みフレーム出力
```

### データフロー図

```
[入力]                    [処理]                         [出力]

字幕ファイル       ───▶   形式判定              ───▶   フィルタ種別決定
(.srt/.ass/.idx)                                        │
      │                                                  ▼
      │                  フィルタパラメータ生成   ───▶   VideoFilterオブジェクト
      │                                                  │
      │                                                  ▼
      │                  スクリプト生成          ───▶   AviSynth/VS
      │                  TextSub/VobSub追加            スクリプト
      │                                                  │
      │                                                  ▼
ソースビデオ       ───▶   エンコード             ───▶   字幕焼き付け済み
                          フィルタ適用                  ビデオ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| VideoFilter.vb | `Source/General/VideoFilter.vb` | ソース | フィルタ定義 |
| FilterParameter.vb | `Source/General/FilterParameter.vb` | ソース | パラメータ定義 |
| Script.vb | `Source/General/Script.vb` | ソース | スクリプト生成 |
| Project.vb | `Source/General/Project.vb` | ソース | ConvertSup2Subプロパティ |
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | ユーティリティ |
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | フィルタ設定UI |
