# 機能設計書 29-MP4 Mux

## 概要

本ドキュメントは、StaxRipのMP4 Mux機能について、その処理内容、入出力仕様、および実装詳細を記載した設計書である。

### 本機能の処理概要

MP4 Mux機能は、エンコード済みビデオ、オーディオ、字幕をMP4（MPEG-4 Part 14）コンテナにマルチプレクスする機能である。MP4Boxツールを使用して、広い互換性を持つMP4ファイルを生成する。

**業務上の目的・背景**：MP4は最も広く互換性のあるコンテナ形式であり、ほぼすべてのデバイス・プラットフォームで再生可能。Apple製品、モバイルデバイス、ストリーミングサービス向けの配布形式として標準的に使用される。

**機能の利用シーン**：
- iPhone/iPad向けの動画エンコード
- YouTubeなど動画共有サービスへのアップロード
- 汎用的な動画配布
- ストリーミング配信用のMP4作成

**主要な処理内容**：
1. ビデオ、オーディオ、字幕ファイルの収集
2. MP4Boxコマンドライン構築
3. メタデータ（言語、トラック名、PAR等）設定
4. チャプター、iTunesタグの追加
5. Mux実行とログ出力

**関連システム・外部連携**：
- MP4Box: GPACプロジェクトのMP4ツール

**権限による制御**：本機能に権限による制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | MuxerForm | 主画面 | MP4 Mux設定、トラック編集 |
| 1 | MainForm | 参照画面 | Muxer選択 |

## 機能種別

ファイル合成 / データ変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| VideoFile | String | Yes | ビデオファイルパス | ファイル存在 |
| AudioTracks | List(Of AudioProfile) | No | オーディオトラックリスト | - |
| Subtitles | List(Of Subtitle) | No | 字幕リスト（SRT/VobSubのみ） | - |
| ChapterFile | String | No | チャプターファイル（txt） | ファイル存在 |
| CoverFile | String | No | カバーアート | ファイル存在 |
| PAR | String | No | ピクセルアスペクト比 | - |
| VideoTrackName | String | No | ビデオトラック名 | - |

### 対応入力形式

```
Video/Audio: ts, m2ts, ivf, obu, mpg, m2v, flac, avi, opus,
             ac3, ec3, eac3, thd, mp4, m4a, aac, mov,
             264, h264, avc, 265, h265, hevc, hvc,
             266, h266, vvc, mp2, mpa, mp3

Subtitle: idx (VobSub), srt, sub
```

### 入力データソース

- エンコード済みファイル（p.VideoEncoder.OutputPath）
- オーディオファイル（p.AudioTracks、p.AudioFiles）
- 字幕ファイル（Muxer.Subtitles）
- プロジェクト設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| TargetFile | String | 出力MP4ファイルパス |

### 出力先

- 指定された出力ファイル（p.TargetFile）

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ Muxer.Init()でチャプター、字幕を自動検出

2. コマンドライン構築
   └─ GetArgs()でMP4Boxコマンドライン生成

3. Mux実行
   └─ Proc経由でMP4Box起動

4. 結果確認
   └─ 出力ファイル存在確認、MediaInfo出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[Muxer.Init]
    B --> C[GetArgs構築]
    C --> D[フレームレート設定]
    D --> E[ビデオ追加 -add]
    E --> F{チャンク複数?}
    F -->|Yes| G[チャンク結合 -cat]
    F -->|No| H[オーディオ追加]
    G --> H
    H --> I[字幕追加]
    I --> J[チャプター追加 -chap]
    J --> K[iTunesタグ追加 -itags]
    K --> L[MP4Box実行]
    L --> M{出力存在?}
    M -->|Yes| N[MediaInfo出力]
    M -->|No| O[エラー]
    N --> Z[終了]
    O --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-29-01 | 字幕制限 | MP4はSRT/VobSubのみサポート | 字幕追加時 |
| BR-29-02 | PAR自動 | PARが"auto"または"0"の場合は自動計算 | PAR設定時 |
| BR-29-03 | チャンク結合 | 複数チャンク時は-catで結合 | GetChunks() > 1 |
| BR-29-04 | SBRフラグ | ファイル名にSBRを含む場合は:sbrを追加 | AAC時 |
| BR-29-05 | フレームレート | ソースにフレームレートがない場合は-fpsで指定 | フレームレート0時 |

### MP4Boxコマンドライン構造

```
MP4Box
  [-fps {framerate}]
  -add "{video}#video[:par=x:y][:name=...]"
  [-cat "{chunk2}" -cat "{chunk3}" ...]

  -add "{audio}[#trackID=id][:sbr][:lang=xxx][:delay=ms][:name=...][:tkhd=3:group=1]"

  -add "{subtitle}#index[:lang=xxx][:name=...][:tkhd=0|3:group=2][:txtflags=...]"

  [-chap {chapterfile}]
  [{additional}]
  [-itags cover={cover}:tag1=value1:...]
  -new {output}
```

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-29-01 | 出力失敗 | MP4出力ファイルが生成されない | ErrorAbortExceptionスロー |
| E-29-02 | 形式未対応 | 未対応字幕形式の追加 | スキップ |

### リトライ仕様

リトライ処理なし。

## トランザクション仕様

トランザクション制御なし。

## パフォーマンス要件

- Mux処理は高速（ストリームコピー）
- 処理時間は入力ファイルサイズに依存

## セキュリティ考慮事項

外部プロセス（MP4Box）の実行はPackage経由で制御。

## 備考

MP4固有の制限:
- 字幕はSRT/VobSubのみ（PGS、ASS等は非対応）
- DTS音声は通常非対応
- 添付ファイル機能なし

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: クラス構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Muxer.vb | `Source/General/Muxer.vb` | MP4Muxer クラス（294-493行目） |

**読解のコツ**: MP4MuxerはMuxer基底クラスを継承。OutputExt="mp4"を返す。

#### Step 2: コマンドライン生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Muxer.vb | `Source/General/Muxer.vb` | MP4Muxer.GetArgs()（323-418行目） |
| 2-2 | Muxer.vb | `Source/General/Muxer.vb` | AddAudio()（421-451行目） |

**主要処理フロー**:
1. フレームレート設定（326-328行目）
2. PAR設定（332-350行目）
3. ビデオ追加（355-364行目）
4. チャンク結合（360-363行目）
5. オーディオ追加（368-374行目）
6. 字幕追加（380-392行目）
7. チャプター追加（394-396行目）
8. iTunesタグ追加（402-414行目）

#### Step 3: Mux実行を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Muxer.vb | `Source/General/Muxer.vb` | MP4Muxer.Mux()（458-473行目） |

### プログラム呼び出し階層図

```
MP4Muxer.Mux()
    │
    ├─ GetArgs()
    │      ├─ -fps {framerate}
    │      │
    │      ├─ ビデオオプション
    │      │      ├─ -add "{video}#video"
    │      │      ├─ :par=x:y
    │      │      └─ :name=...
    │      │
    │      ├─ チャンク結合
    │      │      └─ -cat "{chunk}"
    │      │
    │      ├─ AddAudio() [各オーディオ]
    │      │      ├─ -add "{audio}"
    │      │      ├─ #trackID=id または #audio
    │      │      ├─ :sbr (SBR時)
    │      │      ├─ :lang=xxx
    │      │      ├─ :delay=ms
    │      │      ├─ :name=...
    │      │      └─ :tkhd=3:group=1 (default時)
    │      │
    │      ├─ 字幕オプション
    │      │      ├─ -add "{subtitle}#index"
    │      │      ├─ :lang=xxx
    │      │      ├─ :name=...
    │      │      └─ :txtflags=0xC0000000 (forced時)
    │      │
    │      ├─ -chap {chapterfile}
    │      │
    │      ├─ -itags cover=...:tag=value:...
    │      │
    │      └─ -new {output}
    │
    └─ Proc.Start()
           └─ MP4Box実行
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ビデオファイル     ───▶   GetArgs()             ───▶   MP4Boxコマンド
オーディオ[]               コマンドライン構築            ライン
字幕[]                                                    │
      │                                                    ▼
チャプター         ───▶                                   │
iTunesタグ                                                │
カバー                                                    │
      │                                                    ▼
      └──────────────────────────────────────────▶   MP4Box
                                                          │
                                                          ▼
                                                     MP4ファイル
                                                     (p.TargetFile)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Muxer.vb | `Source/General/Muxer.vb` | ソース | MP4Muxer クラス |
| MuxerForm.vb | `Source/Forms/MuxerForm.vb` | ソース | MP4 Mux設定UI |
| Package.vb | `Source/General/Package.vb` | ソース | MP4Boxパッケージ定義 |
| MediaInfo.vb | `Source/General/MediaInfo.vb` | ソース | 出力ファイル情報取得 |
