# 機能設計書 3-Blu-ray/DVDサポート

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるBlu-ray/DVDサポート機能の設計仕様を記述する。Blu-rayディスク（BDMV構造）およびDVDディスク（VIDEO_TS構造）からのビデオ/オーディオストリーム読み込みに対応する機能である。

### 本機能の処理概要

**業務上の目的・背景**：物理メディアやイメージファイルからのビデオコンテンツ取り込みニーズに対応する。Blu-rayは高解像度（1080p/4K）コンテンツ、DVDは標準解像度コンテンツの主要なソースである。本機能により、これらのディスク構造を解析し、タイトル/プレイリストの選択、ストリーム抽出を可能にする。

**機能の利用シーン**：
- Blu-rayディスクからの動画抽出・エンコード
- DVDディスクからの動画抽出・エンコード
- ISOイメージファイルからのコンテンツ取り込み
- BDMVフォルダ構造の直接読み込み
- VIDEO_TSフォルダ構造の直接読み込み

**主要な処理内容**：
1. ディスク構造の検出（BDMV/VIDEO_TS）
2. プレイリスト/タイトル情報の解析（eac3toによる）
3. ストリーム選択ダイアログの表示（eac3toForm）
4. 選択ストリームのデマルチプレクス
5. チャプター情報の抽出（オプション）
6. 一時ディレクトリへのストリーム出力

**関連システム・外部連携**：
- eac3to：Blu-rayストリーム解析・抽出
- DGIndex/DGIndexNV：DVD VOBファイルのデマルチプレクス
- MediaInfo：メディア情報解析

**権限による制御**：特になし。ディスク/フォルダへの読み取りアクセス権が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | Blu-ray/DVDからの読み込み起動 |
| - | eac3toForm | Demux設定 | Blu-rayストリーム選択・抽出設定 |

## 機能種別

データ読み込み / ディスク解析 / Demux処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sourcePath | String | Yes | BDMVフォルダまたはVIDEO_TSフォルダのパス | 構造検証 |
| playlistId | Integer | No | 選択プレイリストID | 有効なID範囲 |

### 入力データソース

- フォルダ選択：BDMVまたはVIDEO_TSフォルダ
- ISOマウント：マウントされたドライブからの参照
- ドラッグ&ドロップ：フォルダドロップ

### 対応ディスク構造

- **Blu-ray**: BDMV/STREAM/*.m2ts構造
- **DVD**: VIDEO_TS/*.VOB構造

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 抽出ビデオストリーム | File | H.264/H.265/VC-1/MPEG2ストリーム |
| 抽出オーディオストリーム | File | AC3/DTS/TrueHD/LPCM等 |
| 抽出字幕ストリーム | File | PGS/VobSub形式 |
| チャプターファイル | File | テキスト形式チャプター情報 |

### 出力先

- プロジェクト一時ディレクトリ（p.TempDir）
- ユーザー指定ディレクトリ（eac3toFormで設定可能）

## 処理フロー

### 処理シーケンス

```
1. ディスク構造検出
   └─ BDMV/VIDEO_TSフォルダ構造の判定
2. eac3to解析実行
   └─ プレイリスト一覧取得
   └─ ストリーム情報取得
3. eac3toForm表示
   └─ プレイリスト選択
   └─ ストリーム選択（ビデオ/オーディオ/字幕）
   └─ 出力形式設定
4. Demux実行
   └─ eac3toによるストリーム抽出
   └─ 進捗表示
5. 結果反映
   └─ 抽出ファイルをプロジェクトに設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[パス受信]
    B --> C{BDMV構造?}
    C -->|Yes| D[Blu-ray処理]
    C -->|No| E{VIDEO_TS?}
    E -->|Yes| F[DVD処理]
    E -->|No| G[エラー]
    D --> H[eac3to解析]
    H --> I[プレイリスト一覧取得]
    I --> J[eac3toForm表示]
    J --> K{OK押下?}
    K -->|No| L[キャンセル]
    K -->|Yes| M[Demux実行]
    M --> N[ストリーム抽出]
    N --> O[プロジェクト設定]
    O --> P[終了]
    F --> Q[DGIndex/eac3to処理]
    Q --> J
    L --> P
    G --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 構造検証 | BDMV/STREAM/*.m2tsまたはVIDEO_TS/*.VOB存在必須 | 常時 |
| BR-002 | 3D非対応 | 3Dコンテンツ（左目/右目別ストリーム）はエラー | eac3to解析時 |
| BR-003 | プレイリスト選択必須 | 複数プレイリスト時は選択必須 | Blu-ray時 |
| BR-004 | チャプター抽出オプション | cbChaptersチェック状態で制御 | 常時 |

### 計算ロジック

特になし。

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-001 | InvalidStructure | BDMV/VIDEO_TS構造が不正 | エラーメッセージ表示 |
| E-002 | 3DContent | 3Dコンテンツ検出 | 「3D demuxing isn't supported」表示 |
| E-003 | eac3toError | eac3to実行失敗 | 終了コード表示、処理中断 |
| E-004 | EmptyOutput | eac3to出力が空 | 警告メッセージ表示 |

### リトライ仕様

リトライ処理は行わない。エラー時はダイアログをキャンセル。

## トランザクション仕様

本機能はトランザクション管理を行わない。

## パフォーマンス要件

- 解析処理：プレイリスト数に依存（数秒〜数十秒）
- Demux処理：コンテンツサイズに依存

## セキュリティ考慮事項

- 一時ファイル出力先の権限確認
- eac3to実行時の引数エスケープ

## 備考

- eac3toは外部ツールとして別途インストールが必要
- Haaliスプリッターが必要な場合がある（MKV出力時）
- ビデオ出力形式：H264/H265/VC1/M2V/MKV/Nothing
- オーディオ出力形式：m4a/ac3/dts/flac/pcm/wav/dtsma/dtshr/eac3/thd

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Blu-rayストリーム情報を保持するデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | eac3toForm.vb | `Source/Forms/eac3toForm.vb` | M2TSStreamクラス定義 |

**読解のコツ**: M2TSStreamクラスはストリームの種別（IsVideo/IsAudio/IsSubtitle/IsChapters）とコーデック情報を保持する。

#### Step 2: UIダイアログを理解する

eac3toFormのUI構造と動作を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | eac3toForm.vb | `Source/Forms/eac3toForm.vb` | フォーム定義（9-649行目） |
| 2-2 | eac3toForm.vb | `Source/Forms/eac3toForm.vb` | Streams BindingList（583行目） |

**主要コントロール**:
- **cbVideoOutput**: ビデオ出力形式選択
- **cbVideoStream**: ビデオストリーム選択
- **lvAudio**: オーディオストリームリスト
- **lvSubtitles**: 字幕ストリームリスト
- **cbChapters**: チャプター抽出チェックボックス

#### Step 3: eac3to解析処理を理解する

eac3toによるストリーム解析の実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | eac3toForm.vb | `Source/Forms/eac3toForm.vb` | StartAnalyze（726-759行目） |
| 3-2 | eac3toForm.vb | `Source/Forms/eac3toForm.vb` | Init（780-961行目） |

**主要処理フロー**:
1. **726行目**: StartAnalyzeメソッド（Task.Runで非同期実行）
2. **729-735行目**: eac3toコマンドライン構築
3. **737-757行目**: プロセス実行と出力キャプチャ
4. **780行目**: Init()で解析結果をUIに反映

#### Step 4: Demux処理を理解する

ストリーム抽出のコマンドライン構築を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | eac3toForm.vb | `Source/Forms/eac3toForm.vb` | GetArgs（967-1030行目） |

**主要処理フロー**:
- **967行目**: GetArgsメソッド
- **972-978行目**: ビデオストリーム出力引数
- **991-1007行目**: オーディオストリーム出力引数
- **1009-1027行目**: 字幕・チャプター出力引数

### プログラム呼び出し階層図

```
MainForm（Blu-ray/DVDフォルダ読み込み）
    │
    └─ eac3toForm.ShowDialog()
           │
           ├─ OnShown()
           │      └─ Task.Run(StartAnalyze)
           │             └─ eac3to.exe実行（解析）
           │             └─ OutputDataReceived（出力パース）
           │             └─ Init()（UI初期化）
           │
           ├─ ストリーム選択UI操作
           │      ├─ cbVideoStream/cbVideoOutput
           │      ├─ lvAudio（チェック選択）
           │      └─ lvSubtitles（チェック選択）
           │
           └─ OK押下時
                  └─ GetArgs()（コマンドライン構築）
                  └─ eac3to Demux実行
```

### データフロー図

```
[入力]                      [処理]                        [出力]

BDMV/VIDEO_TSパス ────▶ eac3to解析
                              │
                              ▼
                     プレイリスト/ストリーム情報
                              │
                              ▼
                     eac3toForm（UI選択）
                              │
                              ▼
                     GetArgs()構築 ────────────▶ eac3toコマンドライン
                              │
                              ▼
                     eac3to Demux実行
                              │
                              ▼
                     ストリーム抽出 ─────────────▶ .h264/.h265/.ac3/.dts等
                                                  _chapters.txt
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| eac3toForm.vb | `Source/Forms/eac3toForm.vb` | ソース | Blu-ray Demuxダイアログ |
| Demux.vb | `Source/General/Demux.vb` | ソース | Demuxer基底クラス（eac3toDemuxer含む） |
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | ダイアログ呼び出し元 |
| Package.vb | `Source/General/Package.vb` | ソース | eac3toパッケージ定義 |
