# 機能設計書 30-WebM Mux

## 概要

本ドキュメントは、StaxRipのWebM Mux機能について、その処理内容、入出力仕様、および実装詳細を記載した設計書である。

### 本機能の処理概要

WebM Mux機能は、エンコード済みビデオ、オーディオをWebMコンテナにマルチプレクスする機能である。WebMはMatroskaベースのコンテナであり、mkvmergeツールを使用してMuxを行う。VP8/VP9/AV1ビデオとVorbis/Opusオーディオをサポートする。

**業務上の目的・背景**：WebMはWeb向けのオープンな動画形式であり、HTML5の<video>タグでネイティブサポートされる。ロイヤリティフリーであり、Web配信やオープンソースプロジェクトで広く使用される。

**機能の利用シーン**：
- Webサイト埋め込み動画の作成
- HTML5プレーヤー向けの動画エンコード
- オープンソースプロジェクトでの動画配布
- YouTubeなど動画共有サービスへのアップロード

**主要な処理内容**：
1. ビデオ、オーディオファイルの収集
2. mkvmergeコマンドライン構築（MkvMuxerを継承）
3. WebM互換形式の検証
4. Mux実行とログ出力

**関連システム・外部連携**：
- mkvmerge: MKVToolNixのMuxツール（WebMモード）

**権限による制御**：本機能に権限による制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | MuxerForm | 主画面 | WebM Mux設定 |
| 1 | MainForm | 参照画面 | Muxer選択 |

## 機能種別

ファイル合成 / データ変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| VideoFile | String | Yes | ビデオファイルパス（VP8/VP9/AV1） | ファイル存在 |
| AudioTracks | List(Of AudioProfile) | No | オーディオトラックリスト（Vorbis/Opus） | - |

### 対応入力形式

```
Video: mkv, webm, mka, ogg, opus, ivf
Audio: ogg, opus
```

**注意**: WebMは以下のコーデックのみサポート
- ビデオ: VP8, VP9, AV1
- オーディオ: Vorbis, Opus

### 入力データソース

- エンコード済みファイル（p.VideoEncoder.OutputPath）
- オーディオファイル（p.AudioTracks）
- プロジェクト設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| TargetFile | String | 出力WebMファイルパス |

### 出力先

- 指定された出力ファイル（p.TargetFile）

## 処理フロー

### 処理シーケンス

```
1. 形式検証
   └─ ビデオ/オーディオがWebM互換か確認

2. コマンドライン構築
   └─ MkvMuxer.GetArgs()を継承（WebM制約適用）

3. Mux実行
   └─ Proc経由でmkvmerge起動

4. 結果確認
   └─ 出力ファイル存在確認、MediaInfo出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{形式確認}
    B -->|非対応| Z[エラー終了]
    B -->|対応| C[MkvMuxer.GetArgs継承]
    C --> D[チャプター/字幕除外]
    D --> E[mkvmerge実行]
    E --> F{出力存在?}
    F -->|Yes| G[MediaInfo出力]
    F -->|No| H[エラーログ]
    G --> Z[終了]
    H --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-30-01 | コーデック制限 | VP8/VP9/AV1 + Vorbis/Opusのみサポート | 常時 |
| BR-30-02 | チャプター非対応 | WebMではチャプターを追加しない | WebMMuxer時 |
| BR-30-03 | 字幕制限 | WebVTT等の限定的な字幕のみ | 字幕追加時 |
| BR-30-04 | MkvMuxer継承 | 基本処理はMkvMuxerを継承 | 常時 |

### WebM制約

| 項目 | 対応状況 |
|-----|---------|
| ビデオコーデック | VP8, VP9, AV1のみ |
| オーディオコーデック | Vorbis, Opusのみ |
| 字幕 | 限定的（WebVTT等） |
| チャプター | 非対応 |
| 添付ファイル | 非対応 |
| タグ | 限定的 |

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-30-01 | 非対応コーデック | WebM非対応のコーデック使用 | エラーメッセージ表示 |
| E-30-02 | 出力失敗 | WebM出力ファイルが生成されない | エラーログ出力 |

### リトライ仕様

リトライ処理なし。

## トランザクション仕様

トランザクション制御なし。

## パフォーマンス要件

- Mux処理は高速（ストリームコピー）
- 処理時間は入力ファイルサイズに依存

## セキュリティ考慮事項

外部プロセス（mkvmerge）の実行はPackage経由で制御。

## 備考

WebM vs MKV:
- WebMはMKVのサブセット
- WebMはロイヤリティフリー
- WebMはWeb配信に最適化
- MKVはより多くのコーデック/機能をサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: クラス構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Muxer.vb | `Source/General/Muxer.vb` | WebMMuxer クラス（988-1007行目） |

**読解のコツ**: WebMMuxerはMkvMuxerを継承。OutputExt="webm"を返す。SupportedInputTypesでWebM対応形式のみに制限。

#### Step 2: MkvMuxerとの継承関係を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Muxer.vb | `Source/General/Muxer.vb` | MkvMuxer クラス（624-986行目）- 基底クラス |
| 2-2 | Muxer.vb | `Source/General/Muxer.vb` | Muxer.Init()内のWebMMuxer判定（225行目） |

**主要な継承ポイント**:
- GetArgs()メソッドはMkvMuxerから継承
- SupportedInputTypesをオーバーライドして制限
- OutputExtをオーバーライドして"webm"を返す

#### Step 3: WebM固有の制約を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Muxer.vb | `Source/General/Muxer.vb` | WebMMuxer.SupportedInputTypes（996-999行目） |
| 3-2 | Muxer.vb | `Source/General/Muxer.vb` | Muxer.Init()内のチャプター除外（225行目） |

### プログラム呼び出し階層図

```
WebMMuxer.Mux() [MkvMuxerから継承]
    │
    ├─ WriteTagfile() [MkvMuxerから継承]
    │
    ├─ GetArgs() [MkvMuxerから継承]
    │      ├─ ビデオオプション
    │      ├─ オーディオオプション
    │      │      └─ WebM対応形式のみ (ogg, opus等)
    │      │
    │      ├─ チャプター [WebMMuxerではスキップ]
    │      │
    │      └─ その他オプション
    │
    └─ Proc.Start()
           └─ mkvmerge実行
```

### データフロー図

```
[入力]                    [処理]                         [出力]

VP8/VP9/AV1        ───▶   形式検証             ───▶   WebM互換確認
ビデオファイル             SupportedInputTypes判定        │
      │                                                    ▼
Vorbis/Opus        ───▶   MkvMuxer.GetArgs     ───▶   mkvmergeコマンド
オーディオ                 (チャプター除外)              ライン
      │                                                    │
      │                                                    ▼
      └──────────────────────────────────────────▶   mkvmerge
                                                          │
                                                          ▼
                                                     WebMファイル
                                                     (p.TargetFile)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Muxer.vb | `Source/General/Muxer.vb` | ソース | WebMMuxer、MkvMuxer |
| MuxerForm.vb | `Source/Forms/MuxerForm.vb` | ソース | WebM Mux設定UI |
| Package.vb | `Source/General/Package.vb` | ソース | mkvmergeパッケージ定義 |
| MediaInfo.vb | `Source/General/MediaInfo.vb` | ソース | 出力ファイル情報取得 |
