# 機能設計書 32-カスタムMux

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるコマンドラインベースのカスタム多重化（BatchMuxer）機能の設計を記述する。

### 本機能の処理概要

カスタムMux機能は、ユーザーが任意のコマンドライン（バッチスクリプト）を定義し、それを使用してビデオとオーディオを多重化する機能である。標準で提供されるMKV/MP4/ffmpeg Muxerでは対応できない特殊な要件や、カスタムツールを使用した多重化処理を可能にする。

**業務上の目的・背景**：標準のMuxerでは対応できない特殊なワークフローや、独自のツールチェーンを使用した処理が必要な場合に、ユーザーが自由にコマンドラインを定義できる柔軟性を提供する。業務用のカスタムパイプラインや、特定のコンテナ仕様に準拠した出力が必要な環境に対応する。

**機能の利用シーン**：
- 標準Muxerでサポートされていない特殊なコンテナフォーマットへの出力
- カスタムのメタデータ挿入やストリーム処理が必要な場合
- 独自開発のMuxツールを使用する場合
- 複数のツールを連携させたパイプライン処理

**主要な処理内容**：
1. 出力ファイルタイプの指定
2. バッチスクリプト（コマンドライン）の定義
3. マクロの展開処理
4. コマンドラインの実行（パイプ対応）
5. 複数行コマンドの順次実行

**関連システム・外部連携**：ユーザー定義の外部ツールとの連携。デフォルトではMP4Boxを使用した例が設定される。

**権限による制御**：特になし。すべてのユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 参照画面 | lgbEncoderからMuxer選択 |
| - | SimpleSettingsForm | 主画面 | Batch Muxerダイアログで出力タイプとコマンドライン編集 |

## 機能種別

外部ツール連携 / バッチ処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| OutputTypeValue | String | Yes | 出力ファイルの拡張子 | デフォルト: "mp4" |
| CommandLines | String | Yes | 実行するバッチスクリプト | 空でないこと |

### 入力データソース

- ユーザー入力: 出力ファイルタイプとコマンドライン
- Macro展開: %app_path:MP4Box%、%encoder_out_file%、%audio_file1%、%target_file% 等のマクロ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| TargetFile | ファイル | 指定拡張子のコンテナファイル |

### 出力先

- p.TargetFile で指定されたパス（拡張子はOutputTypeValueで決定）

## 処理フロー

### 処理シーケンス

```
1. コマンドラインの取得
   └─ CommandLinesプロパティからスクリプトを取得

2. マクロ展開
   └─ Macro.Expand()でマクロを実際の値に変換

3. 空行除去
   └─ SplitLinesNoEmpty()で空行を除去

4. 各行の処理ループ
   └─ 各コマンドラインを順次処理

5. パイプ処理判定
   └─ コマンドに"|"が含まれるか確認

6. コマンド実行
   └─ パイプあり: cmd.exe /S /C で実行
   └─ パイプなし: 直接実行

7. エラーハンドリング
   └─ 例外発生時はAbortExceptionをスロー
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[コマンドライン取得]
    B --> C[マクロ展開]
    C --> D[空行除去]
    D --> E{次の行あり?}
    E -->|No| F[終了]
    E -->|Yes| G[現在行取得]
    G --> H{パイプ含む?}
    H -->|Yes| I[cmd.exe /S /C で実行]
    H -->|No| J[直接実行]
    I --> K[プロセス起動]
    J --> K
    K --> L{例外発生?}
    L -->|Yes| M[エラー表示]
    M --> N[AbortException]
    L -->|No| E
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-32-01 | 任意入力対応 | IsSupported()は常にTrueを返す | 常時 |
| BR-32-02 | パイプ対応 | パイプを含むコマンドはcmd.exe経由で実行 | コマンドに"\|"が含まれる場合 |
| BR-32-03 | マクロ展開 | すべてのマクロが展開されてから実行 | 常時 |
| BR-32-04 | 出力タイプ連動 | OutputTypeValueの変更はTargetFileの拡張子に反映 | ダイアログでOK時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし（ファイルベースの処理）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | AbortException | コマンド実行中の一般例外 | エラー表示後に処理中断 |
| - | AbortException | ユーザーによる中断 | 処理中断 |

### リトライ仕様

リトライ処理なし。エラー発生時は処理を中断。

## トランザクション仕様

ファイル操作のためトランザクション管理なし

## パフォーマンス要件

- ユーザー定義のコマンドに依存
- 複数行コマンドは順次実行（並列実行なし）

## セキュリティ考慮事項

- ユーザー入力のコマンドラインをそのまま実行するため、信頼できるスクリプトのみ使用すること
- マクロ展開後のコマンドが意図通りか確認することを推奨

## 備考

- デフォルトのコマンドラインはMP4Boxを使用した基本的なMux例
- 複数行のスクリプトは上から順に実行される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

BatchMuxerクラスの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Muxer.vb | `Source/General/Muxer.vb` | BatchMuxerクラス定義（538-621行目） |

**読解のコツ**: BatchMuxerはMuxerを継承し、CanEditValueがTrueのためEdit()メソッドで設定ダイアログを表示可能。

#### Step 2: プロパティを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Muxer.vb | `Source/General/Muxer.vb` | OutputTypeValueプロパティ（542行目）、CommandLinesプロパティ（543行目） |

**主要プロパティ**:
- **542行目**: OutputTypeValue - デフォルト値は"mp4"
- **543行目**: CommandLines - デフォルトはMP4Boxを使用したコマンド例

#### Step 3: Muxメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Muxer.vb | `Source/General/Muxer.vb` | BatchMuxer.Mux()メソッド（559-583行目） |

**主要処理フロー**:
1. **560行目**: ログヘッダー出力
2. **562行目**: マクロ展開とSplitLinesNoEmpty
3. **563-581行目**: 各コマンドラインの処理ループ
4. **566-569行目**: パイプ含有チェックとcmd.exe経由実行
5. **570-571行目**: パイプなしの場合は直接実行
6. **574-579行目**: 例外ハンドリング

#### Step 4: 編集ダイアログを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Muxer.vb | `Source/General/Muxer.vb` | BatchMuxer.Edit()メソッド（585-620行目） |

**主要処理フロー**:
- **586-587行目**: SimpleSettingsFormの作成とタイトル設定
- **592-595行目**: 出力ファイルタイプのテキストボックス
- **597-607行目**: バッチスクリプトのテキストエリア（UseCommandlineEditor=True）
- **612-615行目**: TargetFileの拡張子更新

### プログラム呼び出し階層図

```
MainForm (Muxer選択)
    │
    ├─ BatchMuxer.Edit()
    │      └─ SimpleSettingsForm
    │             ├─ OutputTypeValue 入力
    │             └─ CommandLines 入力 (マクロ対応)
    │
    └─ BatchMuxer.Mux()
           │
           ├─ Log.WriteHeader()
           │
           ├─ Macro.Expand()
           │
           └─ For Each line In CommandLines
                  │
                  └─ Proc
                         ├─ cmd.exe (パイプあり)
                         └─ 直接実行 (パイプなし)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

CommandLines ──────────────────▶ BatchMuxer.Mux() ─────────────────▶ TargetFile
      │                               │
      ▼                               │
Macro.Expand()                        │
      │                               │
      ▼                               ▼
展開済みコマンド ────────────────▶ Proc実行
                                      │
                                      ▼
                              外部ツール実行
                                      │
                                      ▼
                              コンテナファイル生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Muxer.vb | `Source/General/Muxer.vb` | ソース | BatchMuxerクラスの定義 |
| Macro.vb | `Source/General/Macro.vb` | ソース | マクロ展開処理 |
| Proc.vb | `Source/General/Proc.vb` | ソース | 外部プロセス実行クラス |
| SimpleSettingsForm.vb | `Source/Forms/SimpleSettingsForm.vb` | ソース | 設定ダイアログの基底クラス |
