# 機能設計書 33-メタデータ設定

## 概要

本ドキュメントは、StaxRipアプリケーションにおける出力コンテナファイルへのメタデータ（タイトル、言語、タグ等）設定機能の設計を記述する。

### 本機能の処理概要

メタデータ設定機能は、多重化時に出力ファイルにタイトル、言語コード、カスタムタグ等のメタデータを付与する機能である。MKVではXML形式のタグファイル、MP4ではitagsオプションを通じてメタデータが設定される。また、NFOファイルからの自動取得機能も提供する。

**業務上の目的・背景**：動画ファイルの整理・管理において、メタデータは重要な役割を果たす。タイトルやジャンル、監督名等のメタデータを付与することで、メディアライブラリソフトウェア（Plex、Kodi等）での自動認識や、ファイル管理の効率化が実現できる。

**機能の利用シーン**：
- メディアサーバー用にファイルのメタデータを設定する場合
- 映画/TVシリーズのコレクション整理時
- 配信用コンテンツへの情報付与
- NFOファイルとの連携による自動メタデータ取得

**主要な処理内容**：
1. NFOファイルからのメタデータ自動読み込み
2. タグ一覧（DataGridView）でのカスタムタグ追加・編集
3. MKV用XMLタグファイルの生成
4. MP4用itagsオプションの構築
5. カバー画像の添付
6. 言語コード、トラック名の設定

**関連システム・外部連携**：NFOファイル（XML形式）からのメタデータ取得、mkvmerge/MP4Boxとの連携。

**権限による制御**：特になし。すべてのユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 14 | MuxerForm | 主画面 | tpOptionsでタイトル、言語、タグ設定、tpTagsでタグ編集 |
| 1 | MainForm | 参照画面 | Muxer選択からMuxerFormへ遷移 |

## 機能種別

設定管理 / データ変換処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Tags | BindingList(Of StringPair) | No | カスタムタグのキー・値ペア | - |
| TagFile | String | No | 外部XMLタグファイルのパス | ファイル存在確認 |
| Title | String | No | コンテナのタイトル（MKV用） | - |
| CoverFile | String | No | カバー画像ファイルのパス | jpg/png/bmp形式 |
| VideoTrackName | String | No | ビデオトラックの名前 | マクロ対応 |
| VideoTrackLanguage | Language | No | ビデオトラックの言語 | - |

### 入力データソース

- MuxerFormのtpOptionsタブ: タイトル、カバー、言語等の設定
- MuxerFormのtpTagsタブ: DataGridViewでタグ編集
- NFOファイル: p.FirstOriginalSourceFile.DirAndBase + ".nfo"からの自動読み込み

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| MKV Tags XML | ファイル | MKV用のXMLタグファイル（_tags.xml） |
| MP4 itags | 文字列 | MP4Box用のitagsオプション文字列 |

### 出力先

- MKV: p.TempDir/{base}_tags.xml
- MP4: コマンドライン引数として渡される

## 処理フロー

### 処理シーケンス

```
1. NFOファイル確認
   └─ ソースファイルと同じ場所の.nfoファイルを検索

2. NFOメタデータ読み込み
   └─ title, originaltitle, showtitle, studio, genre等を取得

3. Tags BindingListへの追加
   └─ 読み込んだメタデータをStringPairとして追加

4. MuxerForm表示
   └─ tpTagsタブでDataGridViewによる編集

5. Mux実行時のタグ処理
   ├─ MKV: WriteTagfile()でXMLファイル生成
   └─ MP4: GetArgs()でitagsオプション構築
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{NFOファイル存在?}
    B -->|Yes| C[XMLパース]
    C --> D[fieldNamesに一致する要素抽出]
    D --> E[Tags BindingListに追加]
    B -->|No| F[MuxerForm表示]
    E --> F
    F --> G[ユーザーによるタグ編集]
    G --> H{Muxer種別}
    H -->|MKV| I[WriteTagfile]
    H -->|MP4| J[itags構築]
    I --> K[XMLファイル生成]
    J --> L[コマンドライン引数追加]
    K --> M[mkvmerge実行]
    L --> N[MP4Box実行]
    M --> O[終了]
    N --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-33-01 | NFO自動読み込み | ソースファイルと同じ場所のNFOファイルからメタデータを自動取得 | p.FirstOriginalSourceFile.DirAndBase + ".nfo"が存在する場合 |
| BR-33-02 | NFO対応フィールド | title, originaltitle, showtitle, studio, genre, director, season, episode, premiered, aired, outline, plot, taglineを読み込み | NFOファイル処理時 |
| BR-33-03 | マクロ展開 | タグの名前・値にマクロが含まれる場合は展開 | Mux実行時 |
| BR-33-04 | MKVタグファイル形式 | Tags/Tag/Simple/Name,String形式のXML | MKV Mux時 |
| BR-33-05 | カバー画像自動検出 | cover.jpg/png、small_cover、cover_landを自動検出 | Init()時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし（ファイルベースの処理）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | XMLパースエラー | NFOファイルが不正なXML形式 | Try-Catchでスキップ |
| - | ファイル不在 | TagFileが存在しない | ファイル存在チェック後のみ処理 |

### リトライ仕様

リトライ処理なし

## トランザクション仕様

ファイル操作のためトランザクション管理なし

## パフォーマンス要件

- NFOファイルパースは軽量な処理
- XMLタグファイル生成も軽量

## セキュリティ考慮事項

- NFOファイルの内容は適切にエスケープされてXMLに出力
- マクロ展開時のコマンドインジェクション対策

## 備考

- MKVとMP4で異なるメタデータ仕様に対応
- DataGridViewで自由にタグの追加・削除が可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Muxerクラスのタグ関連プロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Muxer.vb | `Source/General/Muxer.vb` | Tagsプロパティ（36-48行目）、TagFileプロパティ（17行目） |

**読解のコツ**: TagsはBindingList(Of StringPair)型で、DataGridViewにバインド可能。

#### Step 2: NFOファイル読み込みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Muxer.vb | `Source/General/Muxer.vb` | Init()メソッド内のNFO処理（165-176行目） |

**主要処理フロー**:
1. **165行目**: NFOファイル存在確認
2. **167行目**: fieldNames定義（読み込み対象フィールド）
3. **168行目**: XElement.Parse()でNFOを読み込み
4. **169行目**: LINQ Where句でfieldNamesに一致する要素を抽出
5. **171-173行目**: StringPairとしてTagsに追加

#### Step 3: MKVタグファイル生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Muxer.vb | `Source/General/Muxer.vb` | MkvMuxer.WriteTagfile()メソッド（691-710行目） |

**主要処理フロー**:
- **692-694行目**: Tags.Count = 0の場合は早期リターン
- **696-705行目**: XML Literalでタグファイル構造を構築
- **707-708行目**: ファイル保存とTagFileプロパティ更新

#### Step 4: MP4タグ処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Muxer.vb | `Source/General/Muxer.vb` | MP4Muxer.GetArgs()メソッド内のitags処理（402-414行目） |

**主要処理フロー**:
- **402行目**: tagList初期化
- **404-406行目**: カバーファイル追加
- **408-409行目**: Tagsからitagsフォーマットに変換
- **412-413行目**: -itagsオプションとして追加

#### Step 5: MuxerFormのタグ編集UIを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | MuxerForm.vb | `Source/Forms/MuxerForm.vb` | dgvTagsの設定（701-706行目） |

**主要処理フロー**:
- **701行目**: DataSourceにmuxer.Tagsをバインド
- **702-703行目**: 行の追加・削除を許可
- **704-705行目**: 列幅設定

### プログラム呼び出し階層図

```
MainForm (Muxer選択)
    │
    └─ MuxerForm
           │
           ├─ Constructor
           │      └─ dgvTags.DataSource = muxer.Tags
           │
           ├─ tpTags タブ
           │      └─ DataGridView (タグ編集)
           │
           └─ tpOptions タブ
                  ├─ Cover ファイル選択
                  ├─ Tags XMLファイル選択 (MKVのみ)
                  └─ Title 入力 (MKVのみ)

Muxer.Init()
    │
    └─ NFOファイル処理
           ├─ XElement.Parse()
           └─ Tags.Add()

MkvMuxer.Mux()
    │
    └─ WriteTagfile()
           └─ XML Literal で _tags.xml 生成

MP4Muxer.Mux()
    │
    └─ GetArgs()
           └─ -itags オプション構築
```

### データフロー図

```
[入力]                          [処理]                              [出力]

NFOファイル ────────────────────▶ Muxer.Init() ──────────────────▶ Tags (BindingList)
                                      │
MuxerForm tpTags ────────────────────▶│
                                      │
                                      ▼
                              Tags プロパティ
                                      │
                    ┌─────────────────┴─────────────────┐
                    ▼                                   ▼
              MkvMuxer                            MP4Muxer
                    │                                   │
                    ▼                                   ▼
           WriteTagfile()                         GetArgs()
                    │                                   │
                    ▼                                   ▼
            _tags.xml                           -itags オプション
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Muxer.vb | `Source/General/Muxer.vb` | ソース | Muxer基底クラス、MkvMuxer、MP4Muxerの定義 |
| MuxerForm.vb | `Source/Forms/MuxerForm.vb` | ソース | Muxer設定ダイアログ（タグ編集UI含む） |
| Misc.vb | `Source/General/Misc.vb` | ソース | StringPairクラスの定義 |
