# 機能設計書 34-添付ファイル追加

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるMKVコンテナへの添付ファイル（フォント、画像、字幕等）追加機能の設計を記述する。

### 本機能の処理概要

添付ファイル追加機能は、MKVコンテナに任意のファイル（フォント、カバー画像、ドキュメント等）を添付する機能である。特にASS/SSA字幕で使用されるフォントの埋め込みが主な用途であり、フォントの自動検出機能も提供する。

**業務上の目的・背景**：MKVコンテナはAttachments（添付ファイル）機能をサポートしており、字幕で使用するカスタムフォントを埋め込むことで、再生環境にフォントがインストールされていなくても正しく表示できる。また、カバー画像の埋め込みによりメディアプレーヤーでのサムネイル表示が可能になる。

**機能の利用シーン**：
- ASS/SSA字幕で使用するカスタムフォントの埋め込み
- カバー画像のMKVへの添付
- NFOファイルなどのメタデータドキュメントの添付
- 字幕ファイルの添付

**主要な処理内容**：
1. Attachmentsプロパティへのファイル追加
2. 字幕ファイルからのフォント自動検出（ASS/SSAパース）
3. mkvmergeへの--attach-fileオプション生成
4. MuxerFormでの添付ファイル管理（ContextMenuStrip）

**関連システム・外部連携**：mkvmergeとの連携、システムフォントフォルダの検索。

**権限による制御**：特になし。すべてのユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 14 | MuxerForm | 主画面 | bnAddAttachment、ContextMenuStripで添付ファイル管理 |
| 1 | MainForm | 参照画面 | Muxer選択からMuxerFormへ遷移 |

## 機能種別

設定管理 / ファイル操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Attachments | List(Of String) | No | 添付するファイルパスのリスト | - |

### 入力データソース

- ユーザー入力: MuxerFormでのファイル選択（bnAddAttachment）
- 自動検出: ASS/SSA字幕ファイルからのフォント検出
- 自動検出: cover.jpg/png等のカバー画像検出

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| MKV Attachments | mkvmergeオプション | --attach-fileオプションの一連 |

### 出力先

- mkvmergeコマンドライン引数として渡される

## 処理フロー

### 処理シーケンス

```
1. 添付ファイル追加方法
   ├─ bnAddAttachment: ファイルダイアログでユーザー選択
   ├─ ContextMenu: Subtitlesからのフォント検出
   └─ Init(): カバー画像の自動検出

2. フォント自動検出（ASS/SSA）
   └─ 字幕ファイルを解析し、使用フォント名を抽出

3. フォント検索
   └─ Windows Fontsフォルダから該当フォントを検索

4. Attachmentsリストへの追加
   └─ 重複チェック後に追加

5. Mux実行時
   └─ 各ファイルに対して--attach-fileオプション生成
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{添付方法}
    B -->|手動追加| C[FileOpenDialog表示]
    C --> D[ファイル選択]
    D --> E[Attachmentsに追加]
    B -->|フォント検出| F[字幕ファイル解析]
    F --> G{ASS/SSA?}
    G -->|Yes| H[FontNameを抽出]
    H --> I[Fontsフォルダ検索]
    I --> J{フォント見つかった?}
    J -->|Yes| K[Attachmentsに追加]
    J -->|No| L[次のフォントへ]
    G -->|No| M[スキップ]
    B -->|カバー自動検出| N[Init実行]
    N --> O{cover.jpg/png存在?}
    O -->|Yes| P[CoverFileに設定]
    O -->|No| Q[スキップ]
    E --> R[Mux実行]
    K --> R
    P --> R
    R --> S[--attach-file生成]
    S --> T[mkvmerge実行]
    T --> U[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-34-01 | MKV限定 | 添付ファイル機能はMKVコンテナでのみ使用可能 | MkvMuxer使用時 |
| BR-34-02 | フォント検出 | ASS/SSA字幕からStyle行のFontNameを抽出 | 字幕がASS/SSA形式の場合 |
| BR-34-03 | フォント検索パス | %WINDIR%\Fonts を検索対象とする | フォント自動検出時 |
| BR-34-04 | カバー自動検出 | cover.jpg/png, small_cover, cover_landを自動検出 | Init()時 |
| BR-34-05 | 重複防止 | 同一ファイルの重複追加を防止 | Attachments.Add時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし（ファイルベースの処理）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイル不在 | 添付ファイルが存在しない | Mux時にスキップ |
| - | フォント不在 | 検出されたフォントがFontsフォルダに見つからない | ユーザー通知、スキップ |

### リトライ仕様

リトライ処理なし

## トランザクション仕様

ファイル操作のためトランザクション管理なし

## パフォーマンス要件

- フォント検索は%WINDIR%\Fontsの列挙が必要なため、初回は若干時間がかかる
- 添付ファイルのコピーはストリーミングで行われる

## セキュリティ考慮事項

- 添付ファイルパスは適切にエスケープされてmkvmergeに渡される
- システムフォルダへのアクセスは読み取り専用

## 備考

- MP4コンテナは添付ファイル機能をサポートしない（MKV専用機能）
- 大量のフォント埋め込みはファイルサイズの増大につながる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Muxerクラスの添付ファイル関連プロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Muxer.vb | `Source/General/Muxer.vb` | Attachmentsプロパティ（51-64行目） |

**読解のコツ**: AttachmentsはList(Of String)型で、ファイルパスのリストを保持。

#### Step 2: 添付ファイルの手動追加を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MuxerForm.vb | `Source/Forms/MuxerForm.vb` | bnAddAttachment_Click処理（推定） |

**主要処理フロー**:
- ファイル選択ダイアログの表示
- 選択されたファイルをAttachmentsリストに追加
- ListViewの更新

#### Step 3: フォント自動検出を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Muxer.vb | `Source/General/Muxer.vb` | MkvMuxer.Init()のフォント処理 |

**主要処理フロー**:
1. 字幕ファイル（ASS/SSA）の存在確認
2. Style行のパース
3. FontNameフィールドの抽出
4. Fontsフォルダでの検索
5. Attachmentsへの追加

#### Step 4: mkvmergeオプション生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Muxer.vb | `Source/General/Muxer.vb` | MkvMuxer.Mux()のAttachments処理（764-769行目） |

**主要処理フロー**:
- **764行目**: Attachmentsループ開始
- **765行目**: ファイル存在確認
- **766-767行目**: --attach-file オプション追加
- **768行目**: ログ出力

### プログラム呼び出し階層図

```
MuxerForm
    │
    ├─ bnAddAttachment_Click
    │      └─ FileOpenDialog
    │             └─ muxer.Attachments.Add()
    │
    ├─ ContextMenuStrip
    │      └─ "Add fonts used in subtitles"
    │             └─ フォント検出処理
    │                    ├─ ASS/SSA解析
    │                    └─ Fontsフォルダ検索
    │
    └─ lbAttachments (ListBox)
           └─ DataSource = muxer.Attachments

MkvMuxer.Init()
    │
    └─ カバー画像自動検出
           └─ CoverFileに設定

MkvMuxer.Mux()
    │
    └─ For Each attachment In Attachments
           └─ args += " --attach-file " + attachment.Escape
```

### データフロー図

```
[入力]                          [処理]                              [出力]

FileOpenDialog ─────────────────▶ Attachments.Add() ───────────────▶ Attachments List
                                       │
ASS/SSA字幕 ────────────────────▶ フォント解析 ─▶│
    │                                  │         │
    └─ Style行                         ▼         │
                               Fontsフォルダ検索   │
                                       │         │
                                       ▼         ▼
cover.jpg/png ──────────────────▶ CoverFile ────▶ Attachments相当処理
                                       │
                                       ▼
                              MkvMuxer.Mux()
                                       │
                                       ▼
                              --attach-file オプション
                                       │
                                       ▼
                                 mkvmerge実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Muxer.vb | `Source/General/Muxer.vb` | ソース | MkvMuxerクラス、Attachmentsプロパティの定義 |
| MuxerForm.vb | `Source/Forms/MuxerForm.vb` | ソース | 添付ファイル管理UI |
| Subtitle.vb | `Source/General/Subtitle.vb` | ソース | 字幕ファイル解析（ASS/SSAパース） |
