# 機能設計書 38-リサイズ

## 概要

本ドキュメントは、StaxRipアプリケーションにおける映像のリサイズ（解像度変更）機能の設計を記述する。

### 本機能の処理概要

リサイズ機能は、映像の解像度を変更する機能である。クロップ後の映像を目標の解像度にスケーリングし、各種リサイズアルゴリズム（Bicubic、Lanczos、Spline等）を選択できる。アスペクト比の維持、Mod16/Mod8補正、アナモルフィック出力にも対応する。

**業務上の目的・背景**：エンコード時の目標解像度への変換、ビットレート効率の最適化（低解像度への縮小）、特定のデバイス/プラットフォーム要件への対応等のために、リサイズ処理は不可欠である。適切なリサイズアルゴリズムの選択により、画質劣化を最小限に抑えることができる。

**機能の利用シーン**：
- 4K映像の1080pへのダウンスケール
- SD映像のHDへのアップスケール
- Mod16解像度への調整（エンコーダ要件）
- 特定のディスプレイ解像度への最適化

**主要な処理内容**：
1. 目標解像度（TargetWidth, TargetHeight）の計算
2. アスペクト比計算と補正
3. リサイズフィルタの選択（BicubicResize, Lanczos, Spline64等）
4. Mod値に基づく解像度の自動補正
5. AviSynth/VapourSynthスクリプトへのResizeフィルタ出力

**関連システム・外部連携**：フレームサーバー（AviSynth+/VapourSynth）、Calc計算クラス。

**権限による制御**：特になし。すべてのユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | tbTargetWidthとtbTargetHeightでサイズ入力、lgbFiltersでResizeフィルタ表示 |
| 8 | PreviewForm | 参照画面 | リサイズ後の映像プレビュー |

## 機能種別

映像フィルタ / 解像度変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| p.TargetWidth | Integer | Yes | 目標幅（ピクセル） | > 0, Mod依存 |
| p.TargetHeight | Integer | Yes | 目標高さ（ピクセル） | > 0, Mod依存 |
| ResizeFilter | String | No | 使用するリサイズフィルタ | BicubicResize等 |

### 入力データソース

- MainForm.tbTargetWidth/tbTargetHeight: ユーザー入力
- SetTargetImageSize(): アスペクト比計算による自動設定
- フィルタプロファイル: リサイズフィルタの選択

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Resizeフィルタ | スクリプト | AviSynth: BicubicResize(width, height) |
| | | VapourSynth: core.resize.Bicubic(clip, width, height) |

### 出力先

- p.Script.Filters内のResizeカテゴリフィルタ

## 処理フロー

### 処理シーケンス

```
1. 目標サイズ入力
   └─ MainForm.tbTargetWidth/Height、またはSetTargetImageSize()

2. アスペクト比計算
   └─ Calc.GetTargetDAR()でDisplay Aspect Ratioを計算

3. Mod補正
   └─ 指定されたMod値（2/4/8/16）に合わせてサイズ調整

4. リサイズフィルタ選択
   └─ FiltersListViewでResizeフィルタを追加/編集

5. スクリプト生成
   └─ マクロ展開で%target_width%, %target_height%を実際の値に変換

6. リサイズ実行
   └─ フレームサーバーでスクリプト実行
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[目標サイズ入力]
    B --> C{入力方法}
    C -->|直接入力| D[tbTargetWidth/Height]
    C -->|自動計算| E[SetTargetImageSize]
    D --> F[アスペクト比計算]
    E --> F
    F --> G{Mod補正必要?}
    G -->|Yes| H[Mod値に調整]
    G -->|No| I[スキップ]
    H --> J[Resizeフィルタ設定]
    I --> J
    J --> K{フィルタ有効?}
    K -->|Yes| L[スクリプト生成]
    K -->|No| M[リサイズなし]
    L --> N[マクロ展開]
    N --> O[フレームサーバー実行]
    O --> P[終了]
    M --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-38-01 | アスペクト比維持 | 一方のサイズ入力で他方を自動計算 | tbTargetWidth/Heightの変更時 |
| BR-38-02 | Mod補正 | s.TargetImageSizeModによりMod2/4/8/16に補正 | サイズ計算時 |
| BR-38-03 | AviSynth形式 | XxxResize(width, height)形式で出力 | AviSynth使用時 |
| BR-38-04 | VapourSynth形式 | core.resize.Xxx(clip, width, height)形式で出力 | VapourSynth使用時 |
| BR-38-05 | フィルタ有効化 | Resizeカテゴリのフィルタが有効な場合のみリサイズ実行 | スクリプト生成時 |

### 計算ロジック

**アスペクト比計算**:
```
cropWidth = p.SourceWidth - p.CropLeft - p.CropRight
cropHeight = p.SourceHeight - p.CropTop - p.CropBottom
DAR = (cropWidth / cropHeight) * (p.SourcePAR)
```

**目標高さの自動計算（幅指定時）**:
```
TargetHeight = TargetWidth / DAR
TargetHeight = Round(TargetHeight / Mod) * Mod
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし（プロジェクトファイル内に保存）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | サイズ不正 | 幅または高さが0以下 | 最小値1に補正 |
| - | アスペクト比エラー | 計算結果が許容範囲外 | Calc.GetAspectRatioError()でエラー率表示 |

### リトライ仕様

リトライ処理なし

## トランザクション仕様

ファイル操作のためトランザクション管理なし

## パフォーマンス要件

- リサイズ処理はフレームサーバーで実行
- 高解像度からの縮小は高速、拡大は計算量増加

## セキュリティ考慮事項

特になし

## 備考

- 複数のリサイズアルゴリズムが選択可能（Bicubic, Lanczos, Spline64等）
- アナモルフィック出力（1440x1080等）にも対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Projectクラスのリサイズ関連プロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Project.vb | `Source/General/Project.vb` | TargetWidth, TargetHeightプロパティ |
| 1-2 | Project.vb | `Source/General/Project.vb` | SourceWidth, SourceHeight, SourcePARプロパティ |

**読解のコツ**: TargetWidth/Heightは出力解像度、SourceWidth/Heightはソース解像度。

#### Step 2: リサイズフィルタ定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | VideoScript.vb | `Source/Video/VideoScript.vb` | GetDefaults()でResizeフィルタ定義（751, 760行目） |
| 2-2 | AviSynthFilterProfileDefaults.txt | `埋め込みリソース` | リサイズフィルタの一覧 |

**主要処理フロー**:
- **751行目**: AviSynth - BicubicResize(%target_width%, %target_height%)
- **760行目**: VapourSynth - core.resize.Bicubic(clip, %target_width%, %target_height%)

#### Step 3: サイズ計算を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MainForm.vb | `Source/Forms/MainForm.vb` | SetTargetImageSize()メソッド |
| 3-2 | Calc.vb | `Source/General/Calc.vb` | GetTargetDAR()メソッド |
| 3-3 | Calc.vb | `Source/General/Calc.vb` | GetAspectRatioError()メソッド |

**主要処理フロー**:
- SetTargetImageSize(): 目標サイズの設定と計算
- GetTargetDAR(): 表示アスペクト比の計算
- GetAspectRatioError(): アスペクト比誤差の計算

#### Step 4: UIを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | MainForm.vb | `Source/Forms/MainForm.vb` | tbTargetWidth/tbTargetHeightの定義 |
| 4-2 | FiltersListView.vb | `Source/Controls/FiltersListView.vb` | OnItemCheck()でResize有効化時の処理（306-311行目） |

**主要処理フロー**:
- **306-311行目**: Resizeフィルタ有効化時にSetTargetImageSize呼び出し

#### Step 5: マクロ展開を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | Macro.vb | `Source/General/Macro.vb` | %target_width%, %target_height%の展開 |

### プログラム呼び出し階層図

```
MainForm
    │
    ├─ tbTargetWidth/tbTargetHeight
    │      └─ TextChanged イベント
    │             └─ SetTargetImageSize()
    │
    ├─ SetTargetImageSize()
    │      ├─ Calc.GetTargetDAR()
    │      └─ Mod補正処理
    │
    └─ FiltersListView
           │
           ├─ OnItemCheck()
           │      └─ Resize有効化時
           │             └─ SetTargetImageSize()
           │
           └─ p.Script.Filters
                  │
                  └─ Resizeカテゴリフィルタ
                         │
                         └─ GetScript()
                                │
                                └─ Macro.Expand()
                                       ├─ %target_width%
                                       └─ %target_height%
```

### データフロー図

```
[入力]                          [処理]                              [出力]

tbTargetWidth ──────────────────▶ SetTargetImageSize() ────────▶ p.TargetWidth
      │                               │
      │                               ▼
      │                       Calc.GetTargetDAR()
      │                               │
      │                               ▼
      │                          Mod補正
      │                               │
      │                               ▼
tbTargetHeight ─────────────────▶ 自動計算 ───────────────────▶ p.TargetHeight
      │
      │
      │
      └────────────────────────────────────────────────────────▶ VideoScript
                                                                     │
                                                                     ▼
                                                              Resizeフィルタ
                                                                     │
                                                                     ▼
                                                              Macro.Expand()
                                                                     │
                                                         ┌───────────┴───────────┐
                                                         ▼                       ▼
                                                   AviSynth             VapourSynth
                                                         │                       │
                                                         ▼                       ▼
                                                 BicubicResize()      core.resize.Bicubic()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | 目標サイズ入力UI、SetTargetImageSize() |
| Project.vb | `Source/General/Project.vb` | ソース | TargetWidth/TargetHeightプロパティ |
| VideoScript.vb | `Source/Video/VideoScript.vb` | ソース | Resizeフィルタの定義と出力 |
| FiltersListView.vb | `Source/Controls/FiltersListView.vb` | ソース | フィルタ一覧UIとResize有効化処理 |
| Calc.vb | `Source/General/Calc.vb` | ソース | DAR計算、Mod計算、アスペクト比エラー計算 |
| Macro.vb | `Source/General/Macro.vb` | ソース | %target_width%等のマクロ展開 |
