# 機能設計書 39-デインターレース

## 概要

本ドキュメントは、StaxRipアプリケーションにおける映像のデインターレース（インターレース解除）機能の設計を記述する。

### 本機能の処理概要

デインターレース機能は、インターレース映像をプログレッシブ映像に変換する機能である。QTGMC、Yadifmod、IVTC（逆テレシネ）等の各種デインターレースアルゴリズムを提供し、ソース映像の特性に応じた最適な処理を選択できる。

**業務上の目的・背景**：放送やDVD等のインターレースソースは、現代の表示デバイス（PCモニター、スマートTV等）やエンコーダ（x264/x265/AV1）でプログレッシブとして扱う方が高画質・高効率となる。適切なデインターレース処理により、コーミングアーティファクトのない滑らかな映像を得ることができる。

**機能の利用シーン**：
- DVDソースのデインターレース
- 放送録画（TS）のデインターレース
- テレシネ映像の逆テレシネ（IVTC）
- ハイブリッドソース（一部インターレース）の処理

**主要な処理内容**：
1. インターレース検出（トップフィールドファースト/ボトムフィールドファースト）
2. デインターレースフィルタの選択（QTGMC、Yadifmod等）
3. フィールドオーダーの設定（TFF/BFF）
4. ダブルフレームレート出力オプション
5. AviSynth/VapourSynthスクリプトへのFieldフィルタ出力

**関連システム・外部連携**：フレームサーバー（AviSynth+/VapourSynth）、各種デインターレースプラグイン。

**権限による制御**：特になし。すべてのユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | lgbFiltersでFieldフィルタ表示・選択 |
| 8 | PreviewForm | 参照画面 | デインターレース後の映像プレビュー |
| 22 | CodeEditor | 参照画面 | スクリプトの直接編集 |

## 機能種別

映像フィルタ / 変換処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| FieldFilter | VideoFilter | No | 使用するデインターレースフィルタ | Fieldカテゴリ |
| TFF | Boolean | Yes | トップフィールドファースト | True/False |

### 入力データソース

- フィルタプロファイル: Fieldカテゴリのフィルタ定義
- ソース映像: インターレース属性（TFF/BFF）
- FilterParameters: QTGMC等のパラメータ設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Fieldフィルタ | スクリプト | AviSynth: QTGMC(preset="Medium") |
| | | VapourSynth: havsfunc.QTGMC(clip, TFF=True, Preset='Medium') |

### 出力先

- p.Script.Filters内のFieldカテゴリフィルタ

## 処理フロー

### 処理シーケンス

```
1. インターレースソース確認
   └─ ソースファイル解析でインターレース検出

2. デインターレースフィルタ選択
   └─ FiltersListViewでFieldカテゴリのフィルタを追加

3. パラメータ設定
   └─ FilterParametersでTFF/BFF、Preset等を設定

4. スクリプト生成
   └─ GetScript()でFieldフィルタを出力

5. デインターレース実行
   └─ フレームサーバーでスクリプト実行
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{インターレースソース?}
    B -->|No| C[デインターレース不要]
    B -->|Yes| D[フィールドオーダー確認]
    D --> E{TFF or BFF?}
    E -->|TFF| F[TFF=True設定]
    E -->|BFF| G[TFF=False設定]
    F --> H[デインターレースフィルタ選択]
    G --> H
    H --> I{フィルタ種別}
    I -->|QTGMC| J[QTGMCパラメータ設定]
    I -->|Yadifmod| K[Yadifmodパラメータ設定]
    I -->|IVTC| L[IVTCパラメータ設定]
    J --> M[スクリプト生成]
    K --> M
    L --> M
    M --> N[フレームサーバー実行]
    N --> O[終了]
    C --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-39-01 | TFF/BFF判定 | ソースファイルのフィールドオーダーに合わせて設定 | インターレースソース処理時 |
| BR-39-02 | QTGMC Preset | 処理速度と品質のトレードオフでPreset選択 | QTGMC使用時 |
| BR-39-03 | SetFieldBased | VapourSynthではSetFieldBasedでフィールド属性を設定 | VapourSynth使用時 |
| BR-39-04 | フレームレート倍増 | ダブルフレームレート出力時はフレーム数が2倍 | 60fps出力時 |
| BR-39-05 | カテゴリ名 | Fieldカテゴリとしてフィルタリストに表示 | フィルタ選択時 |

### 計算ロジック

**ダブルフレームレート計算**:
```
OutputFrameRate = SourceFrameRate * 2
OutputFrameCount = SourceFrameCount * 2
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし（プロジェクトファイル内に保存）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | フィールドオーダー不一致 | TFF/BFF設定がソースと不一致 | コーミング発生、設定見直し |
| - | プラグイン不在 | QTGMC等のプラグインがない | 要件確認ダイアログ表示 |

### リトライ仕様

リトライ処理なし

## トランザクション仕様

ファイル操作のためトランザクション管理なし

## パフォーマンス要件

- QTGMCは高品質だが計算コストが高い
- Preset選択で速度と品質のバランスを調整可能

## セキュリティ考慮事項

特になし

## 備考

- QTGMC Presetは Draft, Ultra Fast, Super Fast, Very Fast, Faster, Fast, Medium, Slow, Slower, Very Slow, Placebo が選択可能
- VapourSynthではhavsfuncパッケージが必要

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Fieldカテゴリのフィルタ定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | VideoScript.vb | `Source/Video/VideoScript.vb` | GetDefaults()でFieldフィルタ定義（749, 758行目） |

**読解のコツ**: FieldカテゴリにQTGMC等のデインターレースフィルタが定義されている。

#### Step 2: AviSynth形式を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | VideoScript.vb | `Source/Video/VideoScript.vb` | GetDefaults()のAviSynth定義（749行目） |
| 2-2 | VideoScript.vb | `Source/Video/VideoScript.vb` | FilterParameters.Definitions内のQTGMC設定（1125-1136行目） |

**主要処理フロー**:
- **749行目**: QTGMC(preset="Medium")形式
- **1125-1136行目**: QTGMCのPreset選択肢定義

#### Step 3: VapourSynth形式を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | VideoScript.vb | `Source/Video/VideoScript.vb` | GetDefaults()のVapourSynth定義（758行目） |
| 3-2 | VideoScript.vb | `Source/Video/VideoScript.vb` | FilterParameters.Definitions内のhavsfunc.QTGMC設定（1122-1124行目） |

**主要処理フロー**:
- **758行目**: SetFieldBased + havsfunc.QTGMC形式
- **1122-1124行目**: havsfunc.QTGMCのTFF選択肢定義

#### Step 4: パラメータ設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | VideoScript.vb | `Source/Video/VideoScript.vb` | FilterParameters.Definitions（1001-1186行目） |

**主要処理フロー**:
- **1122-1124行目**: TFF = True/False の選択
- **1125-1136行目**: Preset選択（Draft〜Placebo）

#### Step 5: CropFormでのトーンマッピング連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | CropForm.vb | `Source/Forms/CropForm.vb` | HDRトーンマッピングとの連携（264-280行目） |

### プログラム呼び出し階層図

```
MainForm
    │
    └─ FiltersListView
           │
           ├─ RebuildMenu()
           │      └─ filterProfiles (AviSynthProfiles/VapourSynthProfiles)
           │             └─ Fieldカテゴリのフィルタ一覧
           │
           ├─ AddClick() / ReplaceClick()
           │      └─ Macro.ExpandGUI()
           │             └─ FilterParameters.Definitions参照
           │
           └─ p.Script.Filters
                  │
                  └─ Fieldカテゴリフィルタ
                         │
                         └─ GetScript()
                                │
                                └─ QTGMC / Yadifmod / IVTC 出力
```

### データフロー図

```
[入力]                          [処理]                              [出力]

インターレースソース ───────────▶ Field判定 ─────────────────────▶ TFF/BFF設定
      │                               │
      │                               ▼
      │                    フィルタ選択 (QTGMC等)
      │                               │
      │                               ▼
      │                    Macro.ExpandGUI()
      │                               │
      │                               ▼
      │                    FilterParameters
      │                               │
      │                    ┌──────────┴──────────┐
      │                    ▼                     ▼
      │              TFF設定              Preset設定
      │                    │                     │
      │                    └──────────┬──────────┘
      │                               │
      │                               ▼
      └────────────────────────▶ VideoScript
                                      │
                                      ▼
                                Fieldフィルタ
                                      │
                               ┌──────┴──────┐
                               ▼             ▼
                         AviSynth      VapourSynth
                               │             │
                               ▼             ▼
                           QTGMC()   havsfunc.QTGMC()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| VideoScript.vb | `Source/Video/VideoScript.vb` | ソース | Fieldフィルタの定義、FilterParametersの定義 |
| FiltersListView.vb | `Source/Controls/FiltersListView.vb` | ソース | フィルタ一覧UIとパラメータ設定 |
| Macro.vb | `Source/General/Macro.vb` | ソース | ExpandGUI()でパラメータ入力ダイアログ |
| AviSynthFilterProfileDefaults.txt | `埋め込みリソース` | リソース | AviSynth用デインターレースフィルタ定義 |
| VapourSynthFilterProfileDefaults.txt | `埋め込みリソース` | リソース | VapourSynth用デインターレースフィルタ定義 |
