# 機能設計書 40-ノイズ除去

## 概要

本ドキュメントは、StaxRipアプリケーションにおける映像のノイズ除去（デノイズ）機能の設計を記述する。

### 本機能の処理概要

ノイズ除去機能は、映像に含まれるノイズ（ランダムノイズ、グレイン、ブロックノイズ等）を低減する機能である。DFTTest、KNLMeansCL、BM3D、neo_f3kdb等の各種ノイズ除去アルゴリズムを提供し、ソース映像の特性に応じた最適な処理を選択できる。

**業務上の目的・背景**：ソース映像に含まれるノイズは、エンコード効率を低下させ、視覚品質を劣化させる。適切なノイズ除去処理により、より少ないビットレートで高い視覚品質を実現できる。また、フィルムグレインの除去やDVDのブロックノイズ除去等、ソース特有の問題に対処できる。

**機能の利用シーン**：
- DVDソースのブロックノイズ除去
- 放送録画のランダムノイズ除去
- フィルムソースのグレイン除去/軽減
- 高感度撮影映像のノイズ除去
- バンディング（色の階段状アーティファクト）の除去

**主要な処理内容**：
1. ノイズ除去フィルタの選択（DFTTest、KNLMeansCL等）
2. 強度パラメータ（sigma等）の設定
3. 時間軸フィルタリング（tbsize）の設定
4. AviSynth/VapourSynthスクリプトへのNoiseフィルタ出力

**関連システム・外部連携**：フレームサーバー（AviSynth+/VapourSynth）、各種ノイズ除去プラグイン。

**権限による制御**：特になし。すべてのユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | lgbFiltersでNoiseフィルタ表示・選択 |
| 8 | PreviewForm | 参照画面 | ノイズ除去後の映像プレビュー |
| 22 | CodeEditor | 参照画面 | スクリプトの直接編集 |

## 機能種別

映像フィルタ / ノイズ処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| NoiseFilter | VideoFilter | No | 使用するノイズ除去フィルタ | Noiseカテゴリ |
| sigma | Integer/Double | No | ノイズ除去強度 | フィルタ依存 |
| tbsize | Integer | No | 時間軸フレーム数 | 奇数推奨 |

### 入力データソース

- フィルタプロファイル: Noiseカテゴリのフィルタ定義
- ユーザー入力: sigma、tbsize等のパラメータ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Noiseフィルタ | スクリプト | AviSynth: DFTTest(sigma=6, tbsize=1) |
| | | VapourSynth: core.dfttest.DFTTest(clip, sigma=6, tbsize=3, opt=3) |

### 出力先

- p.Script.Filters内のNoiseカテゴリフィルタ

## 処理フロー

### 処理シーケンス

```
1. ノイズソース確認
   └─ プレビューでノイズレベルを視覚的に確認

2. ノイズ除去フィルタ選択
   └─ FiltersListViewでNoiseカテゴリのフィルタを追加

3. パラメータ設定
   └─ sigma、tbsize等を設定

4. スクリプト生成
   └─ GetScript()でNoiseフィルタを出力

5. ノイズ除去実行
   └─ フレームサーバーでスクリプト実行
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ソースノイズ確認]
    B --> C{ノイズ除去必要?}
    C -->|No| D[フィルタ無効]
    C -->|Yes| E[フィルタ選択]
    E --> F{フィルタ種別}
    F -->|DFTTest| G[DFTTestパラメータ設定]
    F -->|KNLMeansCL| H[KNLMパラメータ設定]
    F -->|BM3D| I[BM3Dパラメータ設定]
    F -->|neo_f3kdb| J[f3kdbパラメータ設定]
    G --> K[sigma, tbsize設定]
    H --> L[d, a, s, h設定]
    I --> M[sigma, radius設定]
    J --> N[y, cb, cr, grainy設定]
    K --> O[スクリプト生成]
    L --> O
    M --> O
    N --> O
    O --> P[フレームサーバー実行]
    P --> Q[終了]
    D --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-40-01 | sigma設定 | ノイズ除去強度を0〜20程度で設定 | DFTTest使用時 |
| BR-40-02 | tbsize設定 | 時間軸フレーム数（1=空間のみ、3以上=時間軸含む） | DFTTest使用時 |
| BR-40-03 | GPU加速 | KNLMeansCL、BM3D等はGPU対応 | 対応GPU搭載時 |
| BR-40-04 | バンディング除去 | neo_f3kdbはバンディング除去に特化 | バンディング発生時 |
| BR-40-05 | カテゴリ名 | Noiseカテゴリとしてフィルタリストに表示 | フィルタ選択時 |

### 計算ロジック

特になし（フィルタ内部で処理）

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし（プロジェクトファイル内に保存）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | プラグイン不在 | DFTTest等のプラグインがない | 要件確認ダイアログ表示 |
| - | GPU非対応 | GPU加速フィルタでGPU使用不可 | CPU版フィルタに切り替え |

### リトライ仕様

リトライ処理なし

## トランザクション仕様

ファイル操作のためトランザクション管理なし

## パフォーマンス要件

- DFTTestは比較的軽量
- BM3D、KNLMeansCLはGPU使用時に高速
- 時間軸処理（tbsize > 1）は計算コスト増加

## セキュリティ考慮事項

特になし

## 備考

- sigma値が大きいほどノイズ除去は強いが、ディテール損失も増加
- 時間軸処理は動きの速いシーンでゴースト発生の可能性あり
- バンディング除去にはneo_f3kdbが効果的

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Noiseカテゴリのフィルタ定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | VideoScript.vb | `Source/Video/VideoScript.vb` | GetDefaults()でNoiseフィルタ定義（750, 759行目） |

**読解のコツ**: NoiseカテゴリにDFTTest等のノイズ除去フィルタが定義されている。

#### Step 2: AviSynth形式を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | VideoScript.vb | `Source/Video/VideoScript.vb` | GetDefaults()のAviSynth定義（750行目） |

**主要処理フロー**:
- **750行目**: DFTTest(sigma=6, tbsize=1)形式
- sigma=6: デフォルトのノイズ除去強度
- tbsize=1: 空間フィルタのみ（時間軸処理なし）

#### Step 3: VapourSynth形式を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | VideoScript.vb | `Source/Video/VideoScript.vb` | GetDefaults()のVapourSynth定義（759行目） |

**主要処理フロー**:
- **759行目**: core.dfttest.DFTTest(clip, sigma=6, tbsize=3, opt=3)形式
- tbsize=3: VapourSynthでは時間軸処理有効
- opt=3: 最適化オプション

#### Step 4: フィルタプロファイルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | FilterCategory.vb | `Source/Video/VideoScript.vb` | ParseFilterProfilesIniContent()（938-982行目） |

**主要処理フロー**:
- 埋め込みリソースからフィルタプロファイルを読み込み
- カテゴリ（[Noise]）とフィルタ名=スクリプト形式でパース

### プログラム呼び出し階層図

```
MainForm
    │
    └─ FiltersListView
           │
           ├─ RebuildMenu()
           │      └─ filterProfiles (AviSynthProfiles/VapourSynthProfiles)
           │             └─ Noiseカテゴリのフィルタ一覧
           │
           ├─ AddClick() / ReplaceClick()
           │      └─ Macro.ExpandGUI()
           │             └─ パラメータ入力ダイアログ
           │
           └─ p.Script.Filters
                  │
                  └─ Noiseカテゴリフィルタ
                         │
                         └─ GetScript()
                                │
                                └─ DFTTest / KNLMeansCL / BM3D 出力
```

### データフロー図

```
[入力]                          [処理]                              [出力]

ノイズソース ───────────────────▶ フィルタ選択 ──────────────────▶ Noiseフィルタ設定
      │                               │
      │                               ▼
      │                    パラメータ入力
      │                               │
      │                    ┌──────────┴──────────┐
      │                    ▼                     ▼
      │               sigma設定            tbsize設定
      │                    │                     │
      │                    └──────────┬──────────┘
      │                               │
      │                               ▼
      └────────────────────────▶ VideoScript
                                      │
                                      ▼
                                Noiseフィルタ
                                      │
                               ┌──────┴──────┐
                               ▼             ▼
                         AviSynth      VapourSynth
                               │             │
                               ▼             ▼
                         DFTTest()   core.dfttest.DFTTest()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| VideoScript.vb | `Source/Video/VideoScript.vb` | ソース | Noiseフィルタの定義、FilterCategoryの定義 |
| FiltersListView.vb | `Source/Controls/FiltersListView.vb` | ソース | フィルタ一覧UIとパラメータ設定 |
| Macro.vb | `Source/General/Macro.vb` | ソース | ExpandGUI()でパラメータ入力ダイアログ |
| AviSynthFilterProfileDefaults.txt | `埋め込みリソース` | リソース | AviSynth用ノイズ除去フィルタ定義 |
| VapourSynthFilterProfileDefaults.txt | `埋め込みリソース` | リソース | VapourSynth用ノイズ除去フィルタ定義 |
