# 機能設計書 41-シャープ化

## 概要

本ドキュメントは、StaxRipにおける映像シャープ化（シャープネス調整）機能の設計を記述する。この機能は、AviSynth+およびVapourSynthのフィルタプロファイルを通じて、映像のエッジを強調し、より鮮明な映像を実現する。

### 本機能の処理概要

シャープ化機能は、エンコード前の映像処理パイプラインにおいて、映像のエッジや細部を強調するフィルタを適用する機能である。

**業務上の目的・背景**：映像のエンコード過程では、圧縮や解像度変更により映像がぼやけることがある。シャープ化機能は、このような品質劣化を補正し、視覚的により鮮明な出力を得るために必要である。特にSD映像のアップスケールやアニメーション映像の処理において重要な役割を果たす。

**機能の利用シーン**：
- 解像度アップスケール後のエッジ補正
- 圧縮アーティファクトの軽減
- アニメーション映像のライン強調
- 古い映像素材の品質向上

**主要な処理内容**：
1. ユーザーがFiltersListViewからシャープフィルタを選択
2. フィルタプロファイルから定義済みパラメータを読み込み
3. 選択に応じてユーザー入力ダイアログを表示
4. AviSynth+/VapourSynthスクリプトにフィルタコードを挿入
5. プレビュー画面でリアルタイム確認

**関連システム・外部連携**：
- AviSynth+フィルタプラグイン（CAS、FineSharp、LSFmod等）
- VapourSynthプラグイン（cas、finesharp、havsfunc等）
- フレームサーバー（FrameServer）との連携

**権限による制御**：特になし（全ユーザーが利用可能）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | FiltersListViewでフィルタチェーン構築、シャープフィルタ選択 |
| 2 | PreviewForm | 結果表示画面 | シャープ化適用後のプレビュー確認 |

## 機能種別

映像フィルタ処理 / 信号処理 / スクリプト生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| filterType | String | Yes | シャープフィルタの種類（CAS、FineSharp、LSFmod等） | プロファイル定義内のフィルタ名 |
| strength | Single/Integer | No | シャープネス強度 | フィルタ依存（例: CASは0.0-1.0） |
| mode | Integer | No | 処理モード（フィルタ依存） | フィルタ定義による |

### 入力データソース

- 画面入力（MainFormのFiltersListView）
- フィルタプロファイル定義ファイル（AviSynthFilterProfileDefaults.txt / VapourSynthFilterProfileDefaults.txt）
- ソース映像（IFrameServer経由）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| filterScript | String | AviSynth+/VapourSynthスクリプトコード |
| processedFrame | Bitmap | フィルタ適用後のフレームデータ |

### 出力先

- VideoScript.Filters（フィルタチェーン）
- スクリプトファイル（.avs/.vpy）
- プレビューパネル（VideoRenderer経由）

## 処理フロー

### 処理シーケンス

```
1. フィルタ選択
   └─ MainFormのFiltersListViewでLineカテゴリからSharpenフィルタを選択
2. パラメータ入力
   └─ フィルタ定義に従いダイアログ表示（$enter_text$、$select$マクロ展開）
3. スクリプト生成
   └─ VideoFilter.Scriptにフィルタコードを設定
4. フィルタチェーン追加
   └─ VideoScript.Filtersに追加
5. スクリプト同期
   └─ VideoScript.Synchronize()でファイル出力
6. プレビュー更新
   └─ PreviewFormまたはVideoComparisonFormで確認
```

### フローチャート

```mermaid
flowchart TD
    A[フィルタ選択開始] --> B{フィルタタイプ選択}
    B -->|CAS| C1[強度パラメータ入力]
    B -->|FineSharp| C2[プリセット選択]
    B -->|LSFmod| C3[詳細パラメータ設定]
    B -->|Sharpen| C4[シャープ量入力]
    C1 --> D[スクリプトコード生成]
    C2 --> D
    C3 --> D
    C4 --> D
    D --> E[VideoFilter作成]
    E --> F[フィルタチェーン追加]
    F --> G[スクリプト同期]
    G --> H[プレビュー更新]
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-41-01 | フィルタ順序 | シャープフィルタはリサイズ後に適用推奨 | リサイズフィルタ存在時 |
| BR-41-02 | エンジン依存 | AVS/VSで利用可能フィルタが異なる | スクリプトエンジン選択時 |
| BR-41-03 | 強度制限 | 過度なシャープ化はアーティファクト発生 | 強度パラメータ設定時 |

### 計算ロジック

各シャープフィルタは独自のアルゴリズムを使用：
- **CAS (Contrast Adaptive Sharpening)**: コントラストに応じた適応的シャープ化
- **FineSharp**: 多段階処理による高品質シャープ化
- **LSFmod**: Limitedシャープ化フィルタの改良版

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。設定はプロジェクトファイル（.srip）に保存される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| FILTER-001 | プラグイン未検出 | 必要なAVS/VSプラグインがインストールされていない | Package.VerifyOK()でチェック、自動ダウンロード案内 |
| FILTER-002 | スクリプトエラー | 無効なパラメータ指定 | VideoScript.GetError()で検出、エラーメッセージ表示 |
| FILTER-003 | メモリ不足 | 大量フィルタチェーンでメモリ枯渇 | SetMemoryMax設定案内 |

### リトライ仕様

フィルタ適用エラー時、パラメータ修正後に再適用可能

## トランザクション仕様

該当なし（ファイルベース処理）

## パフォーマンス要件

- プレビュー応答: 1フレームあたり100ms以内（フィルタ複雑度による）
- スクリプト同期: 500ms以内

## セキュリティ考慮事項

- 外部プラグインのパス検証
- スクリプトインジェクション対策（パラメータエスケープ）

## 備考

- AviSynth+とVapourSynthで利用可能なシャープフィルタは異なる
- カスタムフィルタプロファイルはユーザー設定で追加可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フィルタプロファイル定義の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AviSynthFilterProfileDefaults.txt | `Source/Video/AviSynthFilterProfileDefaults.txt` | [Line]セクション内Sharpenカテゴリのフィルタ定義形式 |
| 1-2 | VapourSynthFilterProfileDefaults.txt | `Source/Video/VapourSynthFilterProfileDefaults.txt` | VSでのシャープフィルタ定義 |

**読解のコツ**:
- `$select:msg:...$` はユーザー選択ダイアログを生成するマクロ
- `$enter_text:...$` はテキスト入力ダイアログを生成するマクロ
- `|` 区切りで表示名と値を分離

#### Step 2: エントリーポイントを理解する

フィルタ選択UIの起点を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | FiltersListViewの構築とフィルタ選択イベント |

**主要処理フロー**:
- MainFormでのフィルタリストビュー初期化
- フィルタカテゴリ（Line > Sharpen）の階層構造

#### Step 3: フィルタ処理層を理解する

VideoFilterクラスとスクリプト生成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | VideoScript.vb | `Source/Video/VideoScript.vb` | VideoFilterクラス、Filtersコレクション、Synchronizeメソッド |
| 3-2 | FrameServer.vb | `Source/Video/FrameServer.vb` | フレームサーバーインターフェース |

**主要処理フロー**:
- VideoFilter.Scriptプロパティでフィルタコード保持
- VideoScript.Synchronize()でスクリプトファイル生成

#### Step 4: プレビュー表示を理解する

フィルタ適用結果のプレビュー表示を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | PreviewForm.vb | `Source/Forms/PreviewForm.vb` | VideoRenderer使用、フレーム表示 |
| 4-2 | VideoRenderer.vb | `Source/Video/VideoRenderer.vb` | Direct2D描画、フレームサーバー連携 |

**主要処理フロー**:
- **303-311行目**: PreviewForm.Open()でFrameServer作成
- **101-148行目**: VideoRenderer.Draw()でフレーム描画

### プログラム呼び出し階層図

```
MainForm (FiltersListView)
    │
    ├─ VideoFilter (フィルタ定義)
    │      └─ Script (フィルタコード)
    │
    ├─ VideoScript
    │      ├─ Filters (フィルタコレクション)
    │      └─ Synchronize() → スクリプトファイル出力
    │
    └─ PreviewForm
           ├─ FrameServer (フレーム取得)
           └─ VideoRenderer (描画)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フィルタ選択 ──────▶ VideoFilter作成 ──────▶ スクリプトファイル(.avs/.vpy)
    │                      │                         │
パラメータ入力 ─────▶ Script生成 ──────────▶ エンコーダ入力
    │                      │                         │
ソース映像 ─────────▶ FrameServer ─────────▶ プレビュー表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AviSynthFilterProfileDefaults.txt | `Source/Video/AviSynthFilterProfileDefaults.txt` | 設定 | AVSシャープフィルタ定義（133-142行目） |
| VapourSynthFilterProfileDefaults.txt | `Source/Video/VapourSynthFilterProfileDefaults.txt` | 設定 | VSシャープフィルタ定義（131-140行目） |
| VideoScript.vb | `Source/Video/VideoScript.vb` | ソース | フィルタ管理・スクリプト生成 |
| VideoRenderer.vb | `Source/Video/VideoRenderer.vb` | ソース | フレーム描画処理 |
| PreviewForm.vb | `Source/Forms/PreviewForm.vb` | ソース | プレビューUI |
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | メインUI・フィルタ選択 |
| Package.vb | `Source/General/Package.vb` | ソース | プラグイン管理 |
