# 機能設計書 42-色調補正

## 概要

本ドキュメントは、StaxRipにおける色調補正機能の設計を記述する。この機能は、映像の色相（Hue）、彩度（Saturation）、明るさ（Brightness）、コントラスト（Contrast）などを調整するフィルタを適用する。

### 本機能の処理概要

色調補正機能は、エンコード前の映像処理パイプラインにおいて、映像の色彩特性を調整するフィルタを適用する機能である。

**業務上の目的・背景**：映像素材は撮影条件やソース品質により、色調が適切でない場合がある。色調補正機能は、これらの色彩問題を修正し、視覚的に望ましい出力を得るために必要である。特に古い映像の復元、異なる撮影条件の映像の統一、クリエイティブな色調整において重要な役割を果たす。

**機能の利用シーン**：
- 露出補正（明るさ・コントラスト調整）
- 色かぶりの修正（色相調整）
- 彩度調整（鮮やかさの増減）
- グレースケール変換
- TV/PC間の色域レベル変換
- 自動ゲイン・ホワイトバランス調整

**主要な処理内容**：
1. ユーザーがFiltersListViewからColorフィルタを選択
2. フィルタプロファイルから定義済みパラメータまたはプリセットを読み込み
3. Tweak、ColorYUV、AutoAdjust等のフィルタ設定を行う
4. AviSynth+/VapourSynthスクリプトにフィルタコードを挿入
5. プレビュー画面でリアルタイム確認

**関連システム・外部連携**：
- AviSynth+組み込みフィルタ（Tweak、ColorYUV、Grayscale等）
- VapourSynthプラグイン（adjust、mvsfunc、fmtc等）
- フレームサーバー（FrameServer）との連携

**権限による制御**：特になし（全ユーザーが利用可能）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | FiltersListViewでフィルタチェーン構築、Colorフィルタ選択 |
| 2 | PreviewForm | 結果表示画面 | 色調補正適用後のプレビュー確認 |
| 5 | CropForm | 補助画面 | トーンマッピング適用でのクロップ調整時の色調表示 |

## 機能種別

映像フィルタ処理 / 色彩処理 / スクリプト生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| hue | Single | No | 色相調整値 | -180.0 to 180.0 |
| sat | Single | No | 彩度倍率 | 0.0 to 10.0 |
| bright | Single | No | 明るさ調整値 | -255 to 255 |
| cont | Single | No | コントラスト倍率 | 0.0 to 10.0 |
| levels | String | No | 色域レベル変換モード | "TV->PC" or "PC->TV" |

### 入力データソース

- 画面入力（MainFormのFiltersListView）
- フィルタプロファイル定義ファイル（AviSynthFilterProfileDefaults.txt / VapourSynthFilterProfileDefaults.txt）
- ソース映像（IFrameServer経由）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| filterScript | String | AviSynth+/VapourSynthスクリプトコード |
| processedFrame | Bitmap | フィルタ適用後のフレームデータ |

### 出力先

- VideoScript.Filters（フィルタチェーン）
- スクリプトファイル（.avs/.vpy）
- プレビューパネル（VideoRenderer経由）

## 処理フロー

### 処理シーケンス

```
1. フィルタ選択
   └─ MainFormのFiltersListViewでColorカテゴリからフィルタを選択
2. プリセット/パラメータ選択
   └─ Tweakの場合: Neutral/Brighter/Vivid等のプリセット選択
   └─ Levelsの場合: TV to PC / PC to TV選択
3. スクリプト生成
   └─ VideoFilter.Scriptにフィルタコードを設定
4. フィルタチェーン追加
   └─ VideoScript.Filtersに追加
5. スクリプト同期
   └─ VideoScript.Synchronize()でファイル出力
6. プレビュー更新
   └─ PreviewFormで確認
```

### フローチャート

```mermaid
flowchart TD
    A[フィルタ選択開始] --> B{フィルタタイプ選択}
    B -->|Tweak| C1[プリセット選択]
    B -->|ColorYUV| C2[AutoGain/AutoWhite設定]
    B -->|Grayscale| C3[直接適用]
    B -->|Levels| C4[変換方向選択]
    B -->|AutoAdjust| C5[詳細パラメータ設定]
    C1 --> D[スクリプトコード生成]
    C2 --> D
    C3 --> D
    C4 --> D
    C5 --> D
    D --> E[VideoFilter作成]
    E --> F[フィルタチェーン追加]
    F --> G[スクリプト同期]
    G --> H[プレビュー更新]
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-42-01 | 色域変換順序 | Levels変換はソースフィルタ直後に適用推奨 | TV/PC変換が必要な場合 |
| BR-42-02 | 高ビット深度対応 | 一部フィルタは8bit専用 | ビット深度変換後に適用 |
| BR-42-03 | エンジン依存 | AVS/VSで利用可能フィルタが異なる | スクリプトエンジン選択時 |

### 計算ロジック

各色調補正フィルタの処理：
- **Tweak**: 色相・彩度・明るさ・コントラストの個別調整
- **ColorYUV**: YUV各チャンネルの個別調整、自動ゲイン・ホワイトバランス
- **AutoAdjust**: 自動色調補正（ヒストグラム解析ベース）
- **Levels**: TV（16-235）とPC（0-255）間の色域レベル変換

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。設定はプロジェクトファイル（.srip）に保存される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| COLOR-001 | プラグイン未検出 | 必要なAVS/VSプラグインがインストールされていない | Package.VerifyOK()でチェック |
| COLOR-002 | 色域クリッピング | 補正値が範囲外 | coringパラメータで対応 |
| COLOR-003 | ビット深度非互換 | 8bit専用フィルタを高ビット深度に適用 | ConvertBits()で変換 |

### リトライ仕様

フィルタ適用エラー時、パラメータ修正後に再適用可能

## トランザクション仕様

該当なし（ファイルベース処理）

## パフォーマンス要件

- プレビュー応答: 1フレームあたり50ms以内（色調フィルタは比較的軽量）
- スクリプト同期: 500ms以内

## セキュリティ考慮事項

- 外部プラグインのパス検証
- パラメータ値の範囲チェック

## 備考

- CropFormでは高コントラストモード（p.CropWithHighContrast）でLevelsフィルタが自動適用される
- HDR映像のトーンマッピングはNo.43「HDR処理」で対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フィルタプロファイル定義の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AviSynthFilterProfileDefaults.txt | `Source/Video/AviSynthFilterProfileDefaults.txt` | [Color]セクションのフィルタ定義（28-44行目） |
| 1-2 | VapourSynthFilterProfileDefaults.txt | `Source/Video/VapourSynthFilterProfileDefaults.txt` | [Color]セクションのフィルタ定義（22-51行目） |

**読解のコツ**:
- `$select:...$` マクロでプリセット選択肢を定義
- `|` 区切りで「表示名|実際の値」を指定
- 複数行フィルタは改行で記述

#### Step 2: エントリーポイントを理解する

フィルタ選択UIの起点を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | FiltersListViewの構築とフィルタ選択イベント |

**主要処理フロー**:
- Colorカテゴリのフィルタリスト構築
- Tweak、ColorYUV、Levels等の選択処理

#### Step 3: CropFormでの色調補正連携を理解する

クロップ画面での高コントラストモードを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CropForm.vb | `Source/Forms/CropForm.vb` | 高コントラストモードでのLevelsフィルタ適用（274-280行目） |

**主要処理フロー**:
- **274行目**: `If p.CropWithHighContrast Then` 条件判定
- **275-276行目**: AviSynthでLevels(0, 2.2, 255, 0, 255)適用
- **278行目**: VapourSynthでadjust.Tweak適用

#### Step 4: プレビュー表示を理解する

フィルタ適用結果のプレビュー表示を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | PreviewForm.vb | `Source/Forms/PreviewForm.vb` | VideoRenderer使用、フレーム表示 |
| 4-2 | VideoRenderer.vb | `Source/Video/VideoRenderer.vb` | Direct2D描画処理 |

### プログラム呼び出し階層図

```
MainForm (FiltersListView)
    │
    ├─ VideoFilter (フィルタ定義)
    │      ├─ Category = "Color"
    │      └─ Script (フィルタコード: Tweak/ColorYUV等)
    │
    ├─ VideoScript
    │      ├─ Filters (フィルタコレクション)
    │      └─ Synchronize() → スクリプトファイル出力
    │
    └─ PreviewForm / CropForm
           ├─ FrameServer (フレーム取得)
           └─ VideoRenderer (描画)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フィルタ選択 ──────▶ VideoFilter作成 ──────▶ スクリプトファイル(.avs/.vpy)
    │                      │                         │
プリセット選択 ─────▶ Script生成 ──────────▶ エンコーダ入力
    │              (Tweak/ColorYUV等)              │
    │                      │                         │
ソース映像 ─────────▶ FrameServer ─────────▶ プレビュー表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AviSynthFilterProfileDefaults.txt | `Source/Video/AviSynthFilterProfileDefaults.txt` | 設定 | AVS色調フィルタ定義（28-44行目） |
| VapourSynthFilterProfileDefaults.txt | `Source/Video/VapourSynthFilterProfileDefaults.txt` | 設定 | VS色調フィルタ定義（22-51行目） |
| CropForm.vb | `Source/Forms/CropForm.vb` | ソース | 高コントラストモード処理（274-280行目） |
| VideoScript.vb | `Source/Video/VideoScript.vb` | ソース | フィルタ管理・スクリプト生成 |
| VideoRenderer.vb | `Source/Video/VideoRenderer.vb` | ソース | フレーム描画処理 |
| PreviewForm.vb | `Source/Forms/PreviewForm.vb` | ソース | プレビューUI |
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | メインUI・フィルタ選択 |
