# 機能設計書 43-HDR処理

## 概要

本ドキュメントは、StaxRipにおけるHDR（High Dynamic Range）処理機能の設計を記述する。この機能は、HDRメタデータの抽出およびトーンマッピング（HDR to SDR変換）を行う。

### 本機能の処理概要

HDR処理機能は、HDR10、HDR10+、HLG、Dolby Vision等のHDRフォーマットの映像を処理する機能である。メタデータ抽出とトーンマッピングによるSDR変換の両方を提供する。

**業務上の目的・背景**：HDRコンテンツの普及に伴い、HDR映像の編集・変換ニーズが増加している。SDRディスプレイでの視聴や、HDR非対応プラットフォームへの配信のため、適切なトーンマッピング処理が必要である。また、Dolby Visionメタデータの保持や再エンコードも重要な要件となる。

**機能の利用シーン**：
- HDR10映像のSDR変換（トーンマッピング）
- HDR10+ダイナミックメタデータの抽出・保持
- Dolby Visionメタデータファイル（RPU）の処理
- HLG映像の処理
- クロップ時のHDR映像可視化

**主要な処理内容**：
1. ソース映像のHDRフォーマット検出
2. HDRメタデータ抽出（HDR10+、Dolby Vision等）
3. libplacebo/HDRToolsによるトーンマッピング
4. エンコーダへのHDRメタデータ受け渡し
5. Muxer設定でのHDRメタデータ埋め込み

**関連システム・外部連携**：
- libplacebo（トーンマッピングプラグイン）
- HDRTools（AviSynthプラグイン）
- dovi_tool（Dolby Visionメタデータ処理）
- hdr10plus_tool（HDR10+メタデータ抽出）
- MediaInfo（HDR情報検出）

**権限による制御**：特になし（全ユーザーが利用可能）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | FiltersListViewでトーンマッピングフィルタ選択 |
| 2 | PreviewForm | 結果表示画面 | トーンマッピング適用後のプレビュー確認 |
| 5 | CropForm | 補助画面 | CropWithTonemappingでHDR映像のクロップ調整 |

## 機能種別

映像フィルタ処理 / メタデータ処理 / 色空間変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| src_csp | Integer | Yes | 入力色空間（0:SDR, 1:HDR10, 2:HLG, 3:Dolby Vision） | 0-3 |
| dst_csp | Integer | Yes | 出力色空間 | 0-3 |
| tone_mapping_function | String/Integer | No | トーンマッピングアルゴリズム | bt2390, spline等 |
| dynamic_peak_detection | Boolean | No | 動的ピーク検出 | true/false |
| Lhdr | Single | No | HDR最大輝度（cd/m2） | 1000.0-10000.0 |

### 入力データソース

- 画面入力（MainFormのFiltersListView）
- フィルタプロファイル定義ファイル
- ソース映像メタデータ（MediaInfo経由）
- プロジェクト設定（p.SourceVideoHdrFormat）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| filterScript | String | トーンマッピングスクリプトコード |
| hdrMetadata | File | HDR10+/Dolby Visionメタデータファイル |
| processedFrame | Bitmap | トーンマッピング後のフレームデータ |

### 出力先

- VideoScript.Filters（フィルタチェーン）
- スクリプトファイル（.avs/.vpy）
- メタデータファイル（.json / .bin）
- プレビューパネル（VideoRenderer経由）

## 処理フロー

### 処理シーケンス

```
1. HDRフォーマット検出
   └─ MediaInfo.GetVideo()でHDR_Format_Commercialを取得
2. メタデータ抽出（必要時）
   └─ dovi_tool / hdr10plus_toolでメタデータ抽出
3. トーンマッピングフィルタ選択
   └─ libplacebo_Tonemap / HDRToolsフィルタを選択
4. パラメータ設定
   └─ src_csp, dst_csp, トーンマッピング関数等
5. スクリプト生成
   └─ ConvertBits(16) → Tonemap → ConvertBits(10/8)
6. プレビュー確認
   └─ PreviewForm / CropFormで確認
```

### フローチャート

```mermaid
flowchart TD
    A[HDR処理開始] --> B{HDRフォーマット検出}
    B -->|HDR10| C1[HDR10処理]
    B -->|HDR10+| C2[HDR10+メタデータ抽出]
    B -->|Dolby Vision| C3[Dolby Visionメタデータ処理]
    B -->|HLG| C4[HLG処理]
    B -->|SDR| C5[処理不要]
    C1 --> D{トーンマッピング必要?}
    C2 --> D
    C3 --> D
    C4 --> D
    D -->|Yes| E[libplacebo_Tonemap適用]
    D -->|No| F[メタデータ保持]
    E --> G[スクリプト同期]
    F --> G
    C5 --> H[終了]
    G --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-43-01 | ビット深度 | トーンマッピング前に16bitに変換推奨 | HDR映像処理時 |
| BR-43-02 | Vulkanサポート | libplaceboはVulkan対応GPU必要 | GPU非対応時はCPU処理 |
| BR-43-03 | Dolby Vision | RPUファイルはdovi_toolで処理 | Dolby Vision映像時 |
| BR-43-04 | 自動検出 | SourceVideoHdrFormatで判定 | ソース読み込み時 |

### 計算ロジック

トーンマッピングアルゴリズム：
- **BT.2390**: ITU-R BT.2390標準トーンマッピング
- **ST.2094-10/40**: HDR10+対応トーンマッピング
- **Spline**: スプライン曲線ベーストーンマッピング
- **Reinhard/Hable/Mobius**: クリエイティブトーンマッピング

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。設定はプロジェクトファイル（.srip）に保存される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| HDR-001 | Vulkan非対応 | GPUがVulkanをサポートしていない | Vulkan.IsSupportedでチェック |
| HDR-002 | プラグイン未検出 | libplaceboがインストールされていない | Package.VSLibPlacebo.RequirementsFulfilled |
| HDR-003 | メタデータ破損 | Dolby Vision RPUファイルが不正 | dovi_toolエラーメッセージ表示 |
| HDR-004 | 非HDRソース | SDRソースにトーンマッピング適用 | HDRフォーマット確認を促す |

### リトライ仕様

メタデータ抽出失敗時、再試行または手動パス指定可能

## トランザクション仕様

該当なし（ファイルベース処理）

## パフォーマンス要件

- トーンマッピング処理: GPU使用時1フレームあたり50-100ms
- メタデータ抽出: ソースファイルサイズに依存

## セキュリティ考慮事項

- 外部ツール（dovi_tool等）のパス検証
- メタデータファイルの整合性チェック

## 備考

- CropFormではp.CropWithTonemappingフラグでトーンマッピング適用を制御
- Vulkan.IsSupportedでGPU対応を確認

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

HDR関連のプロジェクト設定とフィルタ定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Project.vb | `Source/General/Project.vb` | SourceVideoHdrFormat, Hdr10PlusMetadataFile, HdrDolbyVisionMetadataFile等 |
| 1-2 | AviSynthFilterProfileDefaults.txt | `Source/Video/AviSynthFilterProfileDefaults.txt` | [Color]セクションのHDR to SDRフィルタ（45-63行目） |
| 1-3 | VapourSynthFilterProfileDefaults.txt | `Source/Video/VapourSynthFilterProfileDefaults.txt` | Tonemap | Placeboフィルタ（47-51行目） |

**読解のコツ**:
- HDR10: src_csp=1, HLG: src_csp=2, Dolby Vision: src_csp=3
- dst_csp=0がSDR出力

#### Step 2: CropFormでのトーンマッピングを理解する

クロップ画面でのHDR映像可視化を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CropForm.vb | `Source/Forms/CropForm.vb` | CropWithTonemapping処理（264-272行目） |

**主要処理フロー**:
- **264行目**: `If p.CropWithTonemapping Then` 条件判定
- **265行目**: ビット深度とHDRフォーマットチェック
- **266-268行目**: AviSynth + AVSLibPlaceboでのトーンマッピング
- **268-269行目**: VapourSynth + VSLibPlaceboでのトーンマッピング

#### Step 3: DolbyVisionメタデータ処理を理解する

Dolby Visionメタデータファイル処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DolbyVisionMetadataFile.vb | `Source/General/DolbyVisionMetadataFile.vb` | DolbyVisionMetadataFileクラス全体 |

**主要処理フロー**:
- RPUファイルの読み込み・書き込み
- dovi_toolとの連携

### プログラム呼び出し階層図

```
MainForm
    │
    ├─ Project
    │      ├─ SourceVideoHdrFormat (HDR検出結果)
    │      ├─ Hdr10PlusMetadataFile (HDR10+メタデータパス)
    │      └─ HdrDolbyVisionMetadataFile (Dolby Visionメタデータ)
    │
    ├─ VideoFilter (トーンマッピングフィルタ)
    │      └─ libplacebo_Tonemap / HDRTools
    │
    ├─ CropForm
    │      └─ CropWithTonemapping → placebo.Tonemap適用
    │
    └─ Package
           ├─ VSLibPlacebo (VapourSynthプラグイン)
           ├─ AVSLibPlacebo (AviSynthプラグイン)
           └─ dovi_tool (Dolby Vision処理)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

HDR映像 ─────────────▶ MediaInfo解析 ───────▶ HdrFormat検出
    │                      │                         │
HDRメタデータ ─────────▶ dovi_tool/hdr10plus_tool ─▶ メタデータファイル
    │                      │                         │
トーンマッピング設定 ──▶ libplacebo_Tonemap ────▶ SDR映像
    │                      │                         │
    └──────────────────────▶ VideoScript ──────────▶ スクリプトファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Project.vb | `Source/General/Project.vb` | ソース | HDR関連プロジェクト設定（80,93-94,134行目） |
| CropForm.vb | `Source/Forms/CropForm.vb` | ソース | トーンマッピング適用（264-272行目） |
| DolbyVisionMetadataFile.vb | `Source/General/DolbyVisionMetadataFile.vb` | ソース | Dolby Visionメタデータ処理 |
| AviSynthFilterProfileDefaults.txt | `Source/Video/AviSynthFilterProfileDefaults.txt` | 設定 | HDRフィルタ定義（45-63行目） |
| VapourSynthFilterProfileDefaults.txt | `Source/Video/VapourSynthFilterProfileDefaults.txt` | 設定 | Tonemapフィルタ定義（47-51行目） |
| Package.vb | `Source/General/Package.vb` | ソース | libplacebo等のパッケージ管理 |
| Thumbnailer.vb | `Source/General/Thumbnailer.vb` | ソース | サムネイル生成時のHDR処理（299-306行目） |
