# 機能設計書 47-クロップ調整UI

## 概要

本ドキュメントは、StaxRipにおけるクロップ調整UI機能の設計を記述する。この機能は、マウス操作でクロップ範囲を視覚的に調整する機能である。

### 本機能の処理概要

クロップ調整UI機能は、CropFormを通じてユーザーがマウスドラッグや矢印キーで映像のクロップ範囲（上下左右）を直感的に調整できるUIを提供する。

**業務上の目的・背景**：映像にはレターボックス（黒帯）やアナモルフィック歪みなどの不要な領域が含まれることがある。クロップ調整UIは、これらを視覚的に確認しながら正確にクロップ範囲を設定するために必要である。

**機能の利用シーン**：
- レターボックス（上下の黒帯）除去
- ピラーボックス（左右の黒帯）除去
- 4:3映像から16:9への変換
- アナモルフィック映像の調整
- 自動クロップ結果の手動修正

**主要な処理内容**：
1. CropFormでビデオパネル表示
2. マウス位置からアクティブな辺（上下左右）を判定
3. マウスドラッグでクロップ値を調整
4. キーボード（+/-、矢印キー）で微調整
5. 自動クロップ/スマートクロップ実行
6. VideoRendererでクロップ結果を即座に反映

**関連システム・外部連携**：
- VideoRenderer（クロップ反映表示）
- IFrameServer（フレームデータ取得）
- g.RunAutoCrop()（自動クロップ検出）
- g.SmartCrop()（アスペクト比ベースクロップ）

**権限による制御**：特になし（全ユーザーが利用可能）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | CropForm | クロップ画面 | クロップ範囲のインタラクティブ調整 |
| 1 | MainForm | 主画面 | クロップ設定の反映確認 |

## 機能種別

UI操作 / 映像編集 / インタラクティブ調整

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| CropLeft | Integer | No | 左クロップ値 | 0 <= value < SourceWidth * 0.8 |
| CropTop | Integer | No | 上クロップ値 | 0 <= value < SourceHeight * 0.8 |
| CropRight | Integer | No | 右クロップ値 | 0 <= value < SourceWidth * 0.8 |
| CropBottom | Integer | No | 下クロップ値 | 0 <= value < SourceHeight * 0.8 |
| AutoCorrectCropValues | Boolean | Yes | クロップ値の偶数補正 | true/false |

### 入力データソース

- マウス操作（ドラッグ、クリック）
- キーボード操作（+/-、矢印キー、Shift/Ctrl修飾）
- コンテキストメニュー操作

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CropLeft | Integer | 確定した左クロップ値 |
| CropTop | Integer | 確定した上クロップ値 |
| CropRight | Integer | 確定した右クロップ値 |
| CropBottom | Integer | 確定した下クロップ値 |

### 出力先

- プロジェクト設定（p.CropLeft/Top/Right/Bottom）
- VideoScript（Cropフィルタ生成用）
- StatusStrip（現在値表示）

## 処理フロー

### 処理シーケンス

```
1. CropForm初期化
   └─ VideoRenderer作成、初期クロップ値読み込み
2. マウス移動
   └─ GetSide()で最寄りの辺を判定 → SelectBorder()でハイライト
3. マウスドラッグ
   └─ MouseCrop()でクロップ値を計算 → UpdateAll()で表示更新
4. キーボード操作
   └─ CropActiveSide()で指定ピクセル分調整
5. 自動クロップ実行
   └─ RunAutoCrop()で黒帯検出 → クロップ値自動設定
6. ダイアログ終了
   └─ p.CropLeft/Top/Right/Bottomに値保存
```

### フローチャート

```mermaid
flowchart TD
    A[CropForm開始] --> B[VideoRenderer初期化]
    B --> C[初期フレーム表示]
    C --> D{ユーザー操作}
    D -->|マウス移動| E[GetSide() 辺判定]
    E --> F[SelectBorder() ハイライト]
    F --> D
    D -->|マウスドラッグ| G[MouseCrop() 値計算]
    G --> H[FixMod() 偶数補正]
    H --> I[UpdateAll() 表示更新]
    I --> D
    D -->|キー操作| J[CropActiveSide() 調整]
    J --> I
    D -->|自動クロップ| K[RunAutoCrop()]
    K --> I
    D -->|終了| L[p.Cropに保存]
    L --> M[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-47-01 | 偶数補正 | AutoCorrectCropValues有効時、値を偶数に補正 | 値設定時 |
| BR-47-02 | 最大クロップ | 各辺のクロップは元サイズの80%以下 | 値設定時 |
| BR-47-03 | 自動検出 | AutoCropは黒帯輝度閾値10で検出 | 自動クロップ時 |
| BR-47-04 | アスペクト比 | SmartCropはターゲットアスペクト比に合わせて調整 | スマートクロップ時 |

### 計算ロジック

辺判定ロジック（GetSide）：
```
マウス位置から各辺への距離を計算
最小距離の辺をアクティブ辺として選択
```

偶数補正（FixMod）：
```
If AutoCorrectCropValues And value Mod 2 <> 0 Then
    value += 1
End If
```

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。設定はプロジェクトファイル（.srip）に保存される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| CROP-001 | スクリプトエラー | クロップ適用後のスクリプトエラー | エラーダイアログ表示、修正を促す |
| CROP-002 | 範囲超過 | クロップ値が最大値を超過 | 最大値に自動補正 |

### リトライ仕様

クロップ値は随時修正可能

## トランザクション仕様

該当なし（インタラクティブ処理）

## パフォーマンス要件

- マウス操作応答: 50ms以内
- クロップ反映描画: 100ms以内

## セキュリティ考慮事項

- 整数オーバーフロー対策
- 範囲チェックによる不正値防止

## 備考

- マウスホイールでも調整可能（Ctrl押下で両辺同時調整）
- コンテキストメニューでCrop Color変更可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

CropFormのプロパティと状態管理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CropForm.vb | `Source/Forms/CropForm.vb` | クラス定義、フィールド（142-151行目） |
| 1-2 | Project.vb | `Source/General/Project.vb` | CropLeft/Top/Right/Bottomプロパティ（233-275行目） |

**読解のコツ**:
- **142-147行目**: FrameServer, Renderer, Side, ActiveCropSide, CommandManager, CustomMenu
- **149-151行目**: BorderColor, BorderSelectedColor, RendererBackColor

#### Step 2: マウス操作を理解する

マウスイベントハンドラを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CropForm.vb | `Source/Forms/CropForm.vb` | pVideo_MouseMove, pVideo_MouseDown（517-530行目） |

**主要処理フロー**:
- **517-523行目**: MouseMove - ドラッグ中はMouseCrop(), それ以外はMouseSelectBorder()
- **525-530行目**: MouseDown - アクティブ辺を設定してMouseCrop()呼び出し

#### Step 3: クロップ値計算を理解する

MouseCrop()とGetSide()メソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CropForm.vb | `Source/Forms/CropForm.vb` | MouseCrop()（406-427行目）、GetSide()（380-404行目） |

**主要処理フロー**:
- **380-404行目**: GetSide() - マウス位置から最寄りの辺を判定
- **406-427行目**: MouseCrop() - 辺に応じてp.CropXXXを更新

#### Step 4: 偶数補正を理解する

FixMod()メソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | CropForm.vb | `Source/Forms/CropForm.vb` | FixMod()（459-465行目） |

**主要処理フロー**:
- **460-462行目**: AutoCorrectCropValues有効かつ奇数の場合+1

#### Step 5: 自動クロップを理解する

RunAutoCrop()を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | CropForm.vb | `Source/Forms/CropForm.vb` | RunAutoCrop()（637-653行目） |

**主要処理フロー**:
- **639-643行目**: クロップ値初期化
- **645-649行目**: g.RunAutoCrop()呼び出し（進捗コールバック付き）

### プログラム呼び出し階層図

```
CropForm
    │
    ├─ VideoRenderer
    │      ├─ CropLeft/Top/Right/Bottom
    │      └─ Draw()
    │
    ├─ マウス操作
    │      ├─ pVideo_MouseMove()
    │      │      ├─ MouseCrop() → p.CropXXX更新
    │      │      └─ MouseSelectBorder() → SelectBorder()
    │      └─ pVideo_MouseDown()
    │             └─ GetSide() → ActiveCropSide設定
    │
    ├─ キーボード操作
    │      └─ CropActiveSide() → CropActiveSideInternal()
    │
    └─ 自動クロップ
           ├─ RunAutoCrop() → g.RunAutoCrop()
           └─ RunSmartCrop() → g.SmartCrop()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

マウス位置 ─────────▶ GetSide() ────────────▶ AnchorStyles(辺)
    │                      │                         │
    │                      ▼                         │
マウスドラッグ ────▶ MouseCrop() ──────────▶ p.CropXXX
    │                      │                         │
    │                      ▼                         │
    │               FixMod() ─────────────▶ 偶数補正値
    │                      │                         │
    │                      ▼                         │
    └──────────────▶ UpdateAll() ─────────▶ Renderer.Draw()
                               │                         │
                               ▼                         │
                           StatusStrip ─────────▶ 情報表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CropForm.vb | `Source/Forms/CropForm.vb` | ソース | クロップUI全体（全行） |
| Project.vb | `Source/General/Project.vb` | ソース | CropLeft/Top/Right/Bottomプロパティ（233-275行目） |
| VideoRenderer.vb | `Source/Video/VideoRenderer.vb` | ソース | クロップ反映描画 |
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | RunAutoCrop(), SmartCrop() |
