# 機能設計書 48-比較プレビュー

## 概要

本ドキュメントは、StaxRipにおける比較プレビュー機能の設計を記述する。この機能は、フィルタ適用前後の映像を並べて比較表示する機能である。

### 本機能の処理概要

比較プレビュー機能は、VideoComparisonFormを通じて複数の映像ファイル（ソース、エンコード済み等）をタブ形式で切り替えながら同一フレーム位置で比較できるUIを提供する。

**業務上の目的・背景**：エンコード設定の品質評価には、ソース映像とエンコード後映像の比較が不可欠である。比較プレビュー機能は、同一フレームでの画質比較を容易にし、最適なエンコード設定の選定を支援する。

**機能の利用シーン**：
- ソース映像とエンコード後映像の画質比較
- 異なるエンコード設定（ビットレート、コーデック）の比較
- フィルタ適用前後の比較
- 複数ソース映像の比較

**主要な処理内容**：
1. VideoComparisonFormで複数ファイルをタブとして開く
2. TrackBarで全タブのフレーム位置を同期
3. Spaceキーでタブを切り替えて比較
4. クロップ/ズーム設定で表示領域を調整
5. PNGとしてスナップショット保存

**関連システム・外部連携**：
- AviSynth+フレームサーバー（FFVideoSource/LSMASHVideoSource）
- VapourSynthフレームサーバー
- ffmpeg（インデックス作成）
- x265 CSVログ（フレーム情報表示）

**権限による制御**：特になし（全ユーザーが利用可能）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | VideoComparisonForm | 比較画面 | 複数映像のタブ表示、フレーム同期 |

## 機能種別

表示機能 / 比較機能 / フレームサーバー連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sourcePaths | String() | Yes | 比較する映像ファイルパス | 複数ファイル |
| position | Integer | No | 比較するフレーム位置 | 0 <= position < MaxFrameCount |
| CropLeft/Top/Right/Bottom | Integer | No | 表示クロップ設定 | 0以上 |

### 入力データソース

- ファイル選択ダイアログ
- ドラッグ&ドロップ
- TrackBarスクロール

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| renderedFrame | Bitmap | 各タブの描画されたフレーム |
| savedPng | File | 保存されたPNGスナップショット |
| frameInfo | String | CSVログからのフレーム情報 |

### 出力先

- VideoComparisonForm.TabControl（タブパネル）
- PNGファイル（保存時）
- laInfo（フレーム情報ラベル）

## 処理フロー

### 処理シーケンス

```
1. ファイル追加
   └─ Add()でファイル選択/ドロップ → VideoTab作成
2. VideoTab初期化
   └─ Open()でスクリプト作成 → FrameServer作成 → Renderer作成
3. フレーム位置同期
   └─ TrackBar.ValueChanged → 全タブのDraw()呼び出し
4. タブ切り替え
   └─ NextTab()でTabControl.SelectedIndex更新
5. PNG保存
   └─ Save()で全タブのビットマップを保存
```

### フローチャート

```mermaid
flowchart TD
    A[VideoComparisonForm開始] --> B[Add()でファイル選択]
    B --> C[VideoTab作成]
    C --> D[Open()でスクリプト生成]
    D --> E[FrameServer作成]
    E --> F[VideoRenderer作成]
    F --> G[タブに追加]
    G --> H{ユーザー操作}
    H -->|TrackBar| I[全タブDraw()]
    I --> H
    H -->|Space| J[NextTab()]
    J --> H
    H -->|S| K[Save() PNG保存]
    K --> H
    H -->|Delete| L[Remove() タブ削除]
    L --> H
    H -->|終了| M[Dispose]
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-48-01 | フレーム同期 | 全タブは同じフレーム位置を表示 | TrackBar操作時 |
| BR-48-02 | 最大フレーム | TrackBar.MaximumはLoaded中の最大FrameCount | タブ追加時 |
| BR-48-03 | ファイル形式 | AVS/VPY/MP4/MKV等をサポート | ファイル追加時 |
| BR-48-04 | CSVログ | x265 CSVログがあればフレーム情報表示 | 同名CSVファイル存在時 |

### 計算ロジック

PNG保存ファイル名：
```
Prefix形式: {Position:00000}_{FileName}.png
Suffix形式: {FileName}_{Position:00000}.png
```

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| COMP-001 | ファイル読み込み失敗 | 対応していないファイル形式 | エラーメッセージ表示 |
| COMP-002 | インデックス作成失敗 | ffmsindex/lwi作成失敗 | プロセスエラー表示 |

### リトライ仕様

Reload()で全タブを再読み込み可能

## トランザクション仕様

該当なし（リアルタイム処理）

## パフォーマンス要件

- タブ切り替え: 100ms以内
- フレーム描画: フィルタ複雑度による

## セキュリティ考慮事項

- ファイルパスの検証
- 一時ファイルの適切な削除

## 備考

- ドラッグ&ドロップでファイル追加可能
- マウスホイールでフレーム移動（100フレーム単位）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

VideoComparisonFormとVideoTabクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | VideoComparisonForm.vb | `Source/Forms/VideoComparisonForm.vb` | クラス定義、フィールド（7-13行目） |
| 1-2 | VideoComparisonForm.vb | `Source/Forms/VideoComparisonForm.vb` | VideoTabクラス（354-613行目） |

**読解のコツ**:
- **8行目**: `Shared Property Pos As Integer` - 全タブ共通のフレーム位置
- **12行目**: CropLeft/Top/Right/Bottom - 表示クロップ設定
- **357-365行目**: VideoTabのプロパティ（Server, Form, FileType等）

#### Step 2: ファイル追加処理を理解する

Add()メソッドとOpen()メソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | VideoComparisonForm.vb | `Source/Forms/VideoComparisonForm.vb` | Add()（129-185行目）、VideoTab.Open()（393-490行目） |

**主要処理フロー**:
- **129-150行目**: Add() - ファイル選択ダイアログまたは既存ソース追加
- **393-490行目**: Open() - ファイルタイプ判定、スクリプト作成、FrameServer作成

#### Step 3: フレーム同期を理解する

TrackBar_ValueChangedを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | VideoComparisonForm.vb | `Source/Forms/VideoComparisonForm.vb` | TrackBar_ValueChanged（228-236行目） |

**主要処理フロー**:
- **229行目**: TrackBarValueChanged()呼び出し
- **232-235行目**: 選択タブのTrackBarValueChanged()で描画

#### Step 4: PNG保存を理解する

Save()メソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | VideoComparisonForm.vb | `Source/Forms/VideoComparisonForm.vb` | Save()（195-226行目） |

**主要処理フロー**:
- **196-206行目**: 全タブループ、ファイル名生成
- **208-210行目**: GetBitmap()でビットマップ取得、PNG保存

### プログラム呼び出し階層図

```
VideoComparisonForm
    │
    ├─ Add()
    │      └─ VideoTab.Open()
    │             ├─ VideoScript作成
    │             ├─ FrameServerFactory.Create()
    │             └─ VideoRenderer作成
    │
    ├─ TrackBar_ValueChanged()
    │      └─ VideoTab.TrackBarValueChanged()
    │             └─ Draw()
    │
    ├─ NextTab()
    │      └─ TabControl.SelectedIndex++
    │
    ├─ Save()
    │      └─ VideoTab.GetBitmap() → PNG保存
    │
    └─ CropZoom()
           └─ SimpleSettingsFormで設定
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ファイルパス ──────▶ VideoTab.Open() ─────▶ FrameServer
    │                      │                         │
    │                      ▼                         │
TrackBar値 ────────▶ Pos更新 ─────────────▶ 全タブ同期
    │                      │                         │
    │                      ▼                         │
    └──────────────▶ Draw() ─────────────▶ タブパネル表示
                               │                         │
                               ▼                         │
                           Save() ────────────▶ PNGファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| VideoComparisonForm.vb | `Source/Forms/VideoComparisonForm.vb` | ソース | 比較UI全体（全行） |
| VideoComparisonForm.Designer.vb | `Source/Forms/VideoComparisonForm.Designer.vb` | ソース | デザイナー生成コード |
| VideoRenderer.vb | `Source/Video/VideoRenderer.vb` | ソース | フレーム描画 |
| FrameServer.vb | `Source/Video/FrameServer.vb` | ソース | フレームサーバーインターフェース |
