# 機能設計書 5-ffmpeg Demux

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるffmpeg Demux機能の設計仕様を記述する。ffmpegを使用してAVI、FLV、M2TS、TSなどの様々なコンテナ形式からビデオ、オーディオ、字幕ストリームを抽出する機能である。

### 本機能の処理概要

**業務上の目的・背景**：ffmpegは幅広いコンテナ形式とコーデックをサポートする汎用ツールである。MKVやMP4以外の形式、または他のDemuxerが対応しない形式のファイルに対して、ffmpegを使用したストリーム抽出を提供する。また、他のDemuxerのフォールバック処理としても使用される。

**機能の利用シーン**：
- AVIファイルからストリーム抽出
- FLVファイルからストリーム抽出
- M2TS/TSファイルからストリーム抽出
- 他のDemuxer（mkvextract、MP4Box）失敗時のフォールバック
- PCM音声の変換抽出

**主要な処理内容**：
1. StreamDemuxFormダイアログでストリーム選択（Dialog時）
2. ffmpeg -c:v copyでビデオストリーム抽出
3. ffmpeg -c:a copyでオーディオストリーム抽出
4. ffmpeg -c:s copyで字幕ストリーム抽出
5. PCM音声のビット深度変換

**関連システム・外部連携**：
- ffmpeg：ストリーム抽出処理
- MediaInfo：メディア情報取得

**権限による制御**：特になし。ファイルシステムへの読み書きアクセス権が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | Demux処理の起動 |
| - | StreamDemuxForm | ストリーム選択 | 抽出対象ストリームの選択UI |

## 機能種別

Demux処理 / ストリーム抽出 / フォールバック処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sourceFile | String | Yes | ソースファイルパス | 拡張子チェック |
| demuxVideo | Boolean | No | ビデオ抽出有無 | - |
| demuxAudio | DemuxMode | No | オーディオ抽出モード | - |
| subtitleMode | SubtitleMode | No | 字幕抽出モード | - |

### 入力データソース

- ソースファイル：プロジェクトのSourceFile
- 設定：Project設定（DemuxVideo、DemuxAudio、SubtitleMode等）

### 対応入力形式

- AVI
- FLV
- M2TS
- TS

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ビデオストリーム | File | FileTypes.VideoDemuxOutput形式 |
| オーディオストリーム | File | 元形式維持（copy）またはPCM変換 |
| 字幕ストリーム | File | SRT/MKS形式 |

### 出力先

- プロジェクト一時ディレクトリ（proj.TempDir）

## 処理フロー

### 処理シーケンス

```
1. ストリーム情報取得
   └─ MediaInfo.GetAudioCount/GetSubtitleCount
2. StreamDemuxForm表示（Dialog時）
   └─ ストリーム選択
3. ビデオDemux
   └─ ffmpeg -c:v copy -an -sn
4. オーディオDemux
   └─ ffmpeg -c:a copy または pcm_s*le変換
5. 字幕Demux
   └─ ffmpeg -c:s copy/srt/dvbsub
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ストリーム数取得]
    B --> C{Dialog表示?}
    C -->|Yes| D[StreamDemuxForm]
    C -->|No| E[自動選択]
    D --> F{OK?}
    F -->|No| G[Abort]
    F -->|Yes| H[設定確定]
    E --> H
    H --> I{Video Demux?}
    I -->|Yes| J[ffmpeg -c:v copy]
    I -->|No| K{Audio Demux?}
    J --> K
    K -->|Yes| L[各オーディオストリーム]
    K -->|No| M{Subtitle Demux?}
    L --> N{DTS形式?}
    N -->|Yes| O[ffmpeg -f dts]
    N -->|No| P{PCM形式?}
    P -->|Yes| Q[ffmpeg pcm_s*le]
    P -->|No| R[ffmpeg -c:a copy]
    O --> M
    Q --> M
    R --> M
    M -->|Yes| S[各字幕ストリーム]
    M -->|No| T[終了]
    S --> U[ffmpeg -c:s codec]
    U --> T
    G --> T
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 入力形式 | avi、flv、m2ts、ts拡張子対応 | 常時 |
| BR-002 | DTS出力形式 | DTS音声は-f dtsフォーマット指定 | DTS形式オーディオ |
| BR-003 | PCM変換 | PCM音声はビット深度に応じてpcm_s*le変換 | PCM形式オーディオ |
| BR-004 | ビット深度補正 | 20bitは24bitに補正 | PCM 20bit時 |
| BR-005 | MKS字幕 | MKS形式はdvbsubコーデックでmatroska出力 | mks字幕 |

### 計算ロジック

- PCMビット深度：20bit -> 24bitに補正
- 出力ファイル名：Audio.GetBaseNameForStream()で生成

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-001 | NoVideoStream | ビデオストリームなし | スキップ |
| E-002 | NoAudioOutput | オーディオ出力なし | ログ出力 |
| E-003 | DialogCancel | ダイアログキャンセル | AbortException |

### リトライ仕様

リトライ処理は行わない（本機能自体がフォールバック処理）。

## トランザクション仕様

本機能はトランザクション管理を行わない。

## パフォーマンス要件

- ストリーム抽出：ファイルサイズに依存
- probesize/analyzeduration：10M/20M設定で解析時間短縮

## セキュリティ考慮事項

- ファイルパスのエスケープ処理（.Escape拡張メソッド）
- UTF-8エンコーディング指定

## 備考

- -hide_banner：ffmpegバナー非表示
- -probesize 10M/-analyzeduration 20M：解析バッファ設定
- -map 0:a:index：複数オーディオストリーム時のストリーム指定
- -vn -sn/-an -sn：不要ストリームの除外

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ffmpegDemuxerクラスとその継承関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Demux.vb | `Source/General/Demux.vb` | Demuxer基底クラス（7-108行目） |
| 1-2 | Demux.vb | `Source/General/Demux.vb` | ffmpegDemuxerクラス（245-458行目） |

**読解のコツ**: InputExtensionsで対応形式、OutputExtensionsで出力形式を確認。

#### Step 2: エントリーポイントを理解する

ffmpegDemuxerのRunメソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Demux.vb | `Source/General/Demux.vb` | ffmpegDemuxer.Run（253-301行目） |

**主要処理フロー**:
1. **257-259行目**: オーディオ/字幕ストリーム数取得
2. **261-277行目**: StreamDemuxFormダイアログ表示（条件付き）
3. **279-281行目**: DemuxVideo呼び出し
4. **283-293行目**: オーディオDemux処理
5. **295-298行目**: 字幕Demux処理

#### Step 3: 各Demux処理を理解する

ビデオ、オーディオ、字幕の個別Demux処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Demux.vb | `Source/General/Demux.vb` | DemuxVideo（303-336行目） |
| 3-2 | Demux.vb | `Source/General/Demux.vb` | DemuxAudio（338-394行目） |
| 3-3 | Demux.vb | `Source/General/Demux.vb` | DemuxSubtitles（396-443行目） |

**主要処理フロー（DemuxAudio）**:
- **351行目**: コマンドライン構築開始（-probesize 20M -analyzeduration 20M）
- **353-355行目**: 複数オーディオ時のmap指定
- **359-370行目**: DTS/PCM形式に応じたコーデック指定
- **374-383行目**: ffmpeg実行

### プログラム呼び出し階層図

```
ffmpegDemuxer.Run(proj)
    │
    ├─ MediaInfo.GetAudioCount()
    ├─ MediaInfo.GetSubtitleCount()
    │
    ├─ StreamDemuxForm.ShowDialog() [条件付き]
    │
    ├─ ffmpegDemuxer.DemuxVideo()
    │      └─ ffmpeg -c:v copy -an -sn
    │
    ├─ ffmpegDemuxer.DemuxAudio() [各ストリーム]
    │      └─ ffmpeg -c:a copy / -f dts / pcm_s*le
    │
    └─ ffmpegDemuxer.DemuxSubtitles()
           └─ ffmpeg -c:s srt/copy/dvbsub
```

### データフロー図

```
[入力]                      [処理]                        [出力]

AVI/FLV/M2TS/TS ────▶ MediaInfo解析
                              │
                              ▼
                     StreamDemuxForm（選択）
                              │
                              ▼
                     ffmpeg -c:v copy ──────────▶ video stream
                              │
                              ▼
                     ffmpeg -c:a copy ──────────▶ audio streams
                              │
                              ▼
                     ffmpeg -c:s codec ─────────▶ subtitle streams
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Demux.vb | `Source/General/Demux.vb` | ソース | ffmpegDemuxerクラス定義（245-458行目） |
| StreamDemuxForm.vb | `Source/Forms/StreamDemuxForm.vb` | ソース | ストリーム選択ダイアログ |
| Package.vb | `Source/General/Package.vb` | ソース | ffmpegパッケージ定義 |
| Misc.vb | `Source/General/Misc.vb` | ソース | MediaInfoクラス |
| Audio.vb | `Source/General/Audio.vb` | ソース | GetBaseNameForStreamメソッド |
