# 機能設計書 50-カスタマイズ設定

## 概要

本ドキュメントは、StaxRipにおけるサムネイルシート生成のカスタマイズ設定機能の設計を記述する。この機能は、サムネイルシートの行数、列数、間隔、フォント等の詳細設定を行う。

### 本機能の処理概要

カスタマイズ設定機能は、ThumbnailerSettingsを通じてサムネイルシート生成の各種パラメータを設定する機能である。ObjectStorageを使用してキー/値ペアで設定を保存する。

**業務上の目的・背景**：サムネイルシートの用途は多様であり、用途に応じた見た目のカスタマイズが必要である。SNS投稿用には小さめのシート、アーカイブ用には詳細なシートなど、柔軟な設定が求められる。

**機能の利用シーン**：
- サムネイルグリッドのレイアウト調整
- タイムスタンプのフォント・色・位置設定
- ヘッダー情報の表示/非表示
- 出力画像形式・品質の設定
- 背景色・スペーサーの設定

**主要な処理内容**：
1. ThumbnailerSettingsからObjectStorage経由で設定読み込み
2. UIフォームで設定値を表示・編集
3. 設定値のバリデーション
4. ObjectStorageへの設定保存
5. Thumbnailer.RunAsync()で設定を反映

**関連システム・外部連携**：
- ObjectStorage（設定保存）
- ThumbnailerSettings（プロジェクト設定）
- FontManager（フォント管理）

**権限による制御**：特になし（全ユーザーが利用可能）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | OptionsForm | 設定画面 | サムネイル設定の編集 |
| 1 | MainForm | 主画面 | プロジェクト設定からのアクセス |

## 機能種別

設定管理 / UI設定 / 永続化

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ThumbWidth | Integer | No | サムネイル幅 | 0-1920（デフォルト600） |
| Interval | Integer | No | 時間間隔（秒） | 1-1800（デフォルト60） |
| Columns | Integer | No | 列数 | 1-50（デフォルト4） |
| Rows | Integer | No | 行数 | 1-80（デフォルト6） |
| RowMode | ThumbnailerRowMode | No | 行数モード | Fixed=0, TimeInterval=1 |
| SpacerPercent | Integer | No | スペーサー幅% | 0-1000（デフォルト20） |
| TimestampFontName | String | No | タイムスタンプフォント | 有効なフォント名 |
| TimestampFontSizePercent | Integer | No | フォントサイズ% | 10-1000（デフォルト100） |
| TimestampFontColor | String | No | フォント色 | HTML形式（例: #E6E6E6） |
| TimestampOutlineColor | String | No | アウトライン色 | HTML形式 |
| TimestampOutlineStrengthPercent | Integer | No | アウトライン強度% | 0-1000（デフォルト100） |
| TimestampAlignment | ContentAlignment | No | タイムスタンプ位置 | BottomLeft等 |
| Header | Boolean | No | ヘッダー表示 | true/false（デフォルトtrue） |
| HeaderFontName | String | No | ヘッダーフォント | 有効なフォント名 |
| HeaderFontSizePercent | Integer | No | ヘッダーフォントサイズ% | 10-1000（デフォルト100） |
| HeaderFontColor | String | No | ヘッダーフォント色 | HTML形式 |
| HeaderBackColor | String | No | ヘッダー背景色 | HTML形式 |
| HeaderSeparatorHeightPercent | Integer | No | ヘッダー区切り高さ% | 0-1000（デフォルト0） |
| ImageBackColor | String | No | 画像背景色 | HTML形式 |
| ImageFileFormat | String | No | 出力形式 | jpg/png/bmp/gif/tif |
| ImageQuality | Integer | No | JPEG品質 | 1-100（デフォルト70） |
| ImageFilePathWithoutExtension | String | No | 出力パス | マクロ対応パス |

### 入力データソース

- UI入力（OptionsForm）
- プロジェクトファイル（.srip）
- デフォルト値

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ThumbnailerSettings | ObjectStorage | 保存された設定値 |

### 出力先

- プロジェクト設定（p.ThumbnailerSettings）
- プロジェクトファイル（.srip）

## 処理フロー

### 処理シーケンス

```
1. 設定画面開始
   └─ ThumbnailerSettingsからObjectStorage読み込み
2. UI表示
   └─ 各設定項目をUI要素にバインド
3. ユーザー編集
   └─ 値変更 → バリデーション
4. 保存
   └─ ObjectStorage.SetXxx()で各値を保存
5. 適用
   └─ Thumbnailer.RunAsync()で設定を使用
```

### フローチャート

```mermaid
flowchart TD
    A[設定画面開始] --> B[ThumbnailerSettings読み込み]
    B --> C[UI要素に値設定]
    C --> D{ユーザー操作}
    D -->|値変更| E[バリデーション]
    E -->|OK| F[UI更新]
    E -->|NG| G[エラー表示]
    G --> D
    F --> D
    D -->|保存| H[ObjectStorage.SetXxx()]
    H --> I[プロジェクト保存]
    I --> J[終了]
    D -->|キャンセル| J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-50-01 | 範囲制限 | 各パラメータはMathf.Clampで範囲内に制限 | 値取得時 |
| BR-50-02 | デフォルト値 | 未設定の場合はデフォルト値を使用 | 値取得時 |
| BR-50-03 | 色形式 | 色はHTML形式（#RRGGBB）で保存 | 色設定時 |
| BR-50-04 | マクロ展開 | ImageFilePathはマクロ展開対応 | パス使用時 |

### 計算ロジック

スペーサー幅計算：
```
spacer = thumbWidth / 10.0 * (SpacerPercent / 100.0)
```

タイムスタンプフォントサイズ計算：
```
timestampFontSize = (thumbWidth / 20.0) * (TimestampFontSizePercent / 100.0)
```

ヘッダーフォントサイズ計算：
```
headerFontSize = (thumbWidth / 25.0) * (columns / 4.0) * (HeaderFontSizePercent / 100.0)
```

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。設定はプロジェクトファイル（.srip）に保存される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| SETTINGS-001 | 無効な値 | 範囲外の数値入力 | Clampで範囲内に補正 |
| SETTINGS-002 | 無効な色 | パースできない色文字列 | デフォルト色を使用 |
| SETTINGS-003 | 無効なフォント | 存在しないフォント名 | システムデフォルトを使用 |

### リトライ仕様

設定は何度でも変更可能

## トランザクション仕様

該当なし（即時保存）

## パフォーマンス要件

- 設定読み込み: 即時
- 設定保存: 即時

## セキュリティ考慮事項

- 出力パスの検証
- フォント名の検証

## 備考

- ColorHSLクラスでHSL色空間対応
- FontManager.GetFont()でフォント取得

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ObjectStorageによる設定保存を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Project.vb | `Source/General/Project.vb` | ThumbnailerSettings As ObjectStorage（151行目） |
| 1-2 | Thumbnailer.vb | `Source/General/Thumbnailer.vb` | settings読み込み（72-145行目） |

**読解のコツ**:
- `ObjectStorage` はキー/値ペアで設定を保存
- `settings.GetInt("key", defaultValue)` 形式で読み込み
- `Mathf.Clamp()` で範囲制限

#### Step 2: 各設定パラメータを理解する

設定値の読み込みと計算を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Thumbnailer.vb | `Source/General/Thumbnailer.vb` | ThumbWidth/Columns/Rows/Interval読み込み（74-84行目） |

**主要処理フロー**:
- **74行目**: `ThumbWidth = Mathf.Clamp(settings.GetInt("ThumbWidth", 600), 0, 1920)`
- **81行目**: `Interval = Mathf.Clamp(settings.GetInt("Interval", 60), 1, 1800)`
- **82行目**: `Columns = Mathf.Clamp(settings.GetInt("Columns", 4), 1, 50)`
- **83行目**: `Rows = Mathf.Clamp(settings.GetInt("Rows", 6), 1, 80)`

#### Step 3: フォント・色設定を理解する

タイムスタンプとヘッダーのスタイル設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Thumbnailer.vb | `Source/General/Thumbnailer.vb` | タイムスタンプ設定（88-108行目） |
| 3-2 | Thumbnailer.vb | `Source/General/Thumbnailer.vb` | ヘッダー設定（115-127行目） |

**主要処理フロー**:
- **88行目**: `TimestampFontName = settings.GetString("TimestampFontName", FontManager.GetThumbnailFont().Name)`
- **92-95行目**: `TimestampFontColor`, `TimestampOutlineColor` をHTML形式から取得
- **99-107行目**: `TimestampAlignment` をEnum.TryParseで取得
- **115-123行目**: `Header`, `HeaderFontName`, `HeaderFontSize`, `HeaderFontColor`, `HeaderBackColor` 取得

#### Step 4: 出力設定を理解する

画像形式と出力パス設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Thumbnailer.vb | `Source/General/Thumbnailer.vb` | 画像出力設定（128-149行目） |

**主要処理フロー**:
- **128行目**: `ImageFileFormat = settings.GetString("ImageFileFormat", "jpg")`
- **129行目**: `ImageQuality = Mathf.Clamp(settings.GetInt("ImageQuality", 70), 1, 100)`
- **145-149行目**: `ImageFilePathWithoutExtension` のマクロ展開

### プログラム呼び出し階層図

```
Project.ThumbnailerSettings (ObjectStorage)
    │
    ├─ GetInt("ThumbWidth", 600)
    ├─ GetInt("Columns", 4)
    ├─ GetInt("Rows", 6)
    ├─ GetInt("Interval", 60)
    ├─ GetInt("RowMode", 0)
    │
    ├─ GetString("TimestampFontName", ...)
    ├─ GetString("TimestampFontColor", ...)
    ├─ GetString("TimestampAlignment", ...)
    │
    ├─ GetBool("Header", True)
    ├─ GetString("HeaderFontName", ...)
    │
    └─ GetString("ImageFileFormat", "jpg")
        └─ GetInt("ImageQuality", 70)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

UI入力 ─────────────▶ バリデーション ────────▶ ObjectStorage
    │                      │                         │
デフォルト値 ──────▶ Mathf.Clamp() ─────────▶ 有効値
    │                      │                         │
    │                      ▼                         │
    └──────────────▶ ObjectStorage.SetXxx() ─▶ プロジェクトファイル
                               │                         │
                               ▼                         │
                           Thumbnailer ─────────▶ サムネイル生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Thumbnailer.vb | `Source/General/Thumbnailer.vb` | ソース | 設定読み込み・適用（72-149行目） |
| Project.vb | `Source/General/Project.vb` | ソース | ThumbnailerSettings定義（151行目） |
| ObjectStorage.vb | `Source/General/Misc.vb` | ソース | キー/値ペア保存 |
| FontManager.vb | `Source/UI/FontManager.vb` | ソース | フォント管理 |
| ColorHSL.vb | `Source/UI/ColorHSL.vb` | ソース | HSL色空間対応 |
