# 機能設計書: GIF生成

## 1. 機能概要

### 1.1 機能名
GIF生成（Animation.GIF）

### 1.2 機能説明
動画ファイルからアニメーションGIF画像を生成する機能。ffmpegを使用して、指定された時間範囲・フレームレート・サイズで高品質なGIFを生成する。パレット生成による色最適化とディザリングオプションにより、高品質なGIF出力を実現する。

### 1.3 関連画面
- メインフォーム（MainForm）- ツールメニューから呼び出し

## 2. 機能詳細

### 2.1 入力仕様

| 項目名 | データ型 | 必須 | 説明 |
|--------|----------|------|------|
| inputFile | String | Yes | 入力動画ファイルパス |
| proj | Project | No | プロジェクトオブジェクト（NullでもOK） |

### 2.2 出力仕様

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| GIFファイル | File | 生成されたアニメーションGIF |

### 2.3 処理フロー

```
開始
  │
  ├─ 入力ファイル存在確認
  │    └─ 存在しない場合 → 終了
  │
  ├─ ffmpegパッケージ検証
  │    └─ 検証失敗 → 終了
  │
  ├─ プロジェクト初期化（Nullの場合）
  │
  ├─ パラメータ取得（設定ストレージから）
  │    ├─ フレームレート（GifFrameRate）
  │    ├─ 開始時間（GifTime）
  │    ├─ 継続時間（GifLength）
  │    ├─ スケール（GifScale）
  │    ├─ パレットモード（PaletteGen）
  │    ├─ ディザリング（GifDither）
  │    └─ 出力ディレクトリ設定
  │
  ├─ パレット生成（ffmpeg）
  │    └─ 一時PNGファイルとして保存
  │
  ├─ GIF生成（ffmpeg）
  │    ├─ パレット使用
  │    └─ 出力先判定（カスタム/ソースと同じ）
  │
  └─ 一時ファイル削除
終了
```

### 2.4 ビジネスルール

| ルールID | ルール内容 |
|----------|------------|
| BR-001 | 入力ファイルが存在しない場合は処理を中断する |
| BR-002 | ffmpegが正しくインストールされていない場合は処理を中断する |
| BR-003 | GIF出力ディレクトリが指定されている場合はそこに出力、そうでなければソースファイルと同じディレクトリに出力 |
| BR-004 | 二段階処理（パレット生成→GIF生成）で高品質なGIFを生成する |

### 2.5 設定パラメータ

| パラメータ名 | デフォルト値 | 説明 |
|--------------|--------------|------|
| GifFrameRate | 15 | 出力GIFのフレームレート |
| GifTime | 15.0 | 開始時間（秒） |
| GifLength | 4.2 | 継続時間（秒） |
| GifScale | 480 | 出力幅（ピクセル） |
| PaletteGen | "diff" | パレット生成モード |
| PaletteUse | "rectangle" | パレット使用モード |
| GifDither | "dither=floyd_steinberg" | ディザリング設定 |
| GifOutput | False | カスタム出力ディレクトリ使用フラグ |
| GifDirectory | DefaultTargetFolder | 出力ディレクトリパス |

## 3. 画面設計

### 3.1 画面レイアウト
本機能は設定ダイアログを介して呼び出される。メインフォームのツールメニューからアクセス可能。

### 3.2 UI要素

| 要素名 | 種類 | 説明 |
|--------|------|------|
| フレームレート | 数値入力 | GIFのフレームレート設定 |
| 開始時間 | 数値入力 | 動画の開始位置（秒） |
| 継続時間 | 数値入力 | GIFの長さ（秒） |
| スケール | 数値入力 | 出力幅（ピクセル） |
| パレットモード | ドロップダウン | diff / full |
| ディザリング | ドロップダウン | floyd_steinberg / bayer / none |

## 4. データ設計

### 4.1 使用データ構造

```vb
' 設定はObjectStorage経由で永続化
s.Storage.GetInt("GifFrameRate", 15)
s.Storage.GetDouble("GifTime", 15.0)
s.Storage.GetDouble("GifLength", 4.2)
s.Storage.GetInt("GifScale", 480)
s.Storage.GetString("PaletteGen", "diff")
s.Storage.GetString("PaletteUse", "rectangle")
s.Storage.GetString("GifDither", "dither=floyd_steinberg")
s.Storage.GetBool("GifOutput", False)
s.Storage.GetString("GifDirectory", p.DefaultTargetFolder)
```

## 5. 外部インターフェース

### 5.1 外部ツール連携

| ツール名 | 用途 |
|----------|------|
| ffmpeg | パレット生成・GIF生成 |

### 5.2 ffmpegコマンド

パレット生成：
```
ffmpeg -ss [Seek] -t [Duration] -i "[inputFile]"
       -vf "fps=[Rate],scale=[Size]:-1:flags=spline,palettegen=stats_mode=[Mode]"
       -loglevel quiet -an -y [cachePath]
```

GIF生成：
```
ffmpeg -ss [Seek] -t [Duration] -i "[inputFile]" -i [cachePath]
       -lavfi "fps=[Rate],scale=[Size]:-1:flags=spline [x]; [x][1:v] paletteuse=[Dither]:diff_mode=[SecondMode]"
       -loglevel quiet -an -y "[OutputPath]"
```

## 6. エラー処理

| エラーコード | エラー内容 | 対処方法 |
|--------------|------------|----------|
| E-001 | 入力ファイル未存在 | 処理を中断し、何も出力しない |
| E-002 | ffmpeg検証失敗 | VerifyOK(True)でエラーダイアログ表示 |
| E-003 | 一時ファイル削除失敗 | 例外をキャッチして無視（Try-Catch） |

## 7. セキュリティ考慮事項

- ファイルパスにはエスケープ処理（ダブルクォート囲い）を適用
- 一時ファイルはFolder.Tempに作成し、処理完了後に削除

## 8. パフォーマンス考慮事項

- 二段階処理（パレット生成→GIF生成）は品質優先のアプローチ
- `-loglevel quiet`オプションでログ出力を抑制し処理を高速化
- スケール指定により出力サイズを制限

## 9. コードリーディングガイド

### 9.1 推奨読解順序

1. **Animation.GIF メソッド** (`Source/General/Extras.vb` 5-69行目)
   - エントリーポイント
   - パラメータ取得とffmpeg呼び出しの全体フロー

2. **Proc クラス** (`Source/General/Proc.vb`)
   - 外部プロセス実行の共通処理

3. **Package.ffmpeg** (`Source/General/Package.vb`)
   - ffmpegパッケージの定義と検証

### 9.2 プログラム呼び出し階層図

```
Animation.GIF()
  ├── File.Exists() - ファイル存在確認
  ├── Package.ffmpeg.VerifyOK() - パッケージ検証
  ├── Project.Init() - プロジェクト初期化（必要時）
  ├── s.Storage.GetXxx() - 設定値取得
  ├── Proc.Start() - パレット生成
  ├── Proc.Start() - GIF生成
  └── FileHelp.Delete() - 一時ファイル削除
```

### 9.3 データフロー図

```
[入力動画] → [ffmpeg palettegen] → [パレットPNG]
                                        ↓
[入力動画] + [パレットPNG] → [ffmpeg paletteuse] → [出力GIF]
                                        ↓
                                [パレットPNG削除]
```

### 9.4 関連ファイル一覧

| ファイルパス | 種別 | 役割 |
|-------------|------|------|
| Source/General/Extras.vb | 実装 | Animation.GIFメソッド定義 |
| Source/General/Proc.vb | 実装 | 外部プロセス実行クラス |
| Source/General/Package.vb | 実装 | ffmpegパッケージ定義 |
| Source/General/ApplicationSettings.vb | 実装 | 設定ストレージ |
| Source/Forms/MainForm.vb | UI | メニューからの呼び出し元 |

## 10. 改訂履歴

| 版数 | 日付 | 変更内容 | 作成者 |
|------|------|----------|--------|
| 1.0 | 2025-01-21 | 初版作成 | AI |
