# 機能設計書: テンプレート

## 1. 機能概要

### 1.1 機能名
テンプレート（Profile Management）

### 1.2 機能説明
エンコーディング設定をプロファイル（テンプレート）として保存・管理する機能。ビデオエンコーダー、オーディオプロファイル、フィルター設定などを再利用可能なテンプレートとして保存し、プロジェクト間で共有できる。

### 1.3 関連画面
- ProfilesForm - プロファイル管理ダイアログ
- メインフォーム（MainForm）- プロファイル選択・適用

## 2. 機能詳細

### 2.1 入力仕様

| 項目名 | データ型 | 必須 | 説明 |
|--------|----------|------|------|
| profiles | IList | Yes | 管理対象のプロファイルリスト |
| loadAction | Action(Of Profile) | No | プロファイル読込時のアクション |
| addFunc | Func(Of Profile) | No | 新規プロファイル追加時の関数 |
| defaultsFunc | Func(Of IList) | No | デフォルトプロファイル取得関数 |

### 2.2 出力仕様

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Profiles | IList | 更新されたプロファイルリスト |

### 2.3 処理フロー

```
開始
  │
  ├─ ProfilesFormダイアログ表示
  │
  ├─ プロファイル一覧表示
  │    └─ ListBoxにプロファイル名を表示
  │
  ├─ ユーザー操作待機
  │    ├─ Add（追加）
  │    │    ├─ AddProfileMethod呼び出し
  │    │    ├─ 名前入力ダイアログ
  │    │    ├─ 重複チェック
  │    │    └─ リストに追加
  │    │
  │    ├─ Remove（削除）
  │    │    └─ 選択項目を削除
  │    │
  │    ├─ Edit（編集）
  │    │    └─ プロファイル編集ダイアログ
  │    │
  │    ├─ Rename（名前変更）
  │    │    └─ 名前入力ダイアログ
  │    │
  │    ├─ Clone（複製）
  │    │    └─ 選択項目をコピー
  │    │
  │    ├─ Load（読込）
  │    │    └─ LoadProfileMethod呼び出し
  │    │
  │    ├─ Up/Down（並び替え）
  │    │    └─ 項目の順序変更
  │    │
  │    ├─ Left/Right（階層変更）
  │    │    └─ サブメニュー構造変更
  │    │
  │    └─ Restore（復元）
  │         ├─ Clean Restore
  │         └─ Overwrite
  │
  ├─ OK押下時
  │    ├─ プロファイルリスト更新
  │    └─ g.SaveSettings()呼び出し
  │
終了
```

### 2.4 ビジネスルール

| ルールID | ルール内容 |
|----------|------------|
| BR-001 | プロファイル名は一意でなければならない |
| BR-002 | 同名プロファイルが存在する場合は上書き確認を行う |
| BR-003 | プロファイル編集は CanEdit=True の場合のみ可能 |
| BR-004 | 階層構造は " \| " で区切って表現する |
| BR-005 | OK押下時のみ設定が保存される |

### 2.5 サブメニュー構造

プロファイル名に ` | ` を含めることで階層構造を表現：
- `Video | x264 | High Quality` → Video > x264 > High Quality
- 左ボタン: 親メニューへ移動
- 右ボタン: サブメニュー名を入力してサブメニュー化

## 3. 画面設計

### 3.1 画面レイアウト

```
+------------------------------------------+
|  [プロファイルリスト]     | [Add...]     |
|                           | [Remove]     |
|                           | [Edit...]    |
|                           | [Rename]     |
|                           | [Up] [<] [>] |
|                           | [Down]       |
|                           | [Clone]      |
|                           | [Load]       |
|                           | [Restore]    |
+------------------------------------------+
|           [OK]        [Cancel]           |
+------------------------------------------+
```

### 3.2 UI要素

| 要素名 | 種類 | 説明 |
|--------|------|------|
| lbMain | ListBox | プロファイル一覧（複数選択可能） |
| bnAdd | Button | 新規プロファイル追加 |
| bnRemove | Button | 選択プロファイル削除 |
| bnEdit | Button | 選択プロファイル編集 |
| bnRename | Button | 選択プロファイル名前変更 |
| bnClone | Button | 選択プロファイル複製 |
| bnLoad | Button | 選択プロファイル読込 |
| bnUp | Button | 選択項目を上へ移動 |
| bnDown | Button | 選択項目を下へ移動 |
| bnLeft | Button | 親メニューへ移動 |
| bnRight | Button | サブメニュー化 |
| bnRestore | Button | デフォルトプロファイル復元 |

## 4. データ設計

### 4.1 Profile基底クラス

```vb
Public MustInherit Class Profile
    Property Name As String
    Property CanEdit As Boolean

    MustOverride Function GetCopy() As Profile
    MustOverride Function Edit() As DialogResult
    MustOverride Sub Clean()
End Class
```

### 4.2 永続化

- 設定はApplicationSettingsに保存
- g.SaveSettings()で永続化
- プロファイルリストは各種類ごとに管理
  - VideoEncoderProfiles
  - AudioProfiles
  - FilterSetupProfiles

## 5. 外部インターフェース

### 5.1 呼び出し元

| 呼び出し元 | 用途 |
|------------|------|
| MainForm | ビデオエンコーダープロファイル管理 |
| AudioForm | オーディオプロファイル管理 |
| FilterSetupForm | フィルタープロファイル管理 |

## 6. エラー処理

| エラーコード | エラー内容 | 対処方法 |
|--------------|------------|----------|
| E-001 | 同名プロファイル存在 | 上書き確認ダイアログ表示 |
| E-002 | 名前が空または無効 | 処理を中断 |

## 7. セキュリティ考慮事項

- プロファイルデータはローカルに保存
- 外部からの入力に対する検証は最小限（信頼された環境前提）

## 8. パフォーマンス考慮事項

- プロファイルはメモリ上にコピーを保持（GetCopy使用）
- OK押下時のみディスクに書き込み

## 9. コードリーディングガイド

### 9.1 推奨読解順序

1. **ProfilesForm クラス** (`Source/Forms/ProfilesForm.vb` 1-580行目)
   - UIとプロファイル管理のメインロジック

2. **Profile 基底クラス** (`Source/General/Profiles.vb`)
   - プロファイルの共通インターフェース

3. **ApplicationSettings** (`Source/General/ApplicationSettings.vb`)
   - プロファイルリストの永続化

### 9.2 プログラム呼び出し階層図

```
ProfilesForm()
  ├── InitializeComponent() - UI初期化
  ├── lbMain.Items.Add() - プロファイル一覧表示
  │
  ├── bnAdd_Click()
  │    ├── AddProfileMethod() - 新規プロファイル取得
  │    ├── InputBox.Show() - 名前入力
  │    └── lbMain.Items.Insert() - リスト追加
  │
  ├── bnEdit_Click()
  │    └── profile.Edit() - 編集ダイアログ表示
  │
  ├── bnRename_Click()
  │    └── InputBox.Show() - 名前入力
  │
  ├── bnClone_Click()
  │    └── ObjectHelp.GetCopy() - 複製
  │
  ├── bnRestore_Click()
  │    └── DefaultsFunc() - デフォルト取得
  │
  └── OnFormClosed()
       ├── Profiles.Clear() - リストクリア
       ├── Profiles.Add() - 更新
       └── g.SaveSettings() - 保存
```

### 9.3 データフロー図

```
[ユーザー入力] → [ProfilesForm] → [Profile オブジェクト]
                      ↓
                [ListBox 表示]
                      ↓
            [OK] → [Profiles リスト更新]
                      ↓
            [g.SaveSettings()] → [Settings.dat]
```

### 9.4 関連ファイル一覧

| ファイルパス | 種別 | 役割 |
|-------------|------|------|
| Source/Forms/ProfilesForm.vb | UI | プロファイル管理ダイアログ |
| Source/General/Profiles.vb | 実装 | Profile基底クラス定義 |
| Source/General/ApplicationSettings.vb | 実装 | 設定永続化 |
| Source/General/GlobalClass.vb | 実装 | SaveSettings呼び出し |
| Source/UI/ListBoxEx.vb | UI | 拡張ListBoxコントロール |

## 10. 改訂履歴

| 版数 | 日付 | 変更内容 | 作成者 |
|------|------|----------|--------|
| 1.0 | 2025-01-21 | 初版作成 | AI |
