# 機能設計書 6-MP4Box Demux

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるMP4Box Demux機能の設計仕様を記述する。MP4、M4V、MOVコンテナからビデオ、オーディオ、字幕、チャプター、カバーアートを抽出する機能である。

### 本機能の処理概要

**業務上の目的・背景**：MP4形式はH.264/H.265ビデオの標準的なコンテナ形式として広く使用されている。本機能はGPACプロジェクトのMP4Boxツールを使用して、MP4ファミリーのコンテナからストリームを効率的に抽出する。AAC/Opusオーディオの特別処理やカバーアート抽出にも対応する。

**機能の利用シーン**：
- MP4ファイルからH.264/H.265ビデオストリーム抽出
- M4Vファイルからストリーム抽出
- MOVファイルからストリーム抽出
- MP4ファイルからオーディオトラック抽出
- MP4ファイルからチャプター情報抽出（OGG形式）
- MP4ファイルからカバーアート抽出

**主要な処理内容**：
1. StreamDemuxFormダイアログでストリーム選択
2. MP4Box -raw/-aviでビデオストリーム抽出
3. MP4Box -raw/-singleでオーディオストリーム抽出
4. MP4Box -raw/-srtで字幕ストリーム抽出
5. MP4Box -dump-chap-oggでチャプター抽出
6. MP4Box -dump-coverでカバーアート抽出
7. PCM音声はffmpegにフォールバック

**関連システム・外部連携**：
- MP4Box（GPAC）：MP4ストリーム抽出
- ffmpeg：PCM音声/フォールバック処理
- MediaInfo：メディア情報取得

**権限による制御**：特になし。ファイルシステムへの読み書きアクセス権が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 主画面 | Demux処理の起動 |
| - | StreamDemuxForm | ストリーム選択 | 抽出対象ストリームの選択UI |

## 機能種別

Demux処理 / ストリーム抽出

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sourceFile | String | Yes | MP4/M4V/MOVファイルパス | 拡張子チェック |
| demuxVideo | Boolean | No | ビデオ抽出有無 | - |
| demuxAudio | DemuxMode | No | オーディオ抽出モード | - |
| demuxChapters | Boolean | No | チャプター抽出有無 | - |
| demuxAttachments | Boolean | No | カバーアート抽出有無 | - |

### 入力データソース

- ソースファイル：プロジェクトのSourceFile
- 設定：Project設定

### 対応入力形式

- MP4
- M4V
- MOV

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ビデオストリーム | File | .h264/.h265/.avi/.mpg |
| オーディオストリーム | File | .aac/.m4a/.ac3/.dts等 |
| 字幕ストリーム | File | .srt等 |
| チャプター | File | _chapters.txt（OGG形式） |
| カバーアート | File | cover.jpg |

### 出力先

- プロジェクト一時ディレクトリ（proj.TempDir）

## 処理フロー

### 処理シーケンス

```
1. ストリーム/添付情報取得
   └─ MediaInfo.GetAudioCount/GetSubtitleCount
   └─ GetAttachments（カバー情報）
2. StreamDemuxForm表示（Dialog時）
   └─ ストリーム選択
3. ビデオDemux
   └─ MP4Box -raw/-avi
4. オーディオDemux
   └─ MP4Box -raw/-single（AAC/Opus）
   └─ ffmpeg（PCM時フォールバック）
5. 字幕Demux
   └─ MP4Box -raw/-srt
6. カバーアート抽出
   └─ MP4Box -dump-cover
7. チャプター抽出
   └─ MP4Box -dump-chap-ogg
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ストリーム数取得]
    B --> C[添付情報取得]
    C --> D{Dialog表示?}
    D -->|Yes| E[StreamDemuxForm]
    D -->|No| F[自動選択]
    E --> G{OK?}
    G -->|No| H[Abort]
    G -->|Yes| I[設定確定]
    F --> I
    I --> J{Video Demux?}
    J -->|Yes| K[MP4Box -raw/-avi]
    J -->|No| L{Audio Demux?}
    K --> M{出力成功?}
    M -->|No| N[ffmpeg fallback]
    M -->|Yes| L
    N --> L
    L -->|Yes| O[各オーディオストリーム]
    L -->|No| P{Subtitle Demux?}
    O --> Q{PCM?}
    Q -->|Yes| R[ffmpeg demux]
    Q -->|No| S{AAC/Opus?}
    S -->|Yes| T[MP4Box -single]
    S -->|No| U[MP4Box -raw]
    R --> P
    T --> P
    U --> P
    P -->|Yes| V[MP4Box -raw/-srt]
    P -->|No| W{Cover抽出?}
    V --> W
    W -->|Yes| X[MP4Box -dump-cover]
    W -->|No| Y{Chapter抽出?}
    X --> Y
    Y -->|Yes| Z[MP4Box -dump-chap-ogg]
    Y -->|No| AA[終了]
    Z --> AA
    H --> AA
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 入力形式 | mp4、m4v、mov拡張子対応 | 常時 |
| BR-002 | AVI出力 | avi拡張子のビデオは-aviオプション | ビデオ抽出時 |
| BR-003 | AAC/Opus抽出 | AAC/Opus形式は-singleオプション | オーディオ抽出時 |
| BR-004 | PCMフォールバック | PCM形式はffmpegで抽出 | PCMオーディオ時 |
| BR-005 | SRT出力 | SRT字幕は-srtオプション | 字幕抽出時 |
| BR-006 | チャプター位置 | Chapters_Pos_End - Chapters_Pos_Begin > 0で存在判定 | チャプター抽出時 |

### 計算ロジック

- チャプター存在判定：MediaInfo.GetMenu("Chapters_Pos_End").ToInt - MediaInfo.GetMenu("Chapters_Pos_Begin").ToInt > 0

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-001 | NoVideoStream | ビデオストリームなし | スキップ |
| E-002 | NoVideoOutput | ビデオ出力なし | ffmpegでフォールバック |
| E-003 | NoFormatDetected | MediaInfoでフォーマット検出失敗 | ffmpegでフォールバック |
| E-004 | DialogCancel | ダイアログキャンセル | AbortException |

### リトライ仕様

- ビデオ抽出失敗時：ffmpegDemuxer.DemuxVideo()でリトライ
- オーディオ抽出失敗時：ffmpegDemuxer.DemuxAudio()でリトライ

## トランザクション仕様

本機能はトランザクション管理を行わない。

## パフォーマンス要件

- ストリーム抽出：ファイルサイズに依存

## セキュリティ考慮事項

- ファイルパスのエスケープ処理
- 一時ディレクトリへの書き込み権限確認

## 備考

- MP4Boxの進捗表示は"|"でスキップ
- カバーアートはCover情報がある場合のみ抽出
- OutputExtensionsはDemuxVideo設定に依存

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

MP4BoxDemuxerクラスとその継承関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Demux.vb | `Source/General/Demux.vb` | Demuxer基底クラス（7-108行目） |
| 1-2 | Demux.vb | `Source/General/Demux.vb` | MP4BoxDemuxerクラス（461-708行目） |

**読解のコツ**: _videoDemuxingフィールドでビデオDemux状態を管理。

#### Step 2: エントリーポイントを理解する

MP4BoxDemuxerのRunメソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Demux.vb | `Source/General/Demux.vb` | MP4BoxDemuxer.Run（471-592行目） |

**主要処理フロー**:
1. **474行目**: GetAttachments（カバー情報取得）
2. **481-496行目**: StreamDemuxFormダイアログ表示
3. **498-500行目**: DemuxVideo呼び出し
4. **502-512行目**: オーディオDemux処理
5. **514-564行目**: 字幕Demux処理
6. **566-575行目**: カバーアート抽出
7. **577-589行目**: チャプター抽出

#### Step 3: 各Demux処理を理解する

ビデオ、オーディオの個別Demux処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Demux.vb | `Source/General/Demux.vb` | DemuxVideo（606-640行目） |
| 3-2 | Demux.vb | `Source/General/Demux.vb` | DemuxAudio（642-693行目） |

**主要処理フロー（DemuxAudio）**:
- **649-652行目**: PCM形式はffmpegにフォールバック
- **663-667行目**: AAC/Opusは-single、それ以外は-raw
- **682-692行目**: 抽出失敗時のフォールバック処理

### プログラム呼び出し階層図

```
MP4BoxDemuxer.Run(proj)
    │
    ├─ MediaInfo.GetAudioCount()
    ├─ MediaInfo.GetSubtitleCount()
    ├─ GetAttachments() [カバー情報]
    │
    ├─ StreamDemuxForm.ShowDialog() [条件付き]
    │
    ├─ MP4BoxDemuxer.DemuxVideo()
    │      ├─ MP4Box -raw/-avi
    │      └─ ffmpegDemuxer.DemuxVideo() [フォールバック]
    │
    ├─ MP4BoxDemuxer.DemuxAudio() [各ストリーム]
    │      ├─ ffmpegDemuxer.DemuxAudio() [PCM時]
    │      ├─ MP4Box -single [AAC/Opus]
    │      ├─ MP4Box -raw [その他]
    │      └─ ffmpegDemuxer.DemuxAudio() [フォールバック]
    │
    ├─ MP4Box -raw/-srt [字幕]
    │
    ├─ MP4Box -dump-cover [カバーアート]
    │
    └─ MP4Box -dump-chap-ogg [チャプター]
```

### データフロー図

```
[入力]                      [処理]                        [出力]

MP4/M4V/MOV ────────▶ MediaInfo解析
                              │
                              ▼
                     StreamDemuxForm（選択）
                              │
                              ▼
                     MP4Box -raw/-avi ──────────▶ video stream
                              │
                              ▼
                     MP4Box -raw/-single ───────▶ audio streams
                              │
                              ▼
                     MP4Box -raw/-srt ──────────▶ subtitle streams
                              │
                              ▼
                     MP4Box -dump-cover ────────▶ cover.jpg
                              │
                              ▼
                     MP4Box -dump-chap-ogg ─────▶ _chapters.txt
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Demux.vb | `Source/General/Demux.vb` | ソース | MP4BoxDemuxerクラス定義（461-708行目） |
| StreamDemuxForm.vb | `Source/Forms/StreamDemuxForm.vb` | ソース | ストリーム選択ダイアログ |
| Package.vb | `Source/General/Package.vb` | ソース | MP4Boxパッケージ定義 |
| Misc.vb | `Source/General/Misc.vb` | ソース | MediaInfoクラス |
